/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'lookup_fast' function
 *
 * Notes:
 *  - Enforce Exploit Detection CFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.XI.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"


char p_pcfi_lookup_fast_kretprobe_state = 0;

static struct kretprobe p_pcfi_lookup_fast_kretprobe = {
    .kp.symbol_name = "lookup_fast",
    .handler = p_pcfi_lookup_fast_ret,
    .entry_handler = p_pcfi_lookup_fast_entry,
    .data_size = sizeof(struct p_pcfi_lookup_fast_data),
};

/*
 * x86-64 syscall ABI:
 *  *rax - syscall_number
 *    rdi - 1st argument
 *    rsi - 2nd argument
 *    rdx - 3rd argument
 *    rcx - 4th argument
 *
 *    r8  - 5th one
 *    r9  - 6th one
 */

int p_pcfi_lookup_fast_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   p_ed_pcfi_cpu(1);

//   p_ed_enforce_validation();

   if (p_is_ed_task(current)) {
      p_tasks_read_lock(&p_flags);
      if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
         if (p_ed_pcfi_validate_sp(current, p_tmp, p_regs_get_sp(p_regs))) {
            // kill this process!
            p_pcfi_kill_task_by_task(current);
         }
      }
      p_tasks_read_unlock(&p_flags);
   }

   return 0;
}


int p_pcfi_lookup_fast_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

//   p_ed_enforce_validation();

   return 0;
}


GENERATE_INSTALL_FUNC(pcfi_lookup_fast)
