/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept add_key syscall
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - Keyring support
 *
 * Timeline:
 *  - Created: 31.I.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_SYS_ADD_KEY_H
#define P_LKRG_EXPLOIT_DETECTION_SYS_ADD_KEY_H

/* per-instance private data */
struct p_sys_add_key_data {
    ktime_t entry_stamp;
};


int p_sys_add_key_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_sys_add_key_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_sys_add_key_hook(int p_isra);
void p_uninstall_sys_add_key_hook(void);

#endif
