// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains content regarding the reasoning that is carried out by the model with respect to the content in the content block. Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance the accuracy of its final response.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub enum ReasoningContentBlock {
    /// <p>The reasoning that the model used to return the output.</p>
    ReasoningText(crate::types::ReasoningTextBlock),
    /// <p>The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption doesn't affect the quality of responses.</p>
    RedactedContent(::aws_smithy_types::Blob),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ReasoningContentBlock {
    /// Tries to convert the enum instance into [`ReasoningText`](crate::types::ReasoningContentBlock::ReasoningText), extracting the inner [`ReasoningTextBlock`](crate::types::ReasoningTextBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_reasoning_text(&self) -> ::std::result::Result<&crate::types::ReasoningTextBlock, &Self> {
        if let ReasoningContentBlock::ReasoningText(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ReasoningText`](crate::types::ReasoningContentBlock::ReasoningText).
    pub fn is_reasoning_text(&self) -> bool {
        self.as_reasoning_text().is_ok()
    }
    /// Tries to convert the enum instance into [`RedactedContent`](crate::types::ReasoningContentBlock::RedactedContent), extracting the inner [`Blob`](::aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_redacted_content(&self) -> ::std::result::Result<&::aws_smithy_types::Blob, &Self> {
        if let ReasoningContentBlock::RedactedContent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`RedactedContent`](crate::types::ReasoningContentBlock::RedactedContent).
    pub fn is_redacted_content(&self) -> bool {
        self.as_redacted_content().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
impl ::std::fmt::Debug for ReasoningContentBlock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "*** Sensitive Data Redacted ***")
    }
}
