/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ntp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apache.commons.net.DatagramSocketClient;
import org.apache.commons.net.ntp.NtpV3Impl;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.commons.net.ntp.TimeStamp;

public final class NTPUDPClient
extends DatagramSocketClient {
    public static final int DEFAULT_PORT = 123;
    private int _version = 3;

    public TimeInfo getTime(InetAddress inetAddress) throws IOException {
        return this.getTime(inetAddress, 123);
    }

    public TimeInfo getTime(InetAddress inetAddress, int n) throws IOException {
        if (!this.isOpen()) {
            this.open();
        }
        NtpV3Impl ntpV3Impl = new NtpV3Impl();
        ntpV3Impl.setMode(3);
        ntpV3Impl.setVersion(this._version);
        DatagramPacket datagramPacket = ntpV3Impl.getDatagramPacket();
        datagramPacket.setAddress(inetAddress);
        NtpV3Impl ntpV3Impl2 = new NtpV3Impl();
        DatagramPacket datagramPacket2 = ntpV3Impl2.getDatagramPacket();
        TimeStamp timeStamp = TimeStamp.getCurrentTime();
        ntpV3Impl.setTransmitTime(timeStamp);
        this._socket_.send(datagramPacket);
        this._socket_.receive(datagramPacket2);
        long l = System.currentTimeMillis();
        TimeInfo timeInfo = new TimeInfo((NtpV3Packet)ntpV3Impl2, l, false);
        return timeInfo;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n) {
        this._version = n;
    }
}

