pub const ext = @import("ext.zig");
const gdesktopenums = @This();

const std = @import("std");
const compat = @import("compat");
pub const AccentColor = enum(c_int) {
    blue = 0,
    teal = 1,
    green = 2,
    yellow = 3,
    orange = 4,
    red = 5,
    pink = 6,
    purple = 7,
    slate = 8,
    _,
};

pub const BackgroundShading = enum(c_int) {
    solid = 0,
    vertical = 1,
    horizontal = 2,
    _,
};

pub const BackgroundStyle = enum(c_int) {
    none = 0,
    wallpaper = 1,
    centered = 2,
    scaled = 3,
    stretched = 4,
    zoom = 5,
    spanned = 6,
    _,
};

pub const ClockFormat = enum(c_int) {
    @"24h" = 0,
    @"12h" = 1,
    _,
};

pub const ColorScheme = enum(c_int) {
    default = 0,
    prefer_dark = 1,
    prefer_light = 2,
    _,
};

pub const DeviceSendEvents = enum(c_int) {
    enabled = 0,
    disabled = 1,
    disabled_on_external_mouse = 2,
    _,
};

pub const FocusMode = enum(c_int) {
    click = 0,
    sloppy = 1,
    mouse = 2,
    _,
};

pub const FocusNewWindows = enum(c_int) {
    smart = 0,
    strict = 1,
    _,
};

pub const FontAntialiasingMode = enum(c_int) {
    none = 0,
    grayscale = 1,
    rgba = 2,
    _,
};

pub const FontHinting = enum(c_int) {
    none = 0,
    slight = 1,
    medium = 2,
    full = 3,
    _,
};

pub const FontRendering = enum(c_int) {
    automatic = 0,
    manual = 1,
    _,
};

pub const FontRgbaOrder = enum(c_int) {
    rgba = 0,
    rgb = 1,
    bgr = 2,
    vrgb = 3,
    vbgr = 4,
    _,
};

pub const LocationAccuracyLevel = enum(c_int) {
    country = 0,
    city = 1,
    neighborhood = 2,
    street = 3,
    exact = 4,
    _,
};

pub const MagnifierCaretTrackingMode = enum(c_int) {
    none = 0,
    centered = 1,
    proportional = 2,
    push = 3,
    _,
};

pub const MagnifierFocusTrackingMode = enum(c_int) {
    none = 0,
    centered = 1,
    proportional = 2,
    push = 3,
    _,
};

pub const MagnifierMouseTrackingMode = enum(c_int) {
    none = 0,
    centered = 1,
    proportional = 2,
    push = 3,
    _,
};

pub const MagnifierScreenPosition = enum(c_int) {
    none = 0,
    full_screen = 1,
    top_half = 2,
    bottom_half = 3,
    left_half = 4,
    right_half = 5,
    _,
};

pub const MouseDwellDirection = enum(c_int) {
    left = 0,
    right = 1,
    up = 2,
    down = 3,
    _,
};

pub const MouseDwellMode = enum(c_int) {
    window = 0,
    gesture = 1,
    _,
};

pub const PadButtonAction = enum(c_int) {
    none = 0,
    help = 1,
    switch_monitor = 2,
    keybinding = 3,
    _,
};

pub const PointerAccelProfile = enum(c_int) {
    default = 0,
    flat = 1,
    adaptive = 2,
    _,
};

pub const PointingStickScrollMethod = enum(c_int) {
    default = 0,
    none = 1,
    on_button_down = 2,
    _,
};

pub const ProxyMode = enum(c_int) {
    none = 0,
    manual = 1,
    auto = 2,
    _,
};

pub const ScreensaverMode = enum(c_int) {
    blank_only = 0,
    random = 1,
    single = 2,
    _,
};

pub const StylusButtonAction = enum(c_int) {
    default = 0,
    middle = 1,
    right = 2,
    back = 3,
    forward = 4,
    switch_monitor = 5,
    keybinding = 6,
    _,
};

pub const TabletMapping = enum(c_int) {
    absolute = 0,
    relative = 1,
    _,
};

pub const TitlebarAction = enum(c_int) {
    toggle_shade = 0,
    toggle_maximize = 1,
    toggle_maximize_horizontally = 2,
    toggle_maximize_vertically = 3,
    minimize = 4,
    none = 5,
    lower = 6,
    menu = 7,
    _,
};

pub const ToolbarIconSize = enum(c_int) {
    small = 0,
    large = 1,
    _,
};

pub const ToolbarStyle = enum(c_int) {
    both = 0,
    both_horiz = 1,
    icons = 2,
    text = 3,
    _,
};

pub const TouchpadClickMethod = enum(c_int) {
    default = 0,
    none = 1,
    areas = 2,
    fingers = 3,
    _,
};

pub const TouchpadHandedness = enum(c_int) {
    right = 0,
    left = 1,
    mouse = 2,
    _,
};

pub const TouchpadTapButtonMap = enum(c_int) {
    default = 0,
    lrm = 1,
    lmr = 2,
    _,
};

pub const UsbProtection = enum(c_int) {
    lockscreen = 0,
    always = 1,
    _,
};

pub const VisualBellType = enum(c_int) {
    fullscreen_flash = 0,
    frame_flash = 1,
    _,
};
