pub const ext = @import("ext.zig");
const webkit2webextension = @This();

const std = @import("std");
const compat = @import("compat");
const soup = @import("soup3");
const gio = @import("gio2");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const javascriptcore = @import("javascriptcore4");
const gtk = @import("gtk3");
const xlib = @import("xlib2");
const gdk = @import("gdk3");
const cairo = @import("cairo1");
const pango = @import("pango1");
const harfbuzz = @import("harfbuzz0");
const freetype2 = @import("freetype22");
const gdkpixbuf = @import("gdkpixbuf2");
const atk = @import("atk1");
/// Represents the context menu in a `WebKitWebView`.
///
/// `webkit2webextension.ContextMenu` represents a context menu containing
/// `webkit2webextension.ContextMenuItem`<!-- -->s in a `WebKitWebView`.
///
/// When a `WebKitWebView` is about to display the context menu, it
/// emits the `WebKitWebView.signals.context`-menu signal, which has the
/// `webkit2webextension.ContextMenu` as an argument. You can modify it, adding new
/// submenus that you can create with `webkit2webextension.ContextMenu.new`, adding
/// new `webkit2webextension.ContextMenuItem`<!-- -->s with
/// `webkit2webextension.ContextMenu.prepend`, `webkit2webextension.ContextMenu.append` or
/// `webkit2webextension.ContextMenu.insert`, maybe after having removed the
/// existing ones with `webkit2webextension.ContextMenu.removeAll`.
pub const ContextMenu = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.ContextMenuClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.ContextMenuPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `webkit2webextension.ContextMenu` object.
    ///
    /// Creates a new `webkit2webextension.ContextMenu` object to be used as a submenu of an existing
    /// `webkit2webextension.ContextMenu`. The context menu of a `WebKitWebView` is created by the view
    /// and passed as an argument of `WebKitWebView.signals.context`-menu signal.
    /// To add items to the menu use `webkit2webextension.ContextMenu.prepend`,
    /// `webkit2webextension.ContextMenu.append` or `webkit2webextension.ContextMenu.insert`.
    /// See also `webkit2webextension.ContextMenu.newWithItems` to create a `webkit2webextension.ContextMenu` with
    /// a list of initial items.
    extern fn webkit_context_menu_new() *webkit2webextension.ContextMenu;
    pub const new = webkit_context_menu_new;

    /// Creates a new `webkit2webextension.ContextMenu` object with the given items.
    ///
    /// Creates a new `webkit2webextension.ContextMenu` object to be used as a submenu of an existing
    /// `webkit2webextension.ContextMenu` with the given initial items.
    /// See also `webkit2webextension.ContextMenu.new`
    extern fn webkit_context_menu_new_with_items(p_items: *glib.List) *webkit2webextension.ContextMenu;
    pub const newWithItems = webkit_context_menu_new_with_items;

    /// Adds `item` at the end of the `menu`.
    extern fn webkit_context_menu_append(p_menu: *ContextMenu, p_item: *webkit2webextension.ContextMenuItem) void;
    pub const append = webkit_context_menu_append;

    /// Gets the first item in the `menu`.
    extern fn webkit_context_menu_first(p_menu: *ContextMenu) *webkit2webextension.ContextMenuItem;
    pub const first = webkit_context_menu_first;

    /// Gets the `gdk.Event` that triggered the context menu. This function only returns a valid
    /// `gdk.Event` when called for a `webkit2webextension.ContextMenu` passed to `WebKitWebView.signals.context`-menu
    /// signal; in all other cases, `NULL` is returned.
    ///
    /// The returned `gdk.Event` is expected to be one of the following types:
    /// <itemizedlist>
    /// <listitem><para>
    /// a `gdk.EventButton` of type `GDK_BUTTON_PRESS` when the context menu was triggered with mouse.
    /// </para></listitem>
    /// <listitem><para>
    /// a `gdk.EventKey` of type `GDK_KEY_PRESS` if the keyboard was used to show the menu.
    /// </para></listitem>
    /// <listitem><para>
    /// a generic `gdk.Event` of type `GDK_NOTHING` when the `gtk.Widget.signals.popup`-menu signal was used to show the context menu.
    /// </para></listitem>
    /// </itemizedlist>
    extern fn webkit_context_menu_get_event(p_menu: *ContextMenu) *gdk.Event;
    pub const getEvent = webkit_context_menu_get_event;

    /// Gets the item at the given position in the `menu`.
    extern fn webkit_context_menu_get_item_at_position(p_menu: *ContextMenu, p_position: c_uint) *webkit2webextension.ContextMenuItem;
    pub const getItemAtPosition = webkit_context_menu_get_item_at_position;

    /// Returns the item list of `menu`.
    extern fn webkit_context_menu_get_items(p_menu: *ContextMenu) *glib.List;
    pub const getItems = webkit_context_menu_get_items;

    /// Gets the length of the `menu`.
    extern fn webkit_context_menu_get_n_items(p_menu: *ContextMenu) c_uint;
    pub const getNItems = webkit_context_menu_get_n_items;

    /// Gets the user data of `menu`.
    ///
    /// This function can be used from the UI Process to get user data previously set
    /// from the Web Process with `webkit2webextension.ContextMenu.setUserData`.
    extern fn webkit_context_menu_get_user_data(p_menu: *ContextMenu) *glib.Variant;
    pub const getUserData = webkit_context_menu_get_user_data;

    /// Inserts `item` into the `menu` at the given position.
    ///
    /// If `position` is negative, or is larger than the number of items
    /// in the `webkit2webextension.ContextMenu`, the item is added on to the end of
    /// the `menu`. The first position is 0.
    extern fn webkit_context_menu_insert(p_menu: *ContextMenu, p_item: *webkit2webextension.ContextMenuItem, p_position: c_int) void;
    pub const insert = webkit_context_menu_insert;

    /// Gets the last item in the `menu`.
    extern fn webkit_context_menu_last(p_menu: *ContextMenu) *webkit2webextension.ContextMenuItem;
    pub const last = webkit_context_menu_last;

    /// Moves `item` to the given position in the `menu`.
    ///
    /// If `position` is negative, or is larger than the number of items
    /// in the `webkit2webextension.ContextMenu`, the item is added on to the end of
    /// the `menu`.
    /// The first position is 0.
    extern fn webkit_context_menu_move_item(p_menu: *ContextMenu, p_item: *webkit2webextension.ContextMenuItem, p_position: c_int) void;
    pub const moveItem = webkit_context_menu_move_item;

    /// Adds `item` at the beginning of the `menu`.
    extern fn webkit_context_menu_prepend(p_menu: *ContextMenu, p_item: *webkit2webextension.ContextMenuItem) void;
    pub const prepend = webkit_context_menu_prepend;

    /// Removes `item` from the `menu`.
    ///
    /// See also `webkit2webextension.ContextMenu.removeAll` to remove all items.
    extern fn webkit_context_menu_remove(p_menu: *ContextMenu, p_item: *webkit2webextension.ContextMenuItem) void;
    pub const remove = webkit_context_menu_remove;

    /// Removes all items of the `menu`.
    extern fn webkit_context_menu_remove_all(p_menu: *ContextMenu) void;
    pub const removeAll = webkit_context_menu_remove_all;

    /// Sets user data to `menu`.
    ///
    /// This function can be used from a Web Process extension to set user data
    /// that can be retrieved from the UI Process using `webkit2webextension.ContextMenu.getUserData`.
    /// If the `user_data` `glib.Variant` is floating, it is consumed.
    extern fn webkit_context_menu_set_user_data(p_menu: *ContextMenu, p_user_data: *glib.Variant) void;
    pub const setUserData = webkit_context_menu_set_user_data;

    extern fn webkit_context_menu_get_type() usize;
    pub const getGObjectType = webkit_context_menu_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.ContextMenu) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.ContextMenu) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ContextMenu, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// One item of a `webkit2webextension.ContextMenu`.
///
/// The `webkit2webextension.ContextMenu` is composed of `webkit2webextension.ContextMenuItem`<!--
/// -->s. These items can be created from a `gtk.Action`, from a
/// `webkit2webextension.ContextMenuAction` or from a `webkit2webextension.ContextMenuAction` and a
/// label. These `webkit2webextension.ContextMenuAction`<!-- -->s denote stock actions
/// for the items. You can also create separators and submenus.
pub const ContextMenuItem = extern struct {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.ContextMenuItemClass;
    f_parent: gobject.InitiallyUnowned,
    f_priv: ?*webkit2webextension.ContextMenuItemPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `webkit2webextension.ContextMenuItem` for the given `action`.
    extern fn webkit_context_menu_item_new(p_action: *gtk.Action) *webkit2webextension.ContextMenuItem;
    pub const new = webkit_context_menu_item_new;

    /// Creates a new `webkit2webextension.ContextMenuItem` for the given `action` and `label`.
    ///
    /// On activation
    /// `target` will be passed as parameter to the callback.
    extern fn webkit_context_menu_item_new_from_gaction(p_action: *gio.Action, p_label: [*:0]const u8, p_target: ?*glib.Variant) *webkit2webextension.ContextMenuItem;
    pub const newFromGaction = webkit_context_menu_item_new_from_gaction;

    /// Creates a new `webkit2webextension.ContextMenuItem` for the given stock action.
    ///
    /// Stock actions are handled automatically by WebKit so that, for example,
    /// when a menu item created with a `WEBKIT_CONTEXT_MENU_ACTION_STOP` is
    /// activated the action associated will be handled by WebKit and the current
    /// load operation will be stopped. You can get the `gio.Action` of a
    /// `webkit2webextension.ContextMenuItem` created with a `webkit2webextension.ContextMenuAction` with
    /// `webkit2webextension.ContextMenuItem.getGaction` and connect to the `gio.SimpleAction.signals.activate` signal
    /// to be notified when the item is activated, but you can't prevent the associated
    /// action from being performed.
    extern fn webkit_context_menu_item_new_from_stock_action(p_action: webkit2webextension.ContextMenuAction) *webkit2webextension.ContextMenuItem;
    pub const newFromStockAction = webkit_context_menu_item_new_from_stock_action;

    /// Creates a new `webkit2webextension.ContextMenuItem` for the given stock action using the given `label`.
    ///
    /// Stock actions have a predefined label, this method can be used to create a
    /// `webkit2webextension.ContextMenuItem` for a `webkit2webextension.ContextMenuAction` but using a custom label.
    extern fn webkit_context_menu_item_new_from_stock_action_with_label(p_action: webkit2webextension.ContextMenuAction, p_label: [*:0]const u8) *webkit2webextension.ContextMenuItem;
    pub const newFromStockActionWithLabel = webkit_context_menu_item_new_from_stock_action_with_label;

    /// Creates a new `webkit2webextension.ContextMenuItem` representing a separator.
    extern fn webkit_context_menu_item_new_separator() *webkit2webextension.ContextMenuItem;
    pub const newSeparator = webkit_context_menu_item_new_separator;

    /// Creates a new `webkit2webextension.ContextMenuItem` using the given `label` with a submenu.
    extern fn webkit_context_menu_item_new_with_submenu(p_label: [*:0]const u8, p_submenu: *webkit2webextension.ContextMenu) *webkit2webextension.ContextMenuItem;
    pub const newWithSubmenu = webkit_context_menu_item_new_with_submenu;

    /// Gets the action associated to `item` as a `gtk.Action`.
    extern fn webkit_context_menu_item_get_action(p_item: *ContextMenuItem) *gtk.Action;
    pub const getAction = webkit_context_menu_item_get_action;

    /// Gets the action associated to `item` as a `gio.Action`.
    extern fn webkit_context_menu_item_get_gaction(p_item: *ContextMenuItem) *gio.Action;
    pub const getGaction = webkit_context_menu_item_get_gaction;

    /// Gets the `webkit2webextension.ContextMenuAction` of `item`.
    ///
    /// If the `webkit2webextension.ContextMenuItem` was not
    /// created for a stock action `WEBKIT_CONTEXT_MENU_ACTION_CUSTOM` will be
    /// returned. If the `webkit2webextension.ContextMenuItem` is a separator `WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION`
    /// will be returned.
    extern fn webkit_context_menu_item_get_stock_action(p_item: *ContextMenuItem) webkit2webextension.ContextMenuAction;
    pub const getStockAction = webkit_context_menu_item_get_stock_action;

    /// Gets the submenu of `item`.
    extern fn webkit_context_menu_item_get_submenu(p_item: *ContextMenuItem) *webkit2webextension.ContextMenu;
    pub const getSubmenu = webkit_context_menu_item_get_submenu;

    /// Checks whether `item` is a separator.
    extern fn webkit_context_menu_item_is_separator(p_item: *ContextMenuItem) c_int;
    pub const isSeparator = webkit_context_menu_item_is_separator;

    /// Sets or replaces the `item` submenu.
    ///
    /// If `submenu` is `NULL` the current
    /// submenu of `item` is removed.
    extern fn webkit_context_menu_item_set_submenu(p_item: *ContextMenuItem, p_submenu: ?*webkit2webextension.ContextMenu) void;
    pub const setSubmenu = webkit_context_menu_item_set_submenu;

    extern fn webkit_context_menu_item_get_type() usize;
    pub const getGObjectType = webkit_context_menu_item_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.ContextMenuItem) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.ContextMenuItem) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ContextMenuItem, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMAttr = extern struct {
    pub const Parent = webkit2webextension.DOMNode;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMAttrClass;
    f_parent_instance: webkit2webextension.DOMNode,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const local_name = struct {
            pub const name = "local-name";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const namespace_uri = struct {
            pub const name = "namespace-uri";

            pub const Type = ?[*:0]u8;
        };

        pub const owner_element = struct {
            pub const name = "owner-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const prefix = struct {
            pub const name = "prefix";

            pub const Type = ?[*:0]u8;
        };

        pub const specified = struct {
            pub const name = "specified";

            pub const Type = c_int;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_attr_get_local_name(p_self: *DOMAttr) [*:0]u8;
    pub const getLocalName = webkit_dom_attr_get_local_name;

    extern fn webkit_dom_attr_get_name(p_self: *DOMAttr) [*:0]u8;
    pub const getName = webkit_dom_attr_get_name;

    extern fn webkit_dom_attr_get_namespace_uri(p_self: *DOMAttr) [*:0]u8;
    pub const getNamespaceUri = webkit_dom_attr_get_namespace_uri;

    extern fn webkit_dom_attr_get_owner_element(p_self: *DOMAttr) *webkit2webextension.DOMElement;
    pub const getOwnerElement = webkit_dom_attr_get_owner_element;

    extern fn webkit_dom_attr_get_prefix(p_self: *DOMAttr) [*:0]u8;
    pub const getPrefix = webkit_dom_attr_get_prefix;

    extern fn webkit_dom_attr_get_specified(p_self: *DOMAttr) c_int;
    pub const getSpecified = webkit_dom_attr_get_specified;

    extern fn webkit_dom_attr_get_value(p_self: *DOMAttr) [*:0]u8;
    pub const getValue = webkit_dom_attr_get_value;

    extern fn webkit_dom_attr_set_value(p_self: *DOMAttr, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setValue = webkit_dom_attr_set_value;

    extern fn webkit_dom_attr_get_type() usize;
    pub const getGObjectType = webkit_dom_attr_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMAttr) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMAttr) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMAttr, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMBlob = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMBlobClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const size = struct {
            pub const name = "size";

            pub const Type = u64;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_blob_get_size(p_self: *DOMBlob) u64;
    pub const getSize = webkit_dom_blob_get_size;

    extern fn webkit_dom_blob_get_type() usize;
    pub const getGObjectType = webkit_dom_blob_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMBlob) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMBlob) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMBlob, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCDATASection = extern struct {
    pub const Parent = webkit2webextension.DOMText;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMCDATASectionClass;
    f_parent_instance: webkit2webextension.DOMText,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_cdata_section_get_type() usize;
    pub const getGObjectType = webkit_dom_cdata_section_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMCDATASection) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMCDATASection) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMCDATASection, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSRule = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMCSSRuleClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const css_text = struct {
            pub const name = "css-text";

            pub const Type = ?[*:0]u8;
        };

        pub const parent_rule = struct {
            pub const name = "parent-rule";

            pub const Type = ?*webkit2webextension.DOMCSSRule;
        };

        pub const parent_style_sheet = struct {
            pub const name = "parent-style-sheet";

            pub const Type = ?*webkit2webextension.DOMCSSStyleSheet;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_css_rule_get_css_text(p_self: *DOMCSSRule) [*:0]u8;
    pub const getCssText = webkit_dom_css_rule_get_css_text;

    extern fn webkit_dom_css_rule_get_parent_rule(p_self: *DOMCSSRule) *webkit2webextension.DOMCSSRule;
    pub const getParentRule = webkit_dom_css_rule_get_parent_rule;

    extern fn webkit_dom_css_rule_get_parent_style_sheet(p_self: *DOMCSSRule) *webkit2webextension.DOMCSSStyleSheet;
    pub const getParentStyleSheet = webkit_dom_css_rule_get_parent_style_sheet;

    extern fn webkit_dom_css_rule_get_rule_type(p_self: *DOMCSSRule) c_ushort;
    pub const getRuleType = webkit_dom_css_rule_get_rule_type;

    extern fn webkit_dom_css_rule_set_css_text(p_self: *DOMCSSRule, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setCssText = webkit_dom_css_rule_set_css_text;

    extern fn webkit_dom_css_rule_get_type() usize;
    pub const getGObjectType = webkit_dom_css_rule_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMCSSRule) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMCSSRule) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMCSSRule, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSRuleList = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMCSSRuleListClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_css_rule_list_get_length(p_self: *DOMCSSRuleList) c_ulong;
    pub const getLength = webkit_dom_css_rule_list_get_length;

    extern fn webkit_dom_css_rule_list_item(p_self: *DOMCSSRuleList, p_index: c_ulong) *webkit2webextension.DOMCSSRule;
    pub const item = webkit_dom_css_rule_list_item;

    extern fn webkit_dom_css_rule_list_get_type() usize;
    pub const getGObjectType = webkit_dom_css_rule_list_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMCSSRuleList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMCSSRuleList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMCSSRuleList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSStyleDeclaration = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMCSSStyleDeclarationClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const css_text = struct {
            pub const name = "css-text";

            pub const Type = ?[*:0]u8;
        };

        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };

        pub const parent_rule = struct {
            pub const name = "parent-rule";

            pub const Type = ?*webkit2webextension.DOMCSSRule;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_css_style_declaration_get_css_text(p_self: *DOMCSSStyleDeclaration) [*:0]u8;
    pub const getCssText = webkit_dom_css_style_declaration_get_css_text;

    extern fn webkit_dom_css_style_declaration_get_length(p_self: *DOMCSSStyleDeclaration) c_ulong;
    pub const getLength = webkit_dom_css_style_declaration_get_length;

    extern fn webkit_dom_css_style_declaration_get_parent_rule(p_self: *DOMCSSStyleDeclaration) *webkit2webextension.DOMCSSRule;
    pub const getParentRule = webkit_dom_css_style_declaration_get_parent_rule;

    extern fn webkit_dom_css_style_declaration_get_property_priority(p_self: *DOMCSSStyleDeclaration, p_propertyName: [*:0]const u8) [*:0]u8;
    pub const getPropertyPriority = webkit_dom_css_style_declaration_get_property_priority;

    extern fn webkit_dom_css_style_declaration_get_property_shorthand(p_self: *DOMCSSStyleDeclaration, p_propertyName: [*:0]const u8) [*:0]u8;
    pub const getPropertyShorthand = webkit_dom_css_style_declaration_get_property_shorthand;

    extern fn webkit_dom_css_style_declaration_get_property_value(p_self: *DOMCSSStyleDeclaration, p_propertyName: [*:0]const u8) [*:0]u8;
    pub const getPropertyValue = webkit_dom_css_style_declaration_get_property_value;

    extern fn webkit_dom_css_style_declaration_is_property_implicit(p_self: *DOMCSSStyleDeclaration, p_propertyName: [*:0]const u8) c_int;
    pub const isPropertyImplicit = webkit_dom_css_style_declaration_is_property_implicit;

    extern fn webkit_dom_css_style_declaration_item(p_self: *DOMCSSStyleDeclaration, p_index: c_ulong) [*:0]u8;
    pub const item = webkit_dom_css_style_declaration_item;

    extern fn webkit_dom_css_style_declaration_remove_property(p_self: *DOMCSSStyleDeclaration, p_propertyName: [*:0]const u8, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const removeProperty = webkit_dom_css_style_declaration_remove_property;

    extern fn webkit_dom_css_style_declaration_set_css_text(p_self: *DOMCSSStyleDeclaration, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setCssText = webkit_dom_css_style_declaration_set_css_text;

    extern fn webkit_dom_css_style_declaration_set_property(p_self: *DOMCSSStyleDeclaration, p_propertyName: [*:0]const u8, p_value: [*:0]const u8, p_priority: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setProperty = webkit_dom_css_style_declaration_set_property;

    extern fn webkit_dom_css_style_declaration_get_type() usize;
    pub const getGObjectType = webkit_dom_css_style_declaration_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMCSSStyleDeclaration) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMCSSStyleDeclaration) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMCSSStyleDeclaration, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSStyleSheet = extern struct {
    pub const Parent = webkit2webextension.DOMStyleSheet;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMCSSStyleSheetClass;
    f_parent_instance: webkit2webextension.DOMStyleSheet,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const css_rules = struct {
            pub const name = "css-rules";

            pub const Type = ?*webkit2webextension.DOMCSSRuleList;
        };

        pub const owner_rule = struct {
            pub const name = "owner-rule";

            pub const Type = ?*webkit2webextension.DOMCSSRule;
        };

        pub const rules = struct {
            pub const name = "rules";

            pub const Type = ?*webkit2webextension.DOMCSSRuleList;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_css_style_sheet_add_rule(p_self: *DOMCSSStyleSheet, p_selector: [*:0]const u8, p_style: [*:0]const u8, p_index: c_ulong, p_error: ?*?*glib.Error) c_long;
    pub const addRule = webkit_dom_css_style_sheet_add_rule;

    extern fn webkit_dom_css_style_sheet_delete_rule(p_self: *DOMCSSStyleSheet, p_index: c_ulong, p_error: ?*?*glib.Error) void;
    pub const deleteRule = webkit_dom_css_style_sheet_delete_rule;

    extern fn webkit_dom_css_style_sheet_get_css_rules(p_self: *DOMCSSStyleSheet) *webkit2webextension.DOMCSSRuleList;
    pub const getCssRules = webkit_dom_css_style_sheet_get_css_rules;

    extern fn webkit_dom_css_style_sheet_get_owner_rule(p_self: *DOMCSSStyleSheet) *webkit2webextension.DOMCSSRule;
    pub const getOwnerRule = webkit_dom_css_style_sheet_get_owner_rule;

    extern fn webkit_dom_css_style_sheet_get_rules(p_self: *DOMCSSStyleSheet) *webkit2webextension.DOMCSSRuleList;
    pub const getRules = webkit_dom_css_style_sheet_get_rules;

    extern fn webkit_dom_css_style_sheet_insert_rule(p_self: *DOMCSSStyleSheet, p_rule: [*:0]const u8, p_index: c_ulong, p_error: ?*?*glib.Error) c_ulong;
    pub const insertRule = webkit_dom_css_style_sheet_insert_rule;

    extern fn webkit_dom_css_style_sheet_remove_rule(p_self: *DOMCSSStyleSheet, p_index: c_ulong, p_error: ?*?*glib.Error) void;
    pub const removeRule = webkit_dom_css_style_sheet_remove_rule;

    extern fn webkit_dom_css_style_sheet_get_type() usize;
    pub const getGObjectType = webkit_dom_css_style_sheet_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMCSSStyleSheet) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMCSSStyleSheet) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMCSSStyleSheet, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSValue = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMCSSValueClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const css_text = struct {
            pub const name = "css-text";

            pub const Type = ?[*:0]u8;
        };

        pub const css_value_type = struct {
            pub const name = "css-value-type";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_css_value_get_css_text(p_self: *DOMCSSValue) [*:0]u8;
    pub const getCssText = webkit_dom_css_value_get_css_text;

    extern fn webkit_dom_css_value_get_css_value_type(p_self: *DOMCSSValue) c_ushort;
    pub const getCssValueType = webkit_dom_css_value_get_css_value_type;

    extern fn webkit_dom_css_value_set_css_text(p_self: *DOMCSSValue, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setCssText = webkit_dom_css_value_set_css_text;

    extern fn webkit_dom_css_value_get_type() usize;
    pub const getGObjectType = webkit_dom_css_value_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMCSSValue) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMCSSValue) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMCSSValue, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCharacterData = extern struct {
    pub const Parent = webkit2webextension.DOMNode;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMCharacterDataClass;
    f_parent_instance: webkit2webextension.DOMNode,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const data = struct {
            pub const name = "data";

            pub const Type = ?[*:0]u8;
        };

        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_character_data_append_data(p_self: *DOMCharacterData, p_data: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const appendData = webkit_dom_character_data_append_data;

    extern fn webkit_dom_character_data_delete_data(p_self: *DOMCharacterData, p_offset: c_ulong, p_length: c_ulong, p_error: ?*?*glib.Error) void;
    pub const deleteData = webkit_dom_character_data_delete_data;

    extern fn webkit_dom_character_data_get_data(p_self: *DOMCharacterData) [*:0]u8;
    pub const getData = webkit_dom_character_data_get_data;

    extern fn webkit_dom_character_data_get_length(p_self: *DOMCharacterData) c_ulong;
    pub const getLength = webkit_dom_character_data_get_length;

    extern fn webkit_dom_character_data_insert_data(p_self: *DOMCharacterData, p_offset: c_ulong, p_data: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const insertData = webkit_dom_character_data_insert_data;

    extern fn webkit_dom_character_data_replace_data(p_self: *DOMCharacterData, p_offset: c_ulong, p_length: c_ulong, p_data: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const replaceData = webkit_dom_character_data_replace_data;

    extern fn webkit_dom_character_data_set_data(p_self: *DOMCharacterData, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setData = webkit_dom_character_data_set_data;

    extern fn webkit_dom_character_data_substring_data(p_self: *DOMCharacterData, p_offset: c_ulong, p_length: c_ulong, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const substringData = webkit_dom_character_data_substring_data;

    extern fn webkit_dom_character_data_get_type() usize;
    pub const getGObjectType = webkit_dom_character_data_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMCharacterData) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMCharacterData) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMCharacterData, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMClientRect = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMClientRectClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const bottom = struct {
            pub const name = "bottom";

            pub const Type = f32;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = f32;
        };

        pub const left = struct {
            pub const name = "left";

            pub const Type = f32;
        };

        pub const right = struct {
            pub const name = "right";

            pub const Type = f32;
        };

        pub const top = struct {
            pub const name = "top";

            pub const Type = f32;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = f32;
        };
    };

    pub const signals = struct {};

    /// Returns the bottom coordinate of `self`, relative to the viewport.
    extern fn webkit_dom_client_rect_get_bottom(p_self: *DOMClientRect) f32;
    pub const getBottom = webkit_dom_client_rect_get_bottom;

    /// Returns the height of `self`.
    extern fn webkit_dom_client_rect_get_height(p_self: *DOMClientRect) f32;
    pub const getHeight = webkit_dom_client_rect_get_height;

    /// Returns the left coordinate of `self`, relative to the viewport.
    extern fn webkit_dom_client_rect_get_left(p_self: *DOMClientRect) f32;
    pub const getLeft = webkit_dom_client_rect_get_left;

    /// Returns the right coordinate of `self`, relative to the viewport.
    extern fn webkit_dom_client_rect_get_right(p_self: *DOMClientRect) f32;
    pub const getRight = webkit_dom_client_rect_get_right;

    /// Returns the top coordinate of `self`, relative to the viewport.
    extern fn webkit_dom_client_rect_get_top(p_self: *DOMClientRect) f32;
    pub const getTop = webkit_dom_client_rect_get_top;

    /// Returns the width of `self`.
    extern fn webkit_dom_client_rect_get_width(p_self: *DOMClientRect) f32;
    pub const getWidth = webkit_dom_client_rect_get_width;

    extern fn webkit_dom_client_rect_get_type() usize;
    pub const getGObjectType = webkit_dom_client_rect_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMClientRect) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMClientRect) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMClientRect, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMClientRectList = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMClientRectListClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    /// Returns the number of `webkit2webextension.DOMClientRect` objects that `self` contains.
    extern fn webkit_dom_client_rect_list_get_length(p_self: *DOMClientRectList) c_ulong;
    pub const getLength = webkit_dom_client_rect_list_get_length;

    /// Returns the `webkit2webextension.DOMClientRect` object that `self` contains at `index`.
    extern fn webkit_dom_client_rect_list_item(p_self: *DOMClientRectList, p_index: c_ulong) *webkit2webextension.DOMClientRect;
    pub const item = webkit_dom_client_rect_list_item;

    extern fn webkit_dom_client_rect_list_get_type() usize;
    pub const getGObjectType = webkit_dom_client_rect_list_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMClientRectList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMClientRectList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMClientRectList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMComment = extern struct {
    pub const Parent = webkit2webextension.DOMCharacterData;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMCommentClass;
    f_parent_instance: webkit2webextension.DOMCharacterData,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_comment_get_type() usize;
    pub const getGObjectType = webkit_dom_comment_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMComment) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMComment) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMComment, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMImplementation = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMDOMImplementationClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_dom_implementation_create_css_style_sheet(p_self: *DOMDOMImplementation, p_title: [*:0]const u8, p_media: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMCSSStyleSheet;
    pub const createCssStyleSheet = webkit_dom_dom_implementation_create_css_style_sheet;

    extern fn webkit_dom_dom_implementation_create_document(p_self: *DOMDOMImplementation, p_namespaceURI: ?[*:0]const u8, p_qualifiedName: [*:0]const u8, p_doctype: ?*webkit2webextension.DOMDocumentType, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMDocument;
    pub const createDocument = webkit_dom_dom_implementation_create_document;

    extern fn webkit_dom_dom_implementation_create_document_type(p_self: *DOMDOMImplementation, p_qualifiedName: [*:0]const u8, p_publicId: [*:0]const u8, p_systemId: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMDocumentType;
    pub const createDocumentType = webkit_dom_dom_implementation_create_document_type;

    extern fn webkit_dom_dom_implementation_create_html_document(p_self: *DOMDOMImplementation, p_title: [*:0]const u8) *webkit2webextension.DOMHTMLDocument;
    pub const createHtmlDocument = webkit_dom_dom_implementation_create_html_document;

    extern fn webkit_dom_dom_implementation_has_feature(p_self: *DOMDOMImplementation, p_feature: [*:0]const u8, p_version: [*:0]const u8) c_int;
    pub const hasFeature = webkit_dom_dom_implementation_has_feature;

    extern fn webkit_dom_dom_implementation_get_type() usize;
    pub const getGObjectType = webkit_dom_dom_implementation_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMDOMImplementation) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMDOMImplementation) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMDOMImplementation, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMSelection = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMDOMSelectionClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const anchor_node = struct {
            pub const name = "anchor-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const anchor_offset = struct {
            pub const name = "anchor-offset";

            pub const Type = c_ulong;
        };

        pub const base_node = struct {
            pub const name = "base-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const base_offset = struct {
            pub const name = "base-offset";

            pub const Type = c_ulong;
        };

        pub const extent_node = struct {
            pub const name = "extent-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const extent_offset = struct {
            pub const name = "extent-offset";

            pub const Type = c_ulong;
        };

        pub const focus_node = struct {
            pub const name = "focus-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const focus_offset = struct {
            pub const name = "focus-offset";

            pub const Type = c_ulong;
        };

        pub const is_collapsed = struct {
            pub const name = "is-collapsed";

            pub const Type = c_int;
        };

        pub const range_count = struct {
            pub const name = "range-count";

            pub const Type = c_ulong;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_dom_selection_add_range(p_self: *DOMDOMSelection, p_range: *webkit2webextension.DOMRange) void;
    pub const addRange = webkit_dom_dom_selection_add_range;

    extern fn webkit_dom_dom_selection_collapse(p_self: *DOMDOMSelection, p_node: *webkit2webextension.DOMNode, p_offset: c_ulong) void;
    pub const collapse = webkit_dom_dom_selection_collapse;

    extern fn webkit_dom_dom_selection_collapse_to_end(p_self: *DOMDOMSelection, p_error: ?*?*glib.Error) void;
    pub const collapseToEnd = webkit_dom_dom_selection_collapse_to_end;

    extern fn webkit_dom_dom_selection_collapse_to_start(p_self: *DOMDOMSelection, p_error: ?*?*glib.Error) void;
    pub const collapseToStart = webkit_dom_dom_selection_collapse_to_start;

    extern fn webkit_dom_dom_selection_contains_node(p_self: *DOMDOMSelection, p_node: *webkit2webextension.DOMNode, p_allowPartial: c_int) c_int;
    pub const containsNode = webkit_dom_dom_selection_contains_node;

    extern fn webkit_dom_dom_selection_delete_from_document(p_self: *DOMDOMSelection) void;
    pub const deleteFromDocument = webkit_dom_dom_selection_delete_from_document;

    extern fn webkit_dom_dom_selection_empty(p_self: *DOMDOMSelection) void;
    pub const empty = webkit_dom_dom_selection_empty;

    extern fn webkit_dom_dom_selection_extend(p_self: *DOMDOMSelection, p_node: *webkit2webextension.DOMNode, p_offset: c_ulong, p_error: ?*?*glib.Error) void;
    pub const extend = webkit_dom_dom_selection_extend;

    extern fn webkit_dom_dom_selection_get_anchor_node(p_self: *DOMDOMSelection) *webkit2webextension.DOMNode;
    pub const getAnchorNode = webkit_dom_dom_selection_get_anchor_node;

    extern fn webkit_dom_dom_selection_get_anchor_offset(p_self: *DOMDOMSelection) c_ulong;
    pub const getAnchorOffset = webkit_dom_dom_selection_get_anchor_offset;

    extern fn webkit_dom_dom_selection_get_base_node(p_self: *DOMDOMSelection) *webkit2webextension.DOMNode;
    pub const getBaseNode = webkit_dom_dom_selection_get_base_node;

    extern fn webkit_dom_dom_selection_get_base_offset(p_self: *DOMDOMSelection) c_ulong;
    pub const getBaseOffset = webkit_dom_dom_selection_get_base_offset;

    extern fn webkit_dom_dom_selection_get_extent_node(p_self: *DOMDOMSelection) *webkit2webextension.DOMNode;
    pub const getExtentNode = webkit_dom_dom_selection_get_extent_node;

    extern fn webkit_dom_dom_selection_get_extent_offset(p_self: *DOMDOMSelection) c_ulong;
    pub const getExtentOffset = webkit_dom_dom_selection_get_extent_offset;

    extern fn webkit_dom_dom_selection_get_focus_node(p_self: *DOMDOMSelection) *webkit2webextension.DOMNode;
    pub const getFocusNode = webkit_dom_dom_selection_get_focus_node;

    extern fn webkit_dom_dom_selection_get_focus_offset(p_self: *DOMDOMSelection) c_ulong;
    pub const getFocusOffset = webkit_dom_dom_selection_get_focus_offset;

    extern fn webkit_dom_dom_selection_get_is_collapsed(p_self: *DOMDOMSelection) c_int;
    pub const getIsCollapsed = webkit_dom_dom_selection_get_is_collapsed;

    extern fn webkit_dom_dom_selection_get_range_at(p_self: *DOMDOMSelection, p_index: c_ulong, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMRange;
    pub const getRangeAt = webkit_dom_dom_selection_get_range_at;

    extern fn webkit_dom_dom_selection_get_range_count(p_self: *DOMDOMSelection) c_ulong;
    pub const getRangeCount = webkit_dom_dom_selection_get_range_count;

    extern fn webkit_dom_dom_selection_get_selection_type(p_self: *DOMDOMSelection) [*:0]u8;
    pub const getSelectionType = webkit_dom_dom_selection_get_selection_type;

    extern fn webkit_dom_dom_selection_modify(p_self: *DOMDOMSelection, p_alter: [*:0]const u8, p_direction: [*:0]const u8, p_granularity: [*:0]const u8) void;
    pub const modify = webkit_dom_dom_selection_modify;

    extern fn webkit_dom_dom_selection_remove_all_ranges(p_self: *DOMDOMSelection) void;
    pub const removeAllRanges = webkit_dom_dom_selection_remove_all_ranges;

    extern fn webkit_dom_dom_selection_select_all_children(p_self: *DOMDOMSelection, p_node: *webkit2webextension.DOMNode) void;
    pub const selectAllChildren = webkit_dom_dom_selection_select_all_children;

    extern fn webkit_dom_dom_selection_set_base_and_extent(p_self: *DOMDOMSelection, p_baseNode: *webkit2webextension.DOMNode, p_baseOffset: c_ulong, p_extentNode: *webkit2webextension.DOMNode, p_extentOffset: c_ulong) void;
    pub const setBaseAndExtent = webkit_dom_dom_selection_set_base_and_extent;

    extern fn webkit_dom_dom_selection_set_position(p_self: *DOMDOMSelection, p_node: *webkit2webextension.DOMNode, p_offset: c_ulong) void;
    pub const setPosition = webkit_dom_dom_selection_set_position;

    extern fn webkit_dom_dom_selection_get_type() usize;
    pub const getGObjectType = webkit_dom_dom_selection_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMDOMSelection) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMDOMSelection) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMDOMSelection, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMTokenList = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMDOMTokenListClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_dom_token_list_add(p_self: *DOMDOMTokenList, p_error: **glib.Error, ...) void;
    pub const add = webkit_dom_dom_token_list_add;

    extern fn webkit_dom_dom_token_list_contains(p_self: *DOMDOMTokenList, p_token: [*:0]const u8) c_int;
    pub const contains = webkit_dom_dom_token_list_contains;

    extern fn webkit_dom_dom_token_list_get_length(p_self: *DOMDOMTokenList) c_ulong;
    pub const getLength = webkit_dom_dom_token_list_get_length;

    extern fn webkit_dom_dom_token_list_get_value(p_self: *DOMDOMTokenList) [*:0]u8;
    pub const getValue = webkit_dom_dom_token_list_get_value;

    extern fn webkit_dom_dom_token_list_item(p_self: *DOMDOMTokenList, p_index: c_ulong) [*:0]u8;
    pub const item = webkit_dom_dom_token_list_item;

    extern fn webkit_dom_dom_token_list_remove(p_self: *DOMDOMTokenList, p_error: **glib.Error, ...) void;
    pub const remove = webkit_dom_dom_token_list_remove;

    extern fn webkit_dom_dom_token_list_replace(p_self: *DOMDOMTokenList, p_token: [*:0]const u8, p_newToken: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const replace = webkit_dom_dom_token_list_replace;

    extern fn webkit_dom_dom_token_list_set_value(p_self: *DOMDOMTokenList, p_value: [*:0]const u8) void;
    pub const setValue = webkit_dom_dom_token_list_set_value;

    extern fn webkit_dom_dom_token_list_toggle(p_self: *DOMDOMTokenList, p_token: [*:0]const u8, p_force: c_int, p_error: ?*?*glib.Error) c_int;
    pub const toggle = webkit_dom_dom_token_list_toggle;

    extern fn webkit_dom_dom_token_list_get_type() usize;
    pub const getGObjectType = webkit_dom_dom_token_list_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMDOMTokenList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMDOMTokenList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMDOMTokenList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMWindow = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMDOMWindowClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const closed = struct {
            pub const name = "closed";

            pub const Type = c_int;
        };

        pub const default_status = struct {
            pub const name = "default-status";

            pub const Type = ?[*:0]u8;
        };

        pub const device_pixel_ratio = struct {
            pub const name = "device-pixel-ratio";

            pub const Type = f64;
        };

        pub const document = struct {
            pub const name = "document";

            pub const Type = ?*webkit2webextension.DOMDocument;
        };

        pub const frame_element = struct {
            pub const name = "frame-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const frames = struct {
            pub const name = "frames";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const inner_height = struct {
            pub const name = "inner-height";

            pub const Type = c_long;
        };

        pub const inner_width = struct {
            pub const name = "inner-width";

            pub const Type = c_long;
        };

        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const offscreen_buffering = struct {
            pub const name = "offscreen-buffering";

            pub const Type = c_int;
        };

        pub const opener = struct {
            pub const name = "opener";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const orientation = struct {
            pub const name = "orientation";

            pub const Type = c_long;
        };

        pub const outer_height = struct {
            pub const name = "outer-height";

            pub const Type = c_long;
        };

        pub const outer_width = struct {
            pub const name = "outer-width";

            pub const Type = c_long;
        };

        pub const page_x_offset = struct {
            pub const name = "page-x-offset";

            pub const Type = c_long;
        };

        pub const page_y_offset = struct {
            pub const name = "page-y-offset";

            pub const Type = c_long;
        };

        pub const parent = struct {
            pub const name = "parent";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const screen_left = struct {
            pub const name = "screen-left";

            pub const Type = c_long;
        };

        pub const screen_top = struct {
            pub const name = "screen-top";

            pub const Type = c_long;
        };

        pub const screen_x = struct {
            pub const name = "screen-x";

            pub const Type = c_long;
        };

        pub const screen_y = struct {
            pub const name = "screen-y";

            pub const Type = c_long;
        };

        pub const scroll_x = struct {
            pub const name = "scroll-x";

            pub const Type = c_long;
        };

        pub const scroll_y = struct {
            pub const name = "scroll-y";

            pub const Type = c_long;
        };

        pub const self = struct {
            pub const name = "self";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const status = struct {
            pub const name = "status";

            pub const Type = ?[*:0]u8;
        };

        pub const top = struct {
            pub const name = "top";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const window = struct {
            pub const name = "window";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_dom_window_alert(p_self: *DOMDOMWindow, p_message: [*:0]const u8) void;
    pub const alert = webkit_dom_dom_window_alert;

    extern fn webkit_dom_dom_window_blur(p_self: *DOMDOMWindow) void;
    pub const blur = webkit_dom_dom_window_blur;

    extern fn webkit_dom_dom_window_capture_events(p_self: *DOMDOMWindow) void;
    pub const captureEvents = webkit_dom_dom_window_capture_events;

    extern fn webkit_dom_dom_window_close(p_self: *DOMDOMWindow) void;
    pub const close = webkit_dom_dom_window_close;

    extern fn webkit_dom_dom_window_confirm(p_self: *DOMDOMWindow, p_message: [*:0]const u8) c_int;
    pub const confirm = webkit_dom_dom_window_confirm;

    extern fn webkit_dom_dom_window_find(p_self: *DOMDOMWindow, p_string: [*:0]const u8, p_caseSensitive: c_int, p_backwards: c_int, p_wrap: c_int, p_wholeWord: c_int, p_searchInFrames: c_int, p_showDialog: c_int) c_int;
    pub const find = webkit_dom_dom_window_find;

    extern fn webkit_dom_dom_window_focus(p_self: *DOMDOMWindow) void;
    pub const focus = webkit_dom_dom_window_focus;

    extern fn webkit_dom_dom_window_get_closed(p_self: *DOMDOMWindow) c_int;
    pub const getClosed = webkit_dom_dom_window_get_closed;

    extern fn webkit_dom_dom_window_get_computed_style(p_self: *DOMDOMWindow, p_element: *webkit2webextension.DOMElement, p_pseudoElement: ?[*:0]const u8) *webkit2webextension.DOMCSSStyleDeclaration;
    pub const getComputedStyle = webkit_dom_dom_window_get_computed_style;

    extern fn webkit_dom_dom_window_get_default_status(p_self: *DOMDOMWindow) [*:0]u8;
    pub const getDefaultStatus = webkit_dom_dom_window_get_default_status;

    extern fn webkit_dom_dom_window_get_device_pixel_ratio(p_self: *DOMDOMWindow) f64;
    pub const getDevicePixelRatio = webkit_dom_dom_window_get_device_pixel_ratio;

    extern fn webkit_dom_dom_window_get_document(p_self: *DOMDOMWindow) *webkit2webextension.DOMDocument;
    pub const getDocument = webkit_dom_dom_window_get_document;

    extern fn webkit_dom_dom_window_get_frame_element(p_self: *DOMDOMWindow) *webkit2webextension.DOMElement;
    pub const getFrameElement = webkit_dom_dom_window_get_frame_element;

    extern fn webkit_dom_dom_window_get_frames(p_self: *DOMDOMWindow) *webkit2webextension.DOMDOMWindow;
    pub const getFrames = webkit_dom_dom_window_get_frames;

    extern fn webkit_dom_dom_window_get_inner_height(p_self: *DOMDOMWindow) c_long;
    pub const getInnerHeight = webkit_dom_dom_window_get_inner_height;

    extern fn webkit_dom_dom_window_get_inner_width(p_self: *DOMDOMWindow) c_long;
    pub const getInnerWidth = webkit_dom_dom_window_get_inner_width;

    extern fn webkit_dom_dom_window_get_length(p_self: *DOMDOMWindow) c_ulong;
    pub const getLength = webkit_dom_dom_window_get_length;

    extern fn webkit_dom_dom_window_get_name(p_self: *DOMDOMWindow) [*:0]u8;
    pub const getName = webkit_dom_dom_window_get_name;

    extern fn webkit_dom_dom_window_get_offscreen_buffering(p_self: *DOMDOMWindow) c_int;
    pub const getOffscreenBuffering = webkit_dom_dom_window_get_offscreen_buffering;

    extern fn webkit_dom_dom_window_get_opener(p_self: *DOMDOMWindow) *webkit2webextension.DOMDOMWindow;
    pub const getOpener = webkit_dom_dom_window_get_opener;

    extern fn webkit_dom_dom_window_get_orientation(p_self: *DOMDOMWindow) c_long;
    pub const getOrientation = webkit_dom_dom_window_get_orientation;

    extern fn webkit_dom_dom_window_get_outer_height(p_self: *DOMDOMWindow) c_long;
    pub const getOuterHeight = webkit_dom_dom_window_get_outer_height;

    extern fn webkit_dom_dom_window_get_outer_width(p_self: *DOMDOMWindow) c_long;
    pub const getOuterWidth = webkit_dom_dom_window_get_outer_width;

    extern fn webkit_dom_dom_window_get_page_x_offset(p_self: *DOMDOMWindow) c_long;
    pub const getPageXOffset = webkit_dom_dom_window_get_page_x_offset;

    extern fn webkit_dom_dom_window_get_page_y_offset(p_self: *DOMDOMWindow) c_long;
    pub const getPageYOffset = webkit_dom_dom_window_get_page_y_offset;

    extern fn webkit_dom_dom_window_get_parent(p_self: *DOMDOMWindow) *webkit2webextension.DOMDOMWindow;
    pub const getParent = webkit_dom_dom_window_get_parent;

    extern fn webkit_dom_dom_window_get_screen_left(p_self: *DOMDOMWindow) c_long;
    pub const getScreenLeft = webkit_dom_dom_window_get_screen_left;

    extern fn webkit_dom_dom_window_get_screen_top(p_self: *DOMDOMWindow) c_long;
    pub const getScreenTop = webkit_dom_dom_window_get_screen_top;

    extern fn webkit_dom_dom_window_get_screen_x(p_self: *DOMDOMWindow) c_long;
    pub const getScreenX = webkit_dom_dom_window_get_screen_x;

    extern fn webkit_dom_dom_window_get_screen_y(p_self: *DOMDOMWindow) c_long;
    pub const getScreenY = webkit_dom_dom_window_get_screen_y;

    extern fn webkit_dom_dom_window_get_scroll_x(p_self: *DOMDOMWindow) c_long;
    pub const getScrollX = webkit_dom_dom_window_get_scroll_x;

    extern fn webkit_dom_dom_window_get_scroll_y(p_self: *DOMDOMWindow) c_long;
    pub const getScrollY = webkit_dom_dom_window_get_scroll_y;

    extern fn webkit_dom_dom_window_get_selection(p_self: *DOMDOMWindow) *webkit2webextension.DOMDOMSelection;
    pub const getSelection = webkit_dom_dom_window_get_selection;

    extern fn webkit_dom_dom_window_get_self(p_self: *DOMDOMWindow) *webkit2webextension.DOMDOMWindow;
    pub const getSelf = webkit_dom_dom_window_get_self;

    extern fn webkit_dom_dom_window_get_status(p_self: *DOMDOMWindow) [*:0]u8;
    pub const getStatus = webkit_dom_dom_window_get_status;

    extern fn webkit_dom_dom_window_get_top(p_self: *DOMDOMWindow) *webkit2webextension.DOMDOMWindow;
    pub const getTop = webkit_dom_dom_window_get_top;

    extern fn webkit_dom_dom_window_get_window(p_self: *DOMDOMWindow) *webkit2webextension.DOMDOMWindow;
    pub const getWindow = webkit_dom_dom_window_get_window;

    extern fn webkit_dom_dom_window_move_by(p_self: *DOMDOMWindow, p_x: f32, p_y: f32) void;
    pub const moveBy = webkit_dom_dom_window_move_by;

    extern fn webkit_dom_dom_window_move_to(p_self: *DOMDOMWindow, p_x: f32, p_y: f32) void;
    pub const moveTo = webkit_dom_dom_window_move_to;

    extern fn webkit_dom_dom_window_print(p_self: *DOMDOMWindow) void;
    pub const print = webkit_dom_dom_window_print;

    extern fn webkit_dom_dom_window_prompt(p_self: *DOMDOMWindow, p_message: [*:0]const u8, p_defaultValue: [*:0]const u8) [*:0]u8;
    pub const prompt = webkit_dom_dom_window_prompt;

    extern fn webkit_dom_dom_window_release_events(p_self: *DOMDOMWindow) void;
    pub const releaseEvents = webkit_dom_dom_window_release_events;

    extern fn webkit_dom_dom_window_resize_by(p_self: *DOMDOMWindow, p_x: f32, p_y: f32) void;
    pub const resizeBy = webkit_dom_dom_window_resize_by;

    extern fn webkit_dom_dom_window_resize_to(p_self: *DOMDOMWindow, p_width: f32, p_height: f32) void;
    pub const resizeTo = webkit_dom_dom_window_resize_to;

    extern fn webkit_dom_dom_window_scroll_by(p_self: *DOMDOMWindow, p_x: f64, p_y: f64) void;
    pub const scrollBy = webkit_dom_dom_window_scroll_by;

    extern fn webkit_dom_dom_window_scroll_to(p_self: *DOMDOMWindow, p_x: f64, p_y: f64) void;
    pub const scrollTo = webkit_dom_dom_window_scroll_to;

    extern fn webkit_dom_dom_window_set_default_status(p_self: *DOMDOMWindow, p_value: [*:0]const u8) void;
    pub const setDefaultStatus = webkit_dom_dom_window_set_default_status;

    extern fn webkit_dom_dom_window_set_name(p_self: *DOMDOMWindow, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_dom_window_set_name;

    extern fn webkit_dom_dom_window_set_status(p_self: *DOMDOMWindow, p_value: [*:0]const u8) void;
    pub const setStatus = webkit_dom_dom_window_set_status;

    extern fn webkit_dom_dom_window_stop(p_self: *DOMDOMWindow) void;
    pub const stop = webkit_dom_dom_window_stop;

    extern fn webkit_dom_dom_window_webkit_message_handlers_post_message(p_window: *DOMDOMWindow, p_handler: [*:0]const u8, p_message: [*:0]const u8) c_int;
    pub const webkitMessageHandlersPostMessage = webkit_dom_dom_window_webkit_message_handlers_post_message;

    extern fn webkit_dom_dom_window_get_type() usize;
    pub const getGObjectType = webkit_dom_dom_window_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMDOMWindow) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMDOMWindow) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMDOMWindow, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDocument = extern struct {
    pub const Parent = webkit2webextension.DOMNode;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMDocumentClass;
    f_parent_instance: webkit2webextension.DOMNode,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const active_element = struct {
            pub const name = "active-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const anchors = struct {
            pub const name = "anchors";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const applets = struct {
            pub const name = "applets";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const body = struct {
            pub const name = "body";

            pub const Type = ?*webkit2webextension.DOMHTMLElement;
        };

        pub const character_set = struct {
            pub const name = "character-set";

            pub const Type = ?[*:0]u8;
        };

        pub const charset = struct {
            pub const name = "charset";

            pub const Type = ?[*:0]u8;
        };

        pub const child_element_count = struct {
            pub const name = "child-element-count";

            pub const Type = c_ulong;
        };

        pub const children = struct {
            pub const name = "children";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const compat_mode = struct {
            pub const name = "compat-mode";

            pub const Type = ?[*:0]u8;
        };

        pub const content_type = struct {
            pub const name = "content-type";

            pub const Type = ?[*:0]u8;
        };

        pub const cookie = struct {
            pub const name = "cookie";

            pub const Type = ?[*:0]u8;
        };

        pub const current_script = struct {
            pub const name = "current-script";

            pub const Type = ?*webkit2webextension.DOMHTMLScriptElement;
        };

        pub const default_view = struct {
            pub const name = "default-view";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const design_mode = struct {
            pub const name = "design-mode";

            pub const Type = ?[*:0]u8;
        };

        pub const dir = struct {
            pub const name = "dir";

            pub const Type = ?[*:0]u8;
        };

        pub const doctype = struct {
            pub const name = "doctype";

            pub const Type = ?*webkit2webextension.DOMDocumentType;
        };

        pub const document_element = struct {
            pub const name = "document-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const document_uri = struct {
            pub const name = "document-uri";

            pub const Type = ?[*:0]u8;
        };

        pub const domain = struct {
            pub const name = "domain";

            pub const Type = ?[*:0]u8;
        };

        pub const embeds = struct {
            pub const name = "embeds";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const first_element_child = struct {
            pub const name = "first-element-child";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const forms = struct {
            pub const name = "forms";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const head = struct {
            pub const name = "head";

            pub const Type = ?*webkit2webextension.DOMHTMLHeadElement;
        };

        pub const hidden = struct {
            pub const name = "hidden";

            pub const Type = c_int;
        };

        pub const images = struct {
            pub const name = "images";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const implementation = struct {
            pub const name = "implementation";

            pub const Type = ?*webkit2webextension.DOMDOMImplementation;
        };

        pub const input_encoding = struct {
            pub const name = "input-encoding";

            pub const Type = ?[*:0]u8;
        };

        pub const last_element_child = struct {
            pub const name = "last-element-child";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const last_modified = struct {
            pub const name = "last-modified";

            pub const Type = ?[*:0]u8;
        };

        pub const links = struct {
            pub const name = "links";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const origin = struct {
            pub const name = "origin";

            pub const Type = ?[*:0]u8;
        };

        pub const plugins = struct {
            pub const name = "plugins";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const pointer_lock_element = struct {
            pub const name = "pointer-lock-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const preferred_stylesheet_set = struct {
            pub const name = "preferred-stylesheet-set";

            pub const Type = ?[*:0]u8;
        };

        pub const ready_state = struct {
            pub const name = "ready-state";

            pub const Type = ?[*:0]u8;
        };

        pub const referrer = struct {
            pub const name = "referrer";

            pub const Type = ?[*:0]u8;
        };

        pub const scripts = struct {
            pub const name = "scripts";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const scrolling_element = struct {
            pub const name = "scrolling-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const selected_stylesheet_set = struct {
            pub const name = "selected-stylesheet-set";

            pub const Type = ?[*:0]u8;
        };

        pub const style_sheets = struct {
            pub const name = "style-sheets";

            pub const Type = ?*webkit2webextension.DOMStyleSheetList;
        };

        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };

        pub const url = struct {
            pub const name = "url";

            pub const Type = ?[*:0]u8;
        };

        pub const visibility_state = struct {
            pub const name = "visibility-state";

            pub const Type = ?[*:0]u8;
        };

        pub const webkit_current_full_screen_element = struct {
            pub const name = "webkit-current-full-screen-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const webkit_full_screen_keyboard_input_allowed = struct {
            pub const name = "webkit-full-screen-keyboard-input-allowed";

            pub const Type = c_int;
        };

        pub const webkit_fullscreen_element = struct {
            pub const name = "webkit-fullscreen-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const webkit_fullscreen_enabled = struct {
            pub const name = "webkit-fullscreen-enabled";

            pub const Type = c_int;
        };

        pub const webkit_is_full_screen = struct {
            pub const name = "webkit-is-full-screen";

            pub const Type = c_int;
        };

        pub const xml_encoding = struct {
            pub const name = "xml-encoding";

            pub const Type = ?[*:0]u8;
        };

        pub const xml_standalone = struct {
            pub const name = "xml-standalone";

            pub const Type = c_int;
        };

        pub const xml_version = struct {
            pub const name = "xml-version";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_document_adopt_node(p_self: *DOMDocument, p_source: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const adoptNode = webkit_dom_document_adopt_node;

    extern fn webkit_dom_document_caret_range_from_point(p_self: *DOMDocument, p_x: c_long, p_y: c_long) *webkit2webextension.DOMRange;
    pub const caretRangeFromPoint = webkit_dom_document_caret_range_from_point;

    extern fn webkit_dom_document_create_attribute(p_self: *DOMDocument, p_name: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMAttr;
    pub const createAttribute = webkit_dom_document_create_attribute;

    extern fn webkit_dom_document_create_attribute_ns(p_self: *DOMDocument, p_namespaceURI: ?[*:0]const u8, p_qualifiedName: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMAttr;
    pub const createAttributeNs = webkit_dom_document_create_attribute_ns;

    extern fn webkit_dom_document_create_cdata_section(p_self: *DOMDocument, p_data: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMCDATASection;
    pub const createCdataSection = webkit_dom_document_create_cdata_section;

    extern fn webkit_dom_document_create_comment(p_self: *DOMDocument, p_data: [*:0]const u8) *webkit2webextension.DOMComment;
    pub const createComment = webkit_dom_document_create_comment;

    extern fn webkit_dom_document_create_css_style_declaration(p_self: *DOMDocument) *webkit2webextension.DOMCSSStyleDeclaration;
    pub const createCssStyleDeclaration = webkit_dom_document_create_css_style_declaration;

    extern fn webkit_dom_document_create_document_fragment(p_self: *DOMDocument) *webkit2webextension.DOMDocumentFragment;
    pub const createDocumentFragment = webkit_dom_document_create_document_fragment;

    extern fn webkit_dom_document_create_element(p_self: *DOMDocument, p_tagName: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMElement;
    pub const createElement = webkit_dom_document_create_element;

    extern fn webkit_dom_document_create_element_ns(p_self: *DOMDocument, p_namespaceURI: ?[*:0]const u8, p_qualifiedName: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMElement;
    pub const createElementNs = webkit_dom_document_create_element_ns;

    /// This function has been removed from the DOM spec and it just returns `NULL`.
    extern fn webkit_dom_document_create_entity_reference(p_self: *DOMDocument, p_name: ?[*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMEntityReference;
    pub const createEntityReference = webkit_dom_document_create_entity_reference;

    extern fn webkit_dom_document_create_event(p_self: *DOMDocument, p_eventType: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMEvent;
    pub const createEvent = webkit_dom_document_create_event;

    extern fn webkit_dom_document_create_expression(p_self: *DOMDocument, p_expression: [*:0]const u8, p_resolver: *webkit2webextension.DOMXPathNSResolver, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMXPathExpression;
    pub const createExpression = webkit_dom_document_create_expression;

    extern fn webkit_dom_document_create_node_iterator(p_self: *DOMDocument, p_root: *webkit2webextension.DOMNode, p_whatToShow: c_ulong, p_filter: ?*webkit2webextension.DOMNodeFilter, p_expandEntityReferences: c_int, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNodeIterator;
    pub const createNodeIterator = webkit_dom_document_create_node_iterator;

    extern fn webkit_dom_document_create_ns_resolver(p_self: *DOMDocument, p_nodeResolver: *webkit2webextension.DOMNode) *webkit2webextension.DOMXPathNSResolver;
    pub const createNsResolver = webkit_dom_document_create_ns_resolver;

    extern fn webkit_dom_document_create_processing_instruction(p_self: *DOMDocument, p_target: [*:0]const u8, p_data: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMProcessingInstruction;
    pub const createProcessingInstruction = webkit_dom_document_create_processing_instruction;

    extern fn webkit_dom_document_create_range(p_self: *DOMDocument) *webkit2webextension.DOMRange;
    pub const createRange = webkit_dom_document_create_range;

    extern fn webkit_dom_document_create_text_node(p_self: *DOMDocument, p_data: [*:0]const u8) *webkit2webextension.DOMText;
    pub const createTextNode = webkit_dom_document_create_text_node;

    extern fn webkit_dom_document_create_tree_walker(p_self: *DOMDocument, p_root: *webkit2webextension.DOMNode, p_whatToShow: c_ulong, p_filter: ?*webkit2webextension.DOMNodeFilter, p_expandEntityReferences: c_int, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMTreeWalker;
    pub const createTreeWalker = webkit_dom_document_create_tree_walker;

    extern fn webkit_dom_document_element_from_point(p_self: *DOMDocument, p_x: c_long, p_y: c_long) *webkit2webextension.DOMElement;
    pub const elementFromPoint = webkit_dom_document_element_from_point;

    extern fn webkit_dom_document_evaluate(p_self: *DOMDocument, p_expression: [*:0]const u8, p_contextNode: *webkit2webextension.DOMNode, p_resolver: ?*webkit2webextension.DOMXPathNSResolver, p_type: c_ushort, p_inResult: ?*webkit2webextension.DOMXPathResult, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMXPathResult;
    pub const evaluate = webkit_dom_document_evaluate;

    extern fn webkit_dom_document_exec_command(p_self: *DOMDocument, p_command: [*:0]const u8, p_userInterface: c_int, p_value: [*:0]const u8) c_int;
    pub const execCommand = webkit_dom_document_exec_command;

    extern fn webkit_dom_document_exit_pointer_lock(p_self: *DOMDocument) void;
    pub const exitPointerLock = webkit_dom_document_exit_pointer_lock;

    extern fn webkit_dom_document_get_active_element(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getActiveElement = webkit_dom_document_get_active_element;

    extern fn webkit_dom_document_get_anchors(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getAnchors = webkit_dom_document_get_anchors;

    extern fn webkit_dom_document_get_applets(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getApplets = webkit_dom_document_get_applets;

    extern fn webkit_dom_document_get_body(p_self: *DOMDocument) *webkit2webextension.DOMHTMLElement;
    pub const getBody = webkit_dom_document_get_body;

    extern fn webkit_dom_document_get_character_set(p_self: *DOMDocument) [*:0]u8;
    pub const getCharacterSet = webkit_dom_document_get_character_set;

    extern fn webkit_dom_document_get_charset(p_self: *DOMDocument) [*:0]u8;
    pub const getCharset = webkit_dom_document_get_charset;

    extern fn webkit_dom_document_get_child_element_count(p_self: *DOMDocument) c_ulong;
    pub const getChildElementCount = webkit_dom_document_get_child_element_count;

    extern fn webkit_dom_document_get_children(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getChildren = webkit_dom_document_get_children;

    extern fn webkit_dom_document_get_compat_mode(p_self: *DOMDocument) [*:0]u8;
    pub const getCompatMode = webkit_dom_document_get_compat_mode;

    extern fn webkit_dom_document_get_content_type(p_self: *DOMDocument) [*:0]u8;
    pub const getContentType = webkit_dom_document_get_content_type;

    extern fn webkit_dom_document_get_cookie(p_self: *DOMDocument, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const getCookie = webkit_dom_document_get_cookie;

    extern fn webkit_dom_document_get_current_script(p_self: *DOMDocument) *webkit2webextension.DOMHTMLScriptElement;
    pub const getCurrentScript = webkit_dom_document_get_current_script;

    extern fn webkit_dom_document_get_default_charset(p_self: *DOMDocument) [*:0]u8;
    pub const getDefaultCharset = webkit_dom_document_get_default_charset;

    extern fn webkit_dom_document_get_default_view(p_self: *DOMDocument) *webkit2webextension.DOMDOMWindow;
    pub const getDefaultView = webkit_dom_document_get_default_view;

    extern fn webkit_dom_document_get_design_mode(p_self: *DOMDocument) [*:0]u8;
    pub const getDesignMode = webkit_dom_document_get_design_mode;

    extern fn webkit_dom_document_get_dir(p_self: *DOMDocument) [*:0]u8;
    pub const getDir = webkit_dom_document_get_dir;

    extern fn webkit_dom_document_get_doctype(p_self: *DOMDocument) *webkit2webextension.DOMDocumentType;
    pub const getDoctype = webkit_dom_document_get_doctype;

    extern fn webkit_dom_document_get_document_element(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getDocumentElement = webkit_dom_document_get_document_element;

    extern fn webkit_dom_document_get_document_uri(p_self: *DOMDocument) [*:0]u8;
    pub const getDocumentUri = webkit_dom_document_get_document_uri;

    extern fn webkit_dom_document_get_domain(p_self: *DOMDocument) [*:0]u8;
    pub const getDomain = webkit_dom_document_get_domain;

    extern fn webkit_dom_document_get_element_by_id(p_self: *DOMDocument, p_elementId: [*:0]const u8) *webkit2webextension.DOMElement;
    pub const getElementById = webkit_dom_document_get_element_by_id;

    extern fn webkit_dom_document_get_elements_by_class_name(p_self: *DOMDocument, p_class_name: [*:0]const u8) *webkit2webextension.DOMNodeList;
    pub const getElementsByClassName = webkit_dom_document_get_elements_by_class_name;

    extern fn webkit_dom_document_get_elements_by_class_name_as_html_collection(p_self: *DOMDocument, p_classNames: [*:0]const u8) *webkit2webextension.DOMHTMLCollection;
    pub const getElementsByClassNameAsHtmlCollection = webkit_dom_document_get_elements_by_class_name_as_html_collection;

    extern fn webkit_dom_document_get_elements_by_name(p_self: *DOMDocument, p_elementName: [*:0]const u8) *webkit2webextension.DOMNodeList;
    pub const getElementsByName = webkit_dom_document_get_elements_by_name;

    extern fn webkit_dom_document_get_elements_by_tag_name(p_self: *DOMDocument, p_tag_name: [*:0]const u8) *webkit2webextension.DOMNodeList;
    pub const getElementsByTagName = webkit_dom_document_get_elements_by_tag_name;

    extern fn webkit_dom_document_get_elements_by_tag_name_as_html_collection(p_self: *DOMDocument, p_tagname: [*:0]const u8) *webkit2webextension.DOMHTMLCollection;
    pub const getElementsByTagNameAsHtmlCollection = webkit_dom_document_get_elements_by_tag_name_as_html_collection;

    extern fn webkit_dom_document_get_elements_by_tag_name_ns(p_self: *DOMDocument, p_namespace_uri: [*:0]const u8, p_tag_name: [*:0]const u8) *webkit2webextension.DOMNodeList;
    pub const getElementsByTagNameNs = webkit_dom_document_get_elements_by_tag_name_ns;

    extern fn webkit_dom_document_get_elements_by_tag_name_ns_as_html_collection(p_self: *DOMDocument, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8) *webkit2webextension.DOMHTMLCollection;
    pub const getElementsByTagNameNsAsHtmlCollection = webkit_dom_document_get_elements_by_tag_name_ns_as_html_collection;

    extern fn webkit_dom_document_get_embeds(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getEmbeds = webkit_dom_document_get_embeds;

    extern fn webkit_dom_document_get_first_element_child(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getFirstElementChild = webkit_dom_document_get_first_element_child;

    extern fn webkit_dom_document_get_forms(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getForms = webkit_dom_document_get_forms;

    extern fn webkit_dom_document_get_head(p_self: *DOMDocument) *webkit2webextension.DOMHTMLHeadElement;
    pub const getHead = webkit_dom_document_get_head;

    extern fn webkit_dom_document_get_hidden(p_self: *DOMDocument) c_int;
    pub const getHidden = webkit_dom_document_get_hidden;

    extern fn webkit_dom_document_get_images(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getImages = webkit_dom_document_get_images;

    extern fn webkit_dom_document_get_implementation(p_self: *DOMDocument) *webkit2webextension.DOMDOMImplementation;
    pub const getImplementation = webkit_dom_document_get_implementation;

    extern fn webkit_dom_document_get_input_encoding(p_self: *DOMDocument) [*:0]u8;
    pub const getInputEncoding = webkit_dom_document_get_input_encoding;

    extern fn webkit_dom_document_get_last_element_child(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getLastElementChild = webkit_dom_document_get_last_element_child;

    extern fn webkit_dom_document_get_last_modified(p_self: *DOMDocument) [*:0]u8;
    pub const getLastModified = webkit_dom_document_get_last_modified;

    extern fn webkit_dom_document_get_links(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getLinks = webkit_dom_document_get_links;

    extern fn webkit_dom_document_get_origin(p_self: *DOMDocument) [*:0]u8;
    pub const getOrigin = webkit_dom_document_get_origin;

    extern fn webkit_dom_document_get_override_style(p_self: *DOMDocument, p_element: *webkit2webextension.DOMElement, p_pseudoElement: ?[*:0]const u8) *webkit2webextension.DOMCSSStyleDeclaration;
    pub const getOverrideStyle = webkit_dom_document_get_override_style;

    extern fn webkit_dom_document_get_plugins(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getPlugins = webkit_dom_document_get_plugins;

    extern fn webkit_dom_document_get_pointer_lock_element(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getPointerLockElement = webkit_dom_document_get_pointer_lock_element;

    /// This function has been removed and does nothing.
    extern fn webkit_dom_document_get_preferred_stylesheet_set(p_self: *DOMDocument) [*:0]u8;
    pub const getPreferredStylesheetSet = webkit_dom_document_get_preferred_stylesheet_set;

    extern fn webkit_dom_document_get_ready_state(p_self: *DOMDocument) [*:0]u8;
    pub const getReadyState = webkit_dom_document_get_ready_state;

    extern fn webkit_dom_document_get_referrer(p_self: *DOMDocument) [*:0]u8;
    pub const getReferrer = webkit_dom_document_get_referrer;

    extern fn webkit_dom_document_get_scripts(p_self: *DOMDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getScripts = webkit_dom_document_get_scripts;

    extern fn webkit_dom_document_get_scrolling_element(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getScrollingElement = webkit_dom_document_get_scrolling_element;

    /// This function has been removed and does nothing.
    extern fn webkit_dom_document_get_selected_stylesheet_set(p_self: *DOMDocument) [*:0]u8;
    pub const getSelectedStylesheetSet = webkit_dom_document_get_selected_stylesheet_set;

    extern fn webkit_dom_document_get_style_sheets(p_self: *DOMDocument) *webkit2webextension.DOMStyleSheetList;
    pub const getStyleSheets = webkit_dom_document_get_style_sheets;

    extern fn webkit_dom_document_get_title(p_self: *DOMDocument) [*:0]u8;
    pub const getTitle = webkit_dom_document_get_title;

    extern fn webkit_dom_document_get_url(p_self: *DOMDocument) [*:0]u8;
    pub const getUrl = webkit_dom_document_get_url;

    extern fn webkit_dom_document_get_visibility_state(p_self: *DOMDocument) [*:0]u8;
    pub const getVisibilityState = webkit_dom_document_get_visibility_state;

    extern fn webkit_dom_document_get_webkit_current_fullscreen_element(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getWebkitCurrentFullscreenElement = webkit_dom_document_get_webkit_current_fullscreen_element;

    extern fn webkit_dom_document_get_webkit_fullscreen_element(p_self: *DOMDocument) *webkit2webextension.DOMElement;
    pub const getWebkitFullscreenElement = webkit_dom_document_get_webkit_fullscreen_element;

    extern fn webkit_dom_document_get_webkit_fullscreen_enabled(p_self: *DOMDocument) c_int;
    pub const getWebkitFullscreenEnabled = webkit_dom_document_get_webkit_fullscreen_enabled;

    extern fn webkit_dom_document_get_webkit_fullscreen_keyboard_input_allowed(p_self: *DOMDocument) c_int;
    pub const getWebkitFullscreenKeyboardInputAllowed = webkit_dom_document_get_webkit_fullscreen_keyboard_input_allowed;

    extern fn webkit_dom_document_get_webkit_is_fullscreen(p_self: *DOMDocument) c_int;
    pub const getWebkitIsFullscreen = webkit_dom_document_get_webkit_is_fullscreen;

    extern fn webkit_dom_document_get_xml_encoding(p_self: *DOMDocument) [*:0]u8;
    pub const getXmlEncoding = webkit_dom_document_get_xml_encoding;

    extern fn webkit_dom_document_get_xml_standalone(p_self: *DOMDocument) c_int;
    pub const getXmlStandalone = webkit_dom_document_get_xml_standalone;

    extern fn webkit_dom_document_get_xml_version(p_self: *DOMDocument) [*:0]u8;
    pub const getXmlVersion = webkit_dom_document_get_xml_version;

    extern fn webkit_dom_document_has_focus(p_self: *DOMDocument) c_int;
    pub const hasFocus = webkit_dom_document_has_focus;

    extern fn webkit_dom_document_import_node(p_self: *DOMDocument, p_importedNode: *webkit2webextension.DOMNode, p_deep: c_int, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const importNode = webkit_dom_document_import_node;

    extern fn webkit_dom_document_query_command_enabled(p_self: *DOMDocument, p_command: [*:0]const u8) c_int;
    pub const queryCommandEnabled = webkit_dom_document_query_command_enabled;

    extern fn webkit_dom_document_query_command_indeterm(p_self: *DOMDocument, p_command: [*:0]const u8) c_int;
    pub const queryCommandIndeterm = webkit_dom_document_query_command_indeterm;

    extern fn webkit_dom_document_query_command_state(p_self: *DOMDocument, p_command: [*:0]const u8) c_int;
    pub const queryCommandState = webkit_dom_document_query_command_state;

    extern fn webkit_dom_document_query_command_supported(p_self: *DOMDocument, p_command: [*:0]const u8) c_int;
    pub const queryCommandSupported = webkit_dom_document_query_command_supported;

    extern fn webkit_dom_document_query_command_value(p_self: *DOMDocument, p_command: [*:0]const u8) [*:0]u8;
    pub const queryCommandValue = webkit_dom_document_query_command_value;

    extern fn webkit_dom_document_query_selector(p_self: *DOMDocument, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMElement;
    pub const querySelector = webkit_dom_document_query_selector;

    extern fn webkit_dom_document_query_selector_all(p_self: *DOMDocument, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNodeList;
    pub const querySelectorAll = webkit_dom_document_query_selector_all;

    extern fn webkit_dom_document_set_body(p_self: *DOMDocument, p_value: *webkit2webextension.DOMHTMLElement, p_error: ?*?*glib.Error) void;
    pub const setBody = webkit_dom_document_set_body;

    extern fn webkit_dom_document_set_charset(p_self: *DOMDocument, p_value: [*:0]const u8) void;
    pub const setCharset = webkit_dom_document_set_charset;

    extern fn webkit_dom_document_set_cookie(p_self: *DOMDocument, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setCookie = webkit_dom_document_set_cookie;

    extern fn webkit_dom_document_set_design_mode(p_self: *DOMDocument, p_value: [*:0]const u8) void;
    pub const setDesignMode = webkit_dom_document_set_design_mode;

    extern fn webkit_dom_document_set_dir(p_self: *DOMDocument, p_value: [*:0]const u8) void;
    pub const setDir = webkit_dom_document_set_dir;

    extern fn webkit_dom_document_set_document_uri(p_self: *DOMDocument, p_value: [*:0]const u8) void;
    pub const setDocumentUri = webkit_dom_document_set_document_uri;

    /// This function has been removed and does nothing.
    extern fn webkit_dom_document_set_selected_stylesheet_set(p_self: *DOMDocument, p_value: [*:0]const u8) void;
    pub const setSelectedStylesheetSet = webkit_dom_document_set_selected_stylesheet_set;

    extern fn webkit_dom_document_set_title(p_self: *DOMDocument, p_value: [*:0]const u8) void;
    pub const setTitle = webkit_dom_document_set_title;

    extern fn webkit_dom_document_set_xml_standalone(p_self: *DOMDocument, p_value: c_int, p_error: ?*?*glib.Error) void;
    pub const setXmlStandalone = webkit_dom_document_set_xml_standalone;

    extern fn webkit_dom_document_set_xml_version(p_self: *DOMDocument, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setXmlVersion = webkit_dom_document_set_xml_version;

    extern fn webkit_dom_document_webkit_cancel_fullscreen(p_self: *DOMDocument) void;
    pub const webkitCancelFullscreen = webkit_dom_document_webkit_cancel_fullscreen;

    extern fn webkit_dom_document_webkit_exit_fullscreen(p_self: *DOMDocument) void;
    pub const webkitExitFullscreen = webkit_dom_document_webkit_exit_fullscreen;

    extern fn webkit_dom_document_get_type() usize;
    pub const getGObjectType = webkit_dom_document_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMDocument) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMDocument) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMDocument, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDocumentFragment = extern struct {
    pub const Parent = webkit2webextension.DOMNode;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMDocumentFragmentClass;
    f_parent_instance: webkit2webextension.DOMNode,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const child_element_count = struct {
            pub const name = "child-element-count";

            pub const Type = c_ulong;
        };

        pub const children = struct {
            pub const name = "children";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const first_element_child = struct {
            pub const name = "first-element-child";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const last_element_child = struct {
            pub const name = "last-element-child";

            pub const Type = ?*webkit2webextension.DOMElement;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_document_fragment_get_child_element_count(p_self: *DOMDocumentFragment) c_ulong;
    pub const getChildElementCount = webkit_dom_document_fragment_get_child_element_count;

    extern fn webkit_dom_document_fragment_get_children(p_self: *DOMDocumentFragment) *webkit2webextension.DOMHTMLCollection;
    pub const getChildren = webkit_dom_document_fragment_get_children;

    extern fn webkit_dom_document_fragment_get_element_by_id(p_self: *DOMDocumentFragment, p_elementId: [*:0]const u8) *webkit2webextension.DOMElement;
    pub const getElementById = webkit_dom_document_fragment_get_element_by_id;

    extern fn webkit_dom_document_fragment_get_first_element_child(p_self: *DOMDocumentFragment) *webkit2webextension.DOMElement;
    pub const getFirstElementChild = webkit_dom_document_fragment_get_first_element_child;

    extern fn webkit_dom_document_fragment_get_last_element_child(p_self: *DOMDocumentFragment) *webkit2webextension.DOMElement;
    pub const getLastElementChild = webkit_dom_document_fragment_get_last_element_child;

    extern fn webkit_dom_document_fragment_query_selector(p_self: *DOMDocumentFragment, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMElement;
    pub const querySelector = webkit_dom_document_fragment_query_selector;

    extern fn webkit_dom_document_fragment_query_selector_all(p_self: *DOMDocumentFragment, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNodeList;
    pub const querySelectorAll = webkit_dom_document_fragment_query_selector_all;

    extern fn webkit_dom_document_fragment_get_type() usize;
    pub const getGObjectType = webkit_dom_document_fragment_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMDocumentFragment) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMDocumentFragment) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMDocumentFragment, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDocumentType = extern struct {
    pub const Parent = webkit2webextension.DOMNode;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMDocumentTypeClass;
    f_parent_instance: webkit2webextension.DOMNode,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const entities = struct {
            pub const name = "entities";

            pub const Type = ?*webkit2webextension.DOMNamedNodeMap;
        };

        pub const internal_subset = struct {
            pub const name = "internal-subset";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const notations = struct {
            pub const name = "notations";

            pub const Type = ?*webkit2webextension.DOMNamedNodeMap;
        };

        pub const public_id = struct {
            pub const name = "public-id";

            pub const Type = ?[*:0]u8;
        };

        pub const system_id = struct {
            pub const name = "system-id";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_document_type_get_entities(p_self: *DOMDocumentType) *webkit2webextension.DOMNamedNodeMap;
    pub const getEntities = webkit_dom_document_type_get_entities;

    extern fn webkit_dom_document_type_get_internal_subset(p_self: *DOMDocumentType) [*:0]u8;
    pub const getInternalSubset = webkit_dom_document_type_get_internal_subset;

    extern fn webkit_dom_document_type_get_name(p_self: *DOMDocumentType) [*:0]u8;
    pub const getName = webkit_dom_document_type_get_name;

    extern fn webkit_dom_document_type_get_notations(p_self: *DOMDocumentType) *webkit2webextension.DOMNamedNodeMap;
    pub const getNotations = webkit_dom_document_type_get_notations;

    extern fn webkit_dom_document_type_get_public_id(p_self: *DOMDocumentType) [*:0]u8;
    pub const getPublicId = webkit_dom_document_type_get_public_id;

    extern fn webkit_dom_document_type_get_system_id(p_self: *DOMDocumentType) [*:0]u8;
    pub const getSystemId = webkit_dom_document_type_get_system_id;

    extern fn webkit_dom_document_type_get_type() usize;
    pub const getGObjectType = webkit_dom_document_type_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMDocumentType) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMDocumentType) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMDocumentType, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMElement = extern struct {
    pub const Parent = webkit2webextension.DOMNode;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMElementClass;
    f_parent_instance: webkit2webextension.DOMNode,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const attributes = struct {
            pub const name = "attributes";

            pub const Type = ?*webkit2webextension.DOMNamedNodeMap;
        };

        pub const child_element_count = struct {
            pub const name = "child-element-count";

            pub const Type = c_ulong;
        };

        pub const children = struct {
            pub const name = "children";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const class_list = struct {
            pub const name = "class-list";

            pub const Type = ?*webkit2webextension.DOMDOMTokenList;
        };

        pub const class_name = struct {
            pub const name = "class-name";

            pub const Type = ?[*:0]u8;
        };

        pub const client_height = struct {
            pub const name = "client-height";

            pub const Type = f64;
        };

        pub const client_left = struct {
            pub const name = "client-left";

            pub const Type = f64;
        };

        pub const client_top = struct {
            pub const name = "client-top";

            pub const Type = f64;
        };

        pub const client_width = struct {
            pub const name = "client-width";

            pub const Type = f64;
        };

        pub const first_element_child = struct {
            pub const name = "first-element-child";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const id = struct {
            pub const name = "id";

            pub const Type = ?[*:0]u8;
        };

        pub const inner_html = struct {
            pub const name = "inner-html";

            pub const Type = ?[*:0]u8;
        };

        pub const last_element_child = struct {
            pub const name = "last-element-child";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const local_name = struct {
            pub const name = "local-name";

            pub const Type = ?[*:0]u8;
        };

        pub const namespace_uri = struct {
            pub const name = "namespace-uri";

            pub const Type = ?[*:0]u8;
        };

        pub const next_element_sibling = struct {
            pub const name = "next-element-sibling";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const offset_height = struct {
            pub const name = "offset-height";

            pub const Type = f64;
        };

        pub const offset_left = struct {
            pub const name = "offset-left";

            pub const Type = f64;
        };

        pub const offset_parent = struct {
            pub const name = "offset-parent";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const offset_top = struct {
            pub const name = "offset-top";

            pub const Type = f64;
        };

        pub const offset_width = struct {
            pub const name = "offset-width";

            pub const Type = f64;
        };

        pub const outer_html = struct {
            pub const name = "outer-html";

            pub const Type = ?[*:0]u8;
        };

        pub const prefix = struct {
            pub const name = "prefix";

            pub const Type = ?[*:0]u8;
        };

        pub const previous_element_sibling = struct {
            pub const name = "previous-element-sibling";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const scroll_height = struct {
            pub const name = "scroll-height";

            pub const Type = c_long;
        };

        pub const scroll_left = struct {
            pub const name = "scroll-left";

            pub const Type = c_long;
        };

        pub const scroll_top = struct {
            pub const name = "scroll-top";

            pub const Type = c_long;
        };

        pub const scroll_width = struct {
            pub const name = "scroll-width";

            pub const Type = c_long;
        };

        pub const style = struct {
            pub const name = "style";

            pub const Type = ?*webkit2webextension.DOMCSSStyleDeclaration;
        };

        pub const tag_name = struct {
            pub const name = "tag-name";

            pub const Type = ?[*:0]u8;
        };

        pub const webkit_region_overset = struct {
            pub const name = "webkit-region-overset";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_element_blur(p_self: *DOMElement) void;
    pub const blur = webkit_dom_element_blur;

    extern fn webkit_dom_element_closest(p_self: *DOMElement, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMElement;
    pub const closest = webkit_dom_element_closest;

    extern fn webkit_dom_element_focus(p_self: *DOMElement) void;
    pub const focus = webkit_dom_element_focus;

    extern fn webkit_dom_element_get_attribute(p_self: *DOMElement, p_name: [*:0]const u8) [*:0]u8;
    pub const getAttribute = webkit_dom_element_get_attribute;

    extern fn webkit_dom_element_get_attribute_node(p_self: *DOMElement, p_name: [*:0]const u8) *webkit2webextension.DOMAttr;
    pub const getAttributeNode = webkit_dom_element_get_attribute_node;

    extern fn webkit_dom_element_get_attribute_node_ns(p_self: *DOMElement, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8) *webkit2webextension.DOMAttr;
    pub const getAttributeNodeNs = webkit_dom_element_get_attribute_node_ns;

    extern fn webkit_dom_element_get_attribute_ns(p_self: *DOMElement, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8) [*:0]u8;
    pub const getAttributeNs = webkit_dom_element_get_attribute_ns;

    extern fn webkit_dom_element_get_attributes(p_self: *DOMElement) *webkit2webextension.DOMNamedNodeMap;
    pub const getAttributes = webkit_dom_element_get_attributes;

    /// Returns a `webkit2webextension.DOMClientRect` representing the size and position of `self`
    /// relative to the viewport.
    extern fn webkit_dom_element_get_bounding_client_rect(p_self: *DOMElement) *webkit2webextension.DOMClientRect;
    pub const getBoundingClientRect = webkit_dom_element_get_bounding_client_rect;

    extern fn webkit_dom_element_get_child_element_count(p_self: *DOMElement) c_ulong;
    pub const getChildElementCount = webkit_dom_element_get_child_element_count;

    extern fn webkit_dom_element_get_children(p_self: *DOMElement) *webkit2webextension.DOMHTMLCollection;
    pub const getChildren = webkit_dom_element_get_children;

    extern fn webkit_dom_element_get_class_list(p_self: *DOMElement) *webkit2webextension.DOMDOMTokenList;
    pub const getClassList = webkit_dom_element_get_class_list;

    extern fn webkit_dom_element_get_class_name(p_self: *DOMElement) [*:0]u8;
    pub const getClassName = webkit_dom_element_get_class_name;

    extern fn webkit_dom_element_get_client_height(p_self: *DOMElement) f64;
    pub const getClientHeight = webkit_dom_element_get_client_height;

    extern fn webkit_dom_element_get_client_left(p_self: *DOMElement) f64;
    pub const getClientLeft = webkit_dom_element_get_client_left;

    /// Returns a collection of `webkit2webextension.DOMClientRect` objects, each of which describe
    /// the size and position of a CSS border box relative to the viewport.
    extern fn webkit_dom_element_get_client_rects(p_self: *DOMElement) *webkit2webextension.DOMClientRectList;
    pub const getClientRects = webkit_dom_element_get_client_rects;

    extern fn webkit_dom_element_get_client_top(p_self: *DOMElement) f64;
    pub const getClientTop = webkit_dom_element_get_client_top;

    extern fn webkit_dom_element_get_client_width(p_self: *DOMElement) f64;
    pub const getClientWidth = webkit_dom_element_get_client_width;

    extern fn webkit_dom_element_get_elements_by_class_name(p_self: *DOMElement, p_class_name: [*:0]const u8) *webkit2webextension.DOMNodeList;
    pub const getElementsByClassName = webkit_dom_element_get_elements_by_class_name;

    extern fn webkit_dom_element_get_elements_by_class_name_as_html_collection(p_self: *DOMElement, p_name: [*:0]const u8) *webkit2webextension.DOMHTMLCollection;
    pub const getElementsByClassNameAsHtmlCollection = webkit_dom_element_get_elements_by_class_name_as_html_collection;

    extern fn webkit_dom_element_get_elements_by_tag_name(p_self: *DOMElement, p_tag_name: [*:0]const u8) *webkit2webextension.DOMNodeList;
    pub const getElementsByTagName = webkit_dom_element_get_elements_by_tag_name;

    extern fn webkit_dom_element_get_elements_by_tag_name_as_html_collection(p_self: *DOMElement, p_name: [*:0]const u8) *webkit2webextension.DOMHTMLCollection;
    pub const getElementsByTagNameAsHtmlCollection = webkit_dom_element_get_elements_by_tag_name_as_html_collection;

    extern fn webkit_dom_element_get_elements_by_tag_name_ns(p_self: *DOMElement, p_namespace_uri: [*:0]const u8, p_tag_name: [*:0]const u8) *webkit2webextension.DOMNodeList;
    pub const getElementsByTagNameNs = webkit_dom_element_get_elements_by_tag_name_ns;

    extern fn webkit_dom_element_get_elements_by_tag_name_ns_as_html_collection(p_self: *DOMElement, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8) *webkit2webextension.DOMHTMLCollection;
    pub const getElementsByTagNameNsAsHtmlCollection = webkit_dom_element_get_elements_by_tag_name_ns_as_html_collection;

    extern fn webkit_dom_element_get_first_element_child(p_self: *DOMElement) *webkit2webextension.DOMElement;
    pub const getFirstElementChild = webkit_dom_element_get_first_element_child;

    extern fn webkit_dom_element_get_id(p_self: *DOMElement) [*:0]u8;
    pub const getId = webkit_dom_element_get_id;

    extern fn webkit_dom_element_get_inner_html(p_self: *DOMElement) [*:0]u8;
    pub const getInnerHtml = webkit_dom_element_get_inner_html;

    extern fn webkit_dom_element_get_last_element_child(p_self: *DOMElement) *webkit2webextension.DOMElement;
    pub const getLastElementChild = webkit_dom_element_get_last_element_child;

    extern fn webkit_dom_element_get_local_name(p_self: *DOMElement) [*:0]u8;
    pub const getLocalName = webkit_dom_element_get_local_name;

    extern fn webkit_dom_element_get_namespace_uri(p_self: *DOMElement) [*:0]u8;
    pub const getNamespaceUri = webkit_dom_element_get_namespace_uri;

    extern fn webkit_dom_element_get_next_element_sibling(p_self: *DOMElement) *webkit2webextension.DOMElement;
    pub const getNextElementSibling = webkit_dom_element_get_next_element_sibling;

    extern fn webkit_dom_element_get_offset_height(p_self: *DOMElement) f64;
    pub const getOffsetHeight = webkit_dom_element_get_offset_height;

    extern fn webkit_dom_element_get_offset_left(p_self: *DOMElement) f64;
    pub const getOffsetLeft = webkit_dom_element_get_offset_left;

    extern fn webkit_dom_element_get_offset_parent(p_self: *DOMElement) *webkit2webextension.DOMElement;
    pub const getOffsetParent = webkit_dom_element_get_offset_parent;

    extern fn webkit_dom_element_get_offset_top(p_self: *DOMElement) f64;
    pub const getOffsetTop = webkit_dom_element_get_offset_top;

    extern fn webkit_dom_element_get_offset_width(p_self: *DOMElement) f64;
    pub const getOffsetWidth = webkit_dom_element_get_offset_width;

    extern fn webkit_dom_element_get_outer_html(p_self: *DOMElement) [*:0]u8;
    pub const getOuterHtml = webkit_dom_element_get_outer_html;

    extern fn webkit_dom_element_get_prefix(p_self: *DOMElement) [*:0]u8;
    pub const getPrefix = webkit_dom_element_get_prefix;

    extern fn webkit_dom_element_get_previous_element_sibling(p_self: *DOMElement) *webkit2webextension.DOMElement;
    pub const getPreviousElementSibling = webkit_dom_element_get_previous_element_sibling;

    extern fn webkit_dom_element_get_scroll_height(p_self: *DOMElement) c_long;
    pub const getScrollHeight = webkit_dom_element_get_scroll_height;

    extern fn webkit_dom_element_get_scroll_left(p_self: *DOMElement) c_long;
    pub const getScrollLeft = webkit_dom_element_get_scroll_left;

    extern fn webkit_dom_element_get_scroll_top(p_self: *DOMElement) c_long;
    pub const getScrollTop = webkit_dom_element_get_scroll_top;

    extern fn webkit_dom_element_get_scroll_width(p_self: *DOMElement) c_long;
    pub const getScrollWidth = webkit_dom_element_get_scroll_width;

    extern fn webkit_dom_element_get_style(p_self: *DOMElement) *webkit2webextension.DOMCSSStyleDeclaration;
    pub const getStyle = webkit_dom_element_get_style;

    extern fn webkit_dom_element_get_tag_name(p_self: *DOMElement) [*:0]u8;
    pub const getTagName = webkit_dom_element_get_tag_name;

    /// CSS Regions support has been removed. This function does nothing.
    extern fn webkit_dom_element_get_webkit_region_overset(p_self: *DOMElement) [*:0]u8;
    pub const getWebkitRegionOverset = webkit_dom_element_get_webkit_region_overset;

    extern fn webkit_dom_element_has_attribute(p_self: *DOMElement, p_name: [*:0]const u8) c_int;
    pub const hasAttribute = webkit_dom_element_has_attribute;

    extern fn webkit_dom_element_has_attribute_ns(p_self: *DOMElement, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8) c_int;
    pub const hasAttributeNs = webkit_dom_element_has_attribute_ns;

    extern fn webkit_dom_element_has_attributes(p_self: *DOMElement) c_int;
    pub const hasAttributes = webkit_dom_element_has_attributes;

    /// Get whether the element is an HTML input element that has been filled automatically.
    extern fn webkit_dom_element_html_input_element_get_auto_filled(p_element: *DOMElement) c_int;
    pub const htmlInputElementGetAutoFilled = webkit_dom_element_html_input_element_get_auto_filled;

    /// Get whether `element` is an HTML text input element that has been edited by a user action.
    extern fn webkit_dom_element_html_input_element_is_user_edited(p_element: *DOMElement) c_int;
    pub const htmlInputElementIsUserEdited = webkit_dom_element_html_input_element_is_user_edited;

    /// Set whether the element is an HTML input element that has been filled automatically.
    /// If `element` is not an HTML input element this function does nothing.
    extern fn webkit_dom_element_html_input_element_set_auto_filled(p_element: *DOMElement, p_auto_filled: c_int) void;
    pub const htmlInputElementSetAutoFilled = webkit_dom_element_html_input_element_set_auto_filled;

    /// Set the value of an HTML input element as if it had been edited by
    /// the user, triggering a change event. If `element` is not an HTML input
    /// element this function does nothing.
    extern fn webkit_dom_element_html_input_element_set_editing_value(p_element: *DOMElement, p_value: [*:0]const u8) void;
    pub const htmlInputElementSetEditingValue = webkit_dom_element_html_input_element_set_editing_value;

    extern fn webkit_dom_element_insert_adjacent_element(p_self: *DOMElement, p_where: [*:0]const u8, p_element: *webkit2webextension.DOMElement, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMElement;
    pub const insertAdjacentElement = webkit_dom_element_insert_adjacent_element;

    extern fn webkit_dom_element_insert_adjacent_html(p_self: *DOMElement, p_where: [*:0]const u8, p_html: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const insertAdjacentHtml = webkit_dom_element_insert_adjacent_html;

    extern fn webkit_dom_element_insert_adjacent_text(p_self: *DOMElement, p_where: [*:0]const u8, p_text: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const insertAdjacentText = webkit_dom_element_insert_adjacent_text;

    extern fn webkit_dom_element_matches(p_self: *DOMElement, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const matches = webkit_dom_element_matches;

    extern fn webkit_dom_element_query_selector(p_self: *DOMElement, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMElement;
    pub const querySelector = webkit_dom_element_query_selector;

    extern fn webkit_dom_element_query_selector_all(p_self: *DOMElement, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNodeList;
    pub const querySelectorAll = webkit_dom_element_query_selector_all;

    extern fn webkit_dom_element_remove(p_self: *DOMElement, p_error: ?*?*glib.Error) void;
    pub const remove = webkit_dom_element_remove;

    extern fn webkit_dom_element_remove_attribute(p_self: *DOMElement, p_name: [*:0]const u8) void;
    pub const removeAttribute = webkit_dom_element_remove_attribute;

    extern fn webkit_dom_element_remove_attribute_node(p_self: *DOMElement, p_oldAttr: *webkit2webextension.DOMAttr, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMAttr;
    pub const removeAttributeNode = webkit_dom_element_remove_attribute_node;

    extern fn webkit_dom_element_remove_attribute_ns(p_self: *DOMElement, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8) void;
    pub const removeAttributeNs = webkit_dom_element_remove_attribute_ns;

    extern fn webkit_dom_element_request_pointer_lock(p_self: *DOMElement) void;
    pub const requestPointerLock = webkit_dom_element_request_pointer_lock;

    extern fn webkit_dom_element_scroll_by_lines(p_self: *DOMElement, p_lines: c_long) void;
    pub const scrollByLines = webkit_dom_element_scroll_by_lines;

    extern fn webkit_dom_element_scroll_by_pages(p_self: *DOMElement, p_pages: c_long) void;
    pub const scrollByPages = webkit_dom_element_scroll_by_pages;

    extern fn webkit_dom_element_scroll_into_view(p_self: *DOMElement, p_alignWithTop: c_int) void;
    pub const scrollIntoView = webkit_dom_element_scroll_into_view;

    extern fn webkit_dom_element_scroll_into_view_if_needed(p_self: *DOMElement, p_centerIfNeeded: c_int) void;
    pub const scrollIntoViewIfNeeded = webkit_dom_element_scroll_into_view_if_needed;

    extern fn webkit_dom_element_set_attribute(p_self: *DOMElement, p_name: [*:0]const u8, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setAttribute = webkit_dom_element_set_attribute;

    extern fn webkit_dom_element_set_attribute_node(p_self: *DOMElement, p_newAttr: *webkit2webextension.DOMAttr, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMAttr;
    pub const setAttributeNode = webkit_dom_element_set_attribute_node;

    extern fn webkit_dom_element_set_attribute_node_ns(p_self: *DOMElement, p_newAttr: *webkit2webextension.DOMAttr, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMAttr;
    pub const setAttributeNodeNs = webkit_dom_element_set_attribute_node_ns;

    extern fn webkit_dom_element_set_attribute_ns(p_self: *DOMElement, p_namespaceURI: ?[*:0]const u8, p_qualifiedName: [*:0]const u8, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setAttributeNs = webkit_dom_element_set_attribute_ns;

    extern fn webkit_dom_element_set_class_name(p_self: *DOMElement, p_value: [*:0]const u8) void;
    pub const setClassName = webkit_dom_element_set_class_name;

    extern fn webkit_dom_element_set_id(p_self: *DOMElement, p_value: [*:0]const u8) void;
    pub const setId = webkit_dom_element_set_id;

    extern fn webkit_dom_element_set_inner_html(p_self: *DOMElement, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setInnerHtml = webkit_dom_element_set_inner_html;

    extern fn webkit_dom_element_set_outer_html(p_self: *DOMElement, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setOuterHtml = webkit_dom_element_set_outer_html;

    extern fn webkit_dom_element_set_scroll_left(p_self: *DOMElement, p_value: c_long) void;
    pub const setScrollLeft = webkit_dom_element_set_scroll_left;

    extern fn webkit_dom_element_set_scroll_top(p_self: *DOMElement, p_value: c_long) void;
    pub const setScrollTop = webkit_dom_element_set_scroll_top;

    extern fn webkit_dom_element_webkit_matches_selector(p_self: *DOMElement, p_selectors: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const webkitMatchesSelector = webkit_dom_element_webkit_matches_selector;

    extern fn webkit_dom_element_webkit_request_fullscreen(p_self: *DOMElement) void;
    pub const webkitRequestFullscreen = webkit_dom_element_webkit_request_fullscreen;

    extern fn webkit_dom_element_get_type() usize;
    pub const getGObjectType = webkit_dom_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMEntityReference = extern struct {
    pub const Parent = webkit2webextension.DOMNode;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMEntityReferenceClass;
    f_parent_instance: webkit2webextension.DOMNode,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_entity_reference_get_type() usize;
    pub const getGObjectType = webkit_dom_entity_reference_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMEntityReference) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMEntityReference) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMEntityReference, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMEvent = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMEventClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const bubbles = struct {
            pub const name = "bubbles";

            pub const Type = c_int;
        };

        pub const cancel_bubble = struct {
            pub const name = "cancel-bubble";

            pub const Type = c_int;
        };

        pub const cancelable = struct {
            pub const name = "cancelable";

            pub const Type = c_int;
        };

        pub const current_target = struct {
            pub const name = "current-target";

            pub const Type = ?*webkit2webextension.DOMEventTarget;
        };

        pub const event_phase = struct {
            pub const name = "event-phase";

            pub const Type = c_uint;
        };

        pub const return_value = struct {
            pub const name = "return-value";

            pub const Type = c_int;
        };

        pub const src_element = struct {
            pub const name = "src-element";

            pub const Type = ?*webkit2webextension.DOMEventTarget;
        };

        pub const target = struct {
            pub const name = "target";

            pub const Type = ?*webkit2webextension.DOMEventTarget;
        };

        pub const time_stamp = struct {
            pub const name = "time-stamp";

            pub const Type = c_uint;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_event_get_bubbles(p_self: *DOMEvent) c_int;
    pub const getBubbles = webkit_dom_event_get_bubbles;

    extern fn webkit_dom_event_get_cancel_bubble(p_self: *DOMEvent) c_int;
    pub const getCancelBubble = webkit_dom_event_get_cancel_bubble;

    extern fn webkit_dom_event_get_cancelable(p_self: *DOMEvent) c_int;
    pub const getCancelable = webkit_dom_event_get_cancelable;

    extern fn webkit_dom_event_get_current_target(p_self: *DOMEvent) *webkit2webextension.DOMEventTarget;
    pub const getCurrentTarget = webkit_dom_event_get_current_target;

    extern fn webkit_dom_event_get_event_phase(p_self: *DOMEvent) c_ushort;
    pub const getEventPhase = webkit_dom_event_get_event_phase;

    extern fn webkit_dom_event_get_event_type(p_self: *DOMEvent) [*:0]u8;
    pub const getEventType = webkit_dom_event_get_event_type;

    extern fn webkit_dom_event_get_return_value(p_self: *DOMEvent) c_int;
    pub const getReturnValue = webkit_dom_event_get_return_value;

    extern fn webkit_dom_event_get_src_element(p_self: *DOMEvent) *webkit2webextension.DOMEventTarget;
    pub const getSrcElement = webkit_dom_event_get_src_element;

    extern fn webkit_dom_event_get_target(p_self: *DOMEvent) *webkit2webextension.DOMEventTarget;
    pub const getTarget = webkit_dom_event_get_target;

    extern fn webkit_dom_event_get_time_stamp(p_self: *DOMEvent) u32;
    pub const getTimeStamp = webkit_dom_event_get_time_stamp;

    extern fn webkit_dom_event_init_event(p_self: *DOMEvent, p_eventTypeArg: [*:0]const u8, p_canBubbleArg: c_int, p_cancelableArg: c_int) void;
    pub const initEvent = webkit_dom_event_init_event;

    extern fn webkit_dom_event_prevent_default(p_self: *DOMEvent) void;
    pub const preventDefault = webkit_dom_event_prevent_default;

    extern fn webkit_dom_event_set_cancel_bubble(p_self: *DOMEvent, p_value: c_int) void;
    pub const setCancelBubble = webkit_dom_event_set_cancel_bubble;

    extern fn webkit_dom_event_set_return_value(p_self: *DOMEvent, p_value: c_int) void;
    pub const setReturnValue = webkit_dom_event_set_return_value;

    extern fn webkit_dom_event_stop_propagation(p_self: *DOMEvent) void;
    pub const stopPropagation = webkit_dom_event_stop_propagation;

    extern fn webkit_dom_event_get_type() usize;
    pub const getGObjectType = webkit_dom_event_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMEvent) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMEvent) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMEvent, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMFile = extern struct {
    pub const Parent = webkit2webextension.DOMBlob;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMFileClass;
    f_parent_instance: webkit2webextension.DOMBlob,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_file_get_name(p_self: *DOMFile) [*:0]u8;
    pub const getName = webkit_dom_file_get_name;

    extern fn webkit_dom_file_get_type() usize;
    pub const getGObjectType = webkit_dom_file_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMFile) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMFile) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMFile, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMFileList = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMFileListClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_file_list_get_length(p_self: *DOMFileList) c_ulong;
    pub const getLength = webkit_dom_file_list_get_length;

    extern fn webkit_dom_file_list_item(p_self: *DOMFileList, p_index: c_ulong) *webkit2webextension.DOMFile;
    pub const item = webkit_dom_file_list_item;

    extern fn webkit_dom_file_list_get_type() usize;
    pub const getGObjectType = webkit_dom_file_list_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMFileList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMFileList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMFileList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLAnchorElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLAnchorElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const charset = struct {
            pub const name = "charset";

            pub const Type = ?[*:0]u8;
        };

        pub const coords = struct {
            pub const name = "coords";

            pub const Type = ?[*:0]u8;
        };

        pub const hash = struct {
            pub const name = "hash";

            pub const Type = ?[*:0]u8;
        };

        pub const host = struct {
            pub const name = "host";

            pub const Type = ?[*:0]u8;
        };

        pub const hostname = struct {
            pub const name = "hostname";

            pub const Type = ?[*:0]u8;
        };

        pub const href = struct {
            pub const name = "href";

            pub const Type = ?[*:0]u8;
        };

        pub const hreflang = struct {
            pub const name = "hreflang";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const pathname = struct {
            pub const name = "pathname";

            pub const Type = ?[*:0]u8;
        };

        pub const port = struct {
            pub const name = "port";

            pub const Type = ?[*:0]u8;
        };

        pub const protocol = struct {
            pub const name = "protocol";

            pub const Type = ?[*:0]u8;
        };

        pub const rel = struct {
            pub const name = "rel";

            pub const Type = ?[*:0]u8;
        };

        pub const rev = struct {
            pub const name = "rev";

            pub const Type = ?[*:0]u8;
        };

        pub const search = struct {
            pub const name = "search";

            pub const Type = ?[*:0]u8;
        };

        pub const shape = struct {
            pub const name = "shape";

            pub const Type = ?[*:0]u8;
        };

        pub const target = struct {
            pub const name = "target";

            pub const Type = ?[*:0]u8;
        };

        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_anchor_element_get_charset(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getCharset = webkit_dom_html_anchor_element_get_charset;

    extern fn webkit_dom_html_anchor_element_get_coords(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getCoords = webkit_dom_html_anchor_element_get_coords;

    extern fn webkit_dom_html_anchor_element_get_hash(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getHash = webkit_dom_html_anchor_element_get_hash;

    extern fn webkit_dom_html_anchor_element_get_host(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getHost = webkit_dom_html_anchor_element_get_host;

    extern fn webkit_dom_html_anchor_element_get_hostname(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getHostname = webkit_dom_html_anchor_element_get_hostname;

    extern fn webkit_dom_html_anchor_element_get_href(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getHref = webkit_dom_html_anchor_element_get_href;

    extern fn webkit_dom_html_anchor_element_get_hreflang(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getHreflang = webkit_dom_html_anchor_element_get_hreflang;

    extern fn webkit_dom_html_anchor_element_get_name(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getName = webkit_dom_html_anchor_element_get_name;

    extern fn webkit_dom_html_anchor_element_get_pathname(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getPathname = webkit_dom_html_anchor_element_get_pathname;

    extern fn webkit_dom_html_anchor_element_get_port(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getPort = webkit_dom_html_anchor_element_get_port;

    extern fn webkit_dom_html_anchor_element_get_protocol(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getProtocol = webkit_dom_html_anchor_element_get_protocol;

    extern fn webkit_dom_html_anchor_element_get_rel(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getRel = webkit_dom_html_anchor_element_get_rel;

    extern fn webkit_dom_html_anchor_element_get_rev(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getRev = webkit_dom_html_anchor_element_get_rev;

    extern fn webkit_dom_html_anchor_element_get_search(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getSearch = webkit_dom_html_anchor_element_get_search;

    extern fn webkit_dom_html_anchor_element_get_shape(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getShape = webkit_dom_html_anchor_element_get_shape;

    extern fn webkit_dom_html_anchor_element_get_target(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getTarget = webkit_dom_html_anchor_element_get_target;

    extern fn webkit_dom_html_anchor_element_get_text(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getText = webkit_dom_html_anchor_element_get_text;

    extern fn webkit_dom_html_anchor_element_get_type_attr(p_self: *DOMHTMLAnchorElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_anchor_element_get_type_attr;

    extern fn webkit_dom_html_anchor_element_set_charset(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setCharset = webkit_dom_html_anchor_element_set_charset;

    extern fn webkit_dom_html_anchor_element_set_coords(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setCoords = webkit_dom_html_anchor_element_set_coords;

    extern fn webkit_dom_html_anchor_element_set_hash(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setHash = webkit_dom_html_anchor_element_set_hash;

    extern fn webkit_dom_html_anchor_element_set_host(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setHost = webkit_dom_html_anchor_element_set_host;

    extern fn webkit_dom_html_anchor_element_set_hostname(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setHostname = webkit_dom_html_anchor_element_set_hostname;

    extern fn webkit_dom_html_anchor_element_set_href(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setHref = webkit_dom_html_anchor_element_set_href;

    extern fn webkit_dom_html_anchor_element_set_hreflang(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setHreflang = webkit_dom_html_anchor_element_set_hreflang;

    extern fn webkit_dom_html_anchor_element_set_name(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_anchor_element_set_name;

    extern fn webkit_dom_html_anchor_element_set_pathname(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setPathname = webkit_dom_html_anchor_element_set_pathname;

    extern fn webkit_dom_html_anchor_element_set_port(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setPort = webkit_dom_html_anchor_element_set_port;

    extern fn webkit_dom_html_anchor_element_set_protocol(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setProtocol = webkit_dom_html_anchor_element_set_protocol;

    extern fn webkit_dom_html_anchor_element_set_rel(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setRel = webkit_dom_html_anchor_element_set_rel;

    extern fn webkit_dom_html_anchor_element_set_rev(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setRev = webkit_dom_html_anchor_element_set_rev;

    extern fn webkit_dom_html_anchor_element_set_search(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setSearch = webkit_dom_html_anchor_element_set_search;

    extern fn webkit_dom_html_anchor_element_set_shape(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setShape = webkit_dom_html_anchor_element_set_shape;

    extern fn webkit_dom_html_anchor_element_set_target(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setTarget = webkit_dom_html_anchor_element_set_target;

    extern fn webkit_dom_html_anchor_element_set_text(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setText = webkit_dom_html_anchor_element_set_text;

    extern fn webkit_dom_html_anchor_element_set_type_attr(p_self: *DOMHTMLAnchorElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_anchor_element_set_type_attr;

    extern fn webkit_dom_html_anchor_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_anchor_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLAnchorElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLAnchorElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLAnchorElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLAppletElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLAppletElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const alt = struct {
            pub const name = "alt";

            pub const Type = ?[*:0]u8;
        };

        pub const archive = struct {
            pub const name = "archive";

            pub const Type = ?[*:0]u8;
        };

        pub const code = struct {
            pub const name = "code";

            pub const Type = ?[*:0]u8;
        };

        pub const code_base = struct {
            pub const name = "code-base";

            pub const Type = ?[*:0]u8;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = ?[*:0]u8;
        };

        pub const hspace = struct {
            pub const name = "hspace";

            pub const Type = c_long;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const object = struct {
            pub const name = "object";

            pub const Type = ?[*:0]u8;
        };

        pub const vspace = struct {
            pub const name = "vspace";

            pub const Type = c_long;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_applet_element_get_align(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_applet_element_get_align;

    extern fn webkit_dom_html_applet_element_get_alt(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getAlt = webkit_dom_html_applet_element_get_alt;

    extern fn webkit_dom_html_applet_element_get_archive(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getArchive = webkit_dom_html_applet_element_get_archive;

    extern fn webkit_dom_html_applet_element_get_code(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getCode = webkit_dom_html_applet_element_get_code;

    extern fn webkit_dom_html_applet_element_get_code_base(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getCodeBase = webkit_dom_html_applet_element_get_code_base;

    extern fn webkit_dom_html_applet_element_get_height(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getHeight = webkit_dom_html_applet_element_get_height;

    extern fn webkit_dom_html_applet_element_get_hspace(p_self: *DOMHTMLAppletElement) c_long;
    pub const getHspace = webkit_dom_html_applet_element_get_hspace;

    extern fn webkit_dom_html_applet_element_get_name(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getName = webkit_dom_html_applet_element_get_name;

    extern fn webkit_dom_html_applet_element_get_object(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getObject = webkit_dom_html_applet_element_get_object;

    extern fn webkit_dom_html_applet_element_get_vspace(p_self: *DOMHTMLAppletElement) c_long;
    pub const getVspace = webkit_dom_html_applet_element_get_vspace;

    extern fn webkit_dom_html_applet_element_get_width(p_self: *DOMHTMLAppletElement) [*:0]u8;
    pub const getWidth = webkit_dom_html_applet_element_get_width;

    extern fn webkit_dom_html_applet_element_set_align(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_applet_element_set_align;

    extern fn webkit_dom_html_applet_element_set_alt(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setAlt = webkit_dom_html_applet_element_set_alt;

    extern fn webkit_dom_html_applet_element_set_archive(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setArchive = webkit_dom_html_applet_element_set_archive;

    extern fn webkit_dom_html_applet_element_set_code(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setCode = webkit_dom_html_applet_element_set_code;

    extern fn webkit_dom_html_applet_element_set_code_base(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setCodeBase = webkit_dom_html_applet_element_set_code_base;

    extern fn webkit_dom_html_applet_element_set_height(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setHeight = webkit_dom_html_applet_element_set_height;

    extern fn webkit_dom_html_applet_element_set_hspace(p_self: *DOMHTMLAppletElement, p_value: c_long) void;
    pub const setHspace = webkit_dom_html_applet_element_set_hspace;

    extern fn webkit_dom_html_applet_element_set_name(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_applet_element_set_name;

    extern fn webkit_dom_html_applet_element_set_object(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setObject = webkit_dom_html_applet_element_set_object;

    extern fn webkit_dom_html_applet_element_set_vspace(p_self: *DOMHTMLAppletElement, p_value: c_long) void;
    pub const setVspace = webkit_dom_html_applet_element_set_vspace;

    extern fn webkit_dom_html_applet_element_set_width(p_self: *DOMHTMLAppletElement, p_value: [*:0]const u8) void;
    pub const setWidth = webkit_dom_html_applet_element_set_width;

    extern fn webkit_dom_html_applet_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_applet_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLAppletElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLAppletElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLAppletElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLAreaElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLAreaElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const alt = struct {
            pub const name = "alt";

            pub const Type = ?[*:0]u8;
        };

        pub const coords = struct {
            pub const name = "coords";

            pub const Type = ?[*:0]u8;
        };

        pub const hash = struct {
            pub const name = "hash";

            pub const Type = ?[*:0]u8;
        };

        pub const host = struct {
            pub const name = "host";

            pub const Type = ?[*:0]u8;
        };

        pub const hostname = struct {
            pub const name = "hostname";

            pub const Type = ?[*:0]u8;
        };

        pub const href = struct {
            pub const name = "href";

            pub const Type = ?[*:0]u8;
        };

        pub const no_href = struct {
            pub const name = "no-href";

            pub const Type = c_int;
        };

        pub const pathname = struct {
            pub const name = "pathname";

            pub const Type = ?[*:0]u8;
        };

        pub const port = struct {
            pub const name = "port";

            pub const Type = ?[*:0]u8;
        };

        pub const protocol = struct {
            pub const name = "protocol";

            pub const Type = ?[*:0]u8;
        };

        pub const search = struct {
            pub const name = "search";

            pub const Type = ?[*:0]u8;
        };

        pub const shape = struct {
            pub const name = "shape";

            pub const Type = ?[*:0]u8;
        };

        pub const target = struct {
            pub const name = "target";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_area_element_get_alt(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getAlt = webkit_dom_html_area_element_get_alt;

    extern fn webkit_dom_html_area_element_get_coords(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getCoords = webkit_dom_html_area_element_get_coords;

    extern fn webkit_dom_html_area_element_get_hash(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getHash = webkit_dom_html_area_element_get_hash;

    extern fn webkit_dom_html_area_element_get_host(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getHost = webkit_dom_html_area_element_get_host;

    extern fn webkit_dom_html_area_element_get_hostname(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getHostname = webkit_dom_html_area_element_get_hostname;

    extern fn webkit_dom_html_area_element_get_href(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getHref = webkit_dom_html_area_element_get_href;

    extern fn webkit_dom_html_area_element_get_no_href(p_self: *DOMHTMLAreaElement) c_int;
    pub const getNoHref = webkit_dom_html_area_element_get_no_href;

    extern fn webkit_dom_html_area_element_get_pathname(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getPathname = webkit_dom_html_area_element_get_pathname;

    extern fn webkit_dom_html_area_element_get_port(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getPort = webkit_dom_html_area_element_get_port;

    extern fn webkit_dom_html_area_element_get_protocol(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getProtocol = webkit_dom_html_area_element_get_protocol;

    extern fn webkit_dom_html_area_element_get_search(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getSearch = webkit_dom_html_area_element_get_search;

    extern fn webkit_dom_html_area_element_get_shape(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getShape = webkit_dom_html_area_element_get_shape;

    extern fn webkit_dom_html_area_element_get_target(p_self: *DOMHTMLAreaElement) [*:0]u8;
    pub const getTarget = webkit_dom_html_area_element_get_target;

    extern fn webkit_dom_html_area_element_set_alt(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setAlt = webkit_dom_html_area_element_set_alt;

    extern fn webkit_dom_html_area_element_set_coords(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setCoords = webkit_dom_html_area_element_set_coords;

    extern fn webkit_dom_html_area_element_set_hash(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setHash = webkit_dom_html_area_element_set_hash;

    extern fn webkit_dom_html_area_element_set_host(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setHost = webkit_dom_html_area_element_set_host;

    extern fn webkit_dom_html_area_element_set_hostname(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setHostname = webkit_dom_html_area_element_set_hostname;

    extern fn webkit_dom_html_area_element_set_href(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setHref = webkit_dom_html_area_element_set_href;

    extern fn webkit_dom_html_area_element_set_no_href(p_self: *DOMHTMLAreaElement, p_value: c_int) void;
    pub const setNoHref = webkit_dom_html_area_element_set_no_href;

    extern fn webkit_dom_html_area_element_set_pathname(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setPathname = webkit_dom_html_area_element_set_pathname;

    extern fn webkit_dom_html_area_element_set_port(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setPort = webkit_dom_html_area_element_set_port;

    extern fn webkit_dom_html_area_element_set_protocol(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setProtocol = webkit_dom_html_area_element_set_protocol;

    extern fn webkit_dom_html_area_element_set_search(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setSearch = webkit_dom_html_area_element_set_search;

    extern fn webkit_dom_html_area_element_set_shape(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setShape = webkit_dom_html_area_element_set_shape;

    extern fn webkit_dom_html_area_element_set_target(p_self: *DOMHTMLAreaElement, p_value: [*:0]const u8) void;
    pub const setTarget = webkit_dom_html_area_element_set_target;

    extern fn webkit_dom_html_area_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_area_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLAreaElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLAreaElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLAreaElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBRElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLBRElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const clear = struct {
            pub const name = "clear";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_br_element_get_clear(p_self: *DOMHTMLBRElement) [*:0]u8;
    pub const getClear = webkit_dom_html_br_element_get_clear;

    extern fn webkit_dom_html_br_element_set_clear(p_self: *DOMHTMLBRElement, p_value: [*:0]const u8) void;
    pub const setClear = webkit_dom_html_br_element_set_clear;

    extern fn webkit_dom_html_br_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_br_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLBRElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLBRElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLBRElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBaseElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLBaseElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const href = struct {
            pub const name = "href";

            pub const Type = ?[*:0]u8;
        };

        pub const target = struct {
            pub const name = "target";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_base_element_get_href(p_self: *DOMHTMLBaseElement) [*:0]u8;
    pub const getHref = webkit_dom_html_base_element_get_href;

    extern fn webkit_dom_html_base_element_get_target(p_self: *DOMHTMLBaseElement) [*:0]u8;
    pub const getTarget = webkit_dom_html_base_element_get_target;

    extern fn webkit_dom_html_base_element_set_href(p_self: *DOMHTMLBaseElement, p_value: [*:0]const u8) void;
    pub const setHref = webkit_dom_html_base_element_set_href;

    extern fn webkit_dom_html_base_element_set_target(p_self: *DOMHTMLBaseElement, p_value: [*:0]const u8) void;
    pub const setTarget = webkit_dom_html_base_element_set_target;

    extern fn webkit_dom_html_base_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_base_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLBaseElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLBaseElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLBaseElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBaseFontElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLBaseFontElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// This function has been removed from the DOM spec and it just returns `NULL`.
    extern fn webkit_dom_html_base_font_element_get_color(p_self: *DOMHTMLBaseFontElement) [*:0]u8;
    pub const getColor = webkit_dom_html_base_font_element_get_color;

    /// This function has been removed from the DOM spec and it just returns `NULL`.
    extern fn webkit_dom_html_base_font_element_get_face(p_self: *DOMHTMLBaseFontElement) [*:0]u8;
    pub const getFace = webkit_dom_html_base_font_element_get_face;

    /// This function has been removed from the DOM spec and it just returns 0.
    extern fn webkit_dom_html_base_font_element_get_size(p_self: *DOMHTMLBaseFontElement) c_long;
    pub const getSize = webkit_dom_html_base_font_element_get_size;

    /// This function has been removed from the DOM spec and it does nothing.
    extern fn webkit_dom_html_base_font_element_set_color(p_self: *DOMHTMLBaseFontElement, p_value: [*:0]const u8) void;
    pub const setColor = webkit_dom_html_base_font_element_set_color;

    /// This function has been removed from the DOM spec and it does nothing.
    extern fn webkit_dom_html_base_font_element_set_face(p_self: *DOMHTMLBaseFontElement, p_value: [*:0]const u8) void;
    pub const setFace = webkit_dom_html_base_font_element_set_face;

    /// This function has been removed from the DOM spec and it does nothing.
    extern fn webkit_dom_html_base_font_element_set_size(p_self: *DOMHTMLBaseFontElement, p_value: c_long) void;
    pub const setSize = webkit_dom_html_base_font_element_set_size;

    extern fn webkit_dom_html_base_font_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_base_font_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLBaseFontElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLBaseFontElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLBaseFontElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBodyElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLBodyElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const a_link = struct {
            pub const name = "a-link";

            pub const Type = ?[*:0]u8;
        };

        pub const background = struct {
            pub const name = "background";

            pub const Type = ?[*:0]u8;
        };

        pub const bg_color = struct {
            pub const name = "bg-color";

            pub const Type = ?[*:0]u8;
        };

        pub const link = struct {
            pub const name = "link";

            pub const Type = ?[*:0]u8;
        };

        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };

        pub const v_link = struct {
            pub const name = "v-link";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_body_element_get_a_link(p_self: *DOMHTMLBodyElement) [*:0]u8;
    pub const getALink = webkit_dom_html_body_element_get_a_link;

    extern fn webkit_dom_html_body_element_get_background(p_self: *DOMHTMLBodyElement) [*:0]u8;
    pub const getBackground = webkit_dom_html_body_element_get_background;

    extern fn webkit_dom_html_body_element_get_bg_color(p_self: *DOMHTMLBodyElement) [*:0]u8;
    pub const getBgColor = webkit_dom_html_body_element_get_bg_color;

    extern fn webkit_dom_html_body_element_get_link(p_self: *DOMHTMLBodyElement) [*:0]u8;
    pub const getLink = webkit_dom_html_body_element_get_link;

    extern fn webkit_dom_html_body_element_get_text(p_self: *DOMHTMLBodyElement) [*:0]u8;
    pub const getText = webkit_dom_html_body_element_get_text;

    extern fn webkit_dom_html_body_element_get_v_link(p_self: *DOMHTMLBodyElement) [*:0]u8;
    pub const getVLink = webkit_dom_html_body_element_get_v_link;

    extern fn webkit_dom_html_body_element_set_a_link(p_self: *DOMHTMLBodyElement, p_value: [*:0]const u8) void;
    pub const setALink = webkit_dom_html_body_element_set_a_link;

    extern fn webkit_dom_html_body_element_set_background(p_self: *DOMHTMLBodyElement, p_value: [*:0]const u8) void;
    pub const setBackground = webkit_dom_html_body_element_set_background;

    extern fn webkit_dom_html_body_element_set_bg_color(p_self: *DOMHTMLBodyElement, p_value: [*:0]const u8) void;
    pub const setBgColor = webkit_dom_html_body_element_set_bg_color;

    extern fn webkit_dom_html_body_element_set_link(p_self: *DOMHTMLBodyElement, p_value: [*:0]const u8) void;
    pub const setLink = webkit_dom_html_body_element_set_link;

    extern fn webkit_dom_html_body_element_set_text(p_self: *DOMHTMLBodyElement, p_value: [*:0]const u8) void;
    pub const setText = webkit_dom_html_body_element_set_text;

    extern fn webkit_dom_html_body_element_set_v_link(p_self: *DOMHTMLBodyElement, p_value: [*:0]const u8) void;
    pub const setVLink = webkit_dom_html_body_element_set_v_link;

    extern fn webkit_dom_html_body_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_body_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLBodyElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLBodyElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLBodyElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLButtonElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLButtonElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const autofocus = struct {
            pub const name = "autofocus";

            pub const Type = c_int;
        };

        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };

        pub const will_validate = struct {
            pub const name = "will-validate";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_button_element_get_autofocus(p_self: *DOMHTMLButtonElement) c_int;
    pub const getAutofocus = webkit_dom_html_button_element_get_autofocus;

    extern fn webkit_dom_html_button_element_get_button_type(p_self: *DOMHTMLButtonElement) [*:0]u8;
    pub const getButtonType = webkit_dom_html_button_element_get_button_type;

    extern fn webkit_dom_html_button_element_get_disabled(p_self: *DOMHTMLButtonElement) c_int;
    pub const getDisabled = webkit_dom_html_button_element_get_disabled;

    extern fn webkit_dom_html_button_element_get_form(p_self: *DOMHTMLButtonElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_button_element_get_form;

    extern fn webkit_dom_html_button_element_get_name(p_self: *DOMHTMLButtonElement) [*:0]u8;
    pub const getName = webkit_dom_html_button_element_get_name;

    extern fn webkit_dom_html_button_element_get_value(p_self: *DOMHTMLButtonElement) [*:0]u8;
    pub const getValue = webkit_dom_html_button_element_get_value;

    extern fn webkit_dom_html_button_element_get_will_validate(p_self: *DOMHTMLButtonElement) c_int;
    pub const getWillValidate = webkit_dom_html_button_element_get_will_validate;

    extern fn webkit_dom_html_button_element_set_autofocus(p_self: *DOMHTMLButtonElement, p_value: c_int) void;
    pub const setAutofocus = webkit_dom_html_button_element_set_autofocus;

    extern fn webkit_dom_html_button_element_set_button_type(p_self: *DOMHTMLButtonElement, p_value: [*:0]const u8) void;
    pub const setButtonType = webkit_dom_html_button_element_set_button_type;

    extern fn webkit_dom_html_button_element_set_disabled(p_self: *DOMHTMLButtonElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_button_element_set_disabled;

    extern fn webkit_dom_html_button_element_set_name(p_self: *DOMHTMLButtonElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_button_element_set_name;

    extern fn webkit_dom_html_button_element_set_value(p_self: *DOMHTMLButtonElement, p_value: [*:0]const u8) void;
    pub const setValue = webkit_dom_html_button_element_set_value;

    extern fn webkit_dom_html_button_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_button_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLButtonElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLButtonElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLButtonElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLCanvasElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLCanvasElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const height = struct {
            pub const name = "height";

            pub const Type = c_long;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_canvas_element_get_height(p_self: *DOMHTMLCanvasElement) c_long;
    pub const getHeight = webkit_dom_html_canvas_element_get_height;

    extern fn webkit_dom_html_canvas_element_get_width(p_self: *DOMHTMLCanvasElement) c_long;
    pub const getWidth = webkit_dom_html_canvas_element_get_width;

    extern fn webkit_dom_html_canvas_element_set_height(p_self: *DOMHTMLCanvasElement, p_value: c_long) void;
    pub const setHeight = webkit_dom_html_canvas_element_set_height;

    extern fn webkit_dom_html_canvas_element_set_width(p_self: *DOMHTMLCanvasElement, p_value: c_long) void;
    pub const setWidth = webkit_dom_html_canvas_element_set_width;

    extern fn webkit_dom_html_canvas_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_canvas_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLCanvasElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLCanvasElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLCanvasElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLCollection = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMHTMLCollectionClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_collection_get_length(p_self: *DOMHTMLCollection) c_ulong;
    pub const getLength = webkit_dom_html_collection_get_length;

    extern fn webkit_dom_html_collection_item(p_self: *DOMHTMLCollection, p_index: c_ulong) *webkit2webextension.DOMNode;
    pub const item = webkit_dom_html_collection_item;

    extern fn webkit_dom_html_collection_named_item(p_self: *DOMHTMLCollection, p_name: [*:0]const u8) *webkit2webextension.DOMNode;
    pub const namedItem = webkit_dom_html_collection_named_item;

    extern fn webkit_dom_html_collection_get_type() usize;
    pub const getGObjectType = webkit_dom_html_collection_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLCollection) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLCollection) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLCollection, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDListElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLDListElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const compact = struct {
            pub const name = "compact";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_d_list_element_get_compact(p_self: *DOMHTMLDListElement) c_int;
    pub const getCompact = webkit_dom_html_d_list_element_get_compact;

    extern fn webkit_dom_html_d_list_element_set_compact(p_self: *DOMHTMLDListElement, p_value: c_int) void;
    pub const setCompact = webkit_dom_html_d_list_element_set_compact;

    extern fn webkit_dom_html_d_list_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_d_list_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLDListElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLDListElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLDListElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDirectoryElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLDirectoryElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const compact = struct {
            pub const name = "compact";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_directory_element_get_compact(p_self: *DOMHTMLDirectoryElement) c_int;
    pub const getCompact = webkit_dom_html_directory_element_get_compact;

    extern fn webkit_dom_html_directory_element_set_compact(p_self: *DOMHTMLDirectoryElement, p_value: c_int) void;
    pub const setCompact = webkit_dom_html_directory_element_set_compact;

    extern fn webkit_dom_html_directory_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_directory_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLDirectoryElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLDirectoryElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLDirectoryElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDivElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLDivElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_div_element_get_align(p_self: *DOMHTMLDivElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_div_element_get_align;

    extern fn webkit_dom_html_div_element_set_align(p_self: *DOMHTMLDivElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_div_element_set_align;

    extern fn webkit_dom_html_div_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_div_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLDivElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLDivElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLDivElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDocument = extern struct {
    pub const Parent = webkit2webextension.DOMDocument;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLDocumentClass;
    f_parent_instance: webkit2webextension.DOMDocument,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const alink_color = struct {
            pub const name = "alink-color";

            pub const Type = ?[*:0]u8;
        };

        pub const bg_color = struct {
            pub const name = "bg-color";

            pub const Type = ?[*:0]u8;
        };

        pub const dir = struct {
            pub const name = "dir";

            pub const Type = ?[*:0]u8;
        };

        pub const fg_color = struct {
            pub const name = "fg-color";

            pub const Type = ?[*:0]u8;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = c_long;
        };

        pub const link_color = struct {
            pub const name = "link-color";

            pub const Type = ?[*:0]u8;
        };

        pub const vlink_color = struct {
            pub const name = "vlink-color";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_document_capture_events(p_self: *DOMHTMLDocument) void;
    pub const captureEvents = webkit_dom_html_document_capture_events;

    extern fn webkit_dom_html_document_clear(p_self: *DOMHTMLDocument) void;
    pub const clear = webkit_dom_html_document_clear;

    extern fn webkit_dom_html_document_close(p_self: *DOMHTMLDocument) void;
    pub const close = webkit_dom_html_document_close;

    extern fn webkit_dom_html_document_get_alink_color(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getAlinkColor = webkit_dom_html_document_get_alink_color;

    extern fn webkit_dom_html_document_get_bg_color(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getBgColor = webkit_dom_html_document_get_bg_color;

    extern fn webkit_dom_html_document_get_compat_mode(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getCompatMode = webkit_dom_html_document_get_compat_mode;

    extern fn webkit_dom_html_document_get_design_mode(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getDesignMode = webkit_dom_html_document_get_design_mode;

    extern fn webkit_dom_html_document_get_dir(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getDir = webkit_dom_html_document_get_dir;

    extern fn webkit_dom_html_document_get_embeds(p_self: *DOMHTMLDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getEmbeds = webkit_dom_html_document_get_embeds;

    extern fn webkit_dom_html_document_get_fg_color(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getFgColor = webkit_dom_html_document_get_fg_color;

    extern fn webkit_dom_html_document_get_height(p_self: *DOMHTMLDocument) c_long;
    pub const getHeight = webkit_dom_html_document_get_height;

    extern fn webkit_dom_html_document_get_link_color(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getLinkColor = webkit_dom_html_document_get_link_color;

    extern fn webkit_dom_html_document_get_plugins(p_self: *DOMHTMLDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getPlugins = webkit_dom_html_document_get_plugins;

    extern fn webkit_dom_html_document_get_scripts(p_self: *DOMHTMLDocument) *webkit2webextension.DOMHTMLCollection;
    pub const getScripts = webkit_dom_html_document_get_scripts;

    extern fn webkit_dom_html_document_get_vlink_color(p_self: *DOMHTMLDocument) [*:0]u8;
    pub const getVlinkColor = webkit_dom_html_document_get_vlink_color;

    extern fn webkit_dom_html_document_get_width(p_self: *DOMHTMLDocument) c_long;
    pub const getWidth = webkit_dom_html_document_get_width;

    extern fn webkit_dom_html_document_release_events(p_self: *DOMHTMLDocument) void;
    pub const releaseEvents = webkit_dom_html_document_release_events;

    extern fn webkit_dom_html_document_set_alink_color(p_self: *DOMHTMLDocument, p_value: [*:0]const u8) void;
    pub const setAlinkColor = webkit_dom_html_document_set_alink_color;

    extern fn webkit_dom_html_document_set_bg_color(p_self: *DOMHTMLDocument, p_value: [*:0]const u8) void;
    pub const setBgColor = webkit_dom_html_document_set_bg_color;

    extern fn webkit_dom_html_document_set_design_mode(p_self: *DOMHTMLDocument, p_value: [*:0]const u8) void;
    pub const setDesignMode = webkit_dom_html_document_set_design_mode;

    extern fn webkit_dom_html_document_set_dir(p_self: *DOMHTMLDocument, p_value: [*:0]const u8) void;
    pub const setDir = webkit_dom_html_document_set_dir;

    extern fn webkit_dom_html_document_set_fg_color(p_self: *DOMHTMLDocument, p_value: [*:0]const u8) void;
    pub const setFgColor = webkit_dom_html_document_set_fg_color;

    extern fn webkit_dom_html_document_set_link_color(p_self: *DOMHTMLDocument, p_value: [*:0]const u8) void;
    pub const setLinkColor = webkit_dom_html_document_set_link_color;

    extern fn webkit_dom_html_document_set_vlink_color(p_self: *DOMHTMLDocument, p_value: [*:0]const u8) void;
    pub const setVlinkColor = webkit_dom_html_document_set_vlink_color;

    extern fn webkit_dom_html_document_get_type() usize;
    pub const getGObjectType = webkit_dom_html_document_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLDocument) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLDocument) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLDocument, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLElement = extern struct {
    pub const Parent = webkit2webextension.DOMElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLElementClass;
    f_parent_instance: webkit2webextension.DOMElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const access_key = struct {
            pub const name = "access-key";

            pub const Type = ?[*:0]u8;
        };

        pub const content_editable = struct {
            pub const name = "content-editable";

            pub const Type = ?[*:0]u8;
        };

        pub const dir = struct {
            pub const name = "dir";

            pub const Type = ?[*:0]u8;
        };

        pub const draggable = struct {
            pub const name = "draggable";

            pub const Type = c_int;
        };

        pub const hidden = struct {
            pub const name = "hidden";

            pub const Type = c_int;
        };

        pub const inner_text = struct {
            pub const name = "inner-text";

            pub const Type = ?[*:0]u8;
        };

        pub const is_content_editable = struct {
            pub const name = "is-content-editable";

            pub const Type = c_int;
        };

        pub const lang = struct {
            pub const name = "lang";

            pub const Type = ?[*:0]u8;
        };

        pub const outer_text = struct {
            pub const name = "outer-text";

            pub const Type = ?[*:0]u8;
        };

        pub const spellcheck = struct {
            pub const name = "spellcheck";

            pub const Type = c_int;
        };

        pub const tab_index = struct {
            pub const name = "tab-index";

            pub const Type = c_long;
        };

        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };

        pub const translate = struct {
            pub const name = "translate";

            pub const Type = c_int;
        };

        pub const webkitdropzone = struct {
            pub const name = "webkitdropzone";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_element_click(p_self: *DOMHTMLElement) void;
    pub const click = webkit_dom_html_element_click;

    extern fn webkit_dom_html_element_get_access_key(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getAccessKey = webkit_dom_html_element_get_access_key;

    extern fn webkit_dom_html_element_get_children(p_self: *DOMHTMLElement) *webkit2webextension.DOMHTMLCollection;
    pub const getChildren = webkit_dom_html_element_get_children;

    extern fn webkit_dom_html_element_get_content_editable(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getContentEditable = webkit_dom_html_element_get_content_editable;

    extern fn webkit_dom_html_element_get_dir(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getDir = webkit_dom_html_element_get_dir;

    extern fn webkit_dom_html_element_get_draggable(p_self: *DOMHTMLElement) c_int;
    pub const getDraggable = webkit_dom_html_element_get_draggable;

    extern fn webkit_dom_html_element_get_hidden(p_self: *DOMHTMLElement) c_int;
    pub const getHidden = webkit_dom_html_element_get_hidden;

    extern fn webkit_dom_html_element_get_inner_html(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getInnerHtml = webkit_dom_html_element_get_inner_html;

    extern fn webkit_dom_html_element_get_inner_text(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getInnerText = webkit_dom_html_element_get_inner_text;

    extern fn webkit_dom_html_element_get_is_content_editable(p_self: *DOMHTMLElement) c_int;
    pub const getIsContentEditable = webkit_dom_html_element_get_is_content_editable;

    extern fn webkit_dom_html_element_get_lang(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getLang = webkit_dom_html_element_get_lang;

    extern fn webkit_dom_html_element_get_outer_html(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getOuterHtml = webkit_dom_html_element_get_outer_html;

    extern fn webkit_dom_html_element_get_outer_text(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getOuterText = webkit_dom_html_element_get_outer_text;

    extern fn webkit_dom_html_element_get_spellcheck(p_self: *DOMHTMLElement) c_int;
    pub const getSpellcheck = webkit_dom_html_element_get_spellcheck;

    extern fn webkit_dom_html_element_get_tab_index(p_self: *DOMHTMLElement) c_long;
    pub const getTabIndex = webkit_dom_html_element_get_tab_index;

    extern fn webkit_dom_html_element_get_title(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getTitle = webkit_dom_html_element_get_title;

    extern fn webkit_dom_html_element_get_translate(p_self: *DOMHTMLElement) c_int;
    pub const getTranslate = webkit_dom_html_element_get_translate;

    extern fn webkit_dom_html_element_get_webkitdropzone(p_self: *DOMHTMLElement) [*:0]u8;
    pub const getWebkitdropzone = webkit_dom_html_element_get_webkitdropzone;

    extern fn webkit_dom_html_element_set_access_key(p_self: *DOMHTMLElement, p_value: [*:0]const u8) void;
    pub const setAccessKey = webkit_dom_html_element_set_access_key;

    extern fn webkit_dom_html_element_set_content_editable(p_self: *DOMHTMLElement, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setContentEditable = webkit_dom_html_element_set_content_editable;

    extern fn webkit_dom_html_element_set_dir(p_self: *DOMHTMLElement, p_value: [*:0]const u8) void;
    pub const setDir = webkit_dom_html_element_set_dir;

    extern fn webkit_dom_html_element_set_draggable(p_self: *DOMHTMLElement, p_value: c_int) void;
    pub const setDraggable = webkit_dom_html_element_set_draggable;

    extern fn webkit_dom_html_element_set_hidden(p_self: *DOMHTMLElement, p_value: c_int) void;
    pub const setHidden = webkit_dom_html_element_set_hidden;

    extern fn webkit_dom_html_element_set_inner_html(p_self: *DOMHTMLElement, p_contents: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setInnerHtml = webkit_dom_html_element_set_inner_html;

    extern fn webkit_dom_html_element_set_inner_text(p_self: *DOMHTMLElement, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setInnerText = webkit_dom_html_element_set_inner_text;

    extern fn webkit_dom_html_element_set_lang(p_self: *DOMHTMLElement, p_value: [*:0]const u8) void;
    pub const setLang = webkit_dom_html_element_set_lang;

    extern fn webkit_dom_html_element_set_outer_html(p_self: *DOMHTMLElement, p_contents: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setOuterHtml = webkit_dom_html_element_set_outer_html;

    extern fn webkit_dom_html_element_set_outer_text(p_self: *DOMHTMLElement, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setOuterText = webkit_dom_html_element_set_outer_text;

    extern fn webkit_dom_html_element_set_spellcheck(p_self: *DOMHTMLElement, p_value: c_int) void;
    pub const setSpellcheck = webkit_dom_html_element_set_spellcheck;

    extern fn webkit_dom_html_element_set_tab_index(p_self: *DOMHTMLElement, p_value: c_long) void;
    pub const setTabIndex = webkit_dom_html_element_set_tab_index;

    extern fn webkit_dom_html_element_set_title(p_self: *DOMHTMLElement, p_value: [*:0]const u8) void;
    pub const setTitle = webkit_dom_html_element_set_title;

    extern fn webkit_dom_html_element_set_translate(p_self: *DOMHTMLElement, p_value: c_int) void;
    pub const setTranslate = webkit_dom_html_element_set_translate;

    extern fn webkit_dom_html_element_set_webkitdropzone(p_self: *DOMHTMLElement, p_value: [*:0]const u8) void;
    pub const setWebkitdropzone = webkit_dom_html_element_set_webkitdropzone;

    extern fn webkit_dom_html_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLEmbedElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLEmbedElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = c_long;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const src = struct {
            pub const name = "src";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_embed_element_get_align(p_self: *DOMHTMLEmbedElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_embed_element_get_align;

    extern fn webkit_dom_html_embed_element_get_height(p_self: *DOMHTMLEmbedElement) c_long;
    pub const getHeight = webkit_dom_html_embed_element_get_height;

    extern fn webkit_dom_html_embed_element_get_name(p_self: *DOMHTMLEmbedElement) [*:0]u8;
    pub const getName = webkit_dom_html_embed_element_get_name;

    extern fn webkit_dom_html_embed_element_get_src(p_self: *DOMHTMLEmbedElement) [*:0]u8;
    pub const getSrc = webkit_dom_html_embed_element_get_src;

    extern fn webkit_dom_html_embed_element_get_type_attr(p_self: *DOMHTMLEmbedElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_embed_element_get_type_attr;

    extern fn webkit_dom_html_embed_element_get_width(p_self: *DOMHTMLEmbedElement) c_long;
    pub const getWidth = webkit_dom_html_embed_element_get_width;

    extern fn webkit_dom_html_embed_element_set_align(p_self: *DOMHTMLEmbedElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_embed_element_set_align;

    extern fn webkit_dom_html_embed_element_set_height(p_self: *DOMHTMLEmbedElement, p_value: c_long) void;
    pub const setHeight = webkit_dom_html_embed_element_set_height;

    extern fn webkit_dom_html_embed_element_set_name(p_self: *DOMHTMLEmbedElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_embed_element_set_name;

    extern fn webkit_dom_html_embed_element_set_src(p_self: *DOMHTMLEmbedElement, p_value: [*:0]const u8) void;
    pub const setSrc = webkit_dom_html_embed_element_set_src;

    extern fn webkit_dom_html_embed_element_set_type_attr(p_self: *DOMHTMLEmbedElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_embed_element_set_type_attr;

    extern fn webkit_dom_html_embed_element_set_width(p_self: *DOMHTMLEmbedElement, p_value: c_long) void;
    pub const setWidth = webkit_dom_html_embed_element_set_width;

    extern fn webkit_dom_html_embed_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_embed_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLEmbedElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLEmbedElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLEmbedElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFieldSetElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLFieldSetElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_field_set_element_get_form(p_self: *DOMHTMLFieldSetElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_field_set_element_get_form;

    extern fn webkit_dom_html_field_set_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_field_set_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLFieldSetElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLFieldSetElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLFieldSetElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFontElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLFontElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const color = struct {
            pub const name = "color";

            pub const Type = ?[*:0]u8;
        };

        pub const face = struct {
            pub const name = "face";

            pub const Type = ?[*:0]u8;
        };

        pub const size = struct {
            pub const name = "size";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_font_element_get_color(p_self: *DOMHTMLFontElement) [*:0]u8;
    pub const getColor = webkit_dom_html_font_element_get_color;

    extern fn webkit_dom_html_font_element_get_face(p_self: *DOMHTMLFontElement) [*:0]u8;
    pub const getFace = webkit_dom_html_font_element_get_face;

    extern fn webkit_dom_html_font_element_get_size(p_self: *DOMHTMLFontElement) [*:0]u8;
    pub const getSize = webkit_dom_html_font_element_get_size;

    extern fn webkit_dom_html_font_element_set_color(p_self: *DOMHTMLFontElement, p_value: [*:0]const u8) void;
    pub const setColor = webkit_dom_html_font_element_set_color;

    extern fn webkit_dom_html_font_element_set_face(p_self: *DOMHTMLFontElement, p_value: [*:0]const u8) void;
    pub const setFace = webkit_dom_html_font_element_set_face;

    extern fn webkit_dom_html_font_element_set_size(p_self: *DOMHTMLFontElement, p_value: [*:0]const u8) void;
    pub const setSize = webkit_dom_html_font_element_set_size;

    extern fn webkit_dom_html_font_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_font_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLFontElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLFontElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLFontElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFormElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLFormElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const accept_charset = struct {
            pub const name = "accept-charset";

            pub const Type = ?[*:0]u8;
        };

        pub const action = struct {
            pub const name = "action";

            pub const Type = ?[*:0]u8;
        };

        pub const elements = struct {
            pub const name = "elements";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const encoding = struct {
            pub const name = "encoding";

            pub const Type = ?[*:0]u8;
        };

        pub const enctype = struct {
            pub const name = "enctype";

            pub const Type = ?[*:0]u8;
        };

        pub const length = struct {
            pub const name = "length";

            pub const Type = c_long;
        };

        pub const method = struct {
            pub const name = "method";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const target = struct {
            pub const name = "target";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_form_element_get_accept_charset(p_self: *DOMHTMLFormElement) [*:0]u8;
    pub const getAcceptCharset = webkit_dom_html_form_element_get_accept_charset;

    extern fn webkit_dom_html_form_element_get_action(p_self: *DOMHTMLFormElement) [*:0]u8;
    pub const getAction = webkit_dom_html_form_element_get_action;

    extern fn webkit_dom_html_form_element_get_elements(p_self: *DOMHTMLFormElement) *webkit2webextension.DOMHTMLCollection;
    pub const getElements = webkit_dom_html_form_element_get_elements;

    extern fn webkit_dom_html_form_element_get_encoding(p_self: *DOMHTMLFormElement) [*:0]u8;
    pub const getEncoding = webkit_dom_html_form_element_get_encoding;

    extern fn webkit_dom_html_form_element_get_enctype(p_self: *DOMHTMLFormElement) [*:0]u8;
    pub const getEnctype = webkit_dom_html_form_element_get_enctype;

    extern fn webkit_dom_html_form_element_get_length(p_self: *DOMHTMLFormElement) c_long;
    pub const getLength = webkit_dom_html_form_element_get_length;

    extern fn webkit_dom_html_form_element_get_method(p_self: *DOMHTMLFormElement) [*:0]u8;
    pub const getMethod = webkit_dom_html_form_element_get_method;

    extern fn webkit_dom_html_form_element_get_name(p_self: *DOMHTMLFormElement) [*:0]u8;
    pub const getName = webkit_dom_html_form_element_get_name;

    extern fn webkit_dom_html_form_element_get_target(p_self: *DOMHTMLFormElement) [*:0]u8;
    pub const getTarget = webkit_dom_html_form_element_get_target;

    extern fn webkit_dom_html_form_element_reset(p_self: *DOMHTMLFormElement) void;
    pub const reset = webkit_dom_html_form_element_reset;

    extern fn webkit_dom_html_form_element_set_accept_charset(p_self: *DOMHTMLFormElement, p_value: [*:0]const u8) void;
    pub const setAcceptCharset = webkit_dom_html_form_element_set_accept_charset;

    extern fn webkit_dom_html_form_element_set_action(p_self: *DOMHTMLFormElement, p_value: [*:0]const u8) void;
    pub const setAction = webkit_dom_html_form_element_set_action;

    extern fn webkit_dom_html_form_element_set_encoding(p_self: *DOMHTMLFormElement, p_value: [*:0]const u8) void;
    pub const setEncoding = webkit_dom_html_form_element_set_encoding;

    extern fn webkit_dom_html_form_element_set_enctype(p_self: *DOMHTMLFormElement, p_value: [*:0]const u8) void;
    pub const setEnctype = webkit_dom_html_form_element_set_enctype;

    extern fn webkit_dom_html_form_element_set_method(p_self: *DOMHTMLFormElement, p_value: [*:0]const u8) void;
    pub const setMethod = webkit_dom_html_form_element_set_method;

    extern fn webkit_dom_html_form_element_set_name(p_self: *DOMHTMLFormElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_form_element_set_name;

    extern fn webkit_dom_html_form_element_set_target(p_self: *DOMHTMLFormElement, p_value: [*:0]const u8) void;
    pub const setTarget = webkit_dom_html_form_element_set_target;

    extern fn webkit_dom_html_form_element_submit(p_self: *DOMHTMLFormElement) void;
    pub const submit = webkit_dom_html_form_element_submit;

    extern fn webkit_dom_html_form_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_form_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLFormElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLFormElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLFormElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFrameElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLFrameElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const content_document = struct {
            pub const name = "content-document";

            pub const Type = ?*webkit2webextension.DOMDocument;
        };

        pub const content_window = struct {
            pub const name = "content-window";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const frame_border = struct {
            pub const name = "frame-border";

            pub const Type = ?[*:0]u8;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = c_long;
        };

        pub const long_desc = struct {
            pub const name = "long-desc";

            pub const Type = ?[*:0]u8;
        };

        pub const margin_height = struct {
            pub const name = "margin-height";

            pub const Type = ?[*:0]u8;
        };

        pub const margin_width = struct {
            pub const name = "margin-width";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const no_resize = struct {
            pub const name = "no-resize";

            pub const Type = c_int;
        };

        pub const scrolling = struct {
            pub const name = "scrolling";

            pub const Type = ?[*:0]u8;
        };

        pub const src = struct {
            pub const name = "src";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_frame_element_get_content_document(p_self: *DOMHTMLFrameElement) *webkit2webextension.DOMDocument;
    pub const getContentDocument = webkit_dom_html_frame_element_get_content_document;

    extern fn webkit_dom_html_frame_element_get_content_window(p_self: *DOMHTMLFrameElement) *webkit2webextension.DOMDOMWindow;
    pub const getContentWindow = webkit_dom_html_frame_element_get_content_window;

    extern fn webkit_dom_html_frame_element_get_frame_border(p_self: *DOMHTMLFrameElement) [*:0]u8;
    pub const getFrameBorder = webkit_dom_html_frame_element_get_frame_border;

    extern fn webkit_dom_html_frame_element_get_height(p_self: *DOMHTMLFrameElement) c_long;
    pub const getHeight = webkit_dom_html_frame_element_get_height;

    extern fn webkit_dom_html_frame_element_get_long_desc(p_self: *DOMHTMLFrameElement) [*:0]u8;
    pub const getLongDesc = webkit_dom_html_frame_element_get_long_desc;

    extern fn webkit_dom_html_frame_element_get_margin_height(p_self: *DOMHTMLFrameElement) [*:0]u8;
    pub const getMarginHeight = webkit_dom_html_frame_element_get_margin_height;

    extern fn webkit_dom_html_frame_element_get_margin_width(p_self: *DOMHTMLFrameElement) [*:0]u8;
    pub const getMarginWidth = webkit_dom_html_frame_element_get_margin_width;

    extern fn webkit_dom_html_frame_element_get_name(p_self: *DOMHTMLFrameElement) [*:0]u8;
    pub const getName = webkit_dom_html_frame_element_get_name;

    extern fn webkit_dom_html_frame_element_get_no_resize(p_self: *DOMHTMLFrameElement) c_int;
    pub const getNoResize = webkit_dom_html_frame_element_get_no_resize;

    extern fn webkit_dom_html_frame_element_get_scrolling(p_self: *DOMHTMLFrameElement) [*:0]u8;
    pub const getScrolling = webkit_dom_html_frame_element_get_scrolling;

    extern fn webkit_dom_html_frame_element_get_src(p_self: *DOMHTMLFrameElement) [*:0]u8;
    pub const getSrc = webkit_dom_html_frame_element_get_src;

    extern fn webkit_dom_html_frame_element_get_width(p_self: *DOMHTMLFrameElement) c_long;
    pub const getWidth = webkit_dom_html_frame_element_get_width;

    extern fn webkit_dom_html_frame_element_set_frame_border(p_self: *DOMHTMLFrameElement, p_value: [*:0]const u8) void;
    pub const setFrameBorder = webkit_dom_html_frame_element_set_frame_border;

    extern fn webkit_dom_html_frame_element_set_long_desc(p_self: *DOMHTMLFrameElement, p_value: [*:0]const u8) void;
    pub const setLongDesc = webkit_dom_html_frame_element_set_long_desc;

    extern fn webkit_dom_html_frame_element_set_margin_height(p_self: *DOMHTMLFrameElement, p_value: [*:0]const u8) void;
    pub const setMarginHeight = webkit_dom_html_frame_element_set_margin_height;

    extern fn webkit_dom_html_frame_element_set_margin_width(p_self: *DOMHTMLFrameElement, p_value: [*:0]const u8) void;
    pub const setMarginWidth = webkit_dom_html_frame_element_set_margin_width;

    extern fn webkit_dom_html_frame_element_set_name(p_self: *DOMHTMLFrameElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_frame_element_set_name;

    extern fn webkit_dom_html_frame_element_set_no_resize(p_self: *DOMHTMLFrameElement, p_value: c_int) void;
    pub const setNoResize = webkit_dom_html_frame_element_set_no_resize;

    extern fn webkit_dom_html_frame_element_set_scrolling(p_self: *DOMHTMLFrameElement, p_value: [*:0]const u8) void;
    pub const setScrolling = webkit_dom_html_frame_element_set_scrolling;

    extern fn webkit_dom_html_frame_element_set_src(p_self: *DOMHTMLFrameElement, p_value: [*:0]const u8) void;
    pub const setSrc = webkit_dom_html_frame_element_set_src;

    extern fn webkit_dom_html_frame_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_frame_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLFrameElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLFrameElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLFrameElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFrameSetElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLFrameSetElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const cols = struct {
            pub const name = "cols";

            pub const Type = ?[*:0]u8;
        };

        pub const rows = struct {
            pub const name = "rows";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_frame_set_element_get_cols(p_self: *DOMHTMLFrameSetElement) [*:0]u8;
    pub const getCols = webkit_dom_html_frame_set_element_get_cols;

    extern fn webkit_dom_html_frame_set_element_get_rows(p_self: *DOMHTMLFrameSetElement) [*:0]u8;
    pub const getRows = webkit_dom_html_frame_set_element_get_rows;

    extern fn webkit_dom_html_frame_set_element_set_cols(p_self: *DOMHTMLFrameSetElement, p_value: [*:0]const u8) void;
    pub const setCols = webkit_dom_html_frame_set_element_set_cols;

    extern fn webkit_dom_html_frame_set_element_set_rows(p_self: *DOMHTMLFrameSetElement, p_value: [*:0]const u8) void;
    pub const setRows = webkit_dom_html_frame_set_element_set_rows;

    extern fn webkit_dom_html_frame_set_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_frame_set_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLFrameSetElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLFrameSetElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLFrameSetElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHRElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLHRElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const no_shade = struct {
            pub const name = "no-shade";

            pub const Type = c_int;
        };

        pub const size = struct {
            pub const name = "size";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_hr_element_get_align(p_self: *DOMHTMLHRElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_hr_element_get_align;

    extern fn webkit_dom_html_hr_element_get_no_shade(p_self: *DOMHTMLHRElement) c_int;
    pub const getNoShade = webkit_dom_html_hr_element_get_no_shade;

    extern fn webkit_dom_html_hr_element_get_size(p_self: *DOMHTMLHRElement) [*:0]u8;
    pub const getSize = webkit_dom_html_hr_element_get_size;

    extern fn webkit_dom_html_hr_element_get_width(p_self: *DOMHTMLHRElement) [*:0]u8;
    pub const getWidth = webkit_dom_html_hr_element_get_width;

    extern fn webkit_dom_html_hr_element_set_align(p_self: *DOMHTMLHRElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_hr_element_set_align;

    extern fn webkit_dom_html_hr_element_set_no_shade(p_self: *DOMHTMLHRElement, p_value: c_int) void;
    pub const setNoShade = webkit_dom_html_hr_element_set_no_shade;

    extern fn webkit_dom_html_hr_element_set_size(p_self: *DOMHTMLHRElement, p_value: [*:0]const u8) void;
    pub const setSize = webkit_dom_html_hr_element_set_size;

    extern fn webkit_dom_html_hr_element_set_width(p_self: *DOMHTMLHRElement, p_value: [*:0]const u8) void;
    pub const setWidth = webkit_dom_html_hr_element_set_width;

    extern fn webkit_dom_html_hr_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_hr_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLHRElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLHRElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLHRElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHeadElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLHeadElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const profile = struct {
            pub const name = "profile";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_head_element_get_profile(p_self: *DOMHTMLHeadElement) [*:0]u8;
    pub const getProfile = webkit_dom_html_head_element_get_profile;

    extern fn webkit_dom_html_head_element_set_profile(p_self: *DOMHTMLHeadElement, p_value: [*:0]const u8) void;
    pub const setProfile = webkit_dom_html_head_element_set_profile;

    extern fn webkit_dom_html_head_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_head_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLHeadElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLHeadElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLHeadElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHeadingElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLHeadingElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_heading_element_get_align(p_self: *DOMHTMLHeadingElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_heading_element_get_align;

    extern fn webkit_dom_html_heading_element_set_align(p_self: *DOMHTMLHeadingElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_heading_element_set_align;

    extern fn webkit_dom_html_heading_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_heading_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLHeadingElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLHeadingElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLHeadingElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHtmlElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLHtmlElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const version = struct {
            pub const name = "version";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_html_element_get_version(p_self: *DOMHTMLHtmlElement) [*:0]u8;
    pub const getVersion = webkit_dom_html_html_element_get_version;

    extern fn webkit_dom_html_html_element_set_version(p_self: *DOMHTMLHtmlElement, p_value: [*:0]const u8) void;
    pub const setVersion = webkit_dom_html_html_element_set_version;

    extern fn webkit_dom_html_html_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_html_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLHtmlElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLHtmlElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLHtmlElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLIFrameElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLIFrameElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const content_document = struct {
            pub const name = "content-document";

            pub const Type = ?*webkit2webextension.DOMDocument;
        };

        pub const content_window = struct {
            pub const name = "content-window";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };

        pub const frame_border = struct {
            pub const name = "frame-border";

            pub const Type = ?[*:0]u8;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = ?[*:0]u8;
        };

        pub const long_desc = struct {
            pub const name = "long-desc";

            pub const Type = ?[*:0]u8;
        };

        pub const margin_height = struct {
            pub const name = "margin-height";

            pub const Type = ?[*:0]u8;
        };

        pub const margin_width = struct {
            pub const name = "margin-width";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const scrolling = struct {
            pub const name = "scrolling";

            pub const Type = ?[*:0]u8;
        };

        pub const src = struct {
            pub const name = "src";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_iframe_element_get_align(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_iframe_element_get_align;

    extern fn webkit_dom_html_iframe_element_get_content_document(p_self: *DOMHTMLIFrameElement) *webkit2webextension.DOMDocument;
    pub const getContentDocument = webkit_dom_html_iframe_element_get_content_document;

    extern fn webkit_dom_html_iframe_element_get_content_window(p_self: *DOMHTMLIFrameElement) *webkit2webextension.DOMDOMWindow;
    pub const getContentWindow = webkit_dom_html_iframe_element_get_content_window;

    extern fn webkit_dom_html_iframe_element_get_frame_border(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getFrameBorder = webkit_dom_html_iframe_element_get_frame_border;

    extern fn webkit_dom_html_iframe_element_get_height(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getHeight = webkit_dom_html_iframe_element_get_height;

    extern fn webkit_dom_html_iframe_element_get_long_desc(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getLongDesc = webkit_dom_html_iframe_element_get_long_desc;

    extern fn webkit_dom_html_iframe_element_get_margin_height(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getMarginHeight = webkit_dom_html_iframe_element_get_margin_height;

    extern fn webkit_dom_html_iframe_element_get_margin_width(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getMarginWidth = webkit_dom_html_iframe_element_get_margin_width;

    extern fn webkit_dom_html_iframe_element_get_name(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getName = webkit_dom_html_iframe_element_get_name;

    extern fn webkit_dom_html_iframe_element_get_scrolling(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getScrolling = webkit_dom_html_iframe_element_get_scrolling;

    extern fn webkit_dom_html_iframe_element_get_src(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getSrc = webkit_dom_html_iframe_element_get_src;

    extern fn webkit_dom_html_iframe_element_get_width(p_self: *DOMHTMLIFrameElement) [*:0]u8;
    pub const getWidth = webkit_dom_html_iframe_element_get_width;

    extern fn webkit_dom_html_iframe_element_set_align(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_iframe_element_set_align;

    extern fn webkit_dom_html_iframe_element_set_frame_border(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setFrameBorder = webkit_dom_html_iframe_element_set_frame_border;

    extern fn webkit_dom_html_iframe_element_set_height(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setHeight = webkit_dom_html_iframe_element_set_height;

    extern fn webkit_dom_html_iframe_element_set_long_desc(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setLongDesc = webkit_dom_html_iframe_element_set_long_desc;

    extern fn webkit_dom_html_iframe_element_set_margin_height(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setMarginHeight = webkit_dom_html_iframe_element_set_margin_height;

    extern fn webkit_dom_html_iframe_element_set_margin_width(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setMarginWidth = webkit_dom_html_iframe_element_set_margin_width;

    extern fn webkit_dom_html_iframe_element_set_name(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_iframe_element_set_name;

    extern fn webkit_dom_html_iframe_element_set_scrolling(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setScrolling = webkit_dom_html_iframe_element_set_scrolling;

    extern fn webkit_dom_html_iframe_element_set_src(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setSrc = webkit_dom_html_iframe_element_set_src;

    extern fn webkit_dom_html_iframe_element_set_width(p_self: *DOMHTMLIFrameElement, p_value: [*:0]const u8) void;
    pub const setWidth = webkit_dom_html_iframe_element_set_width;

    extern fn webkit_dom_html_iframe_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_iframe_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLIFrameElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLIFrameElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLIFrameElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLImageElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLImageElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const alt = struct {
            pub const name = "alt";

            pub const Type = ?[*:0]u8;
        };

        pub const border = struct {
            pub const name = "border";

            pub const Type = ?[*:0]u8;
        };

        pub const complete = struct {
            pub const name = "complete";

            pub const Type = c_int;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = c_long;
        };

        pub const hspace = struct {
            pub const name = "hspace";

            pub const Type = c_long;
        };

        pub const is_map = struct {
            pub const name = "is-map";

            pub const Type = c_int;
        };

        pub const long_desc = struct {
            pub const name = "long-desc";

            pub const Type = ?[*:0]u8;
        };

        pub const lowsrc = struct {
            pub const name = "lowsrc";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const natural_height = struct {
            pub const name = "natural-height";

            pub const Type = c_long;
        };

        pub const natural_width = struct {
            pub const name = "natural-width";

            pub const Type = c_long;
        };

        pub const src = struct {
            pub const name = "src";

            pub const Type = ?[*:0]u8;
        };

        pub const use_map = struct {
            pub const name = "use-map";

            pub const Type = ?[*:0]u8;
        };

        pub const vspace = struct {
            pub const name = "vspace";

            pub const Type = c_long;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = c_long;
        };

        pub const x = struct {
            pub const name = "x";

            pub const Type = c_long;
        };

        pub const y = struct {
            pub const name = "y";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_image_element_get_align(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_image_element_get_align;

    extern fn webkit_dom_html_image_element_get_alt(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getAlt = webkit_dom_html_image_element_get_alt;

    extern fn webkit_dom_html_image_element_get_border(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getBorder = webkit_dom_html_image_element_get_border;

    extern fn webkit_dom_html_image_element_get_complete(p_self: *DOMHTMLImageElement) c_int;
    pub const getComplete = webkit_dom_html_image_element_get_complete;

    extern fn webkit_dom_html_image_element_get_height(p_self: *DOMHTMLImageElement) c_long;
    pub const getHeight = webkit_dom_html_image_element_get_height;

    extern fn webkit_dom_html_image_element_get_hspace(p_self: *DOMHTMLImageElement) c_long;
    pub const getHspace = webkit_dom_html_image_element_get_hspace;

    extern fn webkit_dom_html_image_element_get_is_map(p_self: *DOMHTMLImageElement) c_int;
    pub const getIsMap = webkit_dom_html_image_element_get_is_map;

    extern fn webkit_dom_html_image_element_get_long_desc(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getLongDesc = webkit_dom_html_image_element_get_long_desc;

    extern fn webkit_dom_html_image_element_get_lowsrc(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getLowsrc = webkit_dom_html_image_element_get_lowsrc;

    extern fn webkit_dom_html_image_element_get_name(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getName = webkit_dom_html_image_element_get_name;

    extern fn webkit_dom_html_image_element_get_natural_height(p_self: *DOMHTMLImageElement) c_long;
    pub const getNaturalHeight = webkit_dom_html_image_element_get_natural_height;

    extern fn webkit_dom_html_image_element_get_natural_width(p_self: *DOMHTMLImageElement) c_long;
    pub const getNaturalWidth = webkit_dom_html_image_element_get_natural_width;

    extern fn webkit_dom_html_image_element_get_src(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getSrc = webkit_dom_html_image_element_get_src;

    extern fn webkit_dom_html_image_element_get_use_map(p_self: *DOMHTMLImageElement) [*:0]u8;
    pub const getUseMap = webkit_dom_html_image_element_get_use_map;

    extern fn webkit_dom_html_image_element_get_vspace(p_self: *DOMHTMLImageElement) c_long;
    pub const getVspace = webkit_dom_html_image_element_get_vspace;

    extern fn webkit_dom_html_image_element_get_width(p_self: *DOMHTMLImageElement) c_long;
    pub const getWidth = webkit_dom_html_image_element_get_width;

    extern fn webkit_dom_html_image_element_get_x(p_self: *DOMHTMLImageElement) c_long;
    pub const getX = webkit_dom_html_image_element_get_x;

    extern fn webkit_dom_html_image_element_get_y(p_self: *DOMHTMLImageElement) c_long;
    pub const getY = webkit_dom_html_image_element_get_y;

    extern fn webkit_dom_html_image_element_set_align(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_image_element_set_align;

    extern fn webkit_dom_html_image_element_set_alt(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setAlt = webkit_dom_html_image_element_set_alt;

    extern fn webkit_dom_html_image_element_set_border(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setBorder = webkit_dom_html_image_element_set_border;

    extern fn webkit_dom_html_image_element_set_height(p_self: *DOMHTMLImageElement, p_value: c_long) void;
    pub const setHeight = webkit_dom_html_image_element_set_height;

    extern fn webkit_dom_html_image_element_set_hspace(p_self: *DOMHTMLImageElement, p_value: c_long) void;
    pub const setHspace = webkit_dom_html_image_element_set_hspace;

    extern fn webkit_dom_html_image_element_set_is_map(p_self: *DOMHTMLImageElement, p_value: c_int) void;
    pub const setIsMap = webkit_dom_html_image_element_set_is_map;

    extern fn webkit_dom_html_image_element_set_long_desc(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setLongDesc = webkit_dom_html_image_element_set_long_desc;

    extern fn webkit_dom_html_image_element_set_lowsrc(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setLowsrc = webkit_dom_html_image_element_set_lowsrc;

    extern fn webkit_dom_html_image_element_set_name(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_image_element_set_name;

    extern fn webkit_dom_html_image_element_set_src(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setSrc = webkit_dom_html_image_element_set_src;

    extern fn webkit_dom_html_image_element_set_use_map(p_self: *DOMHTMLImageElement, p_value: [*:0]const u8) void;
    pub const setUseMap = webkit_dom_html_image_element_set_use_map;

    extern fn webkit_dom_html_image_element_set_vspace(p_self: *DOMHTMLImageElement, p_value: c_long) void;
    pub const setVspace = webkit_dom_html_image_element_set_vspace;

    extern fn webkit_dom_html_image_element_set_width(p_self: *DOMHTMLImageElement, p_value: c_long) void;
    pub const setWidth = webkit_dom_html_image_element_set_width;

    extern fn webkit_dom_html_image_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_image_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLImageElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLImageElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLImageElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLInputElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLInputElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const accept = struct {
            pub const name = "accept";

            pub const Type = ?[*:0]u8;
        };

        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const alt = struct {
            pub const name = "alt";

            pub const Type = ?[*:0]u8;
        };

        pub const autofocus = struct {
            pub const name = "autofocus";

            pub const Type = c_int;
        };

        pub const capture = struct {
            pub const name = "capture";

            pub const Type = ?[*:0]u8;
        };

        pub const checked = struct {
            pub const name = "checked";

            pub const Type = c_int;
        };

        pub const default_checked = struct {
            pub const name = "default-checked";

            pub const Type = c_int;
        };

        pub const default_value = struct {
            pub const name = "default-value";

            pub const Type = ?[*:0]u8;
        };

        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const files = struct {
            pub const name = "files";

            pub const Type = ?*webkit2webextension.DOMFileList;
        };

        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = c_ulong;
        };

        pub const indeterminate = struct {
            pub const name = "indeterminate";

            pub const Type = c_int;
        };

        pub const max_length = struct {
            pub const name = "max-length";

            pub const Type = c_long;
        };

        pub const multiple = struct {
            pub const name = "multiple";

            pub const Type = c_int;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const read_only = struct {
            pub const name = "read-only";

            pub const Type = c_int;
        };

        pub const size = struct {
            pub const name = "size";

            pub const Type = c_ulong;
        };

        pub const src = struct {
            pub const name = "src";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const use_map = struct {
            pub const name = "use-map";

            pub const Type = ?[*:0]u8;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = c_ulong;
        };

        pub const will_validate = struct {
            pub const name = "will-validate";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_input_element_get_accept(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getAccept = webkit_dom_html_input_element_get_accept;

    extern fn webkit_dom_html_input_element_get_align(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_input_element_get_align;

    extern fn webkit_dom_html_input_element_get_alt(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getAlt = webkit_dom_html_input_element_get_alt;

    extern fn webkit_dom_html_input_element_get_auto_filled(p_self: *DOMHTMLInputElement) c_int;
    pub const getAutoFilled = webkit_dom_html_input_element_get_auto_filled;

    extern fn webkit_dom_html_input_element_get_autofocus(p_self: *DOMHTMLInputElement) c_int;
    pub const getAutofocus = webkit_dom_html_input_element_get_autofocus;

    extern fn webkit_dom_html_input_element_get_capture(p_self: *DOMHTMLInputElement) c_int;
    pub const getCapture = webkit_dom_html_input_element_get_capture;

    extern fn webkit_dom_html_input_element_get_capture_type(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getCaptureType = webkit_dom_html_input_element_get_capture_type;

    extern fn webkit_dom_html_input_element_get_checked(p_self: *DOMHTMLInputElement) c_int;
    pub const getChecked = webkit_dom_html_input_element_get_checked;

    extern fn webkit_dom_html_input_element_get_default_checked(p_self: *DOMHTMLInputElement) c_int;
    pub const getDefaultChecked = webkit_dom_html_input_element_get_default_checked;

    extern fn webkit_dom_html_input_element_get_default_value(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getDefaultValue = webkit_dom_html_input_element_get_default_value;

    extern fn webkit_dom_html_input_element_get_disabled(p_self: *DOMHTMLInputElement) c_int;
    pub const getDisabled = webkit_dom_html_input_element_get_disabled;

    extern fn webkit_dom_html_input_element_get_files(p_self: *DOMHTMLInputElement) *webkit2webextension.DOMFileList;
    pub const getFiles = webkit_dom_html_input_element_get_files;

    extern fn webkit_dom_html_input_element_get_form(p_self: *DOMHTMLInputElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_input_element_get_form;

    extern fn webkit_dom_html_input_element_get_height(p_self: *DOMHTMLInputElement) c_ulong;
    pub const getHeight = webkit_dom_html_input_element_get_height;

    extern fn webkit_dom_html_input_element_get_indeterminate(p_self: *DOMHTMLInputElement) c_int;
    pub const getIndeterminate = webkit_dom_html_input_element_get_indeterminate;

    extern fn webkit_dom_html_input_element_get_input_type(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getInputType = webkit_dom_html_input_element_get_input_type;

    extern fn webkit_dom_html_input_element_get_max_length(p_self: *DOMHTMLInputElement) c_long;
    pub const getMaxLength = webkit_dom_html_input_element_get_max_length;

    extern fn webkit_dom_html_input_element_get_multiple(p_self: *DOMHTMLInputElement) c_int;
    pub const getMultiple = webkit_dom_html_input_element_get_multiple;

    extern fn webkit_dom_html_input_element_get_name(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getName = webkit_dom_html_input_element_get_name;

    extern fn webkit_dom_html_input_element_get_read_only(p_self: *DOMHTMLInputElement) c_int;
    pub const getReadOnly = webkit_dom_html_input_element_get_read_only;

    extern fn webkit_dom_html_input_element_get_size(p_self: *DOMHTMLInputElement) c_ulong;
    pub const getSize = webkit_dom_html_input_element_get_size;

    extern fn webkit_dom_html_input_element_get_src(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getSrc = webkit_dom_html_input_element_get_src;

    extern fn webkit_dom_html_input_element_get_use_map(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getUseMap = webkit_dom_html_input_element_get_use_map;

    extern fn webkit_dom_html_input_element_get_value(p_self: *DOMHTMLInputElement) [*:0]u8;
    pub const getValue = webkit_dom_html_input_element_get_value;

    extern fn webkit_dom_html_input_element_get_width(p_self: *DOMHTMLInputElement) c_ulong;
    pub const getWidth = webkit_dom_html_input_element_get_width;

    extern fn webkit_dom_html_input_element_get_will_validate(p_self: *DOMHTMLInputElement) c_int;
    pub const getWillValidate = webkit_dom_html_input_element_get_will_validate;

    extern fn webkit_dom_html_input_element_is_edited(p_input: *DOMHTMLInputElement) c_int;
    pub const isEdited = webkit_dom_html_input_element_is_edited;

    extern fn webkit_dom_html_input_element_select(p_self: *DOMHTMLInputElement) void;
    pub const select = webkit_dom_html_input_element_select;

    extern fn webkit_dom_html_input_element_set_accept(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setAccept = webkit_dom_html_input_element_set_accept;

    extern fn webkit_dom_html_input_element_set_align(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_input_element_set_align;

    extern fn webkit_dom_html_input_element_set_alt(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setAlt = webkit_dom_html_input_element_set_alt;

    extern fn webkit_dom_html_input_element_set_auto_filled(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setAutoFilled = webkit_dom_html_input_element_set_auto_filled;

    extern fn webkit_dom_html_input_element_set_autofocus(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setAutofocus = webkit_dom_html_input_element_set_autofocus;

    extern fn webkit_dom_html_input_element_set_capture_type(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setCaptureType = webkit_dom_html_input_element_set_capture_type;

    extern fn webkit_dom_html_input_element_set_checked(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setChecked = webkit_dom_html_input_element_set_checked;

    extern fn webkit_dom_html_input_element_set_default_checked(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setDefaultChecked = webkit_dom_html_input_element_set_default_checked;

    extern fn webkit_dom_html_input_element_set_default_value(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setDefaultValue = webkit_dom_html_input_element_set_default_value;

    extern fn webkit_dom_html_input_element_set_disabled(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_input_element_set_disabled;

    extern fn webkit_dom_html_input_element_set_editing_value(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setEditingValue = webkit_dom_html_input_element_set_editing_value;

    extern fn webkit_dom_html_input_element_set_files(p_self: *DOMHTMLInputElement, p_value: *webkit2webextension.DOMFileList) void;
    pub const setFiles = webkit_dom_html_input_element_set_files;

    extern fn webkit_dom_html_input_element_set_height(p_self: *DOMHTMLInputElement, p_value: c_ulong) void;
    pub const setHeight = webkit_dom_html_input_element_set_height;

    extern fn webkit_dom_html_input_element_set_indeterminate(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setIndeterminate = webkit_dom_html_input_element_set_indeterminate;

    extern fn webkit_dom_html_input_element_set_input_type(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setInputType = webkit_dom_html_input_element_set_input_type;

    extern fn webkit_dom_html_input_element_set_max_length(p_self: *DOMHTMLInputElement, p_value: c_long, p_error: ?*?*glib.Error) void;
    pub const setMaxLength = webkit_dom_html_input_element_set_max_length;

    extern fn webkit_dom_html_input_element_set_multiple(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setMultiple = webkit_dom_html_input_element_set_multiple;

    extern fn webkit_dom_html_input_element_set_name(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_input_element_set_name;

    extern fn webkit_dom_html_input_element_set_read_only(p_self: *DOMHTMLInputElement, p_value: c_int) void;
    pub const setReadOnly = webkit_dom_html_input_element_set_read_only;

    extern fn webkit_dom_html_input_element_set_size(p_self: *DOMHTMLInputElement, p_value: c_ulong, p_error: ?*?*glib.Error) void;
    pub const setSize = webkit_dom_html_input_element_set_size;

    extern fn webkit_dom_html_input_element_set_src(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setSrc = webkit_dom_html_input_element_set_src;

    extern fn webkit_dom_html_input_element_set_use_map(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setUseMap = webkit_dom_html_input_element_set_use_map;

    extern fn webkit_dom_html_input_element_set_value(p_self: *DOMHTMLInputElement, p_value: [*:0]const u8) void;
    pub const setValue = webkit_dom_html_input_element_set_value;

    extern fn webkit_dom_html_input_element_set_width(p_self: *DOMHTMLInputElement, p_value: c_ulong) void;
    pub const setWidth = webkit_dom_html_input_element_set_width;

    extern fn webkit_dom_html_input_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_input_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLInputElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLInputElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLInputElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLIElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLLIElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_li_element_get_type_attr(p_self: *DOMHTMLLIElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_li_element_get_type_attr;

    extern fn webkit_dom_html_li_element_get_value(p_self: *DOMHTMLLIElement) c_long;
    pub const getValue = webkit_dom_html_li_element_get_value;

    extern fn webkit_dom_html_li_element_set_type_attr(p_self: *DOMHTMLLIElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_li_element_set_type_attr;

    extern fn webkit_dom_html_li_element_set_value(p_self: *DOMHTMLLIElement, p_value: c_long) void;
    pub const setValue = webkit_dom_html_li_element_set_value;

    extern fn webkit_dom_html_li_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_li_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLLIElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLLIElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLLIElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLabelElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLLabelElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };

        pub const html_for = struct {
            pub const name = "html-for";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_label_element_get_form(p_self: *DOMHTMLLabelElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_label_element_get_form;

    extern fn webkit_dom_html_label_element_get_html_for(p_self: *DOMHTMLLabelElement) [*:0]u8;
    pub const getHtmlFor = webkit_dom_html_label_element_get_html_for;

    extern fn webkit_dom_html_label_element_set_html_for(p_self: *DOMHTMLLabelElement, p_value: [*:0]const u8) void;
    pub const setHtmlFor = webkit_dom_html_label_element_set_html_for;

    extern fn webkit_dom_html_label_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_label_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLLabelElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLLabelElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLLabelElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLegendElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLLegendElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_legend_element_get_align(p_self: *DOMHTMLLegendElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_legend_element_get_align;

    extern fn webkit_dom_html_legend_element_get_form(p_self: *DOMHTMLLegendElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_legend_element_get_form;

    extern fn webkit_dom_html_legend_element_set_align(p_self: *DOMHTMLLegendElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_legend_element_set_align;

    extern fn webkit_dom_html_legend_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_legend_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLLegendElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLLegendElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLLegendElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLinkElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLLinkElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const charset = struct {
            pub const name = "charset";

            pub const Type = ?[*:0]u8;
        };

        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const href = struct {
            pub const name = "href";

            pub const Type = ?[*:0]u8;
        };

        pub const hreflang = struct {
            pub const name = "hreflang";

            pub const Type = ?[*:0]u8;
        };

        pub const media = struct {
            pub const name = "media";

            pub const Type = ?[*:0]u8;
        };

        pub const rel = struct {
            pub const name = "rel";

            pub const Type = ?[*:0]u8;
        };

        pub const rev = struct {
            pub const name = "rev";

            pub const Type = ?[*:0]u8;
        };

        pub const sheet = struct {
            pub const name = "sheet";

            pub const Type = ?*webkit2webextension.DOMStyleSheet;
        };

        pub const sizes = struct {
            pub const name = "sizes";

            pub const Type = ?*webkit2webextension.DOMDOMTokenList;
        };

        pub const target = struct {
            pub const name = "target";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_link_element_get_charset(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getCharset = webkit_dom_html_link_element_get_charset;

    extern fn webkit_dom_html_link_element_get_disabled(p_self: *DOMHTMLLinkElement) c_int;
    pub const getDisabled = webkit_dom_html_link_element_get_disabled;

    extern fn webkit_dom_html_link_element_get_href(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getHref = webkit_dom_html_link_element_get_href;

    extern fn webkit_dom_html_link_element_get_hreflang(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getHreflang = webkit_dom_html_link_element_get_hreflang;

    extern fn webkit_dom_html_link_element_get_media(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getMedia = webkit_dom_html_link_element_get_media;

    extern fn webkit_dom_html_link_element_get_rel(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getRel = webkit_dom_html_link_element_get_rel;

    extern fn webkit_dom_html_link_element_get_rev(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getRev = webkit_dom_html_link_element_get_rev;

    extern fn webkit_dom_html_link_element_get_sheet(p_self: *DOMHTMLLinkElement) *webkit2webextension.DOMStyleSheet;
    pub const getSheet = webkit_dom_html_link_element_get_sheet;

    extern fn webkit_dom_html_link_element_get_sizes(p_self: *DOMHTMLLinkElement) *webkit2webextension.DOMDOMTokenList;
    pub const getSizes = webkit_dom_html_link_element_get_sizes;

    extern fn webkit_dom_html_link_element_get_target(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getTarget = webkit_dom_html_link_element_get_target;

    extern fn webkit_dom_html_link_element_get_type_attr(p_self: *DOMHTMLLinkElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_link_element_get_type_attr;

    extern fn webkit_dom_html_link_element_set_charset(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setCharset = webkit_dom_html_link_element_set_charset;

    extern fn webkit_dom_html_link_element_set_disabled(p_self: *DOMHTMLLinkElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_link_element_set_disabled;

    extern fn webkit_dom_html_link_element_set_href(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setHref = webkit_dom_html_link_element_set_href;

    extern fn webkit_dom_html_link_element_set_hreflang(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setHreflang = webkit_dom_html_link_element_set_hreflang;

    extern fn webkit_dom_html_link_element_set_media(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setMedia = webkit_dom_html_link_element_set_media;

    extern fn webkit_dom_html_link_element_set_rel(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setRel = webkit_dom_html_link_element_set_rel;

    extern fn webkit_dom_html_link_element_set_rev(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setRev = webkit_dom_html_link_element_set_rev;

    extern fn webkit_dom_html_link_element_set_sizes(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setSizes = webkit_dom_html_link_element_set_sizes;

    extern fn webkit_dom_html_link_element_set_target(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setTarget = webkit_dom_html_link_element_set_target;

    extern fn webkit_dom_html_link_element_set_type_attr(p_self: *DOMHTMLLinkElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_link_element_set_type_attr;

    extern fn webkit_dom_html_link_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_link_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLLinkElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLLinkElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLLinkElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMapElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLMapElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const areas = struct {
            pub const name = "areas";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_map_element_get_areas(p_self: *DOMHTMLMapElement) *webkit2webextension.DOMHTMLCollection;
    pub const getAreas = webkit_dom_html_map_element_get_areas;

    extern fn webkit_dom_html_map_element_get_name(p_self: *DOMHTMLMapElement) [*:0]u8;
    pub const getName = webkit_dom_html_map_element_get_name;

    extern fn webkit_dom_html_map_element_set_name(p_self: *DOMHTMLMapElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_map_element_set_name;

    extern fn webkit_dom_html_map_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_map_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLMapElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLMapElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLMapElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMarqueeElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLMarqueeElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_html_marquee_element_start(p_self: *DOMHTMLMarqueeElement) void;
    pub const start = webkit_dom_html_marquee_element_start;

    extern fn webkit_dom_html_marquee_element_stop(p_self: *DOMHTMLMarqueeElement) void;
    pub const stop = webkit_dom_html_marquee_element_stop;

    extern fn webkit_dom_html_marquee_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_marquee_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLMarqueeElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLMarqueeElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLMarqueeElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMenuElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLMenuElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const compact = struct {
            pub const name = "compact";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_menu_element_get_compact(p_self: *DOMHTMLMenuElement) c_int;
    pub const getCompact = webkit_dom_html_menu_element_get_compact;

    extern fn webkit_dom_html_menu_element_set_compact(p_self: *DOMHTMLMenuElement, p_value: c_int) void;
    pub const setCompact = webkit_dom_html_menu_element_set_compact;

    extern fn webkit_dom_html_menu_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_menu_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLMenuElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLMenuElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLMenuElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMetaElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLMetaElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const content = struct {
            pub const name = "content";

            pub const Type = ?[*:0]u8;
        };

        pub const http_equiv = struct {
            pub const name = "http-equiv";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const scheme = struct {
            pub const name = "scheme";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_meta_element_get_content(p_self: *DOMHTMLMetaElement) [*:0]u8;
    pub const getContent = webkit_dom_html_meta_element_get_content;

    extern fn webkit_dom_html_meta_element_get_http_equiv(p_self: *DOMHTMLMetaElement) [*:0]u8;
    pub const getHttpEquiv = webkit_dom_html_meta_element_get_http_equiv;

    extern fn webkit_dom_html_meta_element_get_name(p_self: *DOMHTMLMetaElement) [*:0]u8;
    pub const getName = webkit_dom_html_meta_element_get_name;

    extern fn webkit_dom_html_meta_element_get_scheme(p_self: *DOMHTMLMetaElement) [*:0]u8;
    pub const getScheme = webkit_dom_html_meta_element_get_scheme;

    extern fn webkit_dom_html_meta_element_set_content(p_self: *DOMHTMLMetaElement, p_value: [*:0]const u8) void;
    pub const setContent = webkit_dom_html_meta_element_set_content;

    extern fn webkit_dom_html_meta_element_set_http_equiv(p_self: *DOMHTMLMetaElement, p_value: [*:0]const u8) void;
    pub const setHttpEquiv = webkit_dom_html_meta_element_set_http_equiv;

    extern fn webkit_dom_html_meta_element_set_name(p_self: *DOMHTMLMetaElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_meta_element_set_name;

    extern fn webkit_dom_html_meta_element_set_scheme(p_self: *DOMHTMLMetaElement, p_value: [*:0]const u8) void;
    pub const setScheme = webkit_dom_html_meta_element_set_scheme;

    extern fn webkit_dom_html_meta_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_meta_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLMetaElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLMetaElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLMetaElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLModElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLModElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const cite = struct {
            pub const name = "cite";

            pub const Type = ?[*:0]u8;
        };

        pub const date_time = struct {
            pub const name = "date-time";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_mod_element_get_cite(p_self: *DOMHTMLModElement) [*:0]u8;
    pub const getCite = webkit_dom_html_mod_element_get_cite;

    extern fn webkit_dom_html_mod_element_get_date_time(p_self: *DOMHTMLModElement) [*:0]u8;
    pub const getDateTime = webkit_dom_html_mod_element_get_date_time;

    extern fn webkit_dom_html_mod_element_set_cite(p_self: *DOMHTMLModElement, p_value: [*:0]const u8) void;
    pub const setCite = webkit_dom_html_mod_element_set_cite;

    extern fn webkit_dom_html_mod_element_set_date_time(p_self: *DOMHTMLModElement, p_value: [*:0]const u8) void;
    pub const setDateTime = webkit_dom_html_mod_element_set_date_time;

    extern fn webkit_dom_html_mod_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_mod_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLModElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLModElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLModElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOListElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLOListElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const compact = struct {
            pub const name = "compact";

            pub const Type = c_int;
        };

        pub const start = struct {
            pub const name = "start";

            pub const Type = c_long;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_o_list_element_get_compact(p_self: *DOMHTMLOListElement) c_int;
    pub const getCompact = webkit_dom_html_o_list_element_get_compact;

    extern fn webkit_dom_html_o_list_element_get_start(p_self: *DOMHTMLOListElement) c_long;
    pub const getStart = webkit_dom_html_o_list_element_get_start;

    extern fn webkit_dom_html_o_list_element_get_type_attr(p_self: *DOMHTMLOListElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_o_list_element_get_type_attr;

    extern fn webkit_dom_html_o_list_element_set_compact(p_self: *DOMHTMLOListElement, p_value: c_int) void;
    pub const setCompact = webkit_dom_html_o_list_element_set_compact;

    extern fn webkit_dom_html_o_list_element_set_start(p_self: *DOMHTMLOListElement, p_value: c_long) void;
    pub const setStart = webkit_dom_html_o_list_element_set_start;

    extern fn webkit_dom_html_o_list_element_set_type_attr(p_self: *DOMHTMLOListElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_o_list_element_set_type_attr;

    extern fn webkit_dom_html_o_list_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_o_list_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLOListElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLOListElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLOListElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLObjectElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLObjectElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const archive = struct {
            pub const name = "archive";

            pub const Type = ?[*:0]u8;
        };

        pub const border = struct {
            pub const name = "border";

            pub const Type = ?[*:0]u8;
        };

        pub const code = struct {
            pub const name = "code";

            pub const Type = ?[*:0]u8;
        };

        pub const code_base = struct {
            pub const name = "code-base";

            pub const Type = ?[*:0]u8;
        };

        pub const code_type = struct {
            pub const name = "code-type";

            pub const Type = ?[*:0]u8;
        };

        pub const content_document = struct {
            pub const name = "content-document";

            pub const Type = ?*webkit2webextension.DOMDocument;
        };

        pub const data = struct {
            pub const name = "data";

            pub const Type = ?[*:0]u8;
        };

        pub const declare = struct {
            pub const name = "declare";

            pub const Type = c_int;
        };

        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = ?[*:0]u8;
        };

        pub const hspace = struct {
            pub const name = "hspace";

            pub const Type = c_long;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const standby = struct {
            pub const name = "standby";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const use_map = struct {
            pub const name = "use-map";

            pub const Type = ?[*:0]u8;
        };

        pub const vspace = struct {
            pub const name = "vspace";

            pub const Type = c_long;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_object_element_get_align(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_object_element_get_align;

    extern fn webkit_dom_html_object_element_get_archive(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getArchive = webkit_dom_html_object_element_get_archive;

    extern fn webkit_dom_html_object_element_get_border(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getBorder = webkit_dom_html_object_element_get_border;

    extern fn webkit_dom_html_object_element_get_code(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getCode = webkit_dom_html_object_element_get_code;

    extern fn webkit_dom_html_object_element_get_code_base(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getCodeBase = webkit_dom_html_object_element_get_code_base;

    extern fn webkit_dom_html_object_element_get_code_type(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getCodeType = webkit_dom_html_object_element_get_code_type;

    extern fn webkit_dom_html_object_element_get_content_document(p_self: *DOMHTMLObjectElement) *webkit2webextension.DOMDocument;
    pub const getContentDocument = webkit_dom_html_object_element_get_content_document;

    extern fn webkit_dom_html_object_element_get_data(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getData = webkit_dom_html_object_element_get_data;

    extern fn webkit_dom_html_object_element_get_declare(p_self: *DOMHTMLObjectElement) c_int;
    pub const getDeclare = webkit_dom_html_object_element_get_declare;

    extern fn webkit_dom_html_object_element_get_form(p_self: *DOMHTMLObjectElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_object_element_get_form;

    extern fn webkit_dom_html_object_element_get_height(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getHeight = webkit_dom_html_object_element_get_height;

    extern fn webkit_dom_html_object_element_get_hspace(p_self: *DOMHTMLObjectElement) c_long;
    pub const getHspace = webkit_dom_html_object_element_get_hspace;

    extern fn webkit_dom_html_object_element_get_name(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getName = webkit_dom_html_object_element_get_name;

    extern fn webkit_dom_html_object_element_get_standby(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getStandby = webkit_dom_html_object_element_get_standby;

    extern fn webkit_dom_html_object_element_get_type_attr(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_object_element_get_type_attr;

    extern fn webkit_dom_html_object_element_get_use_map(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getUseMap = webkit_dom_html_object_element_get_use_map;

    extern fn webkit_dom_html_object_element_get_vspace(p_self: *DOMHTMLObjectElement) c_long;
    pub const getVspace = webkit_dom_html_object_element_get_vspace;

    extern fn webkit_dom_html_object_element_get_width(p_self: *DOMHTMLObjectElement) [*:0]u8;
    pub const getWidth = webkit_dom_html_object_element_get_width;

    extern fn webkit_dom_html_object_element_set_align(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_object_element_set_align;

    extern fn webkit_dom_html_object_element_set_archive(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setArchive = webkit_dom_html_object_element_set_archive;

    extern fn webkit_dom_html_object_element_set_border(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setBorder = webkit_dom_html_object_element_set_border;

    extern fn webkit_dom_html_object_element_set_code(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setCode = webkit_dom_html_object_element_set_code;

    extern fn webkit_dom_html_object_element_set_code_base(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setCodeBase = webkit_dom_html_object_element_set_code_base;

    extern fn webkit_dom_html_object_element_set_code_type(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setCodeType = webkit_dom_html_object_element_set_code_type;

    extern fn webkit_dom_html_object_element_set_data(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setData = webkit_dom_html_object_element_set_data;

    extern fn webkit_dom_html_object_element_set_declare(p_self: *DOMHTMLObjectElement, p_value: c_int) void;
    pub const setDeclare = webkit_dom_html_object_element_set_declare;

    extern fn webkit_dom_html_object_element_set_height(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setHeight = webkit_dom_html_object_element_set_height;

    extern fn webkit_dom_html_object_element_set_hspace(p_self: *DOMHTMLObjectElement, p_value: c_long) void;
    pub const setHspace = webkit_dom_html_object_element_set_hspace;

    extern fn webkit_dom_html_object_element_set_name(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_object_element_set_name;

    extern fn webkit_dom_html_object_element_set_standby(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setStandby = webkit_dom_html_object_element_set_standby;

    extern fn webkit_dom_html_object_element_set_type_attr(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_object_element_set_type_attr;

    extern fn webkit_dom_html_object_element_set_use_map(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setUseMap = webkit_dom_html_object_element_set_use_map;

    extern fn webkit_dom_html_object_element_set_vspace(p_self: *DOMHTMLObjectElement, p_value: c_long) void;
    pub const setVspace = webkit_dom_html_object_element_set_vspace;

    extern fn webkit_dom_html_object_element_set_width(p_self: *DOMHTMLObjectElement, p_value: [*:0]const u8) void;
    pub const setWidth = webkit_dom_html_object_element_set_width;

    extern fn webkit_dom_html_object_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_object_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLObjectElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLObjectElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLObjectElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOptGroupElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLOptGroupElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const label = struct {
            pub const name = "label";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_opt_group_element_get_disabled(p_self: *DOMHTMLOptGroupElement) c_int;
    pub const getDisabled = webkit_dom_html_opt_group_element_get_disabled;

    extern fn webkit_dom_html_opt_group_element_get_label(p_self: *DOMHTMLOptGroupElement) [*:0]u8;
    pub const getLabel = webkit_dom_html_opt_group_element_get_label;

    extern fn webkit_dom_html_opt_group_element_set_disabled(p_self: *DOMHTMLOptGroupElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_opt_group_element_set_disabled;

    extern fn webkit_dom_html_opt_group_element_set_label(p_self: *DOMHTMLOptGroupElement, p_value: [*:0]const u8) void;
    pub const setLabel = webkit_dom_html_opt_group_element_set_label;

    extern fn webkit_dom_html_opt_group_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_opt_group_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLOptGroupElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLOptGroupElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLOptGroupElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOptionElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLOptionElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const default_selected = struct {
            pub const name = "default-selected";

            pub const Type = c_int;
        };

        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };

        pub const index = struct {
            pub const name = "index";

            pub const Type = c_long;
        };

        pub const label = struct {
            pub const name = "label";

            pub const Type = ?[*:0]u8;
        };

        pub const selected = struct {
            pub const name = "selected";

            pub const Type = c_int;
        };

        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_option_element_get_default_selected(p_self: *DOMHTMLOptionElement) c_int;
    pub const getDefaultSelected = webkit_dom_html_option_element_get_default_selected;

    extern fn webkit_dom_html_option_element_get_disabled(p_self: *DOMHTMLOptionElement) c_int;
    pub const getDisabled = webkit_dom_html_option_element_get_disabled;

    extern fn webkit_dom_html_option_element_get_form(p_self: *DOMHTMLOptionElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_option_element_get_form;

    extern fn webkit_dom_html_option_element_get_index(p_self: *DOMHTMLOptionElement) c_long;
    pub const getIndex = webkit_dom_html_option_element_get_index;

    extern fn webkit_dom_html_option_element_get_label(p_self: *DOMHTMLOptionElement) [*:0]u8;
    pub const getLabel = webkit_dom_html_option_element_get_label;

    extern fn webkit_dom_html_option_element_get_selected(p_self: *DOMHTMLOptionElement) c_int;
    pub const getSelected = webkit_dom_html_option_element_get_selected;

    extern fn webkit_dom_html_option_element_get_text(p_self: *DOMHTMLOptionElement) [*:0]u8;
    pub const getText = webkit_dom_html_option_element_get_text;

    extern fn webkit_dom_html_option_element_get_value(p_self: *DOMHTMLOptionElement) [*:0]u8;
    pub const getValue = webkit_dom_html_option_element_get_value;

    extern fn webkit_dom_html_option_element_set_default_selected(p_self: *DOMHTMLOptionElement, p_value: c_int) void;
    pub const setDefaultSelected = webkit_dom_html_option_element_set_default_selected;

    extern fn webkit_dom_html_option_element_set_disabled(p_self: *DOMHTMLOptionElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_option_element_set_disabled;

    extern fn webkit_dom_html_option_element_set_label(p_self: *DOMHTMLOptionElement, p_value: [*:0]const u8) void;
    pub const setLabel = webkit_dom_html_option_element_set_label;

    extern fn webkit_dom_html_option_element_set_selected(p_self: *DOMHTMLOptionElement, p_value: c_int) void;
    pub const setSelected = webkit_dom_html_option_element_set_selected;

    extern fn webkit_dom_html_option_element_set_value(p_self: *DOMHTMLOptionElement, p_value: [*:0]const u8) void;
    pub const setValue = webkit_dom_html_option_element_set_value;

    extern fn webkit_dom_html_option_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_option_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLOptionElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLOptionElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLOptionElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOptionsCollection = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLCollection;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMHTMLOptionsCollectionClass;
    f_parent_instance: webkit2webextension.DOMHTMLCollection,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };

        pub const selected_index = struct {
            pub const name = "selected-index";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_options_collection_get_length(p_self: *DOMHTMLOptionsCollection) c_ulong;
    pub const getLength = webkit_dom_html_options_collection_get_length;

    extern fn webkit_dom_html_options_collection_get_selected_index(p_self: *DOMHTMLOptionsCollection) c_long;
    pub const getSelectedIndex = webkit_dom_html_options_collection_get_selected_index;

    extern fn webkit_dom_html_options_collection_named_item(p_self: *DOMHTMLOptionsCollection, p_name: [*:0]const u8) *webkit2webextension.DOMNode;
    pub const namedItem = webkit_dom_html_options_collection_named_item;

    extern fn webkit_dom_html_options_collection_set_selected_index(p_self: *DOMHTMLOptionsCollection, p_value: c_long) void;
    pub const setSelectedIndex = webkit_dom_html_options_collection_set_selected_index;

    extern fn webkit_dom_html_options_collection_get_type() usize;
    pub const getGObjectType = webkit_dom_html_options_collection_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLOptionsCollection) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLOptionsCollection) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLOptionsCollection, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLParagraphElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLParagraphElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_paragraph_element_get_align(p_self: *DOMHTMLParagraphElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_paragraph_element_get_align;

    extern fn webkit_dom_html_paragraph_element_set_align(p_self: *DOMHTMLParagraphElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_paragraph_element_set_align;

    extern fn webkit_dom_html_paragraph_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_paragraph_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLParagraphElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLParagraphElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLParagraphElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLParamElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLParamElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };

        pub const value_type = struct {
            pub const name = "value-type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_param_element_get_name(p_self: *DOMHTMLParamElement) [*:0]u8;
    pub const getName = webkit_dom_html_param_element_get_name;

    extern fn webkit_dom_html_param_element_get_type_attr(p_self: *DOMHTMLParamElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_param_element_get_type_attr;

    extern fn webkit_dom_html_param_element_get_value(p_self: *DOMHTMLParamElement) [*:0]u8;
    pub const getValue = webkit_dom_html_param_element_get_value;

    extern fn webkit_dom_html_param_element_get_value_type(p_self: *DOMHTMLParamElement) [*:0]u8;
    pub const getValueType = webkit_dom_html_param_element_get_value_type;

    extern fn webkit_dom_html_param_element_set_name(p_self: *DOMHTMLParamElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_param_element_set_name;

    extern fn webkit_dom_html_param_element_set_type_attr(p_self: *DOMHTMLParamElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_param_element_set_type_attr;

    extern fn webkit_dom_html_param_element_set_value(p_self: *DOMHTMLParamElement, p_value: [*:0]const u8) void;
    pub const setValue = webkit_dom_html_param_element_set_value;

    extern fn webkit_dom_html_param_element_set_value_type(p_self: *DOMHTMLParamElement, p_value: [*:0]const u8) void;
    pub const setValueType = webkit_dom_html_param_element_set_value_type;

    extern fn webkit_dom_html_param_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_param_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLParamElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLParamElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLParamElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLPreElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLPreElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const width = struct {
            pub const name = "width";

            pub const Type = c_long;
        };

        pub const wrap = struct {
            pub const name = "wrap";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_pre_element_get_width(p_self: *DOMHTMLPreElement) c_long;
    pub const getWidth = webkit_dom_html_pre_element_get_width;

    extern fn webkit_dom_html_pre_element_get_wrap(p_self: *DOMHTMLPreElement) c_int;
    pub const getWrap = webkit_dom_html_pre_element_get_wrap;

    extern fn webkit_dom_html_pre_element_set_width(p_self: *DOMHTMLPreElement, p_value: c_long) void;
    pub const setWidth = webkit_dom_html_pre_element_set_width;

    extern fn webkit_dom_html_pre_element_set_wrap(p_self: *DOMHTMLPreElement, p_value: c_int) void;
    pub const setWrap = webkit_dom_html_pre_element_set_wrap;

    extern fn webkit_dom_html_pre_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_pre_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLPreElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLPreElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLPreElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLQuoteElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLQuoteElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const cite = struct {
            pub const name = "cite";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_quote_element_get_cite(p_self: *DOMHTMLQuoteElement) [*:0]u8;
    pub const getCite = webkit_dom_html_quote_element_get_cite;

    extern fn webkit_dom_html_quote_element_set_cite(p_self: *DOMHTMLQuoteElement, p_value: [*:0]const u8) void;
    pub const setCite = webkit_dom_html_quote_element_set_cite;

    extern fn webkit_dom_html_quote_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_quote_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLQuoteElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLQuoteElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLQuoteElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLScriptElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLScriptElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const charset = struct {
            pub const name = "charset";

            pub const Type = ?[*:0]u8;
        };

        pub const @"defer" = struct {
            pub const name = "defer";

            pub const Type = c_int;
        };

        pub const event = struct {
            pub const name = "event";

            pub const Type = ?[*:0]u8;
        };

        pub const html_for = struct {
            pub const name = "html-for";

            pub const Type = ?[*:0]u8;
        };

        pub const src = struct {
            pub const name = "src";

            pub const Type = ?[*:0]u8;
        };

        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_script_element_get_charset(p_self: *DOMHTMLScriptElement) [*:0]u8;
    pub const getCharset = webkit_dom_html_script_element_get_charset;

    extern fn webkit_dom_html_script_element_get_defer(p_self: *DOMHTMLScriptElement) c_int;
    pub const getDefer = webkit_dom_html_script_element_get_defer;

    extern fn webkit_dom_html_script_element_get_event(p_self: *DOMHTMLScriptElement) [*:0]u8;
    pub const getEvent = webkit_dom_html_script_element_get_event;

    extern fn webkit_dom_html_script_element_get_html_for(p_self: *DOMHTMLScriptElement) [*:0]u8;
    pub const getHtmlFor = webkit_dom_html_script_element_get_html_for;

    extern fn webkit_dom_html_script_element_get_src(p_self: *DOMHTMLScriptElement) [*:0]u8;
    pub const getSrc = webkit_dom_html_script_element_get_src;

    extern fn webkit_dom_html_script_element_get_text(p_self: *DOMHTMLScriptElement) [*:0]u8;
    pub const getText = webkit_dom_html_script_element_get_text;

    extern fn webkit_dom_html_script_element_get_type_attr(p_self: *DOMHTMLScriptElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_script_element_get_type_attr;

    extern fn webkit_dom_html_script_element_set_charset(p_self: *DOMHTMLScriptElement, p_value: [*:0]const u8) void;
    pub const setCharset = webkit_dom_html_script_element_set_charset;

    extern fn webkit_dom_html_script_element_set_defer(p_self: *DOMHTMLScriptElement, p_value: c_int) void;
    pub const setDefer = webkit_dom_html_script_element_set_defer;

    extern fn webkit_dom_html_script_element_set_event(p_self: *DOMHTMLScriptElement, p_value: [*:0]const u8) void;
    pub const setEvent = webkit_dom_html_script_element_set_event;

    extern fn webkit_dom_html_script_element_set_html_for(p_self: *DOMHTMLScriptElement, p_value: [*:0]const u8) void;
    pub const setHtmlFor = webkit_dom_html_script_element_set_html_for;

    extern fn webkit_dom_html_script_element_set_src(p_self: *DOMHTMLScriptElement, p_value: [*:0]const u8) void;
    pub const setSrc = webkit_dom_html_script_element_set_src;

    extern fn webkit_dom_html_script_element_set_text(p_self: *DOMHTMLScriptElement, p_value: [*:0]const u8) void;
    pub const setText = webkit_dom_html_script_element_set_text;

    extern fn webkit_dom_html_script_element_set_type_attr(p_self: *DOMHTMLScriptElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_script_element_set_type_attr;

    extern fn webkit_dom_html_script_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_script_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLScriptElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLScriptElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLScriptElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLSelectElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLSelectElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const autofocus = struct {
            pub const name = "autofocus";

            pub const Type = c_int;
        };

        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };

        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };

        pub const multiple = struct {
            pub const name = "multiple";

            pub const Type = c_int;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const options = struct {
            pub const name = "options";

            pub const Type = ?*webkit2webextension.DOMHTMLOptionsCollection;
        };

        pub const selected_index = struct {
            pub const name = "selected-index";

            pub const Type = c_long;
        };

        pub const size = struct {
            pub const name = "size";

            pub const Type = c_long;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };

        pub const will_validate = struct {
            pub const name = "will-validate";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_select_element_add(p_self: *DOMHTMLSelectElement, p_element: *webkit2webextension.DOMHTMLElement, p_before: *webkit2webextension.DOMHTMLElement, p_error: ?*?*glib.Error) void;
    pub const add = webkit_dom_html_select_element_add;

    extern fn webkit_dom_html_select_element_get_autofocus(p_self: *DOMHTMLSelectElement) c_int;
    pub const getAutofocus = webkit_dom_html_select_element_get_autofocus;

    extern fn webkit_dom_html_select_element_get_disabled(p_self: *DOMHTMLSelectElement) c_int;
    pub const getDisabled = webkit_dom_html_select_element_get_disabled;

    extern fn webkit_dom_html_select_element_get_form(p_self: *DOMHTMLSelectElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_select_element_get_form;

    extern fn webkit_dom_html_select_element_get_length(p_self: *DOMHTMLSelectElement) c_ulong;
    pub const getLength = webkit_dom_html_select_element_get_length;

    extern fn webkit_dom_html_select_element_get_multiple(p_self: *DOMHTMLSelectElement) c_int;
    pub const getMultiple = webkit_dom_html_select_element_get_multiple;

    extern fn webkit_dom_html_select_element_get_name(p_self: *DOMHTMLSelectElement) [*:0]u8;
    pub const getName = webkit_dom_html_select_element_get_name;

    extern fn webkit_dom_html_select_element_get_options(p_self: *DOMHTMLSelectElement) *webkit2webextension.DOMHTMLOptionsCollection;
    pub const getOptions = webkit_dom_html_select_element_get_options;

    extern fn webkit_dom_html_select_element_get_select_type(p_self: *DOMHTMLSelectElement) [*:0]u8;
    pub const getSelectType = webkit_dom_html_select_element_get_select_type;

    extern fn webkit_dom_html_select_element_get_selected_index(p_self: *DOMHTMLSelectElement) c_long;
    pub const getSelectedIndex = webkit_dom_html_select_element_get_selected_index;

    extern fn webkit_dom_html_select_element_get_size(p_self: *DOMHTMLSelectElement) c_long;
    pub const getSize = webkit_dom_html_select_element_get_size;

    extern fn webkit_dom_html_select_element_get_value(p_self: *DOMHTMLSelectElement) [*:0]u8;
    pub const getValue = webkit_dom_html_select_element_get_value;

    extern fn webkit_dom_html_select_element_get_will_validate(p_self: *DOMHTMLSelectElement) c_int;
    pub const getWillValidate = webkit_dom_html_select_element_get_will_validate;

    extern fn webkit_dom_html_select_element_item(p_self: *DOMHTMLSelectElement, p_index: c_ulong) *webkit2webextension.DOMNode;
    pub const item = webkit_dom_html_select_element_item;

    extern fn webkit_dom_html_select_element_named_item(p_self: *DOMHTMLSelectElement, p_name: [*:0]const u8) *webkit2webextension.DOMNode;
    pub const namedItem = webkit_dom_html_select_element_named_item;

    extern fn webkit_dom_html_select_element_remove(p_self: *DOMHTMLSelectElement, p_index: c_long) void;
    pub const remove = webkit_dom_html_select_element_remove;

    extern fn webkit_dom_html_select_element_set_autofocus(p_self: *DOMHTMLSelectElement, p_value: c_int) void;
    pub const setAutofocus = webkit_dom_html_select_element_set_autofocus;

    extern fn webkit_dom_html_select_element_set_disabled(p_self: *DOMHTMLSelectElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_select_element_set_disabled;

    extern fn webkit_dom_html_select_element_set_length(p_self: *DOMHTMLSelectElement, p_value: c_ulong, p_error: ?*?*glib.Error) void;
    pub const setLength = webkit_dom_html_select_element_set_length;

    extern fn webkit_dom_html_select_element_set_multiple(p_self: *DOMHTMLSelectElement, p_value: c_int) void;
    pub const setMultiple = webkit_dom_html_select_element_set_multiple;

    extern fn webkit_dom_html_select_element_set_name(p_self: *DOMHTMLSelectElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_select_element_set_name;

    extern fn webkit_dom_html_select_element_set_selected_index(p_self: *DOMHTMLSelectElement, p_value: c_long) void;
    pub const setSelectedIndex = webkit_dom_html_select_element_set_selected_index;

    extern fn webkit_dom_html_select_element_set_size(p_self: *DOMHTMLSelectElement, p_value: c_long) void;
    pub const setSize = webkit_dom_html_select_element_set_size;

    extern fn webkit_dom_html_select_element_set_value(p_self: *DOMHTMLSelectElement, p_value: [*:0]const u8) void;
    pub const setValue = webkit_dom_html_select_element_set_value;

    extern fn webkit_dom_html_select_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_select_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLSelectElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLSelectElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLSelectElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLStyleElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLStyleElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const media = struct {
            pub const name = "media";

            pub const Type = ?[*:0]u8;
        };

        pub const sheet = struct {
            pub const name = "sheet";

            pub const Type = ?*webkit2webextension.DOMStyleSheet;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_style_element_get_disabled(p_self: *DOMHTMLStyleElement) c_int;
    pub const getDisabled = webkit_dom_html_style_element_get_disabled;

    extern fn webkit_dom_html_style_element_get_media(p_self: *DOMHTMLStyleElement) [*:0]u8;
    pub const getMedia = webkit_dom_html_style_element_get_media;

    extern fn webkit_dom_html_style_element_get_sheet(p_self: *DOMHTMLStyleElement) *webkit2webextension.DOMStyleSheet;
    pub const getSheet = webkit_dom_html_style_element_get_sheet;

    extern fn webkit_dom_html_style_element_get_type_attr(p_self: *DOMHTMLStyleElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_style_element_get_type_attr;

    extern fn webkit_dom_html_style_element_set_disabled(p_self: *DOMHTMLStyleElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_style_element_set_disabled;

    extern fn webkit_dom_html_style_element_set_media(p_self: *DOMHTMLStyleElement, p_value: [*:0]const u8) void;
    pub const setMedia = webkit_dom_html_style_element_set_media;

    extern fn webkit_dom_html_style_element_set_type_attr(p_self: *DOMHTMLStyleElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_style_element_set_type_attr;

    extern fn webkit_dom_html_style_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_style_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLStyleElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLStyleElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLStyleElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableCaptionElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTableCaptionElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_table_caption_element_get_align(p_self: *DOMHTMLTableCaptionElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_table_caption_element_get_align;

    extern fn webkit_dom_html_table_caption_element_set_align(p_self: *DOMHTMLTableCaptionElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_table_caption_element_set_align;

    extern fn webkit_dom_html_table_caption_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_table_caption_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTableCaptionElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTableCaptionElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTableCaptionElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableCellElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTableCellElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const abbr = struct {
            pub const name = "abbr";

            pub const Type = ?[*:0]u8;
        };

        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const axis = struct {
            pub const name = "axis";

            pub const Type = ?[*:0]u8;
        };

        pub const bg_color = struct {
            pub const name = "bg-color";

            pub const Type = ?[*:0]u8;
        };

        pub const cell_index = struct {
            pub const name = "cell-index";

            pub const Type = c_long;
        };

        pub const ch = struct {
            pub const name = "ch";

            pub const Type = ?[*:0]u8;
        };

        pub const ch_off = struct {
            pub const name = "ch-off";

            pub const Type = ?[*:0]u8;
        };

        pub const col_span = struct {
            pub const name = "col-span";

            pub const Type = c_long;
        };

        pub const headers = struct {
            pub const name = "headers";

            pub const Type = ?[*:0]u8;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = ?[*:0]u8;
        };

        pub const no_wrap = struct {
            pub const name = "no-wrap";

            pub const Type = c_int;
        };

        pub const row_span = struct {
            pub const name = "row-span";

            pub const Type = c_long;
        };

        pub const scope = struct {
            pub const name = "scope";

            pub const Type = ?[*:0]u8;
        };

        pub const v_align = struct {
            pub const name = "v-align";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_table_cell_element_get_abbr(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getAbbr = webkit_dom_html_table_cell_element_get_abbr;

    extern fn webkit_dom_html_table_cell_element_get_align(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_table_cell_element_get_align;

    extern fn webkit_dom_html_table_cell_element_get_axis(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getAxis = webkit_dom_html_table_cell_element_get_axis;

    extern fn webkit_dom_html_table_cell_element_get_bg_color(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getBgColor = webkit_dom_html_table_cell_element_get_bg_color;

    extern fn webkit_dom_html_table_cell_element_get_cell_index(p_self: *DOMHTMLTableCellElement) c_long;
    pub const getCellIndex = webkit_dom_html_table_cell_element_get_cell_index;

    extern fn webkit_dom_html_table_cell_element_get_ch(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getCh = webkit_dom_html_table_cell_element_get_ch;

    extern fn webkit_dom_html_table_cell_element_get_ch_off(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getChOff = webkit_dom_html_table_cell_element_get_ch_off;

    extern fn webkit_dom_html_table_cell_element_get_col_span(p_self: *DOMHTMLTableCellElement) c_long;
    pub const getColSpan = webkit_dom_html_table_cell_element_get_col_span;

    extern fn webkit_dom_html_table_cell_element_get_headers(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getHeaders = webkit_dom_html_table_cell_element_get_headers;

    extern fn webkit_dom_html_table_cell_element_get_height(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getHeight = webkit_dom_html_table_cell_element_get_height;

    extern fn webkit_dom_html_table_cell_element_get_no_wrap(p_self: *DOMHTMLTableCellElement) c_int;
    pub const getNoWrap = webkit_dom_html_table_cell_element_get_no_wrap;

    extern fn webkit_dom_html_table_cell_element_get_row_span(p_self: *DOMHTMLTableCellElement) c_long;
    pub const getRowSpan = webkit_dom_html_table_cell_element_get_row_span;

    extern fn webkit_dom_html_table_cell_element_get_scope(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getScope = webkit_dom_html_table_cell_element_get_scope;

    extern fn webkit_dom_html_table_cell_element_get_v_align(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getVAlign = webkit_dom_html_table_cell_element_get_v_align;

    extern fn webkit_dom_html_table_cell_element_get_width(p_self: *DOMHTMLTableCellElement) [*:0]u8;
    pub const getWidth = webkit_dom_html_table_cell_element_get_width;

    extern fn webkit_dom_html_table_cell_element_set_abbr(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setAbbr = webkit_dom_html_table_cell_element_set_abbr;

    extern fn webkit_dom_html_table_cell_element_set_align(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_table_cell_element_set_align;

    extern fn webkit_dom_html_table_cell_element_set_axis(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setAxis = webkit_dom_html_table_cell_element_set_axis;

    extern fn webkit_dom_html_table_cell_element_set_bg_color(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setBgColor = webkit_dom_html_table_cell_element_set_bg_color;

    extern fn webkit_dom_html_table_cell_element_set_ch(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setCh = webkit_dom_html_table_cell_element_set_ch;

    extern fn webkit_dom_html_table_cell_element_set_ch_off(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setChOff = webkit_dom_html_table_cell_element_set_ch_off;

    extern fn webkit_dom_html_table_cell_element_set_col_span(p_self: *DOMHTMLTableCellElement, p_value: c_long) void;
    pub const setColSpan = webkit_dom_html_table_cell_element_set_col_span;

    extern fn webkit_dom_html_table_cell_element_set_headers(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setHeaders = webkit_dom_html_table_cell_element_set_headers;

    extern fn webkit_dom_html_table_cell_element_set_height(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setHeight = webkit_dom_html_table_cell_element_set_height;

    extern fn webkit_dom_html_table_cell_element_set_no_wrap(p_self: *DOMHTMLTableCellElement, p_value: c_int) void;
    pub const setNoWrap = webkit_dom_html_table_cell_element_set_no_wrap;

    extern fn webkit_dom_html_table_cell_element_set_row_span(p_self: *DOMHTMLTableCellElement, p_value: c_long) void;
    pub const setRowSpan = webkit_dom_html_table_cell_element_set_row_span;

    extern fn webkit_dom_html_table_cell_element_set_scope(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setScope = webkit_dom_html_table_cell_element_set_scope;

    extern fn webkit_dom_html_table_cell_element_set_v_align(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setVAlign = webkit_dom_html_table_cell_element_set_v_align;

    extern fn webkit_dom_html_table_cell_element_set_width(p_self: *DOMHTMLTableCellElement, p_value: [*:0]const u8) void;
    pub const setWidth = webkit_dom_html_table_cell_element_set_width;

    extern fn webkit_dom_html_table_cell_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_table_cell_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTableCellElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTableCellElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTableCellElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableColElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTableColElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const ch = struct {
            pub const name = "ch";

            pub const Type = ?[*:0]u8;
        };

        pub const ch_off = struct {
            pub const name = "ch-off";

            pub const Type = ?[*:0]u8;
        };

        pub const span = struct {
            pub const name = "span";

            pub const Type = c_long;
        };

        pub const v_align = struct {
            pub const name = "v-align";

            pub const Type = ?[*:0]u8;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_table_col_element_get_align(p_self: *DOMHTMLTableColElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_table_col_element_get_align;

    extern fn webkit_dom_html_table_col_element_get_ch(p_self: *DOMHTMLTableColElement) [*:0]u8;
    pub const getCh = webkit_dom_html_table_col_element_get_ch;

    extern fn webkit_dom_html_table_col_element_get_ch_off(p_self: *DOMHTMLTableColElement) [*:0]u8;
    pub const getChOff = webkit_dom_html_table_col_element_get_ch_off;

    extern fn webkit_dom_html_table_col_element_get_span(p_self: *DOMHTMLTableColElement) c_long;
    pub const getSpan = webkit_dom_html_table_col_element_get_span;

    extern fn webkit_dom_html_table_col_element_get_v_align(p_self: *DOMHTMLTableColElement) [*:0]u8;
    pub const getVAlign = webkit_dom_html_table_col_element_get_v_align;

    extern fn webkit_dom_html_table_col_element_get_width(p_self: *DOMHTMLTableColElement) [*:0]u8;
    pub const getWidth = webkit_dom_html_table_col_element_get_width;

    extern fn webkit_dom_html_table_col_element_set_align(p_self: *DOMHTMLTableColElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_table_col_element_set_align;

    extern fn webkit_dom_html_table_col_element_set_ch(p_self: *DOMHTMLTableColElement, p_value: [*:0]const u8) void;
    pub const setCh = webkit_dom_html_table_col_element_set_ch;

    extern fn webkit_dom_html_table_col_element_set_ch_off(p_self: *DOMHTMLTableColElement, p_value: [*:0]const u8) void;
    pub const setChOff = webkit_dom_html_table_col_element_set_ch_off;

    extern fn webkit_dom_html_table_col_element_set_span(p_self: *DOMHTMLTableColElement, p_value: c_long) void;
    pub const setSpan = webkit_dom_html_table_col_element_set_span;

    extern fn webkit_dom_html_table_col_element_set_v_align(p_self: *DOMHTMLTableColElement, p_value: [*:0]const u8) void;
    pub const setVAlign = webkit_dom_html_table_col_element_set_v_align;

    extern fn webkit_dom_html_table_col_element_set_width(p_self: *DOMHTMLTableColElement, p_value: [*:0]const u8) void;
    pub const setWidth = webkit_dom_html_table_col_element_set_width;

    extern fn webkit_dom_html_table_col_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_table_col_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTableColElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTableColElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTableColElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTableElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const bg_color = struct {
            pub const name = "bg-color";

            pub const Type = ?[*:0]u8;
        };

        pub const border = struct {
            pub const name = "border";

            pub const Type = ?[*:0]u8;
        };

        pub const caption = struct {
            pub const name = "caption";

            pub const Type = ?*webkit2webextension.DOMHTMLTableCaptionElement;
        };

        pub const cell_padding = struct {
            pub const name = "cell-padding";

            pub const Type = ?[*:0]u8;
        };

        pub const cell_spacing = struct {
            pub const name = "cell-spacing";

            pub const Type = ?[*:0]u8;
        };

        pub const rows = struct {
            pub const name = "rows";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const rules = struct {
            pub const name = "rules";

            pub const Type = ?[*:0]u8;
        };

        pub const summary = struct {
            pub const name = "summary";

            pub const Type = ?[*:0]u8;
        };

        pub const t_bodies = struct {
            pub const name = "t-bodies";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const t_foot = struct {
            pub const name = "t-foot";

            pub const Type = ?*webkit2webextension.DOMHTMLTableSectionElement;
        };

        pub const t_head = struct {
            pub const name = "t-head";

            pub const Type = ?*webkit2webextension.DOMHTMLTableSectionElement;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_table_element_create_caption(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLElement;
    pub const createCaption = webkit_dom_html_table_element_create_caption;

    extern fn webkit_dom_html_table_element_create_t_foot(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLElement;
    pub const createTFoot = webkit_dom_html_table_element_create_t_foot;

    extern fn webkit_dom_html_table_element_create_t_head(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLElement;
    pub const createTHead = webkit_dom_html_table_element_create_t_head;

    extern fn webkit_dom_html_table_element_delete_caption(p_self: *DOMHTMLTableElement) void;
    pub const deleteCaption = webkit_dom_html_table_element_delete_caption;

    extern fn webkit_dom_html_table_element_delete_row(p_self: *DOMHTMLTableElement, p_index: c_long, p_error: ?*?*glib.Error) void;
    pub const deleteRow = webkit_dom_html_table_element_delete_row;

    extern fn webkit_dom_html_table_element_delete_t_foot(p_self: *DOMHTMLTableElement) void;
    pub const deleteTFoot = webkit_dom_html_table_element_delete_t_foot;

    extern fn webkit_dom_html_table_element_delete_t_head(p_self: *DOMHTMLTableElement) void;
    pub const deleteTHead = webkit_dom_html_table_element_delete_t_head;

    extern fn webkit_dom_html_table_element_get_align(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_table_element_get_align;

    extern fn webkit_dom_html_table_element_get_bg_color(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getBgColor = webkit_dom_html_table_element_get_bg_color;

    extern fn webkit_dom_html_table_element_get_border(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getBorder = webkit_dom_html_table_element_get_border;

    extern fn webkit_dom_html_table_element_get_caption(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLTableCaptionElement;
    pub const getCaption = webkit_dom_html_table_element_get_caption;

    extern fn webkit_dom_html_table_element_get_cell_padding(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getCellPadding = webkit_dom_html_table_element_get_cell_padding;

    extern fn webkit_dom_html_table_element_get_cell_spacing(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getCellSpacing = webkit_dom_html_table_element_get_cell_spacing;

    extern fn webkit_dom_html_table_element_get_rows(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLCollection;
    pub const getRows = webkit_dom_html_table_element_get_rows;

    extern fn webkit_dom_html_table_element_get_rules(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getRules = webkit_dom_html_table_element_get_rules;

    extern fn webkit_dom_html_table_element_get_summary(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getSummary = webkit_dom_html_table_element_get_summary;

    extern fn webkit_dom_html_table_element_get_t_bodies(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLCollection;
    pub const getTBodies = webkit_dom_html_table_element_get_t_bodies;

    extern fn webkit_dom_html_table_element_get_t_foot(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLTableSectionElement;
    pub const getTFoot = webkit_dom_html_table_element_get_t_foot;

    extern fn webkit_dom_html_table_element_get_t_head(p_self: *DOMHTMLTableElement) *webkit2webextension.DOMHTMLTableSectionElement;
    pub const getTHead = webkit_dom_html_table_element_get_t_head;

    extern fn webkit_dom_html_table_element_get_width(p_self: *DOMHTMLTableElement) [*:0]u8;
    pub const getWidth = webkit_dom_html_table_element_get_width;

    extern fn webkit_dom_html_table_element_insert_row(p_self: *DOMHTMLTableElement, p_index: c_long, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMHTMLElement;
    pub const insertRow = webkit_dom_html_table_element_insert_row;

    extern fn webkit_dom_html_table_element_set_align(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_table_element_set_align;

    extern fn webkit_dom_html_table_element_set_bg_color(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setBgColor = webkit_dom_html_table_element_set_bg_color;

    extern fn webkit_dom_html_table_element_set_border(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setBorder = webkit_dom_html_table_element_set_border;

    extern fn webkit_dom_html_table_element_set_caption(p_self: *DOMHTMLTableElement, p_value: *webkit2webextension.DOMHTMLTableCaptionElement, p_error: ?*?*glib.Error) void;
    pub const setCaption = webkit_dom_html_table_element_set_caption;

    extern fn webkit_dom_html_table_element_set_cell_padding(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setCellPadding = webkit_dom_html_table_element_set_cell_padding;

    extern fn webkit_dom_html_table_element_set_cell_spacing(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setCellSpacing = webkit_dom_html_table_element_set_cell_spacing;

    extern fn webkit_dom_html_table_element_set_rules(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setRules = webkit_dom_html_table_element_set_rules;

    extern fn webkit_dom_html_table_element_set_summary(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setSummary = webkit_dom_html_table_element_set_summary;

    extern fn webkit_dom_html_table_element_set_t_foot(p_self: *DOMHTMLTableElement, p_value: *webkit2webextension.DOMHTMLTableSectionElement, p_error: ?*?*glib.Error) void;
    pub const setTFoot = webkit_dom_html_table_element_set_t_foot;

    extern fn webkit_dom_html_table_element_set_t_head(p_self: *DOMHTMLTableElement, p_value: *webkit2webextension.DOMHTMLTableSectionElement, p_error: ?*?*glib.Error) void;
    pub const setTHead = webkit_dom_html_table_element_set_t_head;

    extern fn webkit_dom_html_table_element_set_width(p_self: *DOMHTMLTableElement, p_value: [*:0]const u8) void;
    pub const setWidth = webkit_dom_html_table_element_set_width;

    extern fn webkit_dom_html_table_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_table_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTableElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTableElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTableElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableRowElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTableRowElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const bg_color = struct {
            pub const name = "bg-color";

            pub const Type = ?[*:0]u8;
        };

        pub const cells = struct {
            pub const name = "cells";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const ch = struct {
            pub const name = "ch";

            pub const Type = ?[*:0]u8;
        };

        pub const ch_off = struct {
            pub const name = "ch-off";

            pub const Type = ?[*:0]u8;
        };

        pub const row_index = struct {
            pub const name = "row-index";

            pub const Type = c_long;
        };

        pub const section_row_index = struct {
            pub const name = "section-row-index";

            pub const Type = c_long;
        };

        pub const v_align = struct {
            pub const name = "v-align";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_table_row_element_delete_cell(p_self: *DOMHTMLTableRowElement, p_index: c_long, p_error: ?*?*glib.Error) void;
    pub const deleteCell = webkit_dom_html_table_row_element_delete_cell;

    extern fn webkit_dom_html_table_row_element_get_align(p_self: *DOMHTMLTableRowElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_table_row_element_get_align;

    extern fn webkit_dom_html_table_row_element_get_bg_color(p_self: *DOMHTMLTableRowElement) [*:0]u8;
    pub const getBgColor = webkit_dom_html_table_row_element_get_bg_color;

    extern fn webkit_dom_html_table_row_element_get_cells(p_self: *DOMHTMLTableRowElement) *webkit2webextension.DOMHTMLCollection;
    pub const getCells = webkit_dom_html_table_row_element_get_cells;

    extern fn webkit_dom_html_table_row_element_get_ch(p_self: *DOMHTMLTableRowElement) [*:0]u8;
    pub const getCh = webkit_dom_html_table_row_element_get_ch;

    extern fn webkit_dom_html_table_row_element_get_ch_off(p_self: *DOMHTMLTableRowElement) [*:0]u8;
    pub const getChOff = webkit_dom_html_table_row_element_get_ch_off;

    extern fn webkit_dom_html_table_row_element_get_row_index(p_self: *DOMHTMLTableRowElement) c_long;
    pub const getRowIndex = webkit_dom_html_table_row_element_get_row_index;

    extern fn webkit_dom_html_table_row_element_get_section_row_index(p_self: *DOMHTMLTableRowElement) c_long;
    pub const getSectionRowIndex = webkit_dom_html_table_row_element_get_section_row_index;

    extern fn webkit_dom_html_table_row_element_get_v_align(p_self: *DOMHTMLTableRowElement) [*:0]u8;
    pub const getVAlign = webkit_dom_html_table_row_element_get_v_align;

    extern fn webkit_dom_html_table_row_element_insert_cell(p_self: *DOMHTMLTableRowElement, p_index: c_long, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMHTMLElement;
    pub const insertCell = webkit_dom_html_table_row_element_insert_cell;

    extern fn webkit_dom_html_table_row_element_set_align(p_self: *DOMHTMLTableRowElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_table_row_element_set_align;

    extern fn webkit_dom_html_table_row_element_set_bg_color(p_self: *DOMHTMLTableRowElement, p_value: [*:0]const u8) void;
    pub const setBgColor = webkit_dom_html_table_row_element_set_bg_color;

    extern fn webkit_dom_html_table_row_element_set_ch(p_self: *DOMHTMLTableRowElement, p_value: [*:0]const u8) void;
    pub const setCh = webkit_dom_html_table_row_element_set_ch;

    extern fn webkit_dom_html_table_row_element_set_ch_off(p_self: *DOMHTMLTableRowElement, p_value: [*:0]const u8) void;
    pub const setChOff = webkit_dom_html_table_row_element_set_ch_off;

    extern fn webkit_dom_html_table_row_element_set_v_align(p_self: *DOMHTMLTableRowElement, p_value: [*:0]const u8) void;
    pub const setVAlign = webkit_dom_html_table_row_element_set_v_align;

    extern fn webkit_dom_html_table_row_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_table_row_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTableRowElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTableRowElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTableRowElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableSectionElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTableSectionElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const @"align" = struct {
            pub const name = "align";

            pub const Type = ?[*:0]u8;
        };

        pub const ch = struct {
            pub const name = "ch";

            pub const Type = ?[*:0]u8;
        };

        pub const ch_off = struct {
            pub const name = "ch-off";

            pub const Type = ?[*:0]u8;
        };

        pub const rows = struct {
            pub const name = "rows";

            pub const Type = ?*webkit2webextension.DOMHTMLCollection;
        };

        pub const v_align = struct {
            pub const name = "v-align";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_table_section_element_delete_row(p_self: *DOMHTMLTableSectionElement, p_index: c_long, p_error: ?*?*glib.Error) void;
    pub const deleteRow = webkit_dom_html_table_section_element_delete_row;

    extern fn webkit_dom_html_table_section_element_get_align(p_self: *DOMHTMLTableSectionElement) [*:0]u8;
    pub const getAlign = webkit_dom_html_table_section_element_get_align;

    extern fn webkit_dom_html_table_section_element_get_ch(p_self: *DOMHTMLTableSectionElement) [*:0]u8;
    pub const getCh = webkit_dom_html_table_section_element_get_ch;

    extern fn webkit_dom_html_table_section_element_get_ch_off(p_self: *DOMHTMLTableSectionElement) [*:0]u8;
    pub const getChOff = webkit_dom_html_table_section_element_get_ch_off;

    extern fn webkit_dom_html_table_section_element_get_rows(p_self: *DOMHTMLTableSectionElement) *webkit2webextension.DOMHTMLCollection;
    pub const getRows = webkit_dom_html_table_section_element_get_rows;

    extern fn webkit_dom_html_table_section_element_get_v_align(p_self: *DOMHTMLTableSectionElement) [*:0]u8;
    pub const getVAlign = webkit_dom_html_table_section_element_get_v_align;

    extern fn webkit_dom_html_table_section_element_insert_row(p_self: *DOMHTMLTableSectionElement, p_index: c_long, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMHTMLElement;
    pub const insertRow = webkit_dom_html_table_section_element_insert_row;

    extern fn webkit_dom_html_table_section_element_set_align(p_self: *DOMHTMLTableSectionElement, p_value: [*:0]const u8) void;
    pub const setAlign = webkit_dom_html_table_section_element_set_align;

    extern fn webkit_dom_html_table_section_element_set_ch(p_self: *DOMHTMLTableSectionElement, p_value: [*:0]const u8) void;
    pub const setCh = webkit_dom_html_table_section_element_set_ch;

    extern fn webkit_dom_html_table_section_element_set_ch_off(p_self: *DOMHTMLTableSectionElement, p_value: [*:0]const u8) void;
    pub const setChOff = webkit_dom_html_table_section_element_set_ch_off;

    extern fn webkit_dom_html_table_section_element_set_v_align(p_self: *DOMHTMLTableSectionElement, p_value: [*:0]const u8) void;
    pub const setVAlign = webkit_dom_html_table_section_element_set_v_align;

    extern fn webkit_dom_html_table_section_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_table_section_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTableSectionElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTableSectionElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTableSectionElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTextAreaElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTextAreaElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const autofocus = struct {
            pub const name = "autofocus";

            pub const Type = c_int;
        };

        pub const cols = struct {
            pub const name = "cols";

            pub const Type = c_long;
        };

        pub const default_value = struct {
            pub const name = "default-value";

            pub const Type = ?[*:0]u8;
        };

        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const form = struct {
            pub const name = "form";

            pub const Type = ?*webkit2webextension.DOMHTMLFormElement;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const read_only = struct {
            pub const name = "read-only";

            pub const Type = c_int;
        };

        pub const rows = struct {
            pub const name = "rows";

            pub const Type = c_long;
        };

        pub const selection_end = struct {
            pub const name = "selection-end";

            pub const Type = c_long;
        };

        pub const selection_start = struct {
            pub const name = "selection-start";

            pub const Type = c_long;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };

        pub const value = struct {
            pub const name = "value";

            pub const Type = ?[*:0]u8;
        };

        pub const will_validate = struct {
            pub const name = "will-validate";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_text_area_element_get_area_type(p_self: *DOMHTMLTextAreaElement) [*:0]u8;
    pub const getAreaType = webkit_dom_html_text_area_element_get_area_type;

    extern fn webkit_dom_html_text_area_element_get_autofocus(p_self: *DOMHTMLTextAreaElement) c_int;
    pub const getAutofocus = webkit_dom_html_text_area_element_get_autofocus;

    extern fn webkit_dom_html_text_area_element_get_cols(p_self: *DOMHTMLTextAreaElement) c_long;
    pub const getCols = webkit_dom_html_text_area_element_get_cols;

    extern fn webkit_dom_html_text_area_element_get_default_value(p_self: *DOMHTMLTextAreaElement) [*:0]u8;
    pub const getDefaultValue = webkit_dom_html_text_area_element_get_default_value;

    extern fn webkit_dom_html_text_area_element_get_disabled(p_self: *DOMHTMLTextAreaElement) c_int;
    pub const getDisabled = webkit_dom_html_text_area_element_get_disabled;

    extern fn webkit_dom_html_text_area_element_get_form(p_self: *DOMHTMLTextAreaElement) *webkit2webextension.DOMHTMLFormElement;
    pub const getForm = webkit_dom_html_text_area_element_get_form;

    extern fn webkit_dom_html_text_area_element_get_name(p_self: *DOMHTMLTextAreaElement) [*:0]u8;
    pub const getName = webkit_dom_html_text_area_element_get_name;

    extern fn webkit_dom_html_text_area_element_get_read_only(p_self: *DOMHTMLTextAreaElement) c_int;
    pub const getReadOnly = webkit_dom_html_text_area_element_get_read_only;

    extern fn webkit_dom_html_text_area_element_get_rows(p_self: *DOMHTMLTextAreaElement) c_long;
    pub const getRows = webkit_dom_html_text_area_element_get_rows;

    extern fn webkit_dom_html_text_area_element_get_selection_end(p_self: *DOMHTMLTextAreaElement) c_long;
    pub const getSelectionEnd = webkit_dom_html_text_area_element_get_selection_end;

    extern fn webkit_dom_html_text_area_element_get_selection_start(p_self: *DOMHTMLTextAreaElement) c_long;
    pub const getSelectionStart = webkit_dom_html_text_area_element_get_selection_start;

    extern fn webkit_dom_html_text_area_element_get_value(p_self: *DOMHTMLTextAreaElement) [*:0]u8;
    pub const getValue = webkit_dom_html_text_area_element_get_value;

    extern fn webkit_dom_html_text_area_element_get_will_validate(p_self: *DOMHTMLTextAreaElement) c_int;
    pub const getWillValidate = webkit_dom_html_text_area_element_get_will_validate;

    extern fn webkit_dom_html_text_area_element_is_edited(p_input: *DOMHTMLTextAreaElement) c_int;
    pub const isEdited = webkit_dom_html_text_area_element_is_edited;

    extern fn webkit_dom_html_text_area_element_select(p_self: *DOMHTMLTextAreaElement) void;
    pub const select = webkit_dom_html_text_area_element_select;

    extern fn webkit_dom_html_text_area_element_set_autofocus(p_self: *DOMHTMLTextAreaElement, p_value: c_int) void;
    pub const setAutofocus = webkit_dom_html_text_area_element_set_autofocus;

    extern fn webkit_dom_html_text_area_element_set_cols(p_self: *DOMHTMLTextAreaElement, p_value: c_long) void;
    pub const setCols = webkit_dom_html_text_area_element_set_cols;

    extern fn webkit_dom_html_text_area_element_set_default_value(p_self: *DOMHTMLTextAreaElement, p_value: [*:0]const u8) void;
    pub const setDefaultValue = webkit_dom_html_text_area_element_set_default_value;

    extern fn webkit_dom_html_text_area_element_set_disabled(p_self: *DOMHTMLTextAreaElement, p_value: c_int) void;
    pub const setDisabled = webkit_dom_html_text_area_element_set_disabled;

    extern fn webkit_dom_html_text_area_element_set_name(p_self: *DOMHTMLTextAreaElement, p_value: [*:0]const u8) void;
    pub const setName = webkit_dom_html_text_area_element_set_name;

    extern fn webkit_dom_html_text_area_element_set_read_only(p_self: *DOMHTMLTextAreaElement, p_value: c_int) void;
    pub const setReadOnly = webkit_dom_html_text_area_element_set_read_only;

    extern fn webkit_dom_html_text_area_element_set_rows(p_self: *DOMHTMLTextAreaElement, p_value: c_long) void;
    pub const setRows = webkit_dom_html_text_area_element_set_rows;

    extern fn webkit_dom_html_text_area_element_set_selection_end(p_self: *DOMHTMLTextAreaElement, p_value: c_long) void;
    pub const setSelectionEnd = webkit_dom_html_text_area_element_set_selection_end;

    extern fn webkit_dom_html_text_area_element_set_selection_range(p_self: *DOMHTMLTextAreaElement, p_start: c_long, p_end: c_long, p_direction: [*:0]const u8) void;
    pub const setSelectionRange = webkit_dom_html_text_area_element_set_selection_range;

    extern fn webkit_dom_html_text_area_element_set_selection_start(p_self: *DOMHTMLTextAreaElement, p_value: c_long) void;
    pub const setSelectionStart = webkit_dom_html_text_area_element_set_selection_start;

    extern fn webkit_dom_html_text_area_element_set_value(p_self: *DOMHTMLTextAreaElement, p_value: [*:0]const u8) void;
    pub const setValue = webkit_dom_html_text_area_element_set_value;

    extern fn webkit_dom_html_text_area_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_text_area_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTextAreaElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTextAreaElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTextAreaElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTitleElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLTitleElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_title_element_get_text(p_self: *DOMHTMLTitleElement) [*:0]u8;
    pub const getText = webkit_dom_html_title_element_get_text;

    extern fn webkit_dom_html_title_element_set_text(p_self: *DOMHTMLTitleElement, p_value: [*:0]const u8) void;
    pub const setText = webkit_dom_html_title_element_set_text;

    extern fn webkit_dom_html_title_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_title_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLTitleElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLTitleElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLTitleElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLUListElement = extern struct {
    pub const Parent = webkit2webextension.DOMHTMLElement;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMHTMLUListElementClass;
    f_parent_instance: webkit2webextension.DOMHTMLElement,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const compact = struct {
            pub const name = "compact";

            pub const Type = c_int;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_html_u_list_element_get_compact(p_self: *DOMHTMLUListElement) c_int;
    pub const getCompact = webkit_dom_html_u_list_element_get_compact;

    extern fn webkit_dom_html_u_list_element_get_type_attr(p_self: *DOMHTMLUListElement) [*:0]u8;
    pub const getTypeAttr = webkit_dom_html_u_list_element_get_type_attr;

    extern fn webkit_dom_html_u_list_element_set_compact(p_self: *DOMHTMLUListElement, p_value: c_int) void;
    pub const setCompact = webkit_dom_html_u_list_element_set_compact;

    extern fn webkit_dom_html_u_list_element_set_type_attr(p_self: *DOMHTMLUListElement, p_value: [*:0]const u8) void;
    pub const setTypeAttr = webkit_dom_html_u_list_element_set_type_attr;

    extern fn webkit_dom_html_u_list_element_get_type() usize;
    pub const getGObjectType = webkit_dom_html_u_list_element_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMHTMLUListElement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMHTMLUListElement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMHTMLUListElement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMKeyboardEvent = extern struct {
    pub const Parent = webkit2webextension.DOMUIEvent;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMKeyboardEventClass;
    f_parent_instance: webkit2webextension.DOMUIEvent,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const alt_graph_key = struct {
            pub const name = "alt-graph-key";

            pub const Type = c_int;
        };

        pub const alt_key = struct {
            pub const name = "alt-key";

            pub const Type = c_int;
        };

        pub const ctrl_key = struct {
            pub const name = "ctrl-key";

            pub const Type = c_int;
        };

        pub const key_identifier = struct {
            pub const name = "key-identifier";

            pub const Type = ?[*:0]u8;
        };

        pub const key_location = struct {
            pub const name = "key-location";

            pub const Type = c_ulong;
        };

        pub const meta_key = struct {
            pub const name = "meta-key";

            pub const Type = c_int;
        };

        pub const shift_key = struct {
            pub const name = "shift-key";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_keyboard_event_get_alt_graph_key(p_self: *DOMKeyboardEvent) c_int;
    pub const getAltGraphKey = webkit_dom_keyboard_event_get_alt_graph_key;

    extern fn webkit_dom_keyboard_event_get_alt_key(p_self: *DOMKeyboardEvent) c_int;
    pub const getAltKey = webkit_dom_keyboard_event_get_alt_key;

    extern fn webkit_dom_keyboard_event_get_ctrl_key(p_self: *DOMKeyboardEvent) c_int;
    pub const getCtrlKey = webkit_dom_keyboard_event_get_ctrl_key;

    extern fn webkit_dom_keyboard_event_get_key_identifier(p_self: *DOMKeyboardEvent) [*:0]u8;
    pub const getKeyIdentifier = webkit_dom_keyboard_event_get_key_identifier;

    extern fn webkit_dom_keyboard_event_get_key_location(p_self: *DOMKeyboardEvent) c_ulong;
    pub const getKeyLocation = webkit_dom_keyboard_event_get_key_location;

    extern fn webkit_dom_keyboard_event_get_meta_key(p_self: *DOMKeyboardEvent) c_int;
    pub const getMetaKey = webkit_dom_keyboard_event_get_meta_key;

    extern fn webkit_dom_keyboard_event_get_modifier_state(p_self: *DOMKeyboardEvent, p_keyIdentifierArg: [*:0]const u8) c_int;
    pub const getModifierState = webkit_dom_keyboard_event_get_modifier_state;

    extern fn webkit_dom_keyboard_event_get_shift_key(p_self: *DOMKeyboardEvent) c_int;
    pub const getShiftKey = webkit_dom_keyboard_event_get_shift_key;

    extern fn webkit_dom_keyboard_event_init_keyboard_event(p_self: *DOMKeyboardEvent, p_type: [*:0]const u8, p_canBubble: c_int, p_cancelable: c_int, p_view: *webkit2webextension.DOMDOMWindow, p_keyIdentifier: [*:0]const u8, p_location: c_ulong, p_ctrlKey: c_int, p_altKey: c_int, p_shiftKey: c_int, p_metaKey: c_int, p_altGraphKey: c_int) void;
    pub const initKeyboardEvent = webkit_dom_keyboard_event_init_keyboard_event;

    extern fn webkit_dom_keyboard_event_get_type() usize;
    pub const getGObjectType = webkit_dom_keyboard_event_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMKeyboardEvent) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMKeyboardEvent) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMKeyboardEvent, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMMediaList = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMMediaListClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };

        pub const media_text = struct {
            pub const name = "media-text";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_media_list_append_medium(p_self: *DOMMediaList, p_newMedium: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const appendMedium = webkit_dom_media_list_append_medium;

    extern fn webkit_dom_media_list_delete_medium(p_self: *DOMMediaList, p_oldMedium: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const deleteMedium = webkit_dom_media_list_delete_medium;

    extern fn webkit_dom_media_list_get_length(p_self: *DOMMediaList) c_ulong;
    pub const getLength = webkit_dom_media_list_get_length;

    extern fn webkit_dom_media_list_get_media_text(p_self: *DOMMediaList) [*:0]u8;
    pub const getMediaText = webkit_dom_media_list_get_media_text;

    extern fn webkit_dom_media_list_item(p_self: *DOMMediaList, p_index: c_ulong) [*:0]u8;
    pub const item = webkit_dom_media_list_item;

    extern fn webkit_dom_media_list_set_media_text(p_self: *DOMMediaList, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setMediaText = webkit_dom_media_list_set_media_text;

    extern fn webkit_dom_media_list_get_type() usize;
    pub const getGObjectType = webkit_dom_media_list_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMMediaList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMMediaList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMMediaList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMMouseEvent = extern struct {
    pub const Parent = webkit2webextension.DOMUIEvent;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMMouseEventClass;
    f_parent_instance: webkit2webextension.DOMUIEvent,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const alt_key = struct {
            pub const name = "alt-key";

            pub const Type = c_int;
        };

        pub const button = struct {
            pub const name = "button";

            pub const Type = c_uint;
        };

        pub const client_x = struct {
            pub const name = "client-x";

            pub const Type = c_long;
        };

        pub const client_y = struct {
            pub const name = "client-y";

            pub const Type = c_long;
        };

        pub const ctrl_key = struct {
            pub const name = "ctrl-key";

            pub const Type = c_int;
        };

        pub const from_element = struct {
            pub const name = "from-element";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const meta_key = struct {
            pub const name = "meta-key";

            pub const Type = c_int;
        };

        pub const offset_x = struct {
            pub const name = "offset-x";

            pub const Type = c_long;
        };

        pub const offset_y = struct {
            pub const name = "offset-y";

            pub const Type = c_long;
        };

        pub const related_target = struct {
            pub const name = "related-target";

            pub const Type = ?*webkit2webextension.DOMEventTarget;
        };

        pub const screen_x = struct {
            pub const name = "screen-x";

            pub const Type = c_long;
        };

        pub const screen_y = struct {
            pub const name = "screen-y";

            pub const Type = c_long;
        };

        pub const shift_key = struct {
            pub const name = "shift-key";

            pub const Type = c_int;
        };

        pub const to_element = struct {
            pub const name = "to-element";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const x = struct {
            pub const name = "x";

            pub const Type = c_long;
        };

        pub const y = struct {
            pub const name = "y";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_mouse_event_get_alt_key(p_self: *DOMMouseEvent) c_int;
    pub const getAltKey = webkit_dom_mouse_event_get_alt_key;

    extern fn webkit_dom_mouse_event_get_button(p_self: *DOMMouseEvent) c_ushort;
    pub const getButton = webkit_dom_mouse_event_get_button;

    extern fn webkit_dom_mouse_event_get_client_x(p_self: *DOMMouseEvent) c_long;
    pub const getClientX = webkit_dom_mouse_event_get_client_x;

    extern fn webkit_dom_mouse_event_get_client_y(p_self: *DOMMouseEvent) c_long;
    pub const getClientY = webkit_dom_mouse_event_get_client_y;

    extern fn webkit_dom_mouse_event_get_ctrl_key(p_self: *DOMMouseEvent) c_int;
    pub const getCtrlKey = webkit_dom_mouse_event_get_ctrl_key;

    extern fn webkit_dom_mouse_event_get_from_element(p_self: *DOMMouseEvent) *webkit2webextension.DOMNode;
    pub const getFromElement = webkit_dom_mouse_event_get_from_element;

    extern fn webkit_dom_mouse_event_get_meta_key(p_self: *DOMMouseEvent) c_int;
    pub const getMetaKey = webkit_dom_mouse_event_get_meta_key;

    extern fn webkit_dom_mouse_event_get_offset_x(p_self: *DOMMouseEvent) c_long;
    pub const getOffsetX = webkit_dom_mouse_event_get_offset_x;

    extern fn webkit_dom_mouse_event_get_offset_y(p_self: *DOMMouseEvent) c_long;
    pub const getOffsetY = webkit_dom_mouse_event_get_offset_y;

    extern fn webkit_dom_mouse_event_get_related_target(p_self: *DOMMouseEvent) *webkit2webextension.DOMEventTarget;
    pub const getRelatedTarget = webkit_dom_mouse_event_get_related_target;

    extern fn webkit_dom_mouse_event_get_screen_x(p_self: *DOMMouseEvent) c_long;
    pub const getScreenX = webkit_dom_mouse_event_get_screen_x;

    extern fn webkit_dom_mouse_event_get_screen_y(p_self: *DOMMouseEvent) c_long;
    pub const getScreenY = webkit_dom_mouse_event_get_screen_y;

    extern fn webkit_dom_mouse_event_get_shift_key(p_self: *DOMMouseEvent) c_int;
    pub const getShiftKey = webkit_dom_mouse_event_get_shift_key;

    extern fn webkit_dom_mouse_event_get_to_element(p_self: *DOMMouseEvent) *webkit2webextension.DOMNode;
    pub const getToElement = webkit_dom_mouse_event_get_to_element;

    extern fn webkit_dom_mouse_event_get_x(p_self: *DOMMouseEvent) c_long;
    pub const getX = webkit_dom_mouse_event_get_x;

    extern fn webkit_dom_mouse_event_get_y(p_self: *DOMMouseEvent) c_long;
    pub const getY = webkit_dom_mouse_event_get_y;

    extern fn webkit_dom_mouse_event_init_mouse_event(p_self: *DOMMouseEvent, p_type: [*:0]const u8, p_canBubble: c_int, p_cancelable: c_int, p_view: *webkit2webextension.DOMDOMWindow, p_detail: c_long, p_screenX: c_long, p_screenY: c_long, p_clientX: c_long, p_clientY: c_long, p_ctrlKey: c_int, p_altKey: c_int, p_shiftKey: c_int, p_metaKey: c_int, p_button: c_ushort, p_relatedTarget: *webkit2webextension.DOMEventTarget) void;
    pub const initMouseEvent = webkit_dom_mouse_event_init_mouse_event;

    extern fn webkit_dom_mouse_event_get_type() usize;
    pub const getGObjectType = webkit_dom_mouse_event_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMMouseEvent) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMMouseEvent) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMMouseEvent, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNamedNodeMap = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMNamedNodeMapClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_named_node_map_get_length(p_self: *DOMNamedNodeMap) c_ulong;
    pub const getLength = webkit_dom_named_node_map_get_length;

    extern fn webkit_dom_named_node_map_get_named_item(p_self: *DOMNamedNodeMap, p_name: [*:0]const u8) *webkit2webextension.DOMNode;
    pub const getNamedItem = webkit_dom_named_node_map_get_named_item;

    extern fn webkit_dom_named_node_map_get_named_item_ns(p_self: *DOMNamedNodeMap, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8) *webkit2webextension.DOMNode;
    pub const getNamedItemNs = webkit_dom_named_node_map_get_named_item_ns;

    extern fn webkit_dom_named_node_map_item(p_self: *DOMNamedNodeMap, p_index: c_ulong) *webkit2webextension.DOMNode;
    pub const item = webkit_dom_named_node_map_item;

    extern fn webkit_dom_named_node_map_remove_named_item(p_self: *DOMNamedNodeMap, p_name: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const removeNamedItem = webkit_dom_named_node_map_remove_named_item;

    extern fn webkit_dom_named_node_map_remove_named_item_ns(p_self: *DOMNamedNodeMap, p_namespaceURI: [*:0]const u8, p_localName: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const removeNamedItemNs = webkit_dom_named_node_map_remove_named_item_ns;

    extern fn webkit_dom_named_node_map_set_named_item(p_self: *DOMNamedNodeMap, p_node: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const setNamedItem = webkit_dom_named_node_map_set_named_item;

    extern fn webkit_dom_named_node_map_set_named_item_ns(p_self: *DOMNamedNodeMap, p_node: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const setNamedItemNs = webkit_dom_named_node_map_set_named_item_ns;

    extern fn webkit_dom_named_node_map_get_type() usize;
    pub const getGObjectType = webkit_dom_named_node_map_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMNamedNodeMap) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMNamedNodeMap) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMNamedNodeMap, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNode = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMNodeClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const base_uri = struct {
            pub const name = "base-uri";

            pub const Type = ?[*:0]u8;
        };

        pub const child_nodes = struct {
            pub const name = "child-nodes";

            pub const Type = ?*webkit2webextension.DOMNodeList;
        };

        pub const first_child = struct {
            pub const name = "first-child";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const last_child = struct {
            pub const name = "last-child";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const next_sibling = struct {
            pub const name = "next-sibling";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const node_name = struct {
            pub const name = "node-name";

            pub const Type = ?[*:0]u8;
        };

        pub const node_type = struct {
            pub const name = "node-type";

            pub const Type = c_uint;
        };

        pub const node_value = struct {
            pub const name = "node-value";

            pub const Type = ?[*:0]u8;
        };

        pub const owner_document = struct {
            pub const name = "owner-document";

            pub const Type = ?*webkit2webextension.DOMDocument;
        };

        pub const parent_element = struct {
            pub const name = "parent-element";

            pub const Type = ?*webkit2webextension.DOMElement;
        };

        pub const parent_node = struct {
            pub const name = "parent-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const previous_sibling = struct {
            pub const name = "previous-sibling";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const text_content = struct {
            pub const name = "text-content";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Get the `webkit2webextension.DOMNode` for the DOM node referenced by `value`.
    extern fn webkit_dom_node_for_js_value(p_value: *javascriptcore.Value) *webkit2webextension.DOMNode;
    pub const forJsValue = webkit_dom_node_for_js_value;

    extern fn webkit_dom_node_append_child(p_self: *DOMNode, p_newChild: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const appendChild = webkit_dom_node_append_child;

    extern fn webkit_dom_node_clone_node(p_self: *DOMNode, p_deep: c_int, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const cloneNode = webkit_dom_node_clone_node;

    extern fn webkit_dom_node_clone_node_with_error(p_self: *DOMNode, p_deep: c_int, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const cloneNodeWithError = webkit_dom_node_clone_node_with_error;

    extern fn webkit_dom_node_compare_document_position(p_self: *DOMNode, p_other: *webkit2webextension.DOMNode) c_ushort;
    pub const compareDocumentPosition = webkit_dom_node_compare_document_position;

    extern fn webkit_dom_node_contains(p_self: *DOMNode, p_other: *webkit2webextension.DOMNode) c_int;
    pub const contains = webkit_dom_node_contains;

    extern fn webkit_dom_node_get_base_uri(p_self: *DOMNode) [*:0]u8;
    pub const getBaseUri = webkit_dom_node_get_base_uri;

    extern fn webkit_dom_node_get_child_nodes(p_self: *DOMNode) *webkit2webextension.DOMNodeList;
    pub const getChildNodes = webkit_dom_node_get_child_nodes;

    extern fn webkit_dom_node_get_first_child(p_self: *DOMNode) *webkit2webextension.DOMNode;
    pub const getFirstChild = webkit_dom_node_get_first_child;

    extern fn webkit_dom_node_get_last_child(p_self: *DOMNode) *webkit2webextension.DOMNode;
    pub const getLastChild = webkit_dom_node_get_last_child;

    extern fn webkit_dom_node_get_local_name(p_self: *DOMNode) [*:0]u8;
    pub const getLocalName = webkit_dom_node_get_local_name;

    extern fn webkit_dom_node_get_namespace_uri(p_self: *DOMNode) [*:0]u8;
    pub const getNamespaceUri = webkit_dom_node_get_namespace_uri;

    extern fn webkit_dom_node_get_next_sibling(p_self: *DOMNode) *webkit2webextension.DOMNode;
    pub const getNextSibling = webkit_dom_node_get_next_sibling;

    extern fn webkit_dom_node_get_node_name(p_self: *DOMNode) [*:0]u8;
    pub const getNodeName = webkit_dom_node_get_node_name;

    extern fn webkit_dom_node_get_node_type(p_self: *DOMNode) c_ushort;
    pub const getNodeType = webkit_dom_node_get_node_type;

    extern fn webkit_dom_node_get_node_value(p_self: *DOMNode) [*:0]u8;
    pub const getNodeValue = webkit_dom_node_get_node_value;

    extern fn webkit_dom_node_get_owner_document(p_self: *DOMNode) *webkit2webextension.DOMDocument;
    pub const getOwnerDocument = webkit_dom_node_get_owner_document;

    extern fn webkit_dom_node_get_parent_element(p_self: *DOMNode) *webkit2webextension.DOMElement;
    pub const getParentElement = webkit_dom_node_get_parent_element;

    extern fn webkit_dom_node_get_parent_node(p_self: *DOMNode) *webkit2webextension.DOMNode;
    pub const getParentNode = webkit_dom_node_get_parent_node;

    extern fn webkit_dom_node_get_prefix(p_self: *DOMNode) [*:0]u8;
    pub const getPrefix = webkit_dom_node_get_prefix;

    extern fn webkit_dom_node_get_previous_sibling(p_self: *DOMNode) *webkit2webextension.DOMNode;
    pub const getPreviousSibling = webkit_dom_node_get_previous_sibling;

    extern fn webkit_dom_node_get_text_content(p_self: *DOMNode) [*:0]u8;
    pub const getTextContent = webkit_dom_node_get_text_content;

    extern fn webkit_dom_node_has_child_nodes(p_self: *DOMNode) c_int;
    pub const hasChildNodes = webkit_dom_node_has_child_nodes;

    extern fn webkit_dom_node_insert_before(p_self: *DOMNode, p_newChild: *webkit2webextension.DOMNode, p_refChild: ?*webkit2webextension.DOMNode, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const insertBefore = webkit_dom_node_insert_before;

    extern fn webkit_dom_node_is_default_namespace(p_self: *DOMNode, p_namespaceURI: [*:0]const u8) c_int;
    pub const isDefaultNamespace = webkit_dom_node_is_default_namespace;

    extern fn webkit_dom_node_is_equal_node(p_self: *DOMNode, p_other: *webkit2webextension.DOMNode) c_int;
    pub const isEqualNode = webkit_dom_node_is_equal_node;

    extern fn webkit_dom_node_is_same_node(p_self: *DOMNode, p_other: *webkit2webextension.DOMNode) c_int;
    pub const isSameNode = webkit_dom_node_is_same_node;

    extern fn webkit_dom_node_is_supported(p_self: *DOMNode, p_feature: [*:0]const u8, p_version: [*:0]const u8) c_int;
    pub const isSupported = webkit_dom_node_is_supported;

    extern fn webkit_dom_node_lookup_namespace_uri(p_self: *DOMNode, p_prefix: [*:0]const u8) [*:0]u8;
    pub const lookupNamespaceUri = webkit_dom_node_lookup_namespace_uri;

    extern fn webkit_dom_node_lookup_prefix(p_self: *DOMNode, p_namespaceURI: [*:0]const u8) [*:0]u8;
    pub const lookupPrefix = webkit_dom_node_lookup_prefix;

    extern fn webkit_dom_node_normalize(p_self: *DOMNode) void;
    pub const normalize = webkit_dom_node_normalize;

    extern fn webkit_dom_node_remove_child(p_self: *DOMNode, p_oldChild: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const removeChild = webkit_dom_node_remove_child;

    extern fn webkit_dom_node_replace_child(p_self: *DOMNode, p_newChild: *webkit2webextension.DOMNode, p_oldChild: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const replaceChild = webkit_dom_node_replace_child;

    extern fn webkit_dom_node_set_node_value(p_self: *DOMNode, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setNodeValue = webkit_dom_node_set_node_value;

    extern fn webkit_dom_node_set_prefix(p_self: *DOMNode, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setPrefix = webkit_dom_node_set_prefix;

    extern fn webkit_dom_node_set_text_content(p_self: *DOMNode, p_value: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const setTextContent = webkit_dom_node_set_text_content;

    extern fn webkit_dom_node_get_type() usize;
    pub const getGObjectType = webkit_dom_node_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMNode) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMNode) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMNode, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNodeIterator = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMNodeIteratorClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const filter = struct {
            pub const name = "filter";

            pub const Type = ?*webkit2webextension.DOMNodeFilter;
        };

        pub const pointer_before_reference_node = struct {
            pub const name = "pointer-before-reference-node";

            pub const Type = c_int;
        };

        pub const reference_node = struct {
            pub const name = "reference-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const root = struct {
            pub const name = "root";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const what_to_show = struct {
            pub const name = "what-to-show";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_node_iterator_detach(p_self: *DOMNodeIterator) void;
    pub const detach = webkit_dom_node_iterator_detach;

    /// This function has been removed from the DOM spec and it just returns `FALSE`.
    extern fn webkit_dom_node_iterator_get_expand_entity_references(p_self: *DOMNodeIterator) c_int;
    pub const getExpandEntityReferences = webkit_dom_node_iterator_get_expand_entity_references;

    extern fn webkit_dom_node_iterator_get_filter(p_self: *DOMNodeIterator) *webkit2webextension.DOMNodeFilter;
    pub const getFilter = webkit_dom_node_iterator_get_filter;

    extern fn webkit_dom_node_iterator_get_pointer_before_reference_node(p_self: *DOMNodeIterator) c_int;
    pub const getPointerBeforeReferenceNode = webkit_dom_node_iterator_get_pointer_before_reference_node;

    extern fn webkit_dom_node_iterator_get_reference_node(p_self: *DOMNodeIterator) *webkit2webextension.DOMNode;
    pub const getReferenceNode = webkit_dom_node_iterator_get_reference_node;

    extern fn webkit_dom_node_iterator_get_root(p_self: *DOMNodeIterator) *webkit2webextension.DOMNode;
    pub const getRoot = webkit_dom_node_iterator_get_root;

    extern fn webkit_dom_node_iterator_get_what_to_show(p_self: *DOMNodeIterator) c_ulong;
    pub const getWhatToShow = webkit_dom_node_iterator_get_what_to_show;

    extern fn webkit_dom_node_iterator_next_node(p_self: *DOMNodeIterator, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const nextNode = webkit_dom_node_iterator_next_node;

    extern fn webkit_dom_node_iterator_previous_node(p_self: *DOMNodeIterator, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const previousNode = webkit_dom_node_iterator_previous_node;

    extern fn webkit_dom_node_iterator_get_type() usize;
    pub const getGObjectType = webkit_dom_node_iterator_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMNodeIterator) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMNodeIterator) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMNodeIterator, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNodeList = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMNodeListClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_node_list_get_length(p_self: *DOMNodeList) c_ulong;
    pub const getLength = webkit_dom_node_list_get_length;

    extern fn webkit_dom_node_list_item(p_self: *DOMNodeList, p_index: c_ulong) *webkit2webextension.DOMNode;
    pub const item = webkit_dom_node_list_item;

    extern fn webkit_dom_node_list_get_type() usize;
    pub const getGObjectType = webkit_dom_node_list_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMNodeList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMNodeList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMNodeList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMObject = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMObjectClass;
    f_parentInstance: gobject.Object,
    f_coreObject: ?*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const core_object = struct {
            pub const name = "core-object";

            pub const Type = ?*anyopaque;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_object_get_type() usize;
    pub const getGObjectType = webkit_dom_object_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMObject) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMObject) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMObject, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMProcessingInstruction = extern struct {
    pub const Parent = webkit2webextension.DOMCharacterData;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMProcessingInstructionClass;
    f_parent_instance: webkit2webextension.DOMCharacterData,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const sheet = struct {
            pub const name = "sheet";

            pub const Type = ?*webkit2webextension.DOMStyleSheet;
        };

        pub const target = struct {
            pub const name = "target";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_processing_instruction_get_sheet(p_self: *DOMProcessingInstruction) *webkit2webextension.DOMStyleSheet;
    pub const getSheet = webkit_dom_processing_instruction_get_sheet;

    extern fn webkit_dom_processing_instruction_get_target(p_self: *DOMProcessingInstruction) [*:0]u8;
    pub const getTarget = webkit_dom_processing_instruction_get_target;

    extern fn webkit_dom_processing_instruction_get_type() usize;
    pub const getGObjectType = webkit_dom_processing_instruction_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMProcessingInstruction) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMProcessingInstruction) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMProcessingInstruction, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMRange = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMRangeClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const collapsed = struct {
            pub const name = "collapsed";

            pub const Type = c_int;
        };

        pub const common_ancestor_container = struct {
            pub const name = "common-ancestor-container";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const end_container = struct {
            pub const name = "end-container";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const end_offset = struct {
            pub const name = "end-offset";

            pub const Type = c_long;
        };

        pub const start_container = struct {
            pub const name = "start-container";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const start_offset = struct {
            pub const name = "start-offset";

            pub const Type = c_long;
        };

        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_range_clone_contents(p_self: *DOMRange, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMDocumentFragment;
    pub const cloneContents = webkit_dom_range_clone_contents;

    extern fn webkit_dom_range_clone_range(p_self: *DOMRange, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMRange;
    pub const cloneRange = webkit_dom_range_clone_range;

    extern fn webkit_dom_range_collapse(p_self: *DOMRange, p_toStart: c_int, p_error: ?*?*glib.Error) void;
    pub const collapse = webkit_dom_range_collapse;

    extern fn webkit_dom_range_compare_boundary_points(p_self: *DOMRange, p_how: c_ushort, p_sourceRange: *webkit2webextension.DOMRange, p_error: ?*?*glib.Error) c_short;
    pub const compareBoundaryPoints = webkit_dom_range_compare_boundary_points;

    extern fn webkit_dom_range_compare_node(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) c_short;
    pub const compareNode = webkit_dom_range_compare_node;

    extern fn webkit_dom_range_compare_point(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_offset: c_long, p_error: ?*?*glib.Error) c_short;
    pub const comparePoint = webkit_dom_range_compare_point;

    extern fn webkit_dom_range_create_contextual_fragment(p_self: *DOMRange, p_html: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMDocumentFragment;
    pub const createContextualFragment = webkit_dom_range_create_contextual_fragment;

    extern fn webkit_dom_range_delete_contents(p_self: *DOMRange, p_error: ?*?*glib.Error) void;
    pub const deleteContents = webkit_dom_range_delete_contents;

    extern fn webkit_dom_range_detach(p_self: *DOMRange, p_error: ?*?*glib.Error) void;
    pub const detach = webkit_dom_range_detach;

    extern fn webkit_dom_range_expand(p_self: *DOMRange, p_unit: [*:0]const u8, p_error: ?*?*glib.Error) void;
    pub const expand = webkit_dom_range_expand;

    extern fn webkit_dom_range_extract_contents(p_self: *DOMRange, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMDocumentFragment;
    pub const extractContents = webkit_dom_range_extract_contents;

    extern fn webkit_dom_range_get_collapsed(p_self: *DOMRange, p_error: ?*?*glib.Error) c_int;
    pub const getCollapsed = webkit_dom_range_get_collapsed;

    extern fn webkit_dom_range_get_common_ancestor_container(p_self: *DOMRange, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const getCommonAncestorContainer = webkit_dom_range_get_common_ancestor_container;

    extern fn webkit_dom_range_get_end_container(p_self: *DOMRange, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const getEndContainer = webkit_dom_range_get_end_container;

    extern fn webkit_dom_range_get_end_offset(p_self: *DOMRange, p_error: ?*?*glib.Error) c_long;
    pub const getEndOffset = webkit_dom_range_get_end_offset;

    extern fn webkit_dom_range_get_start_container(p_self: *DOMRange, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const getStartContainer = webkit_dom_range_get_start_container;

    extern fn webkit_dom_range_get_start_offset(p_self: *DOMRange, p_error: ?*?*glib.Error) c_long;
    pub const getStartOffset = webkit_dom_range_get_start_offset;

    extern fn webkit_dom_range_get_text(p_self: *DOMRange) [*:0]u8;
    pub const getText = webkit_dom_range_get_text;

    extern fn webkit_dom_range_insert_node(p_self: *DOMRange, p_newNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const insertNode = webkit_dom_range_insert_node;

    extern fn webkit_dom_range_intersects_node(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) c_int;
    pub const intersectsNode = webkit_dom_range_intersects_node;

    extern fn webkit_dom_range_is_point_in_range(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_offset: c_long, p_error: ?*?*glib.Error) c_int;
    pub const isPointInRange = webkit_dom_range_is_point_in_range;

    extern fn webkit_dom_range_select_node(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const selectNode = webkit_dom_range_select_node;

    extern fn webkit_dom_range_select_node_contents(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const selectNodeContents = webkit_dom_range_select_node_contents;

    extern fn webkit_dom_range_set_end(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_offset: c_long, p_error: ?*?*glib.Error) void;
    pub const setEnd = webkit_dom_range_set_end;

    extern fn webkit_dom_range_set_end_after(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const setEndAfter = webkit_dom_range_set_end_after;

    extern fn webkit_dom_range_set_end_before(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const setEndBefore = webkit_dom_range_set_end_before;

    extern fn webkit_dom_range_set_start(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_offset: c_long, p_error: ?*?*glib.Error) void;
    pub const setStart = webkit_dom_range_set_start;

    extern fn webkit_dom_range_set_start_after(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const setStartAfter = webkit_dom_range_set_start_after;

    extern fn webkit_dom_range_set_start_before(p_self: *DOMRange, p_refNode: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const setStartBefore = webkit_dom_range_set_start_before;

    extern fn webkit_dom_range_surround_contents(p_self: *DOMRange, p_newParent: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const surroundContents = webkit_dom_range_surround_contents;

    extern fn webkit_dom_range_to_string(p_self: *DOMRange, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const toString = webkit_dom_range_to_string;

    extern fn webkit_dom_range_get_type() usize;
    pub const getGObjectType = webkit_dom_range_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMRange) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMRange) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMRange, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMStyleSheet = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMStyleSheetClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const disabled = struct {
            pub const name = "disabled";

            pub const Type = c_int;
        };

        pub const href = struct {
            pub const name = "href";

            pub const Type = ?[*:0]u8;
        };

        pub const media = struct {
            pub const name = "media";

            pub const Type = ?*webkit2webextension.DOMMediaList;
        };

        pub const owner_node = struct {
            pub const name = "owner-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const parent_style_sheet = struct {
            pub const name = "parent-style-sheet";

            pub const Type = ?*webkit2webextension.DOMStyleSheet;
        };

        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };

        pub const @"type" = struct {
            pub const name = "type";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_style_sheet_get_content_type(p_self: *DOMStyleSheet) [*:0]u8;
    pub const getContentType = webkit_dom_style_sheet_get_content_type;

    extern fn webkit_dom_style_sheet_get_disabled(p_self: *DOMStyleSheet) c_int;
    pub const getDisabled = webkit_dom_style_sheet_get_disabled;

    extern fn webkit_dom_style_sheet_get_href(p_self: *DOMStyleSheet) [*:0]u8;
    pub const getHref = webkit_dom_style_sheet_get_href;

    extern fn webkit_dom_style_sheet_get_media(p_self: *DOMStyleSheet) *webkit2webextension.DOMMediaList;
    pub const getMedia = webkit_dom_style_sheet_get_media;

    extern fn webkit_dom_style_sheet_get_owner_node(p_self: *DOMStyleSheet) *webkit2webextension.DOMNode;
    pub const getOwnerNode = webkit_dom_style_sheet_get_owner_node;

    extern fn webkit_dom_style_sheet_get_parent_style_sheet(p_self: *DOMStyleSheet) *webkit2webextension.DOMStyleSheet;
    pub const getParentStyleSheet = webkit_dom_style_sheet_get_parent_style_sheet;

    extern fn webkit_dom_style_sheet_get_title(p_self: *DOMStyleSheet) [*:0]u8;
    pub const getTitle = webkit_dom_style_sheet_get_title;

    extern fn webkit_dom_style_sheet_set_disabled(p_self: *DOMStyleSheet, p_value: c_int) void;
    pub const setDisabled = webkit_dom_style_sheet_set_disabled;

    extern fn webkit_dom_style_sheet_get_type() usize;
    pub const getGObjectType = webkit_dom_style_sheet_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMStyleSheet) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMStyleSheet) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMStyleSheet, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMStyleSheetList = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMStyleSheetListClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_style_sheet_list_get_length(p_self: *DOMStyleSheetList) c_ulong;
    pub const getLength = webkit_dom_style_sheet_list_get_length;

    extern fn webkit_dom_style_sheet_list_item(p_self: *DOMStyleSheetList, p_index: c_ulong) *webkit2webextension.DOMStyleSheet;
    pub const item = webkit_dom_style_sheet_list_item;

    extern fn webkit_dom_style_sheet_list_get_type() usize;
    pub const getGObjectType = webkit_dom_style_sheet_list_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMStyleSheetList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMStyleSheetList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMStyleSheetList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMText = extern struct {
    pub const Parent = webkit2webextension.DOMCharacterData;
    pub const Implements = [_]type{webkit2webextension.DOMEventTarget};
    pub const Class = webkit2webextension.DOMTextClass;
    f_parent_instance: webkit2webextension.DOMCharacterData,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const whole_text = struct {
            pub const name = "whole-text";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_text_get_whole_text(p_self: *DOMText) [*:0]u8;
    pub const getWholeText = webkit_dom_text_get_whole_text;

    extern fn webkit_dom_text_replace_whole_text(p_self: *DOMText, p_content: [*:0]const u8, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMText;
    pub const replaceWholeText = webkit_dom_text_replace_whole_text;

    extern fn webkit_dom_text_split_text(p_self: *DOMText, p_offset: c_ulong, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMText;
    pub const splitText = webkit_dom_text_split_text;

    extern fn webkit_dom_text_get_type() usize;
    pub const getGObjectType = webkit_dom_text_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMText) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMText) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMText, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMTreeWalker = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMTreeWalkerClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const current_node = struct {
            pub const name = "current-node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const filter = struct {
            pub const name = "filter";

            pub const Type = ?*webkit2webextension.DOMNodeFilter;
        };

        pub const root = struct {
            pub const name = "root";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const what_to_show = struct {
            pub const name = "what-to-show";

            pub const Type = c_ulong;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_tree_walker_first_child(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const firstChild = webkit_dom_tree_walker_first_child;

    extern fn webkit_dom_tree_walker_get_current_node(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const getCurrentNode = webkit_dom_tree_walker_get_current_node;

    /// This function has been removed from the DOM spec and it just returns `FALSE`.
    extern fn webkit_dom_tree_walker_get_expand_entity_references(p_self: *DOMTreeWalker) c_int;
    pub const getExpandEntityReferences = webkit_dom_tree_walker_get_expand_entity_references;

    extern fn webkit_dom_tree_walker_get_filter(p_self: *DOMTreeWalker) *webkit2webextension.DOMNodeFilter;
    pub const getFilter = webkit_dom_tree_walker_get_filter;

    extern fn webkit_dom_tree_walker_get_root(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const getRoot = webkit_dom_tree_walker_get_root;

    extern fn webkit_dom_tree_walker_get_what_to_show(p_self: *DOMTreeWalker) c_ulong;
    pub const getWhatToShow = webkit_dom_tree_walker_get_what_to_show;

    extern fn webkit_dom_tree_walker_last_child(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const lastChild = webkit_dom_tree_walker_last_child;

    extern fn webkit_dom_tree_walker_next_node(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const nextNode = webkit_dom_tree_walker_next_node;

    extern fn webkit_dom_tree_walker_next_sibling(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const nextSibling = webkit_dom_tree_walker_next_sibling;

    extern fn webkit_dom_tree_walker_parent_node(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const parentNode = webkit_dom_tree_walker_parent_node;

    extern fn webkit_dom_tree_walker_previous_node(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const previousNode = webkit_dom_tree_walker_previous_node;

    extern fn webkit_dom_tree_walker_previous_sibling(p_self: *DOMTreeWalker) *webkit2webextension.DOMNode;
    pub const previousSibling = webkit_dom_tree_walker_previous_sibling;

    extern fn webkit_dom_tree_walker_set_current_node(p_self: *DOMTreeWalker, p_value: *webkit2webextension.DOMNode, p_error: ?*?*glib.Error) void;
    pub const setCurrentNode = webkit_dom_tree_walker_set_current_node;

    extern fn webkit_dom_tree_walker_get_type() usize;
    pub const getGObjectType = webkit_dom_tree_walker_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMTreeWalker) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMTreeWalker) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMTreeWalker, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMUIEvent = extern struct {
    pub const Parent = webkit2webextension.DOMEvent;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMUIEventClass;
    f_parent_instance: webkit2webextension.DOMEvent,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const char_code = struct {
            pub const name = "char-code";

            pub const Type = c_long;
        };

        pub const detail = struct {
            pub const name = "detail";

            pub const Type = c_long;
        };

        pub const key_code = struct {
            pub const name = "key-code";

            pub const Type = c_long;
        };

        pub const layer_x = struct {
            pub const name = "layer-x";

            pub const Type = c_long;
        };

        pub const layer_y = struct {
            pub const name = "layer-y";

            pub const Type = c_long;
        };

        pub const page_x = struct {
            pub const name = "page-x";

            pub const Type = c_long;
        };

        pub const page_y = struct {
            pub const name = "page-y";

            pub const Type = c_long;
        };

        pub const view = struct {
            pub const name = "view";

            pub const Type = ?*webkit2webextension.DOMDOMWindow;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_ui_event_get_char_code(p_self: *DOMUIEvent) c_long;
    pub const getCharCode = webkit_dom_ui_event_get_char_code;

    extern fn webkit_dom_ui_event_get_detail(p_self: *DOMUIEvent) c_long;
    pub const getDetail = webkit_dom_ui_event_get_detail;

    extern fn webkit_dom_ui_event_get_key_code(p_self: *DOMUIEvent) c_long;
    pub const getKeyCode = webkit_dom_ui_event_get_key_code;

    extern fn webkit_dom_ui_event_get_layer_x(p_self: *DOMUIEvent) c_long;
    pub const getLayerX = webkit_dom_ui_event_get_layer_x;

    extern fn webkit_dom_ui_event_get_layer_y(p_self: *DOMUIEvent) c_long;
    pub const getLayerY = webkit_dom_ui_event_get_layer_y;

    extern fn webkit_dom_ui_event_get_page_x(p_self: *DOMUIEvent) c_long;
    pub const getPageX = webkit_dom_ui_event_get_page_x;

    extern fn webkit_dom_ui_event_get_page_y(p_self: *DOMUIEvent) c_long;
    pub const getPageY = webkit_dom_ui_event_get_page_y;

    extern fn webkit_dom_ui_event_get_view(p_self: *DOMUIEvent) *webkit2webextension.DOMDOMWindow;
    pub const getView = webkit_dom_ui_event_get_view;

    extern fn webkit_dom_ui_event_init_ui_event(p_self: *DOMUIEvent, p_type: [*:0]const u8, p_canBubble: c_int, p_cancelable: c_int, p_view: *webkit2webextension.DOMDOMWindow, p_detail: c_long) void;
    pub const initUiEvent = webkit_dom_ui_event_init_ui_event;

    extern fn webkit_dom_ui_event_get_type() usize;
    pub const getGObjectType = webkit_dom_ui_event_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMUIEvent) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMUIEvent) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMUIEvent, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMWheelEvent = extern struct {
    pub const Parent = webkit2webextension.DOMMouseEvent;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMWheelEventClass;
    f_parent_instance: webkit2webextension.DOMMouseEvent,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const wheel_delta = struct {
            pub const name = "wheel-delta";

            pub const Type = c_long;
        };

        pub const wheel_delta_x = struct {
            pub const name = "wheel-delta-x";

            pub const Type = c_long;
        };

        pub const wheel_delta_y = struct {
            pub const name = "wheel-delta-y";

            pub const Type = c_long;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_wheel_event_get_wheel_delta(p_self: *DOMWheelEvent) c_long;
    pub const getWheelDelta = webkit_dom_wheel_event_get_wheel_delta;

    extern fn webkit_dom_wheel_event_get_wheel_delta_x(p_self: *DOMWheelEvent) c_long;
    pub const getWheelDeltaX = webkit_dom_wheel_event_get_wheel_delta_x;

    extern fn webkit_dom_wheel_event_get_wheel_delta_y(p_self: *DOMWheelEvent) c_long;
    pub const getWheelDeltaY = webkit_dom_wheel_event_get_wheel_delta_y;

    extern fn webkit_dom_wheel_event_init_wheel_event(p_self: *DOMWheelEvent, p_wheelDeltaX: c_long, p_wheelDeltaY: c_long, p_view: *webkit2webextension.DOMDOMWindow, p_screenX: c_long, p_screenY: c_long, p_clientX: c_long, p_clientY: c_long, p_ctrlKey: c_int, p_altKey: c_int, p_shiftKey: c_int, p_metaKey: c_int) void;
    pub const initWheelEvent = webkit_dom_wheel_event_init_wheel_event;

    extern fn webkit_dom_wheel_event_get_type() usize;
    pub const getGObjectType = webkit_dom_wheel_event_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMWheelEvent) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMWheelEvent) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMWheelEvent, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMXPathExpression = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMXPathExpressionClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_xpath_expression_evaluate(p_self: *DOMXPathExpression, p_contextNode: *webkit2webextension.DOMNode, p_type: c_ushort, p_inResult: *webkit2webextension.DOMXPathResult, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMXPathResult;
    pub const evaluate = webkit_dom_xpath_expression_evaluate;

    extern fn webkit_dom_xpath_expression_get_type() usize;
    pub const getGObjectType = webkit_dom_xpath_expression_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMXPathExpression) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMXPathExpression) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMXPathExpression, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMXPathResult = extern struct {
    pub const Parent = webkit2webextension.DOMObject;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.DOMXPathResultClass;
    f_parent_instance: webkit2webextension.DOMObject,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const boolean_value = struct {
            pub const name = "boolean-value";

            pub const Type = c_int;
        };

        pub const invalid_iterator_state = struct {
            pub const name = "invalid-iterator-state";

            pub const Type = c_int;
        };

        pub const number_value = struct {
            pub const name = "number-value";

            pub const Type = f64;
        };

        pub const result_type = struct {
            pub const name = "result-type";

            pub const Type = c_uint;
        };

        pub const single_node_value = struct {
            pub const name = "single-node-value";

            pub const Type = ?*webkit2webextension.DOMNode;
        };

        pub const snapshot_length = struct {
            pub const name = "snapshot-length";

            pub const Type = c_ulong;
        };

        pub const string_value = struct {
            pub const name = "string-value";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn webkit_dom_xpath_result_get_boolean_value(p_self: *DOMXPathResult, p_error: ?*?*glib.Error) c_int;
    pub const getBooleanValue = webkit_dom_xpath_result_get_boolean_value;

    extern fn webkit_dom_xpath_result_get_invalid_iterator_state(p_self: *DOMXPathResult) c_int;
    pub const getInvalidIteratorState = webkit_dom_xpath_result_get_invalid_iterator_state;

    extern fn webkit_dom_xpath_result_get_number_value(p_self: *DOMXPathResult, p_error: ?*?*glib.Error) f64;
    pub const getNumberValue = webkit_dom_xpath_result_get_number_value;

    extern fn webkit_dom_xpath_result_get_result_type(p_self: *DOMXPathResult) c_ushort;
    pub const getResultType = webkit_dom_xpath_result_get_result_type;

    extern fn webkit_dom_xpath_result_get_single_node_value(p_self: *DOMXPathResult, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const getSingleNodeValue = webkit_dom_xpath_result_get_single_node_value;

    extern fn webkit_dom_xpath_result_get_snapshot_length(p_self: *DOMXPathResult, p_error: ?*?*glib.Error) c_ulong;
    pub const getSnapshotLength = webkit_dom_xpath_result_get_snapshot_length;

    extern fn webkit_dom_xpath_result_get_string_value(p_self: *DOMXPathResult, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const getStringValue = webkit_dom_xpath_result_get_string_value;

    extern fn webkit_dom_xpath_result_iterate_next(p_self: *DOMXPathResult, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const iterateNext = webkit_dom_xpath_result_iterate_next;

    extern fn webkit_dom_xpath_result_snapshot_item(p_self: *DOMXPathResult, p_index: c_ulong, p_error: ?*?*glib.Error) ?*webkit2webextension.DOMNode;
    pub const snapshotItem = webkit_dom_xpath_result_snapshot_item;

    extern fn webkit_dom_xpath_result_get_type() usize;
    pub const getGObjectType = webkit_dom_xpath_result_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMXPathResult) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMXPathResult) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMXPathResult, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A web page frame.
///
/// Each `WebKitWebPage` has at least one main frame, and can have any number
/// of subframes.
pub const Frame = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.FrameClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.FramePrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Gets the process-unique identifier of this `webkit2webextension.Frame`. No other
    /// frame in the same web process will have the same ID; however, frames
    /// in other web processes may.
    extern fn webkit_frame_get_id(p_frame: *Frame) u64;
    pub const getId = webkit_frame_get_id;

    /// Gets the JavaScript execution context of `frame` for the given `webkit2webextension.ScriptWorld`.
    extern fn webkit_frame_get_javascript_context_for_script_world(p_frame: *Frame, p_world: *webkit2webextension.ScriptWorld) @compileError("not enough type information available");
    pub const getJavascriptContextForScriptWorld = webkit_frame_get_javascript_context_for_script_world;

    /// Gets the global JavaScript execution context. Use this function to bridge
    /// between the WebKit and JavaScriptCore APIs.
    extern fn webkit_frame_get_javascript_global_context(p_frame: *Frame) @compileError("not enough type information available");
    pub const getJavascriptGlobalContext = webkit_frame_get_javascript_global_context;

    /// Get the JavaScript execution context of `frame`. Use this function to bridge
    /// between the WebKit and JavaScriptCore APIs.
    extern fn webkit_frame_get_js_context(p_frame: *Frame) *javascriptcore.Context;
    pub const getJsContext = webkit_frame_get_js_context;

    /// Get the JavaScript execution context of `frame` for the given `webkit2webextension.ScriptWorld`.
    extern fn webkit_frame_get_js_context_for_script_world(p_frame: *Frame, p_world: *webkit2webextension.ScriptWorld) *javascriptcore.Context;
    pub const getJsContextForScriptWorld = webkit_frame_get_js_context_for_script_world;

    /// Get a `javascriptcore.Value` referencing the given DOM object. The value is created in the JavaScript execution
    /// context of `frame`.
    extern fn webkit_frame_get_js_value_for_dom_object(p_frame: *Frame, p_dom_object: *webkit2webextension.DOMObject) *javascriptcore.Value;
    pub const getJsValueForDomObject = webkit_frame_get_js_value_for_dom_object;

    /// Get a `javascriptcore.Value` referencing the given DOM object. The value is created in the JavaScript execution
    /// context of `frame` for the given `webkit2webextension.ScriptWorld`.
    extern fn webkit_frame_get_js_value_for_dom_object_in_script_world(p_frame: *Frame, p_dom_object: *webkit2webextension.DOMObject, p_world: *webkit2webextension.ScriptWorld) *javascriptcore.Value;
    pub const getJsValueForDomObjectInScriptWorld = webkit_frame_get_js_value_for_dom_object_in_script_world;

    /// Gets the current active URI of `frame`.
    extern fn webkit_frame_get_uri(p_frame: *Frame) [*:0]const u8;
    pub const getUri = webkit_frame_get_uri;

    /// Gets whether `frame` is the main frame of a `webkit2webextension.WebPage`
    extern fn webkit_frame_is_main_frame(p_frame: *Frame) c_int;
    pub const isMainFrame = webkit_frame_is_main_frame;

    extern fn webkit_frame_get_type() usize;
    pub const getGObjectType = webkit_frame_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.Frame) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.Frame) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Frame, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Result of a Hit Test.
///
/// A Hit Test is an operation to get context information about a given
/// point in a `WebKitWebView`. `webkit2webextension.HitTestResult` represents the
/// result of a Hit Test. It provides context information about what is
/// at the coordinates of the Hit Test, such as if there's a link,
/// an image or a media.
///
/// You can get the context of the HitTestResult with
/// `webkit2webextension.HitTestResult.getContext` that returns a bitmask of
/// `webkit2webextension.HitTestResultContext` flags. You can also use
/// `webkit2webextension.HitTestResult.contextIsLink`, `webkit2webextension.HitTestResult.contextIsImage` and
/// `webkit2webextension.HitTestResult.contextIsMedia` to determine whether there's
/// a link, image or a media element at the coordinates of the Hit Test.
/// Note that it's possible that several `webkit2webextension.HitTestResultContext` flags
/// are active at the same time, for example if there's a link containing an image.
///
/// When the mouse is moved over a `WebKitWebView` a Hit Test is performed
/// for the mouse coordinates and `WebKitWebView.signals.mouse`-target-changed
/// signal is emitted with a `webkit2webextension.HitTestResult`.
pub const HitTestResult = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.HitTestResultClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.HitTestResultPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Bitmask of `webkit2webextension.HitTestResultContext` flags representing
        /// the context of the `webkit2webextension.HitTestResult`.
        pub const context = struct {
            pub const name = "context";

            pub const Type = c_uint;
        };

        /// The URI of the image if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE`
        /// is present in `webkit2webextension.HitTestResult.properties.context`
        pub const image_uri = struct {
            pub const name = "image-uri";

            pub const Type = ?[*:0]u8;
        };

        /// The label of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkit2webextension.HitTestResult.properties.context`
        pub const link_label = struct {
            pub const name = "link-label";

            pub const Type = ?[*:0]u8;
        };

        /// The title of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkit2webextension.HitTestResult.properties.context`
        pub const link_title = struct {
            pub const name = "link-title";

            pub const Type = ?[*:0]u8;
        };

        /// The URI of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkit2webextension.HitTestResult.properties.context`
        pub const link_uri = struct {
            pub const name = "link-uri";

            pub const Type = ?[*:0]u8;
        };

        /// The URI of the media if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_MEDIA`
        /// is present in `webkit2webextension.HitTestResult.properties.context`
        pub const media_uri = struct {
            pub const name = "media-uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_EDITABLE` flag is present in
    /// `webkit2webextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_editable(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsEditable = webkit_hit_test_result_context_is_editable;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE` flag is present in
    /// `webkit2webextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_image(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsImage = webkit_hit_test_result_context_is_image;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK` flag is present in
    /// `webkit2webextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_link(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsLink = webkit_hit_test_result_context_is_link;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_MEDIA` flag is present in
    /// `webkit2webextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_media(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsMedia = webkit_hit_test_result_context_is_media;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SCROLLBAR` flag is present in
    /// `webkit2webextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_scrollbar(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsScrollbar = webkit_hit_test_result_context_is_scrollbar;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SELECTION` flag is present in
    /// `webkit2webextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_selection(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsSelection = webkit_hit_test_result_context_is_selection;

    /// Gets the value of the `webkit2webextension.HitTestResult.properties.context` property.
    extern fn webkit_hit_test_result_get_context(p_hit_test_result: *HitTestResult) c_uint;
    pub const getContext = webkit_hit_test_result_get_context;

    /// Gets the value of the `webkit2webextension.HitTestResult.properties.image`-uri property.
    extern fn webkit_hit_test_result_get_image_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getImageUri = webkit_hit_test_result_get_image_uri;

    /// Gets the value of the `webkit2webextension.HitTestResult.properties.link`-label property.
    extern fn webkit_hit_test_result_get_link_label(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkLabel = webkit_hit_test_result_get_link_label;

    /// Gets the value of the `webkit2webextension.HitTestResult.properties.link`-title property.
    extern fn webkit_hit_test_result_get_link_title(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkTitle = webkit_hit_test_result_get_link_title;

    /// Gets the value of the `webkit2webextension.HitTestResult.properties.link`-uri property.
    extern fn webkit_hit_test_result_get_link_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkUri = webkit_hit_test_result_get_link_uri;

    /// Gets the value of the `webkit2webextension.HitTestResult.properties.media`-uri property.
    extern fn webkit_hit_test_result_get_media_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getMediaUri = webkit_hit_test_result_get_media_uri;

    extern fn webkit_hit_test_result_get_type() usize;
    pub const getGObjectType = webkit_hit_test_result_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.HitTestResult) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.HitTestResult) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *HitTestResult, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ScriptWorld = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.ScriptWorldClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.ScriptWorldPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted when the JavaScript window object in a `webkit2webextension.ScriptWorld` has been
        /// cleared. This is the preferred place to set custom properties on the window
        /// object using the JavaScriptCore API. You can get the window object of `frame`
        /// from the JavaScript execution context of `world` that is returned by
        /// `webkit2webextension.Frame.getJsContextForScriptWorld`.
        pub const window_object_cleared = struct {
            pub const name = "window-object-cleared";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_page: *webkit2webextension.WebPage, p_frame: *webkit2webextension.Frame, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ScriptWorld, p_instance))),
                    gobject.signalLookup("window-object-cleared", ScriptWorld.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Get the default `webkit2webextension.ScriptWorld`. This is the normal script world
    /// where all scripts are executed by default.
    /// You can get the JavaScript execution context of a `webkit2webextension.ScriptWorld`
    /// for a given `webkit2webextension.Frame` with `webkit2webextension.Frame.getJavascriptContextForScriptWorld`.
    extern fn webkit_script_world_get_default() *webkit2webextension.ScriptWorld;
    pub const getDefault = webkit_script_world_get_default;

    /// Creates a new isolated `webkit2webextension.ScriptWorld`. Scripts executed in
    /// isolated worlds have access to the DOM but not to other variable
    /// or functions created by the page.
    /// The `webkit2webextension.ScriptWorld` is created with a generated unique name. Use
    /// `webkit2webextension.ScriptWorld.newWithName` if you want to create it with a
    /// custom name.
    /// You can get the JavaScript execution context of a `webkit2webextension.ScriptWorld`
    /// for a given `webkit2webextension.Frame` with `webkit2webextension.Frame.getJavascriptContextForScriptWorld`.
    extern fn webkit_script_world_new() *webkit2webextension.ScriptWorld;
    pub const new = webkit_script_world_new;

    /// Creates a new isolated `webkit2webextension.ScriptWorld` with a name. Scripts executed in
    /// isolated worlds have access to the DOM but not to other variable
    /// or functions created by the page.
    /// You can get the JavaScript execution context of a `webkit2webextension.ScriptWorld`
    /// for a given `webkit2webextension.Frame` with `webkit2webextension.Frame.getJavascriptContextForScriptWorld`.
    extern fn webkit_script_world_new_with_name(p_name: [*:0]const u8) *webkit2webextension.ScriptWorld;
    pub const newWithName = webkit_script_world_new_with_name;

    /// Get the name of a `webkit2webextension.ScriptWorld`.
    extern fn webkit_script_world_get_name(p_world: *ScriptWorld) [*:0]const u8;
    pub const getName = webkit_script_world_get_name;

    extern fn webkit_script_world_get_type() usize;
    pub const getGObjectType = webkit_script_world_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.ScriptWorld) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.ScriptWorld) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ScriptWorld, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents a URI request.
///
/// A `webkit2webextension.URIRequest` can be created with a URI using the
/// `webkit2webextension.URIRequest.new` method, and you can get the URI of an
/// existing request with the `webkit2webextension.URIRequest.getUri` one.
pub const URIRequest = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.URIRequestClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.URIRequestPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The URI to which the request will be made.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `webkit2webextension.URIRequest` for the given URI.
    extern fn webkit_uri_request_new(p_uri: [*:0]const u8) *webkit2webextension.URIRequest;
    pub const new = webkit_uri_request_new;

    /// Get the HTTP headers of a `webkit2webextension.URIRequest` as a `soup.MessageHeaders`.
    extern fn webkit_uri_request_get_http_headers(p_request: *URIRequest) *soup.MessageHeaders;
    pub const getHttpHeaders = webkit_uri_request_get_http_headers;

    /// Get the HTTP method of the `webkit2webextension.URIRequest`.
    extern fn webkit_uri_request_get_http_method(p_request: *URIRequest) [*:0]const u8;
    pub const getHttpMethod = webkit_uri_request_get_http_method;

    /// Obtains the request URI.
    extern fn webkit_uri_request_get_uri(p_request: *URIRequest) [*:0]const u8;
    pub const getUri = webkit_uri_request_get_uri;

    /// Set the URI of `request`
    extern fn webkit_uri_request_set_uri(p_request: *URIRequest, p_uri: [*:0]const u8) void;
    pub const setUri = webkit_uri_request_set_uri;

    extern fn webkit_uri_request_get_type() usize;
    pub const getGObjectType = webkit_uri_request_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.URIRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.URIRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URIRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents an URI response.
///
/// A `webkit2webextension.URIResponse` contains information such as the URI, the
/// status code, the content length, the mime type, the HTTP status or
/// the suggested filename.
pub const URIResponse = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.URIResponseClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.URIResponsePrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The expected content length of the response.
        pub const content_length = struct {
            pub const name = "content-length";

            pub const Type = u64;
        };

        /// The HTTP headers of the response, or `NULL` if the response is not an HTTP response.
        pub const http_headers = struct {
            pub const name = "http-headers";

            pub const Type = ?*soup.MessageHeaders;
        };

        /// The MIME type of the response.
        pub const mime_type = struct {
            pub const name = "mime-type";

            pub const Type = ?[*:0]u8;
        };

        /// The status code of the response as returned by the server.
        pub const status_code = struct {
            pub const name = "status-code";

            pub const Type = c_uint;
        };

        /// The suggested filename for the URI response.
        pub const suggested_filename = struct {
            pub const name = "suggested-filename";

            pub const Type = ?[*:0]u8;
        };

        /// The URI for which the response was made.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Get the expected content length of the `webkit2webextension.URIResponse`.
    ///
    /// It can be 0 if the server provided an incorrect or missing Content-Length.
    extern fn webkit_uri_response_get_content_length(p_response: *URIResponse) u64;
    pub const getContentLength = webkit_uri_response_get_content_length;

    /// Get the HTTP headers of a `webkit2webextension.URIResponse` as a `soup.MessageHeaders`.
    extern fn webkit_uri_response_get_http_headers(p_response: *URIResponse) *soup.MessageHeaders;
    pub const getHttpHeaders = webkit_uri_response_get_http_headers;

    /// Gets the MIME type of the response.
    extern fn webkit_uri_response_get_mime_type(p_response: *URIResponse) [*:0]const u8;
    pub const getMimeType = webkit_uri_response_get_mime_type;

    /// Get the status code of the `webkit2webextension.URIResponse`.
    ///
    /// Get the status code of the `webkit2webextension.URIResponse` as returned by
    /// the server. It will normally be a `SoupKnownStatusCode`, for
    /// example `SOUP_STATUS_OK`, though the server can respond with any
    /// unsigned integer.
    extern fn webkit_uri_response_get_status_code(p_response: *URIResponse) c_uint;
    pub const getStatusCode = webkit_uri_response_get_status_code;

    /// Get the suggested filename for `response`.
    ///
    /// Get the suggested filename for `response`, as specified by
    /// the 'Content-Disposition' HTTP header, or `NULL` if it's not
    /// present.
    extern fn webkit_uri_response_get_suggested_filename(p_response: *URIResponse) [*:0]const u8;
    pub const getSuggestedFilename = webkit_uri_response_get_suggested_filename;

    /// Gets the URI which resulted in the response.
    extern fn webkit_uri_response_get_uri(p_response: *URIResponse) [*:0]const u8;
    pub const getUri = webkit_uri_response_get_uri;

    extern fn webkit_uri_response_get_type() usize;
    pub const getGObjectType = webkit_uri_response_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.URIResponse) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.URIResponse) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URIResponse, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Message that can be sent between the UI process and web process extensions.
///
/// A WebKitUserMessage is a message that can be used for the communication between the UI process
/// and web process extensions. A WebKitUserMessage always has a name, and it can also include parameters and
/// UNIX file descriptors. Messages can be sent from a `WebKitWebContext` to all web process extensions,
/// from a web process extension to its corresponding `WebKitWebContext`, and from a `WebKitWebView` to its
/// corresponding `webkit2webextension.WebPage` (and vice versa). One to one messages can be replied to directly with
/// `webkit2webextension.UserMessage.sendReply`.
pub const UserMessage = extern struct {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.UserMessageClass;
    f_parent: gobject.InitiallyUnowned,
    f_priv: ?*webkit2webextension.UserMessagePrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The UNIX file descriptors of the user message.
        pub const fd_list = struct {
            pub const name = "fd-list";

            pub const Type = ?*gio.UnixFDList;
        };

        /// The name of the user message.
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        /// The parameters of the user message as a `glib.Variant`, or `NULL`
        /// if the message doesn't include parameters. Note that only complete types are
        /// allowed.
        pub const parameters = struct {
            pub const name = "parameters";

            pub const Type = ?*glib.Variant;
        };
    };

    pub const signals = struct {};

    /// Gets the quark for the domain of user message errors.
    extern fn webkit_user_message_error_quark() glib.Quark;
    pub const errorQuark = webkit_user_message_error_quark;

    /// Create a new `webkit2webextension.UserMessage` with `name`.
    extern fn webkit_user_message_new(p_name: [*:0]const u8, p_parameters: ?*glib.Variant) *webkit2webextension.UserMessage;
    pub const new = webkit_user_message_new;

    /// Create a new `webkit2webextension.UserMessage` including also a list of UNIX file descriptors to be sent.
    extern fn webkit_user_message_new_with_fd_list(p_name: [*:0]const u8, p_parameters: ?*glib.Variant, p_fd_list: ?*gio.UnixFDList) *webkit2webextension.UserMessage;
    pub const newWithFdList = webkit_user_message_new_with_fd_list;

    /// Get the `message` list of file descritpor.
    extern fn webkit_user_message_get_fd_list(p_message: *UserMessage) ?*gio.UnixFDList;
    pub const getFdList = webkit_user_message_get_fd_list;

    /// Get the `message` name.
    extern fn webkit_user_message_get_name(p_message: *UserMessage) [*:0]const u8;
    pub const getName = webkit_user_message_get_name;

    /// Get the `message` parameters.
    extern fn webkit_user_message_get_parameters(p_message: *UserMessage) ?*glib.Variant;
    pub const getParameters = webkit_user_message_get_parameters;

    /// Send a reply to an user message.
    ///
    /// If `reply` is floating, it's consumed.
    /// You can only send a reply to a `webkit2webextension.UserMessage` that has been
    /// received.
    extern fn webkit_user_message_send_reply(p_message: *UserMessage, p_reply: *webkit2webextension.UserMessage) void;
    pub const sendReply = webkit_user_message_send_reply;

    extern fn webkit_user_message_get_type() usize;
    pub const getGObjectType = webkit_user_message_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.UserMessage) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.UserMessage) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *UserMessage, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Access to editing capabilities of a `webkit2webextension.WebPage`.
///
/// The WebKitWebEditor provides access to various editing capabilities of
/// a `webkit2webextension.WebPage` such as a possibility to react to the current selection in
/// `webkit2webextension.WebPage`.
pub const WebEditor = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.WebEditorClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.WebEditorPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted for every selection change inside a `webkit2webextension.WebPage`
        /// as well as for every caret position change as the caret is a collapsed
        /// selection.
        pub const selection_changed = struct {
            pub const name = "selection-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebEditor, p_instance))),
                    gobject.signalLookup("selection-changed", WebEditor.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Gets the `webkit2webextension.WebPage` that is associated with the `webkit2webextension.WebEditor`.
    extern fn webkit_web_editor_get_page(p_editor: *WebEditor) *webkit2webextension.WebPage;
    pub const getPage = webkit_web_editor_get_page;

    extern fn webkit_web_editor_get_type() usize;
    pub const getGObjectType = webkit_web_editor_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.WebEditor) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.WebEditor) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebEditor, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents an extension of the WebProcess.
///
/// WebKitWebExtension is a loadable module for the WebProcess. It allows you to execute code in the
/// WebProcess and being able to use the DOM API, to change any request or to inject custom
/// JavaScript code, for example.
///
/// To create a WebKitWebExtension you should write a module with an initialization function that could
/// be either `webkit_web_extension_initialize` with prototype `webkit2webextension.WebExtensionInitializeFunction` or
/// `webkit_web_extension_initialize_with_user_data` with prototype `webkit2webextension.WebExtensionInitializeWithUserDataFunction`.
/// This function has to be public and it has to use the `G_MODULE_EXPORT` macro. It is called when the
/// web process is initialized.
///
/// ```c
/// static void
/// web_page_created_callback (WebKitWebExtension *extension,
///                            WebKitWebPage      *web_page,
///                            gpointer            user_data)
/// {
///     g_print ("Page `d` created for `s`\n",
///              webkit_web_page_get_id (web_page),
///              webkit_web_page_get_uri (web_page));
/// }
///
/// G_MODULE_EXPORT void
/// webkit_web_extension_initialize (WebKitWebExtension *extension)
/// {
///     g_signal_connect (extension, "page-created",
///                       G_CALLBACK (web_page_created_callback),
///                       NULL);
/// }
/// ```
///
/// The previous piece of code shows a trivial example of an extension that notifies when
/// a `webkit2webextension.WebPage` is created.
///
/// WebKit has to know where it can find the created WebKitWebExtension. To do so you
/// should use the `webkit_web_context_set_web_extensions_directory` function. The signal
/// `WebKitWebContext.signals.initialize`-web-extensions is the recommended place to call it.
///
/// To provide the initialization data used by the `webkit_web_extension_initialize_with_user_data`
/// function, you have to call `webkit_web_context_set_web_extensions_initialization_user_data` with
/// the desired data as parameter. You can see an example of this in the following piece of code:
///
/// ```c
/// `define` WEB_EXTENSIONS_DIRECTORY // ...
///
/// static void
/// initialize_web_extensions (WebKitWebContext *context,
///                            gpointer          user_data)
/// {
///   // Web Extensions get a different ID for each Web Process
///   static guint32 unique_id = 0;
///
///   webkit_web_context_set_web_extensions_directory (
///      context, WEB_EXTENSIONS_DIRECTORY);
///   webkit_web_context_set_web_extensions_initialization_user_data (
///      context, g_variant_new_uint32 (unique_id++));
/// }
///
/// int main (int argc, char **argv)
/// {
///   g_signal_connect (webkit_web_context_get_default (),
///                    "initialize-web-extensions",
///                     G_CALLBACK (initialize_web_extensions),
///                     NULL);
///
///   GtkWidget *view = webkit_web_view_new ();
///
///   // ...
/// }
/// ```
pub const WebExtension = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.WebExtensionClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.WebExtensionPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted when a new `webkit2webextension.WebPage` is created in
        /// the Web Process.
        pub const page_created = struct {
            pub const name = "page-created";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_web_page: *webkit2webextension.WebPage, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebExtension, p_instance))),
                    gobject.signalLookup("page-created", WebExtension.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a `webkit2webextension.UserMessage` is received from the
        /// `WebKitWebContext` corresponding to `extension`. Messages sent by `WebKitWebContext`
        /// are always broadcasted to all `webkit2webextension.WebExtension`<!-- -->s and they can't be
        /// replied to. Calling `webkit2webextension.UserMessage.sendReply` will do nothing.
        pub const user_message_received = struct {
            pub const name = "user-message-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_message: *webkit2webextension.UserMessage, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebExtension, p_instance))),
                    gobject.signalLookup("user-message-received", WebExtension.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Get the web page of the given `page_id`.
    extern fn webkit_web_extension_get_page(p_extension: *WebExtension, p_page_id: u64) *webkit2webextension.WebPage;
    pub const getPage = webkit_web_extension_get_page;

    /// Send `message` to the `WebKitWebContext` corresponding to `extension`. If `message` is floating, it's consumed.
    ///
    /// If you don't expect any reply, or you simply want to ignore it, you can pass `NULL` as `calback`.
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit2webextension.WebExtension.sendMessageToContextFinish` to get the message reply.
    extern fn webkit_web_extension_send_message_to_context(p_extension: *WebExtension, p_message: *webkit2webextension.UserMessage, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const sendMessageToContext = webkit_web_extension_send_message_to_context;

    /// Finish an asynchronous operation started with `webkit2webextension.WebExtension.sendMessageToContext`.
    extern fn webkit_web_extension_send_message_to_context_finish(p_extension: *WebExtension, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkit2webextension.UserMessage;
    pub const sendMessageToContextFinish = webkit_web_extension_send_message_to_context_finish;

    extern fn webkit_web_extension_get_type() usize;
    pub const getGObjectType = webkit_web_extension_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.WebExtension) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.WebExtension) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebExtension, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Form manager of a `webkit2webextension.WebPage` in a `webkit2webextension.ScriptWorld`
pub const WebFormManager = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.WebFormManagerClass;
    f_parent: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted after form elements (or form associated elements) are associated to `frame`.
        /// This is useful to implement form auto filling for web pages where form fields are added
        /// dynamically. This signal might be emitted multiple times for the same frame.
        ///
        /// Note that this signal could be also emitted when form controls are moved between forms. In
        /// that case, the `elements` array carries the list of those elements which have moved.
        ///
        /// Clients should take a reference to the members of the `elements` array if it is desired to
        /// keep them alive after the signal handler returns.
        pub const form_controls_associated = struct {
            pub const name = "form-controls-associated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_frame: *webkit2webextension.Frame, p_elements: [*]*javascriptcore.Value, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebFormManager, p_instance))),
                    gobject.signalLookup("form-controls-associated", WebFormManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the DOM submit event is about to be fired for `form`.
        /// JavaScript code may rely on the submit event to detect that the user has clicked
        /// on a submit button, and to possibly cancel the form submission before
        /// `webkit2webextension.WebFormManager.signals.will`-submit-form signal is emitted.
        /// However, beware that, for historical reasons, the submit event is not emitted at
        /// all if the form submission is triggered by JavaScript. For these reasons,
        /// this signal may not be used to reliably detect whether a form will be submitted.
        /// Instead, use it to detect if a user has clicked on a form's submit button even if
        /// JavaScript later cancels the form submission, or to read the values of the form's
        /// fields even if JavaScript later clears certain fields before submitting. This may
        /// be needed, for example, to implement a robust browser password manager, as some
        /// misguided websites may use such techniques to attempt to thwart password managers.
        pub const will_send_submit_event = struct {
            pub const name = "will-send-submit-event";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_form: *javascriptcore.Value, p_source_frame: *webkit2webextension.Frame, p_target_frame: *webkit2webextension.Frame, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebFormManager, p_instance))),
                    gobject.signalLookup("will-send-submit-event", WebFormManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when `form` will imminently be submitted. It can no longer
        /// be cancelled. This event always occurs immediately before a form is submitted to
        /// its target, so use this event to reliably detect when a form is submitted. This
        /// signal is emitted after `webkit2webextension.WebFormManager.signals.will`-send-submit-event if that
        /// signal is emitted.
        pub const will_submit_form = struct {
            pub const name = "will-submit-form";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_form: *javascriptcore.Value, p_source_frame: *webkit2webextension.Frame, p_target_frame: *webkit2webextension.Frame, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebFormManager, p_instance))),
                    gobject.signalLookup("will-submit-form", WebFormManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Set the value of an HTML input element as if it had been edited by
    /// the user, triggering a change event, and set it as filled automatically.
    /// If `element` is not an HTML input element this function does nothing.
    extern fn webkit_web_form_manager_input_element_auto_fill(p_element: *javascriptcore.Value, p_value: [*:0]const u8) void;
    pub const inputElementAutoFill = webkit_web_form_manager_input_element_auto_fill;

    /// Get whether `element` is an HTML input element that has been filled automatically.
    extern fn webkit_web_form_manager_input_element_is_auto_filled(p_element: *javascriptcore.Value) c_int;
    pub const inputElementIsAutoFilled = webkit_web_form_manager_input_element_is_auto_filled;

    /// Get whether `element` is an HTML text input element that has been edited by a user action.
    extern fn webkit_web_form_manager_input_element_is_user_edited(p_element: *javascriptcore.Value) c_int;
    pub const inputElementIsUserEdited = webkit_web_form_manager_input_element_is_user_edited;

    extern fn webkit_web_form_manager_get_type() usize;
    pub const getGObjectType = webkit_web_form_manager_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.WebFormManager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.WebFormManager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebFormManager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Result of a Hit Test (Web Process Extensions).
///
/// WebKitWebHitTestResult extends `webkit2webextension.HitTestResult` to provide information
/// about the `webkit2webextension.DOMNode` in the coordinates of the Hit Test.
pub const WebHitTestResult = extern struct {
    pub const Parent = webkit2webextension.HitTestResult;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.WebHitTestResultClass;
    f_parent: webkit2webextension.HitTestResult,
    f_priv: ?*webkit2webextension.WebHitTestResultPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `webkit2webextension.DOMNode`
        pub const node = struct {
            pub const name = "node";

            pub const Type = ?*webkit2webextension.DOMNode;
        };
    };

    pub const signals = struct {};

    /// Get the `javascriptcore.Value` for the DOM node in `world` at the coordinates of the Hit Test.
    extern fn webkit_web_hit_test_result_get_js_node(p_web_hit_test_result: *WebHitTestResult, p_world: ?*webkit2webextension.ScriptWorld) ?*javascriptcore.Value;
    pub const getJsNode = webkit_web_hit_test_result_get_js_node;

    /// Get the `webkit2webextension.DOMNode` in the coordinates of the Hit Test.
    extern fn webkit_web_hit_test_result_get_node(p_hit_test_result: *WebHitTestResult) *webkit2webextension.DOMNode;
    pub const getNode = webkit_web_hit_test_result_get_node;

    extern fn webkit_web_hit_test_result_get_type() usize;
    pub const getGObjectType = webkit_web_hit_test_result_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.WebHitTestResult) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.WebHitTestResult) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebHitTestResult, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A loaded web page.
pub const WebPage = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit2webextension.WebPageClass;
    f_parent: gobject.Object,
    f_priv: ?*webkit2webextension.WebPagePrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The current active URI of the `webkit2webextension.WebPage`.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// Emitted when a message is sent to the console. This can be a message
        /// produced by the use of JavaScript console API, a JavaScript exception,
        /// a security error or other errors, warnings, debug or log messages.
        /// The `console_message` contains information of the message.
        pub const console_message_sent = struct {
            pub const name = "console-message-sent";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_console_message: *webkit2webextension.ConsoleMessage, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("console-message-sent", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted before a context menu is displayed in the UI Process to
        /// give the application a chance to customize the proposed menu,
        /// build its own context menu or pass user data to the UI Process.
        /// This signal is useful when the information available in the UI Process
        /// is not enough to build or customize the context menu, for example, to
        /// add menu entries depending on the node at the coordinates of the
        /// `hit_test_result`. Otherwise, it's recommended to use `WebKitWebView.signals.context`-menu
        /// signal instead.
        pub const context_menu = struct {
            pub const name = "context-menu";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_context_menu: *webkit2webextension.ContextMenu, p_hit_test_result: *webkit2webextension.WebHitTestResult, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("context-menu", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the DOM document of a `webkit2webextension.WebPage` has been
        /// loaded.
        ///
        /// You can wait for this signal to get the DOM document
        pub const document_loaded = struct {
            pub const name = "document-loaded";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("document-loaded", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted after form elements (or form associated elements) are associated to a particular web
        /// page. This is useful to implement form auto filling for web pages where form fields are added
        /// dynamically. This signal might be emitted multiple times for the same web page.
        ///
        /// Note that this signal could be also emitted when form controls are moved between forms. In
        /// that case, the `elements` array carries the list of those elements which have moved.
        ///
        /// Clients should take a reference to the members of the `elements` array if it is desired to
        /// keep them alive after the signal handler returns.
        pub const form_controls_associated = struct {
            pub const name = "form-controls-associated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_elements: [*]*webkit2webextension.DOMElement, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("form-controls-associated", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted after form elements (or form associated elements) are associated to a particular web
        /// page. This is useful to implement form auto filling for web pages where form fields are added
        /// dynamically. This signal might be emitted multiple times for the same web page.
        ///
        /// Note that this signal could be also emitted when form controls are moved between forms. In
        /// that case, the `elements` array carries the list of those elements which have moved.
        ///
        /// Clients should take a reference to the members of the `elements` array if it is desired to
        /// keep them alive after the signal handler returns.
        pub const form_controls_associated_for_frame = struct {
            pub const name = "form-controls-associated-for-frame";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_elements: [*]*webkit2webextension.DOMElement, p_frame: *webkit2webextension.Frame, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("form-controls-associated-for-frame", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when `request` is about to be sent to
        /// the server. This signal can be used to modify the `webkit2webextension.URIRequest`
        /// that will be sent to the server. You can also cancel the resource load
        /// operation by connecting to this signal and returning `TRUE`.
        ///
        /// In case of a server redirection this signal is
        /// emitted again with the `request` argument containing the new
        /// request to be sent to the server due to the redirection and the
        /// `redirected_response` parameter containing the response
        /// received by the server for the initial request.
        ///
        /// Modifications to the `webkit2webextension.URIRequest` and its associated
        /// `soup.MessageHeaders` will be taken into account when the request
        /// is sent over the network.
        pub const send_request = struct {
            pub const name = "send-request";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkit2webextension.URIRequest, p_redirected_response: *webkit2webextension.URIResponse, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("send-request", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a `webkit2webextension.UserMessage` is received from the
        /// `WebKitWebView` corresponding to `web_page`. You can reply to the message
        /// using `webkit2webextension.UserMessage.sendReply`.
        ///
        /// You can handle the user message asynchronously by calling `gobject.Object.ref` on
        /// `message` and returning `TRUE`. If the last reference of `message` is removed
        /// and the message has been replied, the operation in the `WebKitWebView` will
        /// finish with error `WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE`.
        pub const user_message_received = struct {
            pub const name = "user-message-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_message: *webkit2webextension.UserMessage, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("user-message-received", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted to indicate various points during form
        /// submission. `step` indicates the current stage of form submission.
        ///
        /// If this signal is emitted with `WEBKIT_FORM_SUBMISSION_WILL_SEND_DOM_EVENT`,
        /// then the DOM submit event is about to be emitted. JavaScript code
        /// may rely on the submit event to detect that the user has clicked
        /// on a submit button, and to possibly cancel the form submission
        /// before `WEBKIT_FORM_SUBMISSION_WILL_COMPLETE`. However, beware
        /// that, for historical reasons, the submit event is not emitted at
        /// all if the form submission is triggered by JavaScript. For these
        /// reasons, `WEBKIT_FORM_SUBMISSION_WILL_SEND_DOM_EVENT` may not
        /// be used to reliably detect whether a form will be submitted.
        /// Instead, use it to detect if a user has clicked on a form's
        /// submit button even if JavaScript later cancels the form
        /// submission, or to read the values of the form's fields even if
        /// JavaScript later clears certain fields before submitting. This
        /// may be needed, for example, to implement a robust browser
        /// password manager, as some misguided websites may use such
        /// techniques to attempt to thwart password managers.
        ///
        /// If this signal is emitted with `WEBKIT_FORM_SUBMISSION_WILL_COMPLETE`,
        /// the form will imminently be submitted. It can no longer be
        /// cancelled. This event always occurs immediately before a form is
        /// submitted to its target, so use this event to reliably detect
        /// when a form is submitted. This event occurs after
        /// `WEBKIT_FORM_SUBMISSION_WILL_SEND_DOM_EVENT` if that event is
        /// emitted.
        pub const will_submit_form = struct {
            pub const name = "will-submit-form";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_form: *webkit2webextension.DOMElement, p_step: webkit2webextension.FormSubmissionStep, p_source_frame: *webkit2webextension.Frame, p_target_frame: *webkit2webextension.Frame, p_text_field_names: [*][*:0]u8, p_text_field_values: [*][*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("will-submit-form", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Get the `webkit2webextension.DOMDocument` currently loaded in `web_page`
    extern fn webkit_web_page_get_dom_document(p_web_page: *WebPage) *webkit2webextension.DOMDocument;
    pub const getDomDocument = webkit_web_page_get_dom_document;

    /// Gets the `webkit2webextension.WebEditor` of a `webkit2webextension.WebPage`.
    extern fn webkit_web_page_get_editor(p_web_page: *WebPage) *webkit2webextension.WebEditor;
    pub const getEditor = webkit_web_page_get_editor;

    /// Get the `webkit2webextension.WebFormManager` of `web_page` in `world`.
    extern fn webkit_web_page_get_form_manager(p_web_page: *WebPage, p_world: ?*webkit2webextension.ScriptWorld) *webkit2webextension.WebFormManager;
    pub const getFormManager = webkit_web_page_get_form_manager;

    /// Get the identifier of the `webkit2webextension.WebPage`
    extern fn webkit_web_page_get_id(p_web_page: *WebPage) u64;
    pub const getId = webkit_web_page_get_id;

    /// Returns the main frame of a `webkit2webextension.WebPage`.
    extern fn webkit_web_page_get_main_frame(p_web_page: *WebPage) *webkit2webextension.Frame;
    pub const getMainFrame = webkit_web_page_get_main_frame;

    /// Returns the current active URI of `web_page`.
    ///
    /// You can monitor the active URI by connecting to the notify::uri
    /// signal of `web_page`.
    extern fn webkit_web_page_get_uri(p_web_page: *WebPage) [*:0]const u8;
    pub const getUri = webkit_web_page_get_uri;

    /// Send `message` to the `WebKitWebView` corresponding to `web_page`. If `message` is floating, it's consumed.
    ///
    /// If you don't expect any reply, or you simply want to ignore it, you can pass `NULL` as `callback`.
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit2webextension.WebPage.sendMessageToViewFinish` to get the message reply.
    extern fn webkit_web_page_send_message_to_view(p_web_page: *WebPage, p_message: *webkit2webextension.UserMessage, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const sendMessageToView = webkit_web_page_send_message_to_view;

    /// Finish an asynchronous operation started with `webkit2webextension.WebPage.sendMessageToView`.
    extern fn webkit_web_page_send_message_to_view_finish(p_web_page: *WebPage, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkit2webextension.UserMessage;
    pub const sendMessageToViewFinish = webkit_web_page_send_message_to_view_finish;

    extern fn webkit_web_page_get_type() usize;
    pub const getGObjectType = webkit_web_page_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.WebPage) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.WebPage) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebPage, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMEventTarget = opaque {
    pub const Prerequisites = [_]type{gobject.Object};
    pub const Iface = webkit2webextension.DOMEventTargetIface;
    pub const virtual_methods = struct {
        pub const add_event_listener = struct {
            pub fn call(p_class: anytype, p_target: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event_name: [*:0]const u8, p_handler: *gobject.Closure, p_use_capture: c_int) c_int {
                return gobject.ext.as(DOMEventTarget.Iface, p_class).f_add_event_listener.?(gobject.ext.as(DOMEventTarget, p_target), p_event_name, p_handler, p_use_capture);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_target: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event_name: [*:0]const u8, p_handler: *gobject.Closure, p_use_capture: c_int) callconv(.C) c_int) void {
                gobject.ext.as(DOMEventTarget.Iface, p_class).f_add_event_listener = @ptrCast(p_implementation);
            }
        };

        pub const dispatch_event = struct {
            pub fn call(p_class: anytype, p_target: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: *webkit2webextension.DOMEvent, p_error: ?*?*glib.Error) c_int {
                return gobject.ext.as(DOMEventTarget.Iface, p_class).f_dispatch_event.?(gobject.ext.as(DOMEventTarget, p_target), p_event, p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_target: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: *webkit2webextension.DOMEvent, p_error: ?*?*glib.Error) callconv(.C) c_int) void {
                gobject.ext.as(DOMEventTarget.Iface, p_class).f_dispatch_event = @ptrCast(p_implementation);
            }
        };

        pub const remove_event_listener = struct {
            pub fn call(p_class: anytype, p_target: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event_name: [*:0]const u8, p_handler: ?*anyopaque, p_use_capture: c_int) c_int {
                return gobject.ext.as(DOMEventTarget.Iface, p_class).f_remove_event_listener.?(gobject.ext.as(DOMEventTarget, p_target), p_event_name, p_handler, p_use_capture);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_target: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event_name: [*:0]const u8, p_handler: ?*anyopaque, p_use_capture: c_int) callconv(.C) c_int) void {
                gobject.ext.as(DOMEventTarget.Iface, p_class).f_remove_event_listener = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_event_target_add_event_listener(p_target: *DOMEventTarget, p_event_name: [*:0]const u8, p_handler: gobject.Callback, p_use_capture: c_int, p_user_data: ?*anyopaque) c_int;
    pub const addEventListener = webkit_dom_event_target_add_event_listener;

    /// Version of `webkit2webextension.DOMEventTarget.addEventListener` using a closure
    /// instead of a callbacks for easier binding in other languages.
    extern fn webkit_dom_event_target_add_event_listener_with_closure(p_target: *DOMEventTarget, p_event_name: [*:0]const u8, p_handler: *gobject.Closure, p_use_capture: c_int) c_int;
    pub const addEventListenerWithClosure = webkit_dom_event_target_add_event_listener_with_closure;

    extern fn webkit_dom_event_target_dispatch_event(p_target: *DOMEventTarget, p_event: *webkit2webextension.DOMEvent, p_error: ?*?*glib.Error) c_int;
    pub const dispatchEvent = webkit_dom_event_target_dispatch_event;

    extern fn webkit_dom_event_target_remove_event_listener(p_target: *DOMEventTarget, p_event_name: [*:0]const u8, p_handler: ?*anyopaque, p_use_capture: c_int) c_int;
    pub const removeEventListener = webkit_dom_event_target_remove_event_listener;

    /// Version of `webkit2webextension.DOMEventTarget.removeEventListener` using a closure
    /// instead of a callbacks for easier binding in other languages.
    extern fn webkit_dom_event_target_remove_event_listener_with_closure(p_target: *DOMEventTarget, p_event_name: [*:0]const u8, p_handler: *gobject.Closure, p_use_capture: c_int) c_int;
    pub const removeEventListenerWithClosure = webkit_dom_event_target_remove_event_listener_with_closure;

    extern fn webkit_dom_event_target_get_type() usize;
    pub const getGObjectType = webkit_dom_event_target_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMEventTarget) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMEventTarget) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMEventTarget, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNodeFilter = opaque {
    pub const Prerequisites = [_]type{gobject.Object};
    pub const Iface = webkit2webextension.DOMNodeFilterIface;
    pub const virtual_methods = struct {
        pub const accept_node = struct {
            pub fn call(p_class: anytype, p_filter: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_node: *webkit2webextension.DOMNode) c_short {
                return gobject.ext.as(DOMNodeFilter.Iface, p_class).f_accept_node.?(gobject.ext.as(DOMNodeFilter, p_filter), p_node);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_filter: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_node: *webkit2webextension.DOMNode) callconv(.C) c_short) void {
                gobject.ext.as(DOMNodeFilter.Iface, p_class).f_accept_node = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_node_filter_accept_node(p_filter: *DOMNodeFilter, p_node: *webkit2webextension.DOMNode) c_short;
    pub const acceptNode = webkit_dom_node_filter_accept_node;

    extern fn webkit_dom_node_filter_get_type() usize;
    pub const getGObjectType = webkit_dom_node_filter_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMNodeFilter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMNodeFilter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMNodeFilter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMXPathNSResolver = opaque {
    pub const Prerequisites = [_]type{gobject.Object};
    pub const Iface = webkit2webextension.DOMXPathNSResolverIface;
    pub const virtual_methods = struct {
        pub const lookup_namespace_uri = struct {
            pub fn call(p_class: anytype, p_resolver: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_prefix: [*:0]const u8) [*:0]u8 {
                return gobject.ext.as(DOMXPathNSResolver.Iface, p_class).f_lookup_namespace_uri.?(gobject.ext.as(DOMXPathNSResolver, p_resolver), p_prefix);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_resolver: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_prefix: [*:0]const u8) callconv(.C) [*:0]u8) void {
                gobject.ext.as(DOMXPathNSResolver.Iface, p_class).f_lookup_namespace_uri = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_dom_xpath_ns_resolver_lookup_namespace_uri(p_resolver: *DOMXPathNSResolver, p_prefix: [*:0]const u8) [*:0]u8;
    pub const lookupNamespaceUri = webkit_dom_xpath_ns_resolver_lookup_namespace_uri;

    extern fn webkit_dom_xpath_ns_resolver_get_type() usize;
    pub const getGObjectType = webkit_dom_xpath_ns_resolver_get_type;

    extern fn g_object_ref(p_self: *webkit2webextension.DOMXPathNSResolver) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit2webextension.DOMXPathNSResolver) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DOMXPathNSResolver, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ConsoleMessage = opaque {
    /// Make a copy of `console_message`.
    extern fn webkit_console_message_copy(p_console_message: *ConsoleMessage) *webkit2webextension.ConsoleMessage;
    pub const copy = webkit_console_message_copy;

    /// Free the `webkit2webextension.ConsoleMessage`
    extern fn webkit_console_message_free(p_console_message: *ConsoleMessage) void;
    pub const free = webkit_console_message_free;

    /// Gets the log level of a `webkit2webextension.ConsoleMessage`
    extern fn webkit_console_message_get_level(p_console_message: *ConsoleMessage) webkit2webextension.ConsoleMessageLevel;
    pub const getLevel = webkit_console_message_get_level;

    /// Gets the line number of a `webkit2webextension.ConsoleMessage`
    extern fn webkit_console_message_get_line(p_console_message: *ConsoleMessage) c_uint;
    pub const getLine = webkit_console_message_get_line;

    /// Gets the source of a `webkit2webextension.ConsoleMessage`
    extern fn webkit_console_message_get_source(p_console_message: *ConsoleMessage) webkit2webextension.ConsoleMessageSource;
    pub const getSource = webkit_console_message_get_source;

    /// Gets the source identifier of a `webkit2webextension.ConsoleMessage`
    extern fn webkit_console_message_get_source_id(p_console_message: *ConsoleMessage) [*:0]const u8;
    pub const getSourceId = webkit_console_message_get_source_id;

    /// Gets the text message of a `webkit2webextension.ConsoleMessage`
    extern fn webkit_console_message_get_text(p_console_message: *ConsoleMessage) [*:0]const u8;
    pub const getText = webkit_console_message_get_text;

    extern fn webkit_console_message_get_type() usize;
    pub const getGObjectType = webkit_console_message_get_type;
};

pub const ContextMenuClass = extern struct {
    pub const Instance = webkit2webextension.ContextMenu;

    f_parent_class: gobject.ObjectClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ContextMenuClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContextMenuItemClass = extern struct {
    pub const Instance = webkit2webextension.ContextMenuItem;

    f_parent_class: gobject.InitiallyUnownedClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ContextMenuItemClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContextMenuItemPrivate = opaque {};

pub const ContextMenuPrivate = opaque {};

pub const DOMAttrClass = extern struct {
    pub const Instance = webkit2webextension.DOMAttr;

    f_parent_class: webkit2webextension.DOMNodeClass,

    pub fn as(p_instance: *DOMAttrClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMBlobClass = extern struct {
    pub const Instance = webkit2webextension.DOMBlob;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMBlobClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCDATASectionClass = extern struct {
    pub const Instance = webkit2webextension.DOMCDATASection;

    f_parent_class: webkit2webextension.DOMTextClass,

    pub fn as(p_instance: *DOMCDATASectionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSRuleClass = extern struct {
    pub const Instance = webkit2webextension.DOMCSSRule;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMCSSRuleClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSRuleListClass = extern struct {
    pub const Instance = webkit2webextension.DOMCSSRuleList;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMCSSRuleListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSStyleDeclarationClass = extern struct {
    pub const Instance = webkit2webextension.DOMCSSStyleDeclaration;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMCSSStyleDeclarationClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSStyleSheetClass = extern struct {
    pub const Instance = webkit2webextension.DOMCSSStyleSheet;

    f_parent_class: webkit2webextension.DOMStyleSheetClass,

    pub fn as(p_instance: *DOMCSSStyleSheetClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCSSValueClass = extern struct {
    pub const Instance = webkit2webextension.DOMCSSValue;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMCSSValueClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCharacterDataClass = extern struct {
    pub const Instance = webkit2webextension.DOMCharacterData;

    f_parent_class: webkit2webextension.DOMNodeClass,

    pub fn as(p_instance: *DOMCharacterDataClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMClientRectClass = extern struct {
    pub const Instance = webkit2webextension.DOMClientRect;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMClientRectClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMClientRectListClass = extern struct {
    pub const Instance = webkit2webextension.DOMClientRectList;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMClientRectListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMCommentClass = extern struct {
    pub const Instance = webkit2webextension.DOMComment;

    f_parent_class: webkit2webextension.DOMCharacterDataClass,

    pub fn as(p_instance: *DOMCommentClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMImplementationClass = extern struct {
    pub const Instance = webkit2webextension.DOMDOMImplementation;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMDOMImplementationClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMSelectionClass = extern struct {
    pub const Instance = webkit2webextension.DOMDOMSelection;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMDOMSelectionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMTokenListClass = extern struct {
    pub const Instance = webkit2webextension.DOMDOMTokenList;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMDOMTokenListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDOMWindowClass = extern struct {
    pub const Instance = webkit2webextension.DOMDOMWindow;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMDOMWindowClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDocumentClass = extern struct {
    pub const Instance = webkit2webextension.DOMDocument;

    f_parent_class: webkit2webextension.DOMNodeClass,

    pub fn as(p_instance: *DOMDocumentClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDocumentFragmentClass = extern struct {
    pub const Instance = webkit2webextension.DOMDocumentFragment;

    f_parent_class: webkit2webextension.DOMNodeClass,

    pub fn as(p_instance: *DOMDocumentFragmentClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMDocumentTypeClass = extern struct {
    pub const Instance = webkit2webextension.DOMDocumentType;

    f_parent_class: webkit2webextension.DOMNodeClass,

    pub fn as(p_instance: *DOMDocumentTypeClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMElement;

    f_parent_class: webkit2webextension.DOMNodeClass,

    pub fn as(p_instance: *DOMElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMEntityReferenceClass = extern struct {
    pub const Instance = webkit2webextension.DOMEntityReference;

    f_parent_class: webkit2webextension.DOMNodeClass,

    pub fn as(p_instance: *DOMEntityReferenceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMEventClass = extern struct {
    pub const Instance = webkit2webextension.DOMEvent;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMEventClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMEventTargetIface = extern struct {
    pub const Instance = webkit2webextension.DOMEventTarget;

    f_gIface: gobject.TypeInterface,
    f_dispatch_event: ?*const fn (p_target: *webkit2webextension.DOMEventTarget, p_event: *webkit2webextension.DOMEvent, p_error: ?*?*glib.Error) callconv(.C) c_int,
    f_add_event_listener: ?*const fn (p_target: *webkit2webextension.DOMEventTarget, p_event_name: [*:0]const u8, p_handler: *gobject.Closure, p_use_capture: c_int) callconv(.C) c_int,
    f_remove_event_listener: ?*const fn (p_target: *webkit2webextension.DOMEventTarget, p_event_name: [*:0]const u8, p_handler: ?*anyopaque, p_use_capture: c_int) callconv(.C) c_int,
    f__webkitdom_reserved0: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved1: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved2: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *DOMEventTargetIface, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMFileClass = extern struct {
    pub const Instance = webkit2webextension.DOMFile;

    f_parent_class: webkit2webextension.DOMBlobClass,

    pub fn as(p_instance: *DOMFileClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMFileListClass = extern struct {
    pub const Instance = webkit2webextension.DOMFileList;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMFileListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLAnchorElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLAnchorElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLAnchorElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLAppletElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLAppletElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLAppletElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLAreaElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLAreaElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLAreaElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBRElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLBRElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLBRElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBaseElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLBaseElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLBaseElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBaseFontElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLBaseFontElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLBaseFontElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLBodyElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLBodyElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLBodyElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLButtonElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLButtonElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLButtonElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLCanvasElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLCanvasElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLCanvasElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLCollectionClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLCollection;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMHTMLCollectionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDListElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLDListElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLDListElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDirectoryElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLDirectoryElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLDirectoryElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDivElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLDivElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLDivElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLDocumentClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLDocument;

    f_parent_class: webkit2webextension.DOMDocumentClass,

    pub fn as(p_instance: *DOMHTMLDocumentClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLElement;

    f_parent_class: webkit2webextension.DOMElementClass,

    pub fn as(p_instance: *DOMHTMLElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLEmbedElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLEmbedElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLEmbedElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFieldSetElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLFieldSetElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLFieldSetElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFontElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLFontElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLFontElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFormElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLFormElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLFormElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFrameElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLFrameElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLFrameElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLFrameSetElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLFrameSetElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLFrameSetElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHRElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLHRElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLHRElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHeadElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLHeadElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLHeadElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHeadingElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLHeadingElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLHeadingElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLHtmlElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLHtmlElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLHtmlElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLIFrameElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLIFrameElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLIFrameElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLImageElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLImageElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLImageElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLInputElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLInputElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLInputElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLIElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLLIElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLLIElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLabelElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLLabelElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLLabelElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLegendElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLLegendElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLLegendElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLLinkElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLLinkElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLLinkElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMapElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLMapElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLMapElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMarqueeElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLMarqueeElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLMarqueeElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMenuElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLMenuElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLMenuElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLMetaElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLMetaElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLMetaElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLModElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLModElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLModElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOListElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLOListElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLOListElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLObjectElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLObjectElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLObjectElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOptGroupElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLOptGroupElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLOptGroupElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOptionElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLOptionElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLOptionElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLOptionsCollectionClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLOptionsCollection;

    f_parent_class: webkit2webextension.DOMHTMLCollectionClass,

    pub fn as(p_instance: *DOMHTMLOptionsCollectionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLParagraphElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLParagraphElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLParagraphElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLParamElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLParamElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLParamElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLPreElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLPreElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLPreElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLQuoteElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLQuoteElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLQuoteElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLScriptElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLScriptElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLScriptElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLSelectElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLSelectElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLSelectElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLStyleElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLStyleElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLStyleElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableCaptionElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTableCaptionElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTableCaptionElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableCellElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTableCellElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTableCellElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableColElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTableColElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTableColElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTableElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTableElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableRowElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTableRowElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTableRowElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTableSectionElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTableSectionElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTableSectionElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTextAreaElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTextAreaElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTextAreaElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLTitleElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLTitleElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLTitleElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMHTMLUListElementClass = extern struct {
    pub const Instance = webkit2webextension.DOMHTMLUListElement;

    f_parent_class: webkit2webextension.DOMHTMLElementClass,

    pub fn as(p_instance: *DOMHTMLUListElementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMKeyboardEventClass = extern struct {
    pub const Instance = webkit2webextension.DOMKeyboardEvent;

    f_parent_class: webkit2webextension.DOMUIEventClass,

    pub fn as(p_instance: *DOMKeyboardEventClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMMediaListClass = extern struct {
    pub const Instance = webkit2webextension.DOMMediaList;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMMediaListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMMouseEventClass = extern struct {
    pub const Instance = webkit2webextension.DOMMouseEvent;

    f_parent_class: webkit2webextension.DOMUIEventClass,

    pub fn as(p_instance: *DOMMouseEventClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNamedNodeMapClass = extern struct {
    pub const Instance = webkit2webextension.DOMNamedNodeMap;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMNamedNodeMapClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNodeClass = extern struct {
    pub const Instance = webkit2webextension.DOMNode;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMNodeClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNodeFilterIface = extern struct {
    pub const Instance = webkit2webextension.DOMNodeFilter;

    f_gIface: gobject.TypeInterface,
    f_accept_node: ?*const fn (p_filter: *webkit2webextension.DOMNodeFilter, p_node: *webkit2webextension.DOMNode) callconv(.C) c_short,
    f__webkitdom_reserved0: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved1: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved2: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *DOMNodeFilterIface, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNodeIteratorClass = extern struct {
    pub const Instance = webkit2webextension.DOMNodeIterator;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMNodeIteratorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMNodeListClass = extern struct {
    pub const Instance = webkit2webextension.DOMNodeList;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMNodeListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMObjectClass = extern struct {
    pub const Instance = webkit2webextension.DOMObject;

    f_parentClass: gobject.ObjectClass,

    pub fn as(p_instance: *DOMObjectClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMProcessingInstructionClass = extern struct {
    pub const Instance = webkit2webextension.DOMProcessingInstruction;

    f_parent_class: webkit2webextension.DOMCharacterDataClass,

    pub fn as(p_instance: *DOMProcessingInstructionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMRangeClass = extern struct {
    pub const Instance = webkit2webextension.DOMRange;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMRangeClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMStyleSheetClass = extern struct {
    pub const Instance = webkit2webextension.DOMStyleSheet;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMStyleSheetClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMStyleSheetListClass = extern struct {
    pub const Instance = webkit2webextension.DOMStyleSheetList;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMStyleSheetListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMTextClass = extern struct {
    pub const Instance = webkit2webextension.DOMText;

    f_parent_class: webkit2webextension.DOMCharacterDataClass,

    pub fn as(p_instance: *DOMTextClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMTreeWalkerClass = extern struct {
    pub const Instance = webkit2webextension.DOMTreeWalker;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMTreeWalkerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMUIEventClass = extern struct {
    pub const Instance = webkit2webextension.DOMUIEvent;

    f_parent_class: webkit2webextension.DOMEventClass,

    pub fn as(p_instance: *DOMUIEventClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMWheelEventClass = extern struct {
    pub const Instance = webkit2webextension.DOMWheelEvent;

    f_parent_class: webkit2webextension.DOMMouseEventClass,

    pub fn as(p_instance: *DOMWheelEventClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMXPathExpressionClass = extern struct {
    pub const Instance = webkit2webextension.DOMXPathExpression;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMXPathExpressionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMXPathNSResolverIface = extern struct {
    pub const Instance = webkit2webextension.DOMXPathNSResolver;

    f_gIface: gobject.TypeInterface,
    f_lookup_namespace_uri: ?*const fn (p_resolver: *webkit2webextension.DOMXPathNSResolver, p_prefix: [*:0]const u8) callconv(.C) [*:0]u8,
    f__webkitdom_reserved0: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved1: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved2: ?*const fn () callconv(.C) void,
    f__webkitdom_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *DOMXPathNSResolverIface, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DOMXPathResultClass = extern struct {
    pub const Instance = webkit2webextension.DOMXPathResult;

    f_parent_class: webkit2webextension.DOMObjectClass,

    pub fn as(p_instance: *DOMXPathResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const FrameClass = extern struct {
    pub const Instance = webkit2webextension.Frame;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *FrameClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const FramePrivate = opaque {};

pub const HitTestResultClass = extern struct {
    pub const Instance = webkit2webextension.HitTestResult;

    f_parent_class: gobject.ObjectClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *HitTestResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const HitTestResultPrivate = opaque {};

pub const ScriptWorldClass = extern struct {
    pub const Instance = webkit2webextension.ScriptWorld;

    f_parent_class: gobject.ObjectClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ScriptWorldClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ScriptWorldPrivate = opaque {};

pub const URIRequestClass = extern struct {
    pub const Instance = webkit2webextension.URIRequest;

    f_parent_class: gobject.ObjectClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *URIRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URIRequestPrivate = opaque {};

pub const URIResponseClass = extern struct {
    pub const Instance = webkit2webextension.URIResponse;

    f_parent_class: gobject.ObjectClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *URIResponseClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URIResponsePrivate = opaque {};

pub const UserMessageClass = extern struct {
    pub const Instance = webkit2webextension.UserMessage;

    f_parent_class: gobject.InitiallyUnownedClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *UserMessageClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const UserMessagePrivate = opaque {};

pub const WebEditorClass = extern struct {
    pub const Instance = webkit2webextension.WebEditor;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebEditorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebEditorPrivate = opaque {};

pub const WebExtensionClass = extern struct {
    pub const Instance = webkit2webextension.WebExtension;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebExtensionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebExtensionPrivate = opaque {};

pub const WebFormManagerClass = extern struct {
    pub const Instance = webkit2webextension.WebFormManager;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebFormManagerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebHitTestResultClass = extern struct {
    pub const Instance = webkit2webextension.WebHitTestResult;

    f_parent_class: webkit2webextension.HitTestResultClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *WebHitTestResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebHitTestResultPrivate = opaque {};

pub const WebPageClass = extern struct {
    pub const Instance = webkit2webextension.WebPage;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebPageClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebPagePrivate = opaque {};

/// Enum values used to denote the various levels of console messages.
pub const ConsoleMessageLevel = enum(c_int) {
    info = 0,
    log = 1,
    warning = 2,
    @"error" = 3,
    debug = 4,
    _,

    extern fn webkit_console_message_level_get_type() usize;
    pub const getGObjectType = webkit_console_message_level_get_type;
};

/// Enum values used to denote the various sources of console messages.
pub const ConsoleMessageSource = enum(c_int) {
    javascript = 0,
    network = 1,
    console_api = 2,
    security = 3,
    other = 4,
    _,

    extern fn webkit_console_message_source_get_type() usize;
    pub const getGObjectType = webkit_console_message_source_get_type;
};

/// Enum values used to denote the stock actions for
/// `webkit2webextension.ContextMenuItem`<!-- -->s
pub const ContextMenuAction = enum(c_int) {
    no_action = 0,
    open_link = 1,
    open_link_in_new_window = 2,
    download_link_to_disk = 3,
    copy_link_to_clipboard = 4,
    open_image_in_new_window = 5,
    download_image_to_disk = 6,
    copy_image_to_clipboard = 7,
    copy_image_url_to_clipboard = 8,
    open_frame_in_new_window = 9,
    go_back = 10,
    go_forward = 11,
    stop = 12,
    reload = 13,
    copy = 14,
    cut = 15,
    paste = 16,
    delete = 17,
    select_all = 18,
    input_methods = 19,
    unicode = 20,
    spelling_guess = 21,
    no_guesses_found = 22,
    ignore_spelling = 23,
    learn_spelling = 24,
    ignore_grammar = 25,
    font_menu = 26,
    bold = 27,
    italic = 28,
    underline = 29,
    outline = 30,
    inspect_element = 31,
    open_video_in_new_window = 32,
    open_audio_in_new_window = 33,
    copy_video_link_to_clipboard = 34,
    copy_audio_link_to_clipboard = 35,
    toggle_media_controls = 36,
    toggle_media_loop = 37,
    enter_video_fullscreen = 38,
    media_play = 39,
    media_pause = 40,
    media_mute = 41,
    download_video_to_disk = 42,
    download_audio_to_disk = 43,
    insert_emoji = 44,
    paste_as_plain_text = 45,
    custom = 10000,
    _,
};

/// Used to indicate a particular stage in form submission. See
/// `webkit2webextension.WebPage.signals.will`-submit-form.
pub const FormSubmissionStep = enum(c_int) {
    send_dom_event = 0,
    complete = 1,
    _,

    extern fn webkit_form_submission_step_get_type() usize;
    pub const getGObjectType = webkit_form_submission_step_get_type;
};

/// Enum values used to denote errors happening when sending user messages.
pub const UserMessageError = enum(c_int) {
    user_message_unhandled_message = 0,
    _,
};

/// Enum values with flags representing the context of a `webkit2webextension.HitTestResult`.
pub const HitTestResultContext = packed struct(c_uint) {
    _padding0: bool = false,
    document: bool = false,
    link: bool = false,
    image: bool = false,
    media: bool = false,
    editable: bool = false,
    scrollbar: bool = false,
    selection: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_document: HitTestResultContext = @bitCast(@as(c_uint, 2));
    const flags_link: HitTestResultContext = @bitCast(@as(c_uint, 4));
    const flags_image: HitTestResultContext = @bitCast(@as(c_uint, 8));
    const flags_media: HitTestResultContext = @bitCast(@as(c_uint, 16));
    const flags_editable: HitTestResultContext = @bitCast(@as(c_uint, 32));
    const flags_scrollbar: HitTestResultContext = @bitCast(@as(c_uint, 64));
    const flags_selection: HitTestResultContext = @bitCast(@as(c_uint, 128));
};

/// Type definition for a function that will be called to initialize
/// the web extension when the web process starts.
pub const WebExtensionInitializeFunction = *const fn (p_extension: *webkit2webextension.WebExtension) callconv(.C) void;

/// Type definition for a function that will be called to initialize
/// the web extensions when the web process starts, and which receives
/// as additional argument the user data set with
/// `webkit_web_context_set_web_extensions_initialization_user_data`.
pub const WebExtensionInitializeWithUserDataFunction = *const fn (p_extension: *webkit2webextension.WebExtension, p_user_data: *const glib.Variant) callconv(.C) void;

pub const DOM_CSS_RULE_CHARSET_RULE = 2;
pub const DOM_CSS_RULE_FONT_FACE_RULE = 5;
pub const DOM_CSS_RULE_IMPORT_RULE = 3;
pub const DOM_CSS_RULE_MEDIA_RULE = 4;
pub const DOM_CSS_RULE_PAGE_RULE = 6;
pub const DOM_CSS_RULE_STYLE_RULE = 1;
pub const DOM_CSS_RULE_UNKNOWN_RULE = 0;
pub const DOM_CSS_VALUE_CSS_CUSTOM = 3;
pub const DOM_CSS_VALUE_CSS_INHERIT = 0;
pub const DOM_CSS_VALUE_CSS_PRIMITIVE_VALUE = 1;
pub const DOM_CSS_VALUE_CSS_VALUE_LIST = 2;
pub const DOM_ELEMENT_ALLOW_KEYBOARD_INPUT = 1;
pub const DOM_EVENT_AT_TARGET = 2;
pub const DOM_EVENT_BLUR = 8192;
pub const DOM_EVENT_BUBBLING_PHASE = 3;
pub const DOM_EVENT_CAPTURING_PHASE = 1;
pub const DOM_EVENT_CHANGE = 32768;
pub const DOM_EVENT_CLICK = 64;
pub const DOM_EVENT_DBLCLICK = 128;
pub const DOM_EVENT_DRAGDROP = 2048;
pub const DOM_EVENT_FOCUS = 4096;
pub const DOM_EVENT_KEYDOWN = 256;
pub const DOM_EVENT_KEYPRESS = 1024;
pub const DOM_EVENT_KEYUP = 512;
pub const DOM_EVENT_MOUSEDOWN = 1;
pub const DOM_EVENT_MOUSEDRAG = 32;
pub const DOM_EVENT_MOUSEMOVE = 16;
pub const DOM_EVENT_MOUSEOUT = 8;
pub const DOM_EVENT_MOUSEOVER = 4;
pub const DOM_EVENT_MOUSEUP = 2;
pub const DOM_EVENT_NONE = 0;
pub const DOM_EVENT_SELECT = 16384;
pub const DOM_KEYBOARD_EVENT_KEY_LOCATION_LEFT = 1;
pub const DOM_KEYBOARD_EVENT_KEY_LOCATION_NUMPAD = 3;
pub const DOM_KEYBOARD_EVENT_KEY_LOCATION_RIGHT = 2;
pub const DOM_KEYBOARD_EVENT_KEY_LOCATION_STANDARD = 0;
pub const DOM_NODE_ATTRIBUTE_NODE = 2;
pub const DOM_NODE_CDATA_SECTION_NODE = 4;
pub const DOM_NODE_COMMENT_NODE = 8;
pub const DOM_NODE_DOCUMENT_FRAGMENT_NODE = 11;
pub const DOM_NODE_DOCUMENT_NODE = 9;
pub const DOM_NODE_DOCUMENT_POSITION_CONTAINED_BY = 16;
pub const DOM_NODE_DOCUMENT_POSITION_CONTAINS = 8;
pub const DOM_NODE_DOCUMENT_POSITION_DISCONNECTED = 1;
pub const DOM_NODE_DOCUMENT_POSITION_FOLLOWING = 4;
pub const DOM_NODE_DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
pub const DOM_NODE_DOCUMENT_POSITION_PRECEDING = 2;
pub const DOM_NODE_DOCUMENT_TYPE_NODE = 10;
pub const DOM_NODE_ELEMENT_NODE = 1;
pub const DOM_NODE_ENTITY_NODE = 6;
pub const DOM_NODE_ENTITY_REFERENCE_NODE = 5;
/// Accept the node. Use this macro as return value of `webkit2webextension.DOMNodeFilter.acceptNode`
/// implementation to accept the given `webkit2webextension.DOMNode`
pub const DOM_NODE_FILTER_ACCEPT = 1;
/// Reject the node. Use this macro as return value of `webkit2webextension.DOMNodeFilter.acceptNode`
/// implementation to reject the given `webkit2webextension.DOMNode`. The children of the given node will
/// be rejected too.
pub const DOM_NODE_FILTER_REJECT = 2;
/// Show all nodes.
pub const DOM_NODE_FILTER_SHOW_ALL = 4294967295;
/// Show `webkit2webextension.DOMAttr` nodes.
pub const DOM_NODE_FILTER_SHOW_ATTRIBUTE = 2;
/// Show `WebKitDOMCDataSection` nodes.
pub const DOM_NODE_FILTER_SHOW_CDATA_SECTION = 8;
/// Show `webkit2webextension.DOMComment` nodes.
pub const DOM_NODE_FILTER_SHOW_COMMENT = 128;
/// Show `webkit2webextension.DOMDocument` nodes.
pub const DOM_NODE_FILTER_SHOW_DOCUMENT = 256;
/// Show `webkit2webextension.DOMDocumentFragment` nodes.
pub const DOM_NODE_FILTER_SHOW_DOCUMENT_FRAGMENT = 1024;
/// Show `webkit2webextension.DOMDocumentType` nodes.
pub const DOM_NODE_FILTER_SHOW_DOCUMENT_TYPE = 512;
/// Show `webkit2webextension.DOMElement` nodes.
pub const DOM_NODE_FILTER_SHOW_ELEMENT = 1;
/// Show `WebKitDOMEntity` nodes.
pub const DOM_NODE_FILTER_SHOW_ENTITY = 32;
/// Show `webkit2webextension.DOMEntityReference` nodes.
pub const DOM_NODE_FILTER_SHOW_ENTITY_REFERENCE = 16;
/// Show `WebKitDOMNotation` nodes.
pub const DOM_NODE_FILTER_SHOW_NOTATION = 2048;
/// Show `webkit2webextension.DOMProcessingInstruction` nodes.
pub const DOM_NODE_FILTER_SHOW_PROCESSING_INSTRUCTION = 64;
/// Show `webkit2webextension.DOMText` nodes.
pub const DOM_NODE_FILTER_SHOW_TEXT = 4;
/// Skip the node. Use this macro as return value of `webkit2webextension.DOMNodeFilter.acceptNode`
/// implementation to skip the given `webkit2webextension.DOMNode`. The children of the given node will
/// not be skipped.
pub const DOM_NODE_FILTER_SKIP = 3;
pub const DOM_NODE_PROCESSING_INSTRUCTION_NODE = 7;
pub const DOM_NODE_TEXT_NODE = 3;
pub const DOM_RANGE_END_TO_END = 2;
pub const DOM_RANGE_END_TO_START = 3;
pub const DOM_RANGE_NODE_AFTER = 1;
pub const DOM_RANGE_NODE_BEFORE = 0;
pub const DOM_RANGE_NODE_BEFORE_AND_AFTER = 2;
pub const DOM_RANGE_NODE_INSIDE = 3;
pub const DOM_RANGE_START_TO_END = 1;
pub const DOM_RANGE_START_TO_START = 0;
pub const DOM_XPATH_RESULT_ANY_TYPE = 0;
pub const DOM_XPATH_RESULT_ANY_UNORDERED_NODE_TYPE = 8;
pub const DOM_XPATH_RESULT_BOOLEAN_TYPE = 3;
pub const DOM_XPATH_RESULT_FIRST_ORDERED_NODE_TYPE = 9;
pub const DOM_XPATH_RESULT_NUMBER_TYPE = 1;
pub const DOM_XPATH_RESULT_ORDERED_NODE_ITERATOR_TYPE = 5;
pub const DOM_XPATH_RESULT_ORDERED_NODE_SNAPSHOT_TYPE = 7;
pub const DOM_XPATH_RESULT_STRING_TYPE = 2;
pub const DOM_XPATH_RESULT_UNORDERED_NODE_ITERATOR_TYPE = 4;
pub const DOM_XPATH_RESULT_UNORDERED_NODE_SNAPSHOT_TYPE = 6;
