/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import java.awt.Graphics2D;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogRegion;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdInvertRegion
extends MfCmd {
    private int region;
    private static final int RECORD_SIZE = 1;
    private static final int POS_REGION = 0;

    public void replay(WmfFile file) {
        Graphics2D g2 = (Graphics2D)file.getGraphics2D().create();
        g2.setXORMode(Color.white);
        MfLogRegion reg = file.getRegionObject(this.getRegion());
        g2.fill(reg.getBounds());
    }

    public MfCmd getInstance() {
        return new MfCmdInvertRegion();
    }

    public void setRecord(MfRecord record) {
        this.region = record.getParam(0);
    }

    public MfRecord getRecord() {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getRegion());
        return record;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public int getRegion() {
        return this.region;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[INVERT_REGION] region=");
        b.append(this.getRegion());
        return b.toString();
    }

    public int getFunction() {
        return 298;
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

