/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import java.util.ArrayList;
import sun.java2d.xr.DirtyRegion;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.MaskTile;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

public class MaskTileManager {
    public static final int MASK_SIZE = 256;
    MaskTile mainTile = new MaskTile();
    ArrayList<MaskTile> tileList = new ArrayList();
    int allocatedTiles = 0;
    int xTiles;
    int yTiles;
    XRCompositeManager xrMgr;
    XRBackend con;
    int maskPixmap;
    int maskPicture;
    long maskGC;

    public MaskTileManager(XRCompositeManager xRCompositeManager, int n) {
        this.xrMgr = xRCompositeManager;
        this.con = xRCompositeManager.getBackend();
        this.maskPixmap = this.con.createPixmap(n, 8, 256, 256);
        this.maskPicture = this.con.createPicture(this.maskPixmap, 2);
        this.con.renderRectangle(this.maskPicture, (byte)0, new XRColor(Color.black), 0, 0, 256, 256);
        this.maskGC = this.con.createGC(this.maskPixmap);
        this.con.setGCExposures(this.maskGC, false);
    }

    public void fillMask(XRSurfaceData xRSurfaceData) {
        boolean bl = this.xrMgr.maskRequired();
        boolean bl2 = XRUtils.isMaskEvaluated(this.xrMgr.compRule);
        if (bl && bl2) {
            this.mainTile.calculateDirtyAreas();
            DirtyRegion dirtyRegion = this.mainTile.getDirtyArea().cloneRegion();
            this.mainTile.translate(-dirtyRegion.x, -dirtyRegion.y);
            XRColor xRColor = this.xrMgr.getMaskColor();
            if (dirtyRegion.getWidth() <= 256 && dirtyRegion.getHeight() <= 256) {
                this.compositeSingleTile(xRSurfaceData, this.mainTile, dirtyRegion, bl, 0, 0, xRColor);
            } else {
                this.allocTiles(dirtyRegion);
                this.tileRects();
                for (int i = 0; i < this.yTiles; ++i) {
                    for (int j = 0; j < this.xTiles; ++j) {
                        MaskTile maskTile = this.tileList.get(i * this.xTiles + j);
                        int n = j * 256;
                        int n2 = i * 256;
                        this.compositeSingleTile(xRSurfaceData, maskTile, dirtyRegion, bl, n, n2, xRColor);
                    }
                }
            }
        } else if (this.xrMgr.isSolidPaintActive()) {
            this.xrMgr.XRRenderRectangles(xRSurfaceData, this.mainTile.getRects());
        } else {
            this.xrMgr.XRCompositeRectangles(xRSurfaceData, this.mainTile.getRects());
        }
        this.mainTile.reset();
    }

    public int uploadMask(int n, int n2, int n3, int n4, byte[] byArray) {
        int n5 = 0;
        if (byArray != null) {
            float f = this.xrMgr.isTexturePaintActive() ? this.xrMgr.getExtraAlpha() : 1.0f;
            this.con.putMaskImage(this.maskPixmap, this.maskGC, byArray, 0, 0, 0, 0, n, n2, n4, n3, f);
            n5 = this.maskPicture;
        } else if (this.xrMgr.isTexturePaintActive()) {
            n5 = this.xrMgr.getExtraAlphaMask();
        }
        return n5;
    }

    public void clearUploadMask(int n, int n2, int n3) {
        if (n == this.maskPicture) {
            this.con.renderRectangle(this.maskPicture, (byte)0, XRColor.NO_ALPHA, 0, 0, n2, n3);
        }
    }

    protected void compositeSingleTile(XRSurfaceData xRSurfaceData, MaskTile maskTile, DirtyRegion dirtyRegion, boolean bl, int n, int n2, XRColor xRColor) {
        if (maskTile.rects.getSize() > 0) {
            DirtyRegion dirtyRegion2 = maskTile.getDirtyArea();
            int n3 = dirtyRegion2.x + n + dirtyRegion.x;
            int n4 = dirtyRegion2.y + n2 + dirtyRegion.y;
            int n5 = dirtyRegion2.x2 - dirtyRegion2.x;
            int n6 = dirtyRegion2.y2 - dirtyRegion2.y;
            n5 = Math.min(n5, 256);
            n6 = Math.min(n6, 256);
            int n7 = maskTile.rects.getSize();
            if (bl) {
                int n8 = 0;
                if (n7 > 1) {
                    this.con.renderRectangles(this.maskPicture, (byte)1, xRColor, maskTile.rects);
                    n8 = this.maskPicture;
                } else if (this.xrMgr.isTexturePaintActive()) {
                    n8 = this.xrMgr.getExtraAlphaMask();
                }
                this.xrMgr.XRComposite(0, n8, xRSurfaceData.getPicture(), n3, n4, dirtyRegion2.x, dirtyRegion2.y, n3, n4, n5, n6);
                if (n7 > 1) {
                    this.con.renderRectangle(this.maskPicture, (byte)0, XRColor.NO_ALPHA, dirtyRegion2.x, dirtyRegion2.y, n5, n6);
                }
                maskTile.reset();
            } else if (n7 > 0) {
                maskTile.rects.translateRects(n + dirtyRegion.x, n2 + dirtyRegion.y);
                this.xrMgr.XRRenderRectangles(xRSurfaceData, maskTile.rects);
            }
        }
    }

    protected void allocTiles(DirtyRegion dirtyRegion) {
        this.xTiles = dirtyRegion.getWidth() / 256 + 1;
        this.yTiles = dirtyRegion.getHeight() / 256 + 1;
        int n = this.xTiles * this.yTiles;
        if (n > this.allocatedTiles) {
            for (int i = 0; i < n; ++i) {
                if (i < this.allocatedTiles) {
                    this.tileList.get(i).reset();
                    continue;
                }
                this.tileList.add(new MaskTile());
            }
            this.allocatedTiles = n;
        }
    }

    protected void tileRects() {
        GrowableRectArray growableRectArray = this.mainTile.rects;
        for (int i = 0; i < growableRectArray.getSize(); ++i) {
            int n = growableRectArray.getX(i) / 256;
            int n2 = growableRectArray.getY(i) / 256;
            int n3 = (growableRectArray.getX(i) + growableRectArray.getWidth(i)) / 256 + 1 - n;
            int n4 = (growableRectArray.getY(i) + growableRectArray.getHeight(i)) / 256 + 1 - n2;
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n5 = this.xTiles * (n2 + j) + n + k;
                    MaskTile maskTile = this.tileList.get(n5);
                    GrowableRectArray growableRectArray2 = maskTile.getRects();
                    int n6 = growableRectArray2.getNextIndex();
                    int n7 = (n + k) * 256;
                    int n8 = (n2 + j) * 256;
                    growableRectArray2.setX(n6, growableRectArray.getX(i) - n7);
                    growableRectArray2.setY(n6, growableRectArray.getY(i) - n8);
                    growableRectArray2.setWidth(n6, growableRectArray.getWidth(i));
                    growableRectArray2.setHeight(n6, growableRectArray.getHeight(i));
                    this.limitRectCoords(growableRectArray2, n6);
                    maskTile.getDirtyArea().growDirtyRegion(growableRectArray2.getX(n6), growableRectArray2.getY(n6), growableRectArray2.getWidth(n6) + growableRectArray2.getX(n6), growableRectArray2.getHeight(n6) + growableRectArray2.getY(n6));
                }
            }
        }
    }

    private void limitRectCoords(GrowableRectArray growableRectArray, int n) {
        if (growableRectArray.getX(n) + growableRectArray.getWidth(n) > 256) {
            growableRectArray.setWidth(n, 256 - growableRectArray.getX(n));
        }
        if (growableRectArray.getY(n) + growableRectArray.getHeight(n) > 256) {
            growableRectArray.setHeight(n, 256 - growableRectArray.getY(n));
        }
        if (growableRectArray.getX(n) < 0) {
            growableRectArray.setWidth(n, growableRectArray.getWidth(n) + growableRectArray.getX(n));
            growableRectArray.setX(n, 0);
        }
        if (growableRectArray.getY(n) < 0) {
            growableRectArray.setHeight(n, growableRectArray.getHeight(n) + growableRectArray.getY(n));
            growableRectArray.setY(n, 0);
        }
    }

    public MaskTile getMainTile() {
        return this.mainTile;
    }
}

