/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.WebRowSetImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;

public class FilteredRowSetImpl
extends WebRowSetImpl
implements Serializable,
Cloneable,
FilteredRowSet {
    private Predicate p;
    private boolean onInsertRow = false;
    static final long serialVersionUID = 6178454588413509360L;

    public FilteredRowSetImpl() throws SQLException {
    }

    public FilteredRowSetImpl(Hashtable hashtable) throws SQLException {
        super(hashtable);
    }

    @Override
    public void setFilter(Predicate predicate) throws SQLException {
        this.p = predicate;
    }

    @Override
    public Predicate getFilter() {
        return this.p;
    }

    @Override
    protected boolean internalNext() throws SQLException {
        boolean bl = false;
        for (int i = this.getRow(); i <= this.size(); ++i) {
            bl = super.internalNext();
            if (!bl || this.p == null) {
                return bl;
            }
            if (this.p.evaluate(this)) break;
        }
        return bl;
    }

    @Override
    protected boolean internalPrevious() throws SQLException {
        boolean bl = false;
        for (int i = this.getRow(); i > 0; --i) {
            bl = super.internalPrevious();
            if (this.p == null) {
                return bl;
            }
            if (this.p.evaluate(this)) break;
        }
        return bl;
    }

    @Override
    protected boolean internalFirst() throws SQLException {
        boolean bl = super.internalFirst();
        if (this.p == null) {
            return bl;
        }
        while (bl && !this.p.evaluate(this)) {
            bl = super.internalNext();
        }
        return bl;
    }

    @Override
    protected boolean internalLast() throws SQLException {
        boolean bl = super.internalLast();
        if (this.p == null) {
            return bl;
        }
        while (bl && !this.p.evaluate(this)) {
            bl = super.internalPrevious();
        }
        return bl;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.relative").toString());
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.isAfterLast()) {
                    return false;
                }
                bl2 = this.internalNext();
            }
            bl = bl2;
        } else {
            for (int i = n; i < 0; ++i) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                bl3 = this.internalPrevious();
            }
            bl = bl3;
        }
        if (n != 0) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        if (n == 0 || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.absolute").toString());
        }
        if (n > 0) {
            bl2 = this.internalFirst();
            for (int i = 0; i < n - 1; ++i) {
                if (this.isAfterLast()) {
                    return false;
                }
                bl2 = this.internalNext();
            }
            bl = bl2;
        } else {
            bl2 = this.internalLast();
            int n2 = n;
            while (n2 + 1 < 0) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                bl2 = this.internalPrevious();
                ++n2;
            }
            bl = bl2;
        }
        this.notifyCursorMoved();
        return bl;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
        super.moveToInsertRow();
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)n2, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateInt(n, n2);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && this.p != null && !(bl2 = this.p.evaluate((Object)bl, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBoolean(n, bl);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)by, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateByte(n, by);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)s, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateShort(n, s);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)l, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateLong(n, l);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)Float.valueOf(f), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateFloat(n, f);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)d, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateDouble(n, d);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)bigDecimal, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBigDecimal(n, bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)string, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateString(n, string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        boolean bl;
        String string = "";
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
            string = string.concat(byteArray[i].toString());
        }
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)string, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBytes(n, byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)date, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateDate(n, date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)time, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateTime(n, time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)timestamp, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateTimestamp(n, timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)inputStream, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)reader, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateCharacterStream(n, reader, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)inputStream, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate(object, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateObject(n, object);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate(object, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateObject(n, object, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void insertRow() throws SQLException {
        this.onInsertRow = false;
        super.insertRow();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

