/*
 * MP3/MPlayer plugin to VDR (C++)
 *
 * (C) 2001-2005 Stefan Huelswitt <s.huelswitt@gmx.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include "common.h"
#include "i18n.h"

const char *i18n_name = 0;

const tI18nPhrase Phrases[] = {
/*
 * French     translations provided by Maxime Guilbot <maxime.guilbot@orange.fr>
 *               additions provided by Pierre-Henri Beguin <ph.beguin@free.fr>
 *               additions provided by Jerome Rousset <zekje@hotmail.com>
 * Slovenian  translations provided by Matjaz Thaler <matjaz.thaler@guest.arnes.si>
 * Greek      translations provided by Dimitrios Dimitrakos <mail@dimitrios.de>
 * Swedish    translations provided by Jan Ekholm <chakie@infa.abo.fi>
 * Spanish & 
 * Catalan    translations provided by Ramon Roca <ramon.roca@xcombo.com>
 * Finnish    translations provided by Rolf Ahrenberg <rahrenbe@cc.hut.fi>
 *               additions provided by Ville Skytt <ville.skytta@iki.fi>
 * Russian    translations provided by Vyacheslav Dikonov <sdiconov@mail.ru>
*/
  { "Parent",
    "Zurck",
    "Nazaj",
    "", // TODO
    "", // TODO
    "", // TODO
    "Parent",
    "", // TODO
    "Takaisin",
    "", // TODO
    "Predecesor", 
    "Piso",
    "Tillbaka",
    "", // TODO
    "", // TODO
    "Anterior",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Select",
    "Auswhlen",
    "Izberi",
    "", // TODO
    "", // TODO
    "", // TODO
    "Slectionner",
    "", // TODO
    "Valitse",
    "", // TODO
    "Seleccionar", 
    "Epilogi",
    "Vlj",
    "", // TODO
    "", // TODO
    "Escollir",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Error scanning directory!",
    "Fehler beim Lesen des Verzeichnisses!",
    "Napaka pri pregledovanju direktorija!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Erreur de parcours du rpertoire!",
    "", // TODO
    "Hakemiston avaaminen eponnistui!",
    "", // TODO
    "Error al leer una carpeta!", 
    "Lathos stin sarosi tou fakelou!",
    "Kunde inte lsa katalogen!",
    "", // TODO
    "", // TODO
    "Error al llegir una carpeta!",
#if VDRVERSNUM >= 10302
    "  !",
#endif
  },
  { "Source",
    "Datentrger",
    "Izvor",
    "", // TODO
    "", // TODO
    "", // TODO
    "Source",
    "", // TODO
    "Lhde",
    "", // TODO
    "Origen", 
    "Pigi",
    "Klla",
    "", // TODO
    "", // TODO
    "Orgen",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Mount",
    "Einbinden",
    "Priklopi",
    "", // TODO
    "", // TODO
    "", // TODO
    "Monter",
    "", // TODO
    "Kiinnit",
    "", // TODO
    "Mount", 
    "Sindesi",
    "Montera",
    "", // TODO
    "", // TODO
    "Mount",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Unmount",
    "Aushngen",
    "Izklopi",
    "", // TODO
    "", // TODO
    "", // TODO
    "Dmonter",
    "", // TODO
    "Irrota",
    "", // TODO
    "Unmount",
    "Aposindesi",
    "Avmontera",
    "", // TODO
    "", // TODO
    "Unmount",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Selected source is not mounted!",
    "Ausgewhlte Datentrger ist nicht eingebunden!",
    "Izbran izvor ni prikljucen!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Source slectionne non monte!",
    "", // TODO
    "Valittu lhde ei ole kiinnitetty!",
    "", // TODO
    "El origen deseado no est montado!", 
    "Epilegmeni Pigi den ine sindemeni!",
    "Den valda kllan r inte monterad!",
    "", // TODO
    "", // TODO
    "l'Origen sel.leccionat no est muntat!",
#if VDRVERSNUM >= 10302
    "   !",
#endif
  },
  { "Mount succeeded",
    "Einbinden erfolgreich",
    "Priklop izveden",
    "", // TODO
    "", // TODO
    "", // TODO
    "Montage russi",
    "", // TODO
    "Kiinnittminen onnistui",
    "", // TODO
    "mount correcto", 
    "I sindesi petixe",
    "Monteringen lyckades",
    "", // TODO
    "", // TODO
    "mount correcte",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Mount failed!",
    "Einbinden fehlgeschlagen!",
    "Napaka pri priklopu!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Echec du montage!",
    "", // TODO
    "Kiinnittminen eponnistui!",
    "", // TODO
    "No he podido montar!", 
    "I sindesi apetixe!",
    "Monteringen misslyckades!",
    "", // TODO
    "", // TODO
    "No he pogut muntar!",
#if VDRVERSNUM >= 10302
    "  !",
#endif
  },
  { "Unmount succeeded",
    "Aushngen erfolgreich",
    "Izklop izveden",
    "", // TODO
    "", // TODO
    "", // TODO
    "Dmontage russi",
    "", // TODO
    "Irrottaminen onnistui",
    "", // TODO
    "xito al unmount", 
    "I aposindesi itan epitixisi",
    "Avmonteringen lyckades",
    "", // TODO
    "", // TODO
    "unmount amb xit",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Unmount failed!",
    "Aushngen fehlgeschlagen!",
    "Napaka pri izklopu!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Echec du dmontage!",
    "", // TODO
    "Irrottaminen eponnistui!",
    "", // TODO
    "No puedo desmontar!", 
    "I aposindesi den itan epitixis!",
    "Avmonteringen misslyckades!",
    "", // TODO
    "", // TODO
    "No puc desmontar!",
#if VDRVERSNUM >= 10302
    "  !",
#endif
  },
  { "Eject failed!",
    "Auswerfen fehlgeschlagen!",
    "Napaka pri izmetu!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Echec de l'jection!",
    "", // TODO
    "Aseman avaaminen eponnistui!",
    "", // TODO
    "No puedo expulsar!", 
    "I apovoli apetixe!",
    "Mata ut!",
    "", // TODO
    "", // TODO
    "No puc expulsar!",
#if VDRVERSNUM >= 10302
    "  !",
#endif
  },
  { "Hide mainmenu entry",
    "Hauptmeneintrag verstecken",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Cacher l entre du menu",
    "", // TODO
    "Piilota valinta pvalikosta",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "   ",
#endif
  },
// start of MP3 specific phrases
  { "MP3-NextGen",
    "MP3-NextGen-Audioplayer",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3-soitin",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
#if VDRVERSNUM >= 10302
    " MP3",
#endif
  },
  { "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
    "MP3",
#if VDRVERSNUM >= 10302
    " MP3",
#endif
  },
  { "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
    "MP3ng",
#if VDRVERSNUM >= 10302
    " MP3",
#endif
  },
  { "Next Generation audio player",
    "Next Generation Audio-Player",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "",
    "", // TODO
    "Monipuolinen audiosoitin[MKIII]",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "  MKIII",
#endif
  },
  { "Browse",
    "Blttern",
    "Isci",
    "", // TODO
    "", // TODO
    "", // TODO
    "Parcourir",
    "", // TODO
    "Selaa",
    "", // TODO
    "Explorar",
    "Selida",
    "Blddra",
    "", // TODO
    "", // TODO
    "Explorar",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "MP3 source",
    "MP3 Datentrger",
    "MP3 izvor",
    "", // TODO
    "", // TODO
    "", // TODO
    "Source MP3",
    "", // TODO
    "MP3-lhde",
    "", // TODO
    "Origen MP3", 
    "Pigi MP3",
    "MP3 klla",
    "", // TODO
    "", // TODO
    "Orgen MP3",
#if VDRVERSNUM >= 10302
    " MP3",
#endif
  },
  { "Rename",
    "Umbenennen",
    "Preimenuj",
    "", // TODO
    "", // TODO
    "", // TODO
    "Renommer",
    "", // TODO
    "Nime",
    "", // TODO
    "Renombrar", 
    "Alagi Onomatos",
    "Dp om",
    "", // TODO
    "", // TODO
    "Reanomenar",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Add",
    "Hinzufgen",
    "Dodaj",
    "", // TODO
    "", // TODO
    "", // TODO
    "Ajouter",
    "", // TODO
    "Lis",
    "", // TODO
    "Aadir", 
    "Prosthesi",
    "Lgg till",
    "", // TODO
    "", // TODO
    "Afegir",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Remove",
    "Entfernen",
    "Odstrani",
    "", // TODO
    "", // TODO
    "", // TODO
    "Enlever",
    "", // TODO
    "Poista",
    "", // TODO
    "Borrar", 
    "Aferesi",
    "Radera",
    "", // TODO
    "", // TODO
    "Esborrar",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Play all",
    "Alle abspielen",
    "Predvajaj vse",
    "", // TODO
    "", // TODO
    "", // TODO
    "Jouer tous",
    "", // TODO
    "Soita kaikki",
    "", // TODO
    "Reproducirlo todo", 
    "Peksimo olon",
    "Spela alla",
    "", // TODO
    "", // TODO
    "Escoltar-ho tot",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Add all",
    "Alle hinzufgen",
    "Dodaj vse",
    "", // TODO
    "", // TODO
    "", // TODO
    "Ajouter tous",
    "", // TODO
    "Lis kaikki",
    "", // TODO
    "Aadir todo", 
    "Prosthesi olon",
    "Lgg till alla",
    "", // TODO
    "", // TODO
    "Afegir-ho tot",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Empty directory!",
    "Leeres Verzeichnis!",
    "Direktorij prazen!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Rpertoire vide!",
    "", // TODO
    "Hakemisto on tyhj!",
    "", // TODO
    "Carpeta vaca!", 
    "Adios fakelos!",
    "Tom katalog!",
    "", // TODO
    "", // TODO
    "Carpeta buida!",
#if VDRVERSNUM >= 10302
    " !",
#endif
  },
  { "Add recursivly?",
    "Recursiv hinzufgen?",
    "Rekurzivno dodaj?",
    "", // TODO
    "", // TODO
    "", // TODO
    "Ajouter rcursivement?",
    "", // TODO
    "Lis rekursiivisesti?",
    "", // TODO
    "Aadir recursivamente?", 
    "Prosthesi recursiv?",
    "Lgg till rekursivt?",
    "", // TODO
    "", // TODO
    "Afegir recursivament?",
#if VDRVERSNUM >= 10302
    " ?",
#endif
  },
  { "Remove entry?",
    "Eintrag entfernen?",
    "Odstrani izbrano?",
    "", // TODO
    "", // TODO
    "", // TODO
    "Enlever titre?",
    "", // TODO
    "Poistetaanko merkint?",
    "", // TODO
    "Borrar la entrada?", 
    "Aferesi simiou?",
    "Radera post?",
    "", // TODO
    "", // TODO
    "Esborrar la entrada?",
#if VDRVERSNUM >= 10302
    " ?",
#endif
  },
  { "Playlist editor",
    "Abspielliste bearbeiten",
    "Urejevalnik liste",
    "", // TODO
    "", // TODO
    "", // TODO
    "Editeur de liste de lecture",
    "", // TODO
    "Soittolistan muokkaus",
    "", // TODO
    "Editor de listas de reproduccin", 
    "Metatropes stin Playlista",
    "Spellisteditor",
    "", // TODO
    "", // TODO
    "Editor de llistes de reproducci",
#if VDRVERSNUM >= 10302
    "  ",
#endif
  },
  { "Directory browser",
    "Verzeichnisanzeige",
    "Navigator",
    "", // TODO
    "", // TODO
    "", // TODO
    "Navigateur",
    "", // TODO
    "Hakemistoselain",
    "", // TODO
    "Explorar carpetes", 
    "Endiski fakelou",
    "Katalogblddrare",
    "", // TODO
    "", // TODO
    "Navegar per les carpetes",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Delete playlist?",
    "Abspielliste lschen?",
    "Odstrani listo?",
    "", // TODO
    "", // TODO
    "", // TODO
    "Effacer liste?",
    "", // TODO
    "Poistetaanko soittolista?",
    "", // TODO
    "Borrar la lista?", 
    "Svisimo listas?",
    "Radera spellista?",
    "", // TODO
    "", // TODO
    "Esborrar la Llista?",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Are you sure?",
    "Wirklich lschen?",
    "Ste prepricani?",
    "", // TODO
    "", // TODO
    "", // TODO
    "Etes-vous sr?",
    "", // TODO
    "Oletko varma?",
    "", // TODO
    "Est seguro?", 
    "Ise sigouros?",
    "r du sker?",
    "", // TODO
    "", // TODO
    "N'esteu segur?",
#if VDRVERSNUM >= 10302
    " ?",
#endif
  },
  { "unnamed",
    "unbenannt",
    "neimenovan",
    "", // TODO
    "", // TODO
    "", // TODO
    "sansnom",
    "", // TODO
    "nimetn",
    "", // TODO
    "sin nombre", 
    "xoris onoma",
    "namnls",
    "", // TODO
    "", // TODO
    "sense nom",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "unknown",
    "unbekannt",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "inconnu",
    "", // TODO
    "tuntematon",
    "", // TODO
    "desconocido", 
    "", // TODO
    "oknd",
    "", // TODO
    "", // TODO
    "desconegut",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Error scanning playlists!",
    "Fehler beim Einlesen der Abspiellisten!",
    "Napaka pri pregledovanju liste!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Erreur de parcours de la liste!",
    "", // TODO
    "Soittolistojen lukeminen eponnistui!",
    "", // TODO
    "Error al leer las listas!", 
    "Lathos stin sarosi tis Playlistas!",
    "Fel uppstod d spellistorna lstes!",
    "", // TODO
    "", // TODO
    "Error al llegir les llistes!",
#if VDRVERSNUM >= 10302
    "   !",
#endif
  },
  { "Error deleting playlist!",
    "Fehler beim Lschen der Abspielliste!",
    "Napaka pri odstranjevanju liste!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Erreur d'effacement de la liste!",
    "", // TODO
    "Soittolistan poistaminen eponnistui!",
    "", // TODO
    "Error al borrar una lista!",
    "Lathos stin akirosi tis Playlistas!",
    "Fel uppstod d spellistan raderades!",
    "", // TODO
    "", // TODO
    "Error al esborrar una llista!",
#if VDRVERSNUM >= 10302
    "   !",
#endif
  },
  { "Error creating playlist!",
    "Fehler beim Erstellen der Abspielliste!",
    "Napaka pri kreiranju liste!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Erreur de cration de la liste!",
    "", // TODO
    "Soittolistan luominen eponnistui!",
    "", // TODO
    "Error al crear una lista!",
    "Lathos stin dimiourgia tis Playlistas!",
    "Fel uppstod d spellistan skapades!",
    "", // TODO
    "", // TODO
    "Error al crear una llista!",
#if VDRVERSNUM >= 10302
    "   !",
#endif
  },
  { "Can't edit a WinAmp playlist!",
    "Editieren von WinAmp Abspiellisten nicht mglich!",
    "Ne morem vnesti liste od WinAmp-a!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Ne peut pas diter une liste WinAmp!",
    "", // TODO
    "WinAmp-soittolistaa ei voida muokata!",
    "", // TODO
    "No puedo editar una lista del WinAmp!", 
    "Den mporo na kano metatropes se WinAmp Playlista!",
    "Kan inte redigera en WinAmp-spellista!",
    "", // TODO
    "", // TODO
    "No puc editar una llista del WinAmp!",
#if VDRVERSNUM >= 10302
    "   WinAmp!",
#endif
  },
  { "Error renaming playlist!",
    "Fehler beim Umbenennen der Abspielliste!",
    "Napaka pri preimenovanju liste!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Erreur pour renommer la liste!",
    "", // TODO
    "Soittolistan uudelleennimeminen eponnistui!",
    "", // TODO
    "Errir al renombrar la lista!", 
    "Latsos stin metonomasi tis Playlistas!",
    "Fel uppstod d spellistan dptes om!",
    "", // TODO
    "", // TODO
    "Error al reanomenar la llista!",
#if VDRVERSNUM >= 10302
    "  !",
#endif
  },
  { "Loading playlist...",
    "Lade Abspielliste...",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Chargement playlist...",
    "", // TODO
    "Avataan soittolistaa...",
    "", // TODO
    "Cargando la lista de reproduccin...", 
    "", // TODO
    "Lser in spellista...",
    "", // TODO
    "", // TODO
    "Carregant la llista de reproducci...",
#if VDRVERSNUM >= 10302
    "  ...",
#endif
  },
  { "Error loading playlist!",
    "Fehler beim Lesen der Abspielliste!",
    "Napaka pri nalaganju liste!",
    "", // TODO
    "", // TODO
    "", // TODO
    "Erreur de chargement de la playlist!",
    "", // TODO
    "Soittolistan avaaminen eponnistui!",
    "", // TODO
    "Error al cargar la lista de reproduccin!", 
    "Lathos sto fortoma tis Playlistas!",
    "Fel uppstod d spellistan lstes in!",
    "", // TODO
    "", // TODO
    "Error al carregar la llista de reproducci!",
#if VDRVERSNUM >= 10302
    "   !",
#endif
  },
  { "Scanning playlists...",
    "Durchsuche Abspiellisten...",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Scanne playlists...",
    "", // TODO
    "Selataan soittolistoja...", 
    "", // TODO
    "Leyendo las listas de reproduccin...",
    "", // TODO
    "Sker spellistor...",
    "", // TODO
    "", // TODO
    "Llegint les llistes de reproducci...",
#if VDRVERSNUM >= 10302
    "  ...",
#endif
  },
  { "Scanning directory...",
    "Durchsuche Verzeichnis...",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Scanne le repertoire...",
    "", // TODO
    "Selataan hakemistoa...",
    "", // TODO
    "Leyendo las carpetas..",
    "", // TODO
    "Sker igenom katalog...",
    "", // TODO
    "", // TODO
    "Revisant les carpetes..",
#if VDRVERSNUM >= 10302
    " ...",
#endif
  },
  { "Building playlist...",
    "Baue Abspielliste auf...",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Construit la playlist...",
    "", // TODO
    "Muodostetaan soittolistaa...",
    "", // TODO
    "Construyendo la lista de reproduccin...",
    "", // TODO
    "Skapar en spellista...",
    "", // TODO
    "", // TODO
    "Construnt la llista de reproducci...",
#if VDRVERSNUM >= 10302
    "  ...",
#endif
  },
  { "Error building playlist!",
    "Fehler beim Aufbau der Abspielliste!",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Erreur construction playlist!",
    "", // TODO
    "Soittolistan muodostaminen eponnistui!",
    "", // TODO
    "Error al construir la lista de reproduccin!",
    "", // TODO
    "Fel uppstod d spellistan skapades!",
    "", // TODO
    "", // TODO
    "Error al consstruir la llista de reproducci!",
#if VDRVERSNUM >= 10302
    "   !",
#endif
  },
  { "Remote CDDB lookup...",
    "Remote CDDB Abfrage...",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Consultation CDDB...",
    "", // TODO
    "Kysytn CDDB-tietoja...",
    "", // TODO
    "Consultando CDDB...",
    "", // TODO
    "Fjrrfrfrgan till CDDB...",
    "", // TODO
    "", // TODO
    "Consultant CDDB...",
#if VDRVERSNUM >= 10302
    "    CDDB...",
#endif
  },
  { "Connecting to stream server ...",
    "Verbinde mit Stream Server...",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Connexion au Serveur Stream...",
    "", // TODO
    "Yhdistetn palvelimeen...",
    "", // TODO
    "Conectando con el servidor...", 
    "", // TODO
    "Kontaktar stream-server...",
    "", // TODO
    "", // TODO
    "Connectant al servidor...",
#if VDRVERSNUM >= 10302
    "   ...",
#endif
  },
  { "Rename playlist",
    "Abspielliste umbenennen",
    "Preimenuj listo",
    "", // TODO
    "", // TODO
    "", // TODO
    "Renommer la liste",
    "", // TODO
    "Nime soittolista",
    "", // TODO
    "Renombrar la lista de reproduccin",
    "Metonomasi tis Playlistas",
    "Dp om spellistan",
    "", // TODO
    "", // TODO
    "Reanomenar la llista de repr.",
#if VDRVERSNUM >= 10302
    "  ",
#endif
  },
  { "Old name:",
    "Alter Name:",
    "Staro ime:",
    "", // TODO
    "", // TODO
    "", // TODO
    "Ancien nom:",
    "", // TODO
    "Vanha nimi",
    "", // TODO
    "Nombre anterior:", 
    "Palio onoma:",
    "Gammalt namn:",
    "", // TODO
    "", // TODO
    "Nom anterior:",
#if VDRVERSNUM >= 10302
    " :",
#endif
  },
  { "New name",
    "Neuer Name",
    "Novo ime",
    "", // TODO
    "", // TODO
    "", // TODO
    "Nouveau nom",
    "", // TODO
    "Uusi nimi",
    "", // TODO
    "Nombre nuevo", 
    "Neo onoma",
    "Nytt namn",
    "", // TODO
    "", // TODO
    "Nou nom", 
#if VDRVERSNUM >= 10302
    " :",
#endif
  },
  { "Filenames",
    "Dateinamen",
    "Imena datotek",
    "", // TODO
    "", // TODO
    "", // TODO
    "Noms de fichiers",
    "", // TODO
    "tiedostonimet",
    "", // TODO
    "Nombre de los archivos", 
    "Onomata arxeion",
    "Filnamn",
    "", // TODO
    "", 
    "Nom dels arxius",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "ID3 names",
    "ID3 Namen",
    "ID3 imena",
    "", // TODO
    "", // TODO
    "", // TODO
    "Nom ID3",
    "", // TODO
    "ID3-nimet",
    "", // TODO
    "Nombre ID3", 
    "ID3 onomata",
    "ID3 namn",
    "", // TODO
    "", // TODO
    "Nom ID3",
#if VDRVERSNUM >= 10302
    "ID3-",
#endif
  },
  { "ID3 information",
    "ID3 Information",
    "ID3 informacija",
    "", // TODO
    "", // TODO
    "", // TODO
    "Information ID3",
    "", // TODO
    "ID3-informaatio",
    "", // TODO
    "Informacin ID3",
    "Plirofories ID3",
    "ID3 information",
    "", // TODO
    "", // TODO
    "Informaci ID3",
#if VDRVERSNUM >= 10302
    "ID3-",
#endif
  },
  { "ID3 info",
    "ID3 Info",
    "ID3 info",
    "", // TODO
    "", // TODO
    "", // TODO
    "Info ID3",
    "", // TODO
    "ID3-info",
    "", // TODO
    "ID3 info",
    "ID3 pliroforia",
    "ID3 info",
    "", // TODO
    "", // TODO
    "ID3 info",
#if VDRVERSNUM >= 10302
    " ID3",
#endif
  },
  { "Filename",
    "Dateiname",
    "Ime datoteke",
    "", // TODO
    "", // TODO
    "", // TODO
    "Nom du fichier",
    "", // TODO
    "Tiedostonimi",
    "", // TODO
    "Nombre del archivo", 
    "Onoma arxeiou",
    "Filnamn",
    "", // TODO
    "", // TODO
    "Nom de l'arxiu",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Length",
    "Lnge",
    "Dolzina",
    "", // TODO
    "", // TODO
    "", // TODO
    "Longueur",
    "", // TODO
    "Pituus",
    "", // TODO
    "Duracin", 
    "Megethos",
    "Lngd",
    "", // TODO
    "", // TODO
    "Durada",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Title",
    "Titel",
    "Naslov",
    "", // TODO
    "", // TODO
    "", // TODO
    "Titre",
    "", // TODO
    "Kappale",
    "", // TODO
    "Ttulo", 
    "Titlos",
    "Tittel",
    "", // TODO
    "", // TODO
    "Ttol",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Artist",
    "Interpret",
    "Avtor",
    "", // TODO
    "", // TODO
    "", // TODO
    "Artiste",
    "", // TODO
    "Esittj",
    "", // TODO
    "Artista",
    "Ermineftis",
    "Artist",
    "", // TODO
    "", // TODO
    "Intrpret",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Album",
    "Album",
    "Album",
    "", // TODO
    "", // TODO
    "", // TODO
    "Album",
    "", // TODO
    "Albumi",
    "", // TODO
    "Album",
    "Album",
    "Album",
    "", // TODO
    "", // TODO
    "lbum",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Year",
    "Jahr",
    "Leto",
    "", // TODO
    "", // TODO
    "", // TODO
    "Anne",
    "", // TODO
    "Vuosi",
    "", // TODO
    "", // TODO
    "Etos",
    "r",
    "", // TODO
    "", // TODO
    "Any",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Samplerate",
    "Sample Rate",
    "Vzorcenje",
    "", // TODO
    "", // TODO
    "", // TODO
    "Frquence",
    "", // TODO
    "Nytteenottotaajuus",
    "", // TODO
    "Frecuencia", 
    "Sixnotita",
    "Samplingshastighet",
    "", // TODO
    "", // TODO
    "Freqncia",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Bitrate",
    "Bit Rate",
    "Bitna hitrost",
    "", // TODO
    "", // TODO
    "", // TODO
    "Bitrate",
    "", // TODO
    "Bittinopeus",
    "", // TODO
    "Bitrate",
    "Bitrate",
    "Bithastighet",
    "", // TODO
    "", // TODO
    "Bitrate",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Initial loop mode",
    "Default Loop Modus",
    "Osnovni nacin ponavljanje",
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode de rptition initial",
    "", // TODO
    "Jatkuva soitto oletuksena",
    "", // TODO
    "Modo de repeticin inicial", 
    "", // TODO
    "Normalt upprepningslge",
    "", // TODO
    "", // TODO
    "Mode de repetici inicial",
#if VDRVERSNUM >= 10302
    "   ",
#endif
  },
  { "Setup.MP3$Initial shuffle mode",
    "Default Shuffle Modus",
    "Osnovni nacin mesano",
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode de lecture alatoire initial",
    "", // TODO
    "Satunnaissoitto oletuksena",
    "", // TODO
    "Lectura aleatria inicial", 
    "", // TODO
    "Normalt blandlge",
    "", // TODO
    "", // TODO
    "Lectura aleatria inicial",
#if VDRVERSNUM >= 10302
    " .   ",
#endif
  },
  { "Setup.MP3$Audio output mode",
    "Audio Ausgabe Modus",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode de sortie audio",
    "", // TODO
    "nen ulostulomoodi",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "  ",
#endif
  },
  { "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
    "OSS",
#if VDRVERSNUM >= 10302
    "OSS",
#endif
  },
  { "Setup.MP3$Audio mode",
    "Audio Modus",
    "Avdio nacin",
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode audio",
    "", // TODO
    "nimoodi",
    "", // TODO
    "Modo de audio", 
    "Katastasi audio",
    "Audiolge",
    "", // TODO
    "", // TODO
    "Mode d'audio",
#if VDRVERSNUM >= 10302
    "  ",
#endif
  },
  { "Round",
    "Runden",
    "Zaokrozeni",
    "", // TODO
    "", // TODO
    "", // TODO
    "Arrondir",
    "", // TODO
    "pyristetty",
    "", // TODO
    "Redondear", 
    "Kikli",
    "Avrunda",
    "", // TODO
    "", // TODO
    "Arrodonir",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Dither",
    "Streuen",
    "Raztrosni",
    "", // TODO
    "", // TODO
    "", // TODO
    "Lisser",
    "", // TODO
    "ditteroitu",
    "", // TODO
    "Compactar",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Compactar",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Background scan",
    "Hintergrund Scan",
    "",
    "", // TODO
    "", // TODO
    "", // TODO
    "Scan en tache de fond",
    "", // TODO
    "Taustaskannaus",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "ID3 only",
    "nur ID3",
    "",
    "", // TODO
    "", // TODO
    "", // TODO
    "Seulement ID3",
    "", // TODO
    "vain ID3",
    "", // TODO
    "", 
    "",
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    " ID3",
#endif
  },
  { "ID3 & Level",
    "ID3 & Pegel",
    "",
    "", // TODO
    "", // TODO
    "", // TODO
    "ID3 et niveau",
    "", // TODO
    "ID3 & taso",
    "", // TODO
    "", 
    "",
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "ID3  ",
#endif
  },
  { "Setup.MP3$Editor display mode",
    "Editor Anzeige Modus",
    "Nacin prikaza urejevalnika",
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode d'affichage de l'diteur",
    "", // TODO
    "Muokkaustilan nyttmoodi",
    "", // TODO
    "Modo de visualizacin del editor",
    "", // TODO
    "Redigerarens visuella lge",
    "", // TODO
    "", // TODO
    "Mode de visualitzaci del editor",
#if VDRVERSNUM >= 10302
    "  ",
#endif
  },
  { "Setup.MP3$Display mode",
    "Anzeige Modus",
    "Nacin prikaza",
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode d'affichage",
    "", // TODO
    "Nyttmoodi",
    "", // TODO
    "Modo de Visualizacin", 
    "", // TODO
    "Visuellt lge",
    "", // TODO
    "", // TODO
    "Mode de visualitzaci",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Setup.MP3$Background mode",
    "Hintergrund Modus",
    "Ozadje",
    "", // TODO
    "", // TODO
    "", // TODO
    "Arrire plan",
    "", // TODO
    "Taustamoodi",
    "", // TODO
    "Ejecutar al fondo", 
    "", // TODO
    "Bakgrundslge",
    "", // TODO
    "", // TODO
    "Execuci de fons",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Setup.MP3$CDDB for CD-Audio",
    "CDDB fr CD-Audio",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "CDDB pour CD-Audio",
    "", // TODO
    "CDDB-tietokanta",
    "", // TODO
    "CDDB para el Aidio-CD", 
    "", // TODO
    "CDDB fr CD-audio",
    "", // TODO
    "", // TODO
    "CDDB per al Audio-CD",
#if VDRVERSNUM >= 10302
    "CDDB  -CD",
#endif
  },
  { "disabled",
    "aus",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "dsactiver",
    "", // TODO
    "pois",
    "", // TODO
    "desactivado", 
    "", // TODO
    "avstngd",
    "", // TODO
    "", // TODO
    "desactivat",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "local only",
    "nur lokal",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "local uniquement",
    "", // TODO
    "vain paikallinen",
    "", // TODO
    "solo local", 
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "solsament local",
#if VDRVERSNUM >= 10302
    " .",
#endif
  },
  { "local&remote",
    "lokal und entfernt",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "local et distant",
    "", // TODO
    "paikallinen & et",
    "", // TODO
    "local y remoto",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "local i remot",
#if VDRVERSNUM >= 10302
    ".  .",
#endif
  },
  { "Setup.MP3$Use 48kHz mode only",
    "Nur 48kHz Modus benutzen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode 48kHz uniquement",
    "", // TODO
    "Kyt vain 48kHz moodia",
    "", // TODO
    "Solo modo 48kHz",
    "", // TODO
    "Anvnd endast 48Khz-lge",
    "", // TODO
    "", // TODO
    "Noms mode 48kHz",
#if VDRVERSNUM >= 10302
    " 48 ڳ",
#endif
  },
  { "Setup.MP3$Use HTTP proxy",
    "HTTP Proxy benutzen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Utiliser un Proxy HTTP",
    "", // TODO
    "Kyt HTTP-vlityspalvelinta",
    "", // TODO
    "Utilizar proxy HTTP", 
    "", // TODO
    "Anvnd en HTTP-proxy",
    "", // TODO
    "", // TODO
    "Utillitzar proxy HTTP",
#if VDRVERSNUM >= 10302
    " HTTP ",
#endif
  },
  { "Setup.MP3$HTTP proxy host",
    "HTTP Proxy Name",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Nom du Proxy HTTP",
    "", // TODO
    "HTTP-vlityspalvelimen osoite",
    "", // TODO
    "Nombre del puerto HTTP", 
    "", // TODO
    "HTTP-proxyns namn",
    "", // TODO
    "", // TODO
    "Nom del proxy HTTP",
#if VDRVERSNUM >= 10302
    " HTTP ",
#endif
  },
  { "Setup.MP3$HTTP proxy port",
    "HTTP Proxy Port",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Port du proxy HTTP",
    "", // TODO
    "HTTP-vlityspalvelimen portti",
    "", // TODO
    "Puerto del Proxy HTTP", 
    "", // TODO
    "HTTP-proxyns port",
    "", // TODO
    "", // TODO
    "Port del proxy HTTP",
#if VDRVERSNUM >= 10302
    " HTTP ",
#endif
  },
  { "Setup.MP3$CDDB server",
    "CDDB Server",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Serveur CDDB",
    "", // TODO
    "CDDB-palvelin",
    "", // TODO
    "Servidor CDDB", 
    "", // TODO
    "CDDB server",
    "", // TODO
    "", // TODO
    "Servidor CDDB",
#if VDRVERSNUM >= 10302
    " CDDB",
#endif
  },
  { "Setup.MP3$CDDB port",
    "CDDB Port",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Port CDDB",
    "", // TODO
    "CDDB-palvelimen portti",
    "", // TODO
    "Puerto CDDB",
    "", // TODO
    "CDDB port",
    "", // TODO
    "", // TODO
    "Port CDDB",
#if VDRVERSNUM >= 10302
    " CDDB",
#endif
  },
  { "Black",
    "Schwarz",
    "Crnina",
    "", // TODO
    "", // TODO
    "", // TODO
    "Noir",
    "", // TODO
    "musta",
    "", // TODO
    "Negra", 
    "Mavro",
    "Svart",
    "", // TODO
    "", // TODO
    "Negre",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Live",
    "Live",
    "Slika",
    "", // TODO
    "", // TODO
    "", // TODO
    "Live",
    "", // TODO
    "live",
    "", // TODO
    "En vivo", 
    "Zontana",
    "Live",
    "", // TODO
    "", // TODO
    "Imatge",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Coverart",
    "Coverart",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Mainmenu mode",
    "Hauptmen Modus",
    "Nacin glavnega menija",
    "", // TODO
    "", // TODO
    "", // TODO
    "Menu principal",
    "", // TODO
    "Pvalikon tila",
    "", // TODO
    "Men Principal", 
    "", // TODO
    "Huvudmenylge",
    "", // TODO
    "", // TODO
    "Men Principal",
#if VDRVERSNUM >= 10302
    "  ",
#endif
  },
  { "Playlists",
    "Abspiellisten",
    "Lista",
    "", // TODO
    "", // TODO
    "", // TODO
    "Playlists",
    "", // TODO
    "soittolistat",
    "", // TODO
    "Lista de reproduccin", 
    "Listes peksimatos",
    "Spellistor",
    "", // TODO
    "", // TODO
    "Llista a reprodur",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Browser",
    "Verz.anzeige",
    "Navigator",
    "", // TODO
    "", // TODO
    "", // TODO
    "Navigateur",
    "", // TODO
    "selain",
    "", // TODO
    "Navegador",
    "", // TODO
    "Blddra",
    "", // TODO
    "", // TODO
    "Navegador",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Normalizer level",
    "Normalisierer Pegel",
    "Normalni nivo",
    "", // TODO
    "", // TODO
    "", // TODO
    "Niveau de normalisation",
    "", // TODO
    "Normalisoinnin taso",
    "", // TODO
    "Nivel de normalizacin", 
    "", // TODO
    "Normaliseringsniv",
    "", // TODO
    "", // TODO
    "Nivell de normalitzaci",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Setup.MP3$Limiter level",
    "Begrenzer Pegel",
    "Limitni nivo",
    "", // TODO
    "", // TODO
    "", // TODO
    "Niveau limite",
    "", // TODO
    "Rajoittimen taso",
    "", // TODO
    "Limitador del nivel", 
    "", // TODO
    "Begrnsningsniv",
    "", // TODO
    "", // TODO
    "Limitador del nivell",
#if VDRVERSNUM >= 10302
    "  ",
#endif
  },
  { "Setup.MP3$Abort player at end of list",
    "Abspieler am Listenende beenden",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Stopper le lecteur  la fin de la liste",
    "", // TODO
    "Keskeyt soittolistan loputtua",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "    ",
#endif
  },
  { "classic",
    "klassisch",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Classique",
    "", // TODO
    "klassinen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Keep selection menu",
    "Auswahlmen geffnet lassen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "",
    "", // TODO
    "Pid valintaikkunaa auki",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Exit stop playback",
    "Zurck beendet Wiedergabe",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "",
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$UseDeviceStillPicture",
    "Benutze DeviceStillPicture",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "",
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Theme",
    "Optik",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$OSD Offset X",
    "OSD Offset X",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$OSD Offset Y",
    "OSD Offset Y",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Skip with green/yellow Key",
    "Mit grner/gelber Taste skippen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Skip interval",
    "Intervall Skippen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Scroll through playlist",
    "Durch Playliste scrollen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Where to copy tracks",
    "Zielverzeichnis fuer Tracks",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Where to record streams",
    "Aufnahmeverzeichnis fuer Webstreams",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Display tracks",
    "Anzuzeigende Tracks ",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "of",
    "von",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Time",
    "Zeit",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Track",
    "Track",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MP3$Jump interval (FFW/FREW)",
    "Intervall Vor-/Zurckspulen",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    "",
#endif
  },

// start of MPlayer specific phrases

  { "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer-mediasoitin",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
    "MPlayer",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Media replay via MPlayer",
    "Medien Wiedergabe ber MPlayer",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Lecture par MPlayer",
    "", // TODO
    "MPlayeriin perustuva mediasoitin",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "MPlayer browser",
    "MPlayer Verzeichnisanzeige",
    "MPlayer navigator",
    "", // TODO
    "", // TODO
    "", // TODO
    "Navigateur MPlayer",
    "", // TODO
    "MPlayer-hakemistoselain",
    "", // TODO
    "Navegador del MPlayer",
    "Mplayer endiksi fakelon",
    "MPlayer-blddrare",
    "", // TODO
    "", // TODO
    "Navegador del MPlayer",
#if VDRVERSNUM >= 10302
    "  MPlayer",
#endif
  },
  { "MPlayer source",
    "MPlayer Datentrger",
    "MPlayer izvor",
    "", // TODO
    "", // TODO
    "", // TODO
    "Source MPlayer",
    "", // TODO
    "MPlayer-lhde",
    "Orgen del Mplayer", 
    "", // TODO
    "Pigi MPlayer",
    "MPlayer klla",
    "", // TODO
    "", // TODO
    "Orgen del MPlayer",
#if VDRVERSNUM >= 10302
    "  MPlayer",
#endif
  },
  { "Setup.MPlayer$Control mode",
    "Kontroll Modus",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Mode de controle",
    "", // TODO
    "Komentotila",
    "", // TODO
    "Modo de control", 
    "", // TODO
    "Kontrollge",
    "", // TODO
    "", // TODO
    "Mode de control",
#if VDRVERSNUM >= 10302
    " ",
#endif
  },
  { "Traditional",
    "Traditionell",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Traditionnel",
    "", // TODO
    "perinteinen",
    "", // TODO
    "Tradicional", 
    "", // TODO
    "Traditionell",
    "", // TODO
    "", // TODO
    "Tradicional",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Slave",
    "Slave",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Esclave",
    "", // TODO
    "orja",
    "", // TODO
    "Esclavo", 
    "", // TODO
    "Slav",
    "", // TODO
    "", // TODO
    "Esclau",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MPlayer$OSD position",
    "OSD Position",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "",
    "", // TODO
    "Kuvaruutunytn sijainti",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MPlayer$Resume mode",
    "Modus fr Wiederaufnahme",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Reprise",
    "", // TODO
    "Resume-toiminto",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "local first",
    "zuerst local",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Local en premier",
    "", // TODO
    "paikallinen",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "global only",
    "nur global",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Global seulement",
    "", // TODO
    "globaali",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Setup.MPlayer$Slave command key",
    "Slave Kommando Taste",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "",
    "", // TODO
    "Orjakomento nppimelle",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "MPlayer Audio ID",
    "MPlayer Audio ID",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Mplayer piste audio",
    "", // TODO
    "MPlayerin niraidan valinta",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
  },
  { "Audiostream ID",
    "Tonspur ID",
    "", // TODO
    "", // TODO
    "", // TODO
    "", // TODO
    "Canal audio",
    "", // TODO
    "niraidan ID",
    "", // TODO
    "", 
    "", // TODO
    "",
    "", // TODO
    "", // TODO
    "",
#if VDRVERSNUM >= 10302
    "",
#endif
  },

  { NULL }
  };
