/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/***************************************************************************
 *            test.cc
 *
 *  Thu Mar 16 10:48:40 CEST 2013
 *  Copyright 2013 Bent Bisballe Nyeng
 *  deva@aasimon.org
 ****************************************************************************/

/*
 *  This file is part of the Usb Hotplug Library (libusbhp)
 *
 *  Libusbhp is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Libusbhp is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libusbhp; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */
#include <stdio.h>
#include <time.h>

#include <libusbhp.h>

static void attach_fn(struct libusbhp_device_t *device, void *user_data)
{
  printf("attach\n");
  if(device) printf("  (%04x/%04x)\n", device->idVendor, device->idProduct);
}

static void detach_fn(struct libusbhp_device_t *device, void *user_data)
{
  printf("detach\n");
  if(device) printf("  (%04x/%04x)\n", device->idVendor, device->idProduct);
}

int main(int args, char* argv[])
{
  struct libusbhp_t *handle;

  int ret = libusbhp_init(&handle);
  if(ret != 0) {
    printf("Could not initialise handle.\n");
    return 1;
  }

  libusbhp_register_hotplug_listeners(handle, attach_fn, detach_fn, NULL);

  // 100ms timeout
  struct timeval tv;
  tv.tv_sec = 0;
  tv.tv_usec = 100000;

  while(1) {
    int ret = libusbhp_handle_events_timeout(handle, &tv);
    if(ret) printf("handle_events failed [%d]...\n", ret);
    printf("loop\n");
  }

  libusbhp_exit(handle);

  return 0;
}
