/*
*  qm_Scroller.h
*  QUIMUP graphical text scroller
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_SCROLLER_H
#define QM_SCROLLER_H

#include <QLabel>
#include <QFont>
#include <QColor>
#include <QTimer>
#include <QImage>
#include <QPixmap>
#include <QString>
#include <qevent.h> // note: <QEvent> equals qcoreevent.h
#include <unistd.h> // for usleep()

class qm_Scroller : public QLabel
{
    Q_OBJECT

public:
    qm_Scroller(QWidget *parent = nullptr);
    virtual ~qm_Scroller();

    void render_info( QString artist, QString title = "" );
    void pause(bool);
    void setFont(int, bool, bool);
    void setPalette(QPalette);     // overload
    void setFixedSize(int, int);      // overload

private slots:
    void do_scrollstep();

private:
    void start_scroll();
    void stop_scroll();
    QString
        s_artist_keep,
        s_title_keep;
    bool
        b_init_palette,
        b_init_font,
        b_pause,
        b_scrolling,
        b_step_busy,
        b_fast;
    int
        scrollpos,
        scrollstep_size,
        steptime,
        W_display,
        H_display,
        W_string;        ;
    QColor
        fg_color,
        bg_color;
    QFont
        title_font,
        info_font;
    QPixmap
        px_toshow,
        px_scroller;
    QTimer
        *steploop;
    QLabel
        lb_render;

protected:
    void paintEvent(QPaintEvent*);
    void enterEvent(QEnterEvent*);
    void leaveEvent(QEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void mousePressEvent(QMouseEvent*);
};

#endif //  QM_SCROLLER_H
