// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package koalabear

// expBySqrtExp is equivalent to z.Exp(x, 3f)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expBySqrtExp(x Element) *Element {
	// addition chain:
	//
	//	_10     = 2*1
	//	_11     = 1 + _10
	//	_1100   = _11 << 2
	//	_1111   = _11 + _1100
	//	_111100 = _1111 << 2
	//	return    _11 + _111100
	//
	// Operations: 5 squares 3 multiplies

	// Allocate Temporaries.
	var (
		t0 = new(Element)
	)

	// var t0 Element
	// Step 1: z = x^0x2
	z.Square(&x)

	// Step 2: z = x^0x3
	z.Mul(&x, z)

	// Step 4: t0 = x^0xc
	t0.Square(z)
	for s := 1; s < 2; s++ {
		t0.Square(t0)
	}

	// Step 5: t0 = x^0xf
	t0.Mul(z, t0)

	// Step 7: t0 = x^0x3c
	for s := 0; s < 2; s++ {
		t0.Square(t0)
	}

	// Step 8: z = x^0x3f
	z.Mul(z, t0)

	return z
}

// expByLegendreExp is equivalent to z.Exp(x, 3f800000)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expByLegendreExp(x Element) *Element {
	// addition chain:
	//
	//	_10      = 2*1
	//	_11      = 1 + _10
	//	_110     = 2*_11
	//	_111     = 1 + _110
	//	_1110    = 2*_111
	//	_1111    = 1 + _1110
	//	_1111000 = _1111 << 3
	//	_1111111 = _111 + _1111000
	//	return     _1111111 << 23
	//
	// Operations: 29 squares 4 multiplies

	// Allocate Temporaries.
	var (
		t0 = new(Element)
	)

	// var t0 Element
	// Step 1: z = x^0x2
	z.Square(&x)

	// Step 2: z = x^0x3
	z.Mul(&x, z)

	// Step 3: z = x^0x6
	z.Square(z)

	// Step 4: z = x^0x7
	z.Mul(&x, z)

	// Step 5: t0 = x^0xe
	t0.Square(z)

	// Step 6: t0 = x^0xf
	t0.Mul(&x, t0)

	// Step 9: t0 = x^0x78
	for s := 0; s < 3; s++ {
		t0.Square(t0)
	}

	// Step 10: z = x^0x7f
	z.Mul(z, t0)

	// Step 33: z = x^0x3f800000
	for s := 0; s < 23; s++ {
		z.Square(z)
	}

	return z
}
