#ifndef DEBUG_H
#define DEBUG_H

#define NOOP(...) { (void)0; }
#ifdef NO_ERR
# define ERR(...)   { (void)0; }
#else
# define ERR(...)   \
    { \
	fprintf(stderr, "*** <dbh>: ");\
	fprintf(stderr, __VA_ARGS__); \
	fflush(stderr);\
    }
#endif

#ifdef DEBUG
# define DBG(...)   \
    { \
	fprintf(stderr, "DBG <dbh>: ");\
	fprintf(stderr, __VA_ARGS__); \
	fflush(stderr);\
    }
#else
# define DBG(...)   { (void)0; }
#endif


#ifdef DEBUG_TRACE
# define TRACE(...)   \
    { \
	fprintf(stderr, "TRACE <dbh>: ");\
	fprintf(stderr, __VA_ARGS__); \
	fflush(stderr);\
   }
#else
# define TRACE(...)   { (void)0; }
#endif

#endif
