/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import org.jaudiotagger.tag.id3.Id3FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ID3v24FieldKey {
    ALBUM("TALB", Id3FieldType.TEXT),
    ALBUM_ARTIST("TPE2", Id3FieldType.TEXT),
    ALBUM_ARTIST_SORT("TSO2", Id3FieldType.TEXT),
    ALBUM_SORT("TSOA", Id3FieldType.TEXT),
    AMAZON_ID("TXXX", "ASIN", Id3FieldType.TEXT),
    ARTIST("TPE1", Id3FieldType.TEXT),
    ARTIST_SORT("TSOP", Id3FieldType.TEXT),
    BARCODE("TXXX", "BARCODE", Id3FieldType.TEXT),
    BPM("TBPM", Id3FieldType.TEXT),
    CATALOG_NO("TXXX", "CATALOGNUMBER", Id3FieldType.TEXT),
    COMMENT("COMM", Id3FieldType.TEXT),
    COMPOSER("TCOM", Id3FieldType.TEXT),
    COMPOSER_SORT("TSOC", Id3FieldType.TEXT),
    CONDUCTOR("TPE3", Id3FieldType.TEXT),
    COVER_ART("APIC", Id3FieldType.BINARY),
    CUSTOM1("COMM", "Songs-DB_Custom1", Id3FieldType.TEXT),
    CUSTOM2("COMM", "Songs-DB_Custom2", Id3FieldType.TEXT),
    CUSTOM3("COMM", "Songs-DB_Custom3", Id3FieldType.TEXT),
    CUSTOM4("COMM", "Songs-DB_Custom4", Id3FieldType.TEXT),
    CUSTOM5("COMM", "Songs-DB_Custom5", Id3FieldType.TEXT),
    DISC_NO("TPOS", Id3FieldType.TEXT),
    DISC_TOTAL("TPOS", Id3FieldType.TEXT),
    ENCODER("TENC", Id3FieldType.TEXT),
    FBPM("TXXX", "FBPM", Id3FieldType.TEXT),
    GENRE("TCON", Id3FieldType.TEXT),
    GROUPING("TIT1", Id3FieldType.TEXT),
    ISRC("TSRC", Id3FieldType.TEXT),
    IS_COMPILATION("TCMP", Id3FieldType.TEXT),
    KEY("TKEY", Id3FieldType.TEXT),
    LANGUAGE("TLAN", Id3FieldType.TEXT),
    LYRICIST("TEXT", Id3FieldType.TEXT),
    LYRICS("USLT", Id3FieldType.TEXT),
    MEDIA("TMED", Id3FieldType.TEXT),
    MOOD("TMOO", Id3FieldType.TEXT),
    MUSICBRAINZ_ARTISTID("TXXX", "MusicBrainz Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_DISC_ID("TXXX", "MusicBrainz Disc Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEARTISTID("TXXX", "MusicBrainz Album Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEID("TXXX", "MusicBrainz Album Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_COUNTRY("TXXX", "MusicBrainz Album Release Country", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_GROUP_ID("TXXX", "MusicBrainz Release Group Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_STATUS("TXXX", "MusicBrainz Album Status", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_TYPE("TXXX", "MusicBrainz Album Type", Id3FieldType.TEXT),
    MUSICBRAINZ_TRACK_ID("UFID", "http://musicbrainz.org", Id3FieldType.TEXT),
    MUSICBRAINZ_WORK_ID("TXXX", "MusicBrainz Work Id", Id3FieldType.TEXT),
    MUSICIP_ID("TXXX", "MusicIP PUID", Id3FieldType.TEXT),
    OCCASION("COMM", "Songs-DB_Occasion", Id3FieldType.TEXT),
    ORIGINAL_ALBUM("TOAL", Id3FieldType.TEXT),
    ORIGINAL_ARTIST("TOPE", Id3FieldType.TEXT),
    ORIGINAL_LYRICIST("TOLY", Id3FieldType.TEXT),
    ORIGINAL_YEAR("TDOR", Id3FieldType.TEXT),
    QUALITY("COMM", "Songs-DB_Preference", Id3FieldType.TEXT),
    RATING("POPM", Id3FieldType.TEXT),
    RECORD_LABEL("TPUB", Id3FieldType.TEXT),
    REMIXER("TPE4", Id3FieldType.TEXT),
    SCRIPT("TXXX", "SCRIPT", Id3FieldType.TEXT),
    TAGS("TXXX", "TAGS", Id3FieldType.TEXT),
    TEMPO("COMM", "Songs-DB_Tempo", Id3FieldType.TEXT),
    TITLE("TIT2", Id3FieldType.TEXT),
    TITLE_SORT("TSOT", Id3FieldType.TEXT),
    TRACK("TRCK", Id3FieldType.TEXT),
    TRACK_TOTAL("TRCK", Id3FieldType.TEXT),
    URL_DISCOGS_ARTIST_SITE("WXXX", "DISCOGS_ARTIST", Id3FieldType.TEXT),
    URL_DISCOGS_RELEASE_SITE("WXXX", "DISCOGS_RELEASE", Id3FieldType.TEXT),
    URL_LYRICS_SITE("WXXX", "LYRICS_SITE", Id3FieldType.TEXT),
    URL_OFFICIAL_ARTIST_SITE("WOAR", Id3FieldType.TEXT),
    URL_OFFICIAL_RELEASE_SITE("WXXX", "OFFICIAL_RELEASE", Id3FieldType.TEXT),
    URL_WIKIPEDIA_ARTIST_SITE("WXXX", "WIKIPEDIA_ARTIST", Id3FieldType.TEXT),
    URL_WIKIPEDIA_RELEASE_SITE("WXXX", "WIKIPEDIA_RELEASE", Id3FieldType.TEXT),
    YEAR("TDRC", Id3FieldType.TEXT),
    ENGINEER("TIPL", "engineer", Id3FieldType.TEXT),
    PRODUCER("TIPL", "producer", Id3FieldType.TEXT),
    MIXER("TIPL", "mix", Id3FieldType.TEXT),
    DJMIXER("TIPL", "DJ-mix", Id3FieldType.TEXT),
    ARRANGER("TIPL", "arranger", Id3FieldType.TEXT);

    private String fieldName;
    private String frameId;
    private String subId;
    private Id3FieldType fieldType;

    private ID3v24FieldKey(String frameId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.fieldType = fieldType;
        this.fieldName = frameId;
    }

    private ID3v24FieldKey(String frameId, String subId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.subId = subId;
        this.fieldType = fieldType;
        this.fieldName = frameId + ":" + subId;
    }

    public Id3FieldType getFieldType() {
        return this.fieldType;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public String getSubId() {
        return this.subId;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

