/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggInfoReader;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.fix.Fix;
import org.jaudiotagger.tag.Tag;

public class OggFileReader
extends AudioFileReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private OggInfoReader ir;
    private OggVorbisTagReader vtr;

    public OggFileReader() {
        this.ir = new OggInfoReader();
        this.vtr = new OggVorbisTagReader();
    }

    public OggFileReader(Fix fix) {
        Fix fix1 = fix;
        this.ir = new OggInfoReader();
        this.vtr = new OggVorbisTagReader(fix);
    }

    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        return this.ir.read(raf);
    }

    protected Tag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        return this.vtr.read(raf);
    }

    public OggPageHeader readOggPageHeader(RandomAccessFile raf, int count) throws CannotReadException, IOException {
        OggPageHeader pageHeader = OggPageHeader.read(raf);
        while (count > 0) {
            raf.seek(raf.getFilePointer() + (long)pageHeader.getPageLength());
            pageHeader = OggPageHeader.read(raf);
            --count;
        }
        return pageHeader;
    }

    public void summarizeOggPageHeaders(File oggFile) throws CannotReadException, IOException {
        RandomAccessFile raf = new RandomAccessFile(oggFile, "r");
        while (raf.getFilePointer() < raf.length()) {
            System.out.println("pageHeader starts at absolute file position:" + raf.getFilePointer());
            OggPageHeader pageHeader = OggPageHeader.read(raf);
            System.out.println("pageHeader finishes at absolute file position:" + raf.getFilePointer());
            System.out.println(pageHeader + "\n");
            raf.seek(raf.getFilePointer() + (long)pageHeader.getPageLength());
        }
        System.out.println("Raf File Pointer at:" + raf.getFilePointer() + "File Size is:" + raf.length());
        raf.close();
    }

    public void shortSummarizeOggPageHeaders(File oggFile) throws CannotReadException, IOException {
        RandomAccessFile raf = new RandomAccessFile(oggFile, "r");
        int i = 0;
        while (raf.getFilePointer() < raf.length()) {
            System.out.println("pageHeader starts at absolute file position:" + raf.getFilePointer());
            OggPageHeader pageHeader = OggPageHeader.read(raf);
            System.out.println("pageHeader finishes at absolute file position:" + raf.getFilePointer());
            System.out.println(pageHeader + "\n");
            raf.seek(raf.getFilePointer() + (long)pageHeader.getPageLength());
            if (++i < 5) continue;
            break;
        }
        System.out.println("Raf File Pointer at:" + raf.getFilePointer() + "File Size is:" + raf.length());
        raf.close();
    }
}

