/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;

public class ModificationHandler
implements AudioFileModificationListener {
    private Vector<AudioFileModificationListener> listeners = new Vector();

    public void addAudioFileModificationListener(AudioFileModificationListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void fileModified(AudioFile original, File temporary) throws ModifyVetoException {
        Iterator<AudioFileModificationListener> i$ = this.listeners.iterator();
        while (i$.hasNext()) {
            AudioFileModificationListener listener;
            AudioFileModificationListener current = listener = i$.next();
            try {
                current.fileModified(original, temporary);
            }
            catch (ModifyVetoException e) {
                this.vetoThrown(current, original, e);
                throw e;
            }
        }
    }

    public void fileOperationFinished(File result) {
        Iterator<AudioFileModificationListener> i$ = this.listeners.iterator();
        while (i$.hasNext()) {
            AudioFileModificationListener listener;
            AudioFileModificationListener current = listener = i$.next();
            current.fileOperationFinished(result);
        }
    }

    public void fileWillBeModified(AudioFile file, boolean delete) throws ModifyVetoException {
        Iterator<AudioFileModificationListener> i$ = this.listeners.iterator();
        while (i$.hasNext()) {
            AudioFileModificationListener listener;
            AudioFileModificationListener current = listener = i$.next();
            try {
                current.fileWillBeModified(file, delete);
            }
            catch (ModifyVetoException e) {
                this.vetoThrown(current, file, e);
                throw e;
            }
        }
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public void vetoThrown(AudioFileModificationListener cause, AudioFile original, ModifyVetoException veto) {
        Iterator<AudioFileModificationListener> i$ = this.listeners.iterator();
        while (i$.hasNext()) {
            AudioFileModificationListener listener;
            AudioFileModificationListener current = listener = i$.next();
            current.vetoThrown(cause, original, veto);
        }
    }
}

