/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mediautil.gen.Log;
import mediautil.image.jpeg.LLJTran;
import mediautil.image.jpeg.LLJTranException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImagesUtil.class);

    public static InputStream getAutoRotateInputStreamImage(InputStream input, int exifOrientation) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImagesUtil.auto(input, baos, exifOrientation);
        }
        catch (Exception e) {
            logger.error("Error in auto rotate", e);
            return null;
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static void auto(InputStream input, OutputStream output, int exifOrientation) throws IOException, LLJTranException {
        int op = 0;
        switch (exifOrientation) {
            case 1: {
                op = 0;
                break;
            }
            case 2: {
                op = 1;
                break;
            }
            case 3: {
                op = 6;
                break;
            }
            case 4: {
                op = 2;
                break;
            }
            case 5: {
                op = 3;
                break;
            }
            case 6: {
                op = 5;
                break;
            }
            case 7: {
                op = 4;
                break;
            }
            case 8: {
                op = 7;
                break;
            }
            default: {
                op = 0;
            }
        }
        Log.debugLevel = 0;
        LLJTran llj = new LLJTran(input);
        llj.read(3, true);
        int options = 793;
        llj.transform(op, options);
        BufferedOutputStream out = new BufferedOutputStream(output);
        llj.save(out, 768);
        ((OutputStream)out).close();
        input.close();
        llj.freeMemory();
    }
}

