/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.pms.Messages;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerFactory;
import net.pms.newgui.ImagePanel;
import net.pms.newgui.LooksFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNodeSettings
extends DefaultMutableTreeNode {
    private static final Logger logger = LoggerFactory.getLogger(TreeNodeSettings.class);
    private static final long serialVersionUID = -337606760204027449L;
    private Player p;
    private JComponent otherConfigPanel;
    private boolean enable = true;
    private JPanel warningPanel;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Player getPlayer() {
        return this.p;
    }

    public TreeNodeSettings(String name, Player p, JComponent otherConfigPanel) {
        super(name);
        this.p = p;
        this.otherConfigPanel = otherConfigPanel;
    }

    public String id() {
        if (this.p != null) {
            return this.p.id();
        }
        if (this.otherConfigPanel != null) {
            return "" + this.otherConfigPanel.hashCode();
        }
        return null;
    }

    public JComponent getConfigPanel() {
        if (this.p != null) {
            if (PlayerFactory.getPlayers().contains(this.p)) {
                return this.p.config();
            }
            return this.getWarningPanel();
        }
        if (this.otherConfigPanel != null) {
            return this.otherConfigPanel;
        }
        return new JPanel();
    }

    public JPanel getWarningPanel() {
        if (this.warningPanel == null) {
            BufferedImage bi = null;
            try {
                bi = ImageIO.read(LooksFrame.class.getResourceAsStream("/resources/images/messagebox_warning-220.png"));
            }
            catch (IOException e) {
                logger.debug("Caught exception", e);
            }
            ImagePanel ip = new ImagePanel(bi);
            FormLayout layout = new FormLayout("0:grow, pref, 0:grow", "pref, 3dlu, pref, 12dlu, pref, 3dlu, pref, 3dlu, p, 3dlu, p, 3dlu, p");
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.setOpaque(false);
            CellConstraints cc = new CellConstraints();
            JLabel jl = new JLabel(Messages.getString("TreeNodeSettings.4"));
            builder.add((Component)jl, cc.xy(2, 1, "center, fill"));
            jl.setFont(jl.getFont().deriveFont(1));
            builder.add((Component)ip, cc.xy(2, 3, "center, fill"));
            this.warningPanel = builder.getPanel();
        }
        return this.warningPanel;
    }
}

