/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImagePanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ImagePanel.class);
    private static final long serialVersionUID = -6709086531128513425L;
    protected RenderedImage source = null;
    protected int originX = 0;
    protected int originY = 0;

    public ImagePanel() {
        this((RenderedImage)null);
    }

    public ImagePanel(RenderedImage renderedimage) {
        this.setLayout(null);
        if (renderedimage != null) {
            this.source = renderedimage;
            int i = this.source.getWidth();
            int j = this.source.getHeight();
            Insets insets = this.getInsets();
            Dimension dimension = new Dimension(i + insets.left + insets.right, j + insets.top + insets.bottom);
            this.setPreferredSize(dimension);
        }
    }

    public void setOrigin(int i, int j) {
        this.originX = i;
        this.originY = j;
        this.repaint();
    }

    public Point getOrigin() {
        return new Point(this.originX, this.originY);
    }

    public void set(RenderedImage renderedimage) {
        this.source = renderedimage;
        int i = 0;
        int j = 0;
        if (renderedimage != null) {
            i = this.source.getWidth();
            j = this.source.getHeight();
        }
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(i + insets.left + insets.right, j + insets.top + insets.bottom);
        this.setPreferredSize(dimension);
        this.revalidate();
        this.repaint();
    }

    public void set(RenderedImage renderedimage, int i, int j) {
        if (renderedimage == null) {
            this.originX = 0;
            this.originY = 0;
        } else {
            this.originX = i;
            this.originY = j;
        }
        this.set(renderedimage);
    }

    public RenderedImage getSource() {
        return this.source;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D graphics2d = (Graphics2D)g;
        if (this.source == null) {
            graphics2d.setColor(this.getBackground());
            graphics2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Rectangle rectangle = graphics2d.getClipBounds();
        graphics2d.setColor(this.getBackground());
        graphics2d.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = this.getInsets();
        int i = insets.left + this.originX;
        int j = insets.top + this.originY;
        try {
            graphics2d.drawRenderedImage(this.source, AffineTransform.getTranslateInstance(i, j));
        }
        catch (OutOfMemoryError e) {
            logger.debug("Caught exception", e);
        }
    }
}

