/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.network.NetworkConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPNPHelper {
    private static final Logger logger = LoggerFactory.getLogger(UPNPHelper.class);
    private static final String CRLF = "\r\n";
    private static final String ALIVE = "ssdp:alive";
    private static final String IPV4_UPNP_HOST = "239.255.255.250";
    private static final String IPV6_UPNP_HOST = "[FF02::C]";
    private static final int UPNP_PORT = 1900;
    private static final String BYEBYE = "ssdp:byebye";
    private static Thread listenerThread;
    private static Thread aliveThread;
    private static final PmsConfiguration configuration;

    private UPNPHelper() {
    }

    private static void sendDiscover(String host, int port, String st) throws IOException {
        String usn = PMS.get().usn();
        String serverHost = PMS.get().getServer().getHost();
        int serverPort = PMS.get().getServer().getPort();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        usn = st.equals(usn) ? "" : usn + "::";
        StringBuilder discovery = new StringBuilder();
        discovery.append("HTTP/1.1 200 OK").append(CRLF);
        discovery.append("CACHE-CONTROL: max-age=1200").append(CRLF);
        discovery.append("DATE: ").append(sdf.format(new Date(System.currentTimeMillis()))).append(" GMT").append(CRLF);
        discovery.append("LOCATION: http://").append(serverHost).append(":").append(serverPort).append("/description/fetch").append(CRLF);
        discovery.append("SERVER: ").append(PMS.get().getServerName()).append(CRLF);
        discovery.append("ST: ").append(st).append(CRLF);
        discovery.append("EXT: ").append(CRLF);
        discovery.append("USN: ").append(usn).append(st).append(CRLF);
        discovery.append("Content-Length: 0").append(CRLF).append(CRLF);
        UPNPHelper.sendReply(host, port, discovery.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendReply(String host, int port, String msg) {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            InetAddress inetAddr = InetAddress.getByName(host);
            DatagramPacket dgmPacket = new DatagramPacket(msg.getBytes(), msg.length(), inetAddr, port);
            logger.trace("Sending this reply [" + host + ":" + port + "]: " + StringUtils.replace(msg, CRLF, "<CRLF>"));
            datagramSocket.send(dgmPacket);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            logger.debug("Error sending reply", e);
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendAlive() {
        logger.debug("Sending ALIVE...");
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = UPNPHelper.getNewMulticastSocket();
            InetAddress upnpAddress = UPNPHelper.getUPNPAddress();
            multicastSocket.joinGroup(upnpAddress);
            UPNPHelper.sendMessage(multicastSocket, "upnp:rootdevice", ALIVE);
            UPNPHelper.sendMessage(multicastSocket, PMS.get().usn(), ALIVE);
            UPNPHelper.sendMessage(multicastSocket, "urn:schemas-upnp-org:device:MediaServer:1", ALIVE);
            UPNPHelper.sendMessage(multicastSocket, "urn:schemas-upnp-org:service:ContentDirectory:1", ALIVE);
            UPNPHelper.sendMessage(multicastSocket, "urn:schemas-upnp-org:service:ConnectionManager:1", ALIVE);
        }
        catch (IOException e) {
            logger.debug("Error sending ALIVE message", e);
        }
        finally {
            if (multicastSocket != null) {
                try {
                    InetAddress upnpAddress = UPNPHelper.getUPNPAddress();
                    multicastSocket.leaveGroup(upnpAddress);
                }
                catch (IOException iOException) {}
                multicastSocket.disconnect();
                multicastSocket.close();
            }
        }
    }

    private static MulticastSocket getNewMulticastSocket() throws IOException {
        NetworkInterface networkInterface = NetworkConfiguration.getInstance().getNetworkInterfaceByServerName();
        if (networkInterface == null) {
            networkInterface = PMS.get().getServer().getNetworkInterface();
        }
        if (networkInterface == null) {
            throw new IOException("No usable network interface found for UPnP multicast");
        }
        ArrayList<InetAddress> usableAddresses = new ArrayList<InetAddress>();
        ArrayList<InetAddress> networkInterfaceAddresses = Collections.list(networkInterface.getInetAddresses());
        for (InetAddress inetAddress : networkInterfaceAddresses) {
            if (inetAddress == null || !(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
            usableAddresses.add(inetAddress);
        }
        if (usableAddresses.isEmpty()) {
            throw new IOException("No usable addresses found for UPnP multicast");
        }
        InetSocketAddress localAddress = new InetSocketAddress((InetAddress)usableAddresses.get(0), 0);
        MulticastSocket ssdpSocket = new MulticastSocket(localAddress);
        ssdpSocket.setReuseAddress(true);
        logger.trace("Sending message from multicast socket on network interface: " + ssdpSocket.getNetworkInterface());
        logger.trace("Multicast socket is on interface: " + ssdpSocket.getInterface());
        ssdpSocket.setTimeToLive(32);
        logger.trace("Socket Timeout: " + ssdpSocket.getSoTimeout());
        logger.trace("Socket TTL: " + ssdpSocket.getTimeToLive());
        return ssdpSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendByeBye() {
        logger.info("Sending BYEBYE...");
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = UPNPHelper.getNewMulticastSocket();
            InetAddress upnpAddress = UPNPHelper.getUPNPAddress();
            multicastSocket.joinGroup(upnpAddress);
            UPNPHelper.sendMessage(multicastSocket, "upnp:rootdevice", BYEBYE);
            UPNPHelper.sendMessage(multicastSocket, "urn:schemas-upnp-org:device:MediaServer:1", BYEBYE);
            UPNPHelper.sendMessage(multicastSocket, "urn:schemas-upnp-org:service:ContentDirectory:1", BYEBYE);
            UPNPHelper.sendMessage(multicastSocket, "urn:schemas-upnp-org:service:ConnectionManager:1", BYEBYE);
        }
        catch (IOException e) {
            logger.debug("Error sending BYEBYE message", e);
        }
        finally {
            if (multicastSocket != null) {
                try {
                    InetAddress upnpAddress = UPNPHelper.getUPNPAddress();
                    multicastSocket.leaveGroup(upnpAddress);
                }
                catch (IOException iOException) {}
                multicastSocket.disconnect();
                multicastSocket.close();
            }
        }
    }

    private static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void sendMessage(DatagramSocket socket, String nt, String message) throws IOException {
        String msg = UPNPHelper.buildMsg(nt, message);
        InetAddress upnpAddress = UPNPHelper.getUPNPAddress();
        DatagramPacket ssdpPacket = new DatagramPacket(msg.getBytes(), msg.length(), upnpAddress, 1900);
        socket.send(ssdpPacket);
    }

    public static void listen() throws IOException {
        Runnable rAlive = new Runnable(){

            @Override
            public void run() {
                int delay = 10000;
                while (true) {
                    UPNPHelper.sleep(delay);
                    UPNPHelper.sendAlive();
                    switch (delay) {
                        case 10000: {
                            delay = 20000;
                            break;
                        }
                        case 20000: {
                            delay = 180000;
                        }
                    }
                }
            }
        };
        aliveThread = new Thread(rAlive, "UPNP-AliveMessageSender");
        aliveThread.start();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bindErrorReported = false;
                while (true) {
                    InetAddress upnpAddress;
                    MulticastSocket multicastSocket = null;
                    try {
                        multicastSocket = new MulticastSocket(configuration.getUpnpPort());
                        if (bindErrorReported) {
                            logger.warn("Finally, acquiring port " + configuration.getUpnpPort() + " was successful!");
                        }
                        NetworkInterface ni = NetworkConfiguration.getInstance().getNetworkInterfaceByServerName();
                        try {
                            if (ni != null) {
                                multicastSocket.setNetworkInterface(ni);
                            } else if (PMS.get().getServer().getNetworkInterface() != null) {
                                multicastSocket.setNetworkInterface(PMS.get().getServer().getNetworkInterface());
                                logger.trace("Setting multicast network interface: " + PMS.get().getServer().getNetworkInterface());
                            }
                        }
                        catch (SocketException e) {
                            // empty catch block
                        }
                        multicastSocket.setTimeToLive(4);
                        multicastSocket.setReuseAddress(true);
                        InetAddress upnpAddress2 = UPNPHelper.getUPNPAddress();
                        multicastSocket.joinGroup(upnpAddress2);
                        while (true) {
                            int remotePort;
                            String remoteAddr;
                            byte[] buf = new byte[1024];
                            DatagramPacket receivePacket = new DatagramPacket(buf, buf.length);
                            multicastSocket.receive(receivePacket);
                            String s = new String(receivePacket.getData());
                            InetAddress address = receivePacket.getAddress();
                            if (s.startsWith("M-SEARCH")) {
                                remoteAddr = address.getHostAddress();
                                remotePort = receivePacket.getPort();
                                if (!configuration.getIpFiltering().allowed(address)) continue;
                                logger.trace("Receiving a M-SEARCH from [" + remoteAddr + ":" + remotePort + "]");
                                if (StringUtils.indexOf((CharSequence)s, "urn:schemas-upnp-org:service:ContentDirectory:1") > 0) {
                                    UPNPHelper.sendDiscover(remoteAddr, remotePort, "urn:schemas-upnp-org:service:ContentDirectory:1");
                                }
                                if (StringUtils.indexOf((CharSequence)s, "upnp:rootdevice") > 0) {
                                    UPNPHelper.sendDiscover(remoteAddr, remotePort, "upnp:rootdevice");
                                }
                                if (StringUtils.indexOf((CharSequence)s, "urn:schemas-upnp-org:device:MediaServer:1") > 0) {
                                    UPNPHelper.sendDiscover(remoteAddr, remotePort, "urn:schemas-upnp-org:device:MediaServer:1");
                                }
                                if (StringUtils.indexOf((CharSequence)s, "ssdp:all") > 0) {
                                    UPNPHelper.sendDiscover(remoteAddr, remotePort, "urn:schemas-upnp-org:device:MediaServer:1");
                                }
                                if (StringUtils.indexOf((CharSequence)s, PMS.get().usn()) <= 0) continue;
                                UPNPHelper.sendDiscover(remoteAddr, remotePort, PMS.get().usn());
                                continue;
                            }
                            if (!s.startsWith("NOTIFY")) continue;
                            remoteAddr = address.getHostAddress();
                            remotePort = receivePacket.getPort();
                            logger.trace("Receiving a NOTIFY from [" + remoteAddr + ":" + remotePort + "]");
                        }
                    }
                    catch (BindException e) {
                        if (!bindErrorReported) {
                            logger.error("Unable to bind to " + configuration.getUpnpPort() + ", which means that PMS will not automatically appear on your renderer! " + "This usually means that another program occupies the port. Please " + "stop the other program and free up the port. " + "PMS will keep trying to bind to it...[" + e.getMessage() + "]");
                        }
                        bindErrorReported = true;
                        UPNPHelper.sleep(5000);
                        if (multicastSocket == null) continue;
                        try {
                            upnpAddress = UPNPHelper.getUPNPAddress();
                            multicastSocket.leaveGroup(upnpAddress);
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        multicastSocket.disconnect();
                        multicastSocket.close();
                        continue;
                    }
                    catch (IOException e) {
                        try {
                            logger.error("UPNP network exception", e);
                            UPNPHelper.sleep(1000);
                            continue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (multicastSocket == null) continue;
                            try {
                                upnpAddress = UPNPHelper.getUPNPAddress();
                                multicastSocket.leaveGroup(upnpAddress);
                            }
                            catch (IOException iOException) {}
                            multicastSocket.disconnect();
                            multicastSocket.close();
                            continue;
                        }
                    }
                    break;
                }
            }
        };
        listenerThread = new Thread(r, "UPNPHelper");
        listenerThread.start();
    }

    public static void shutDownListener() {
        listenerThread.interrupt();
        aliveThread.interrupt();
    }

    private static String buildMsg(String nt, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("NOTIFY * HTTP/1.1").append(CRLF);
        sb.append("HOST: ").append(IPV4_UPNP_HOST).append(":").append(1900).append(CRLF);
        sb.append("NT: ").append(nt).append(CRLF);
        sb.append("NTS: ").append(message).append(CRLF);
        if (message.equals(ALIVE)) {
            sb.append("LOCATION: http://").append(PMS.get().getServer().getHost()).append(":").append(PMS.get().getServer().getPort()).append("/description/fetch").append(CRLF);
        }
        sb.append("USN: ").append(PMS.get().usn());
        if (!nt.equals(PMS.get().usn())) {
            sb.append("::").append(nt);
        }
        sb.append(CRLF);
        if (message.equals(ALIVE)) {
            sb.append("CACHE-CONTROL: max-age=1800").append(CRLF);
        }
        if (message.equals(ALIVE)) {
            sb.append("SERVER: ").append(PMS.get().getServerName()).append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }

    private static InetAddress getUPNPAddress() throws IOException {
        return InetAddress.getByName(IPV4_UPNP_HOST);
    }

    static {
        configuration = PMS.getConfiguration();
    }
}

