/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.ChapterFileTranscodeVirtualFolder;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTranscodeVirtualFolder
extends VirtualFolder {
    private static final Logger logger = LoggerFactory.getLogger(FileTranscodeVirtualFolder.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();

    @Deprecated
    public FileTranscodeVirtualFolder(String name, String thumbnailIcon, boolean copy) {
        super(name, thumbnailIcon);
    }

    public FileTranscodeVirtualFolder(String name, String thumbnailIcon) {
        super(name, thumbnailIcon);
    }

    private DLNAResource createResourceWithAudioSubtitlePlayer(DLNAResource original, DLNAMediaAudio audio, DLNAMediaSubtitle subtitle, Player player) {
        DLNAResource copy = original.clone();
        copy.setMedia(original.getMedia());
        copy.setNoName(true);
        copy.setMediaAudio(audio);
        copy.setMediaSubtitle(subtitle);
        copy.setPlayer(player);
        return copy;
    }

    private boolean isSeekable(DLNAResource dlna) {
        Player player = dlna.getPlayer();
        return player == null || player.isTimeSeekable();
    }

    private void addChapterFolder(DLNAResource dlna) {
        int chapterInterval;
        if (!dlna.getFormat().isVideo()) {
            return;
        }
        int n = chapterInterval = configuration.isChapterSupport() ? configuration.getChapterInterval() : -1;
        if (chapterInterval > 0 && this.isSeekable(dlna)) {
            double duration = dlna.getMedia().getDurationInSeconds();
            if (duration != 0.0 && duration <= (double)(chapterInterval * 60)) {
                return;
            }
            ChapterFileTranscodeVirtualFolder chapterFolder = new ChapterFileTranscodeVirtualFolder(String.format(Messages.getString("FileTranscodeVirtualFolder.1"), dlna.getDisplayName()), null, chapterInterval);
            DLNAResource copy = dlna.clone();
            copy.setNoName(true);
            chapterFolder.addChildInternal(copy);
            this.addChildInternal(chapterFolder);
        }
    }

    @Override
    protected void resolveOnce() {
        if (this.getChildren().size() == 1) {
            DLNAResource child = this.getChildren().get(0);
            child.resolve();
            RendererConfiguration renderer = null;
            if (this.getParent() != null) {
                renderer = this.getParent().getDefaultRenderer();
            }
            if (child.getFormat() != null && (child.getFormat().isCompatible(child.getMedia(), renderer) || child.isSkipTranscode())) {
                if (renderer != null) {
                    logger.trace("Duplicating {} for direct streaming to renderer: {}", (Object)child.getName(), (Object)renderer.getRendererName());
                }
                DLNAResource noTranscode = this.createResourceWithAudioSubtitlePlayer(child, null, null, null);
                this.addChildInternal(noTranscode);
                this.addChapterFolder(noTranscode);
            }
            ArrayList<DLNAResource> copies = new ArrayList<DLNAResource>();
            ArrayList<DLNAMediaAudio> audioTracks = new ArrayList<DLNAMediaAudio>(child.getMedia().getAudioTracksList());
            ArrayList<DLNAMediaSubtitle> subtitleTracks = new ArrayList<DLNAMediaSubtitle>(child.getMedia().getSubtitleTracksList());
            if (audioTracks.isEmpty()) {
                audioTracks.add(null);
            }
            if (subtitleTracks.isEmpty()) {
                subtitleTracks.add(null);
            } else {
                DLNAMediaSubtitle noSubtitle = new DLNAMediaSubtitle();
                noSubtitle.setId(-1);
                subtitleTracks.add(noSubtitle);
            }
            for (DLNAMediaAudio audio : audioTracks) {
                for (DLNAMediaSubtitle subtitle : subtitleTracks) {
                    DLNAResource temp = this.createResourceWithAudioSubtitlePlayer(child, audio, subtitle, null);
                    ArrayList<Player> players = PlayerFactory.getPlayers(temp);
                    for (Player player : players) {
                        DLNAResource copy = this.createResourceWithAudioSubtitlePlayer(child, audio, subtitle, player);
                        copies.add(copy);
                    }
                }
            }
            Collections.sort(copies, new ResourceSort(PlayerFactory.getAllPlayers()));
            for (DLNAResource dlna : copies) {
                logger.trace("Adding {}: audio: {}, subtitle: {}, player: {}", dlna.getName(), dlna.getMediaAudio(), dlna.getMediaSubtitle(), dlna.getPlayer() != null ? dlna.getPlayer().name() : null);
                this.addChildInternal(dlna);
                this.addChapterFolder(dlna);
            }
        }
    }

    private class ResourceSort
    implements Comparator<DLNAResource> {
        private ArrayList<Player> players;

        ResourceSort(ArrayList<Player> players) {
            this.players = players;
        }

        private String getMediaAudioLanguage(DLNAResource dlna) {
            return dlna.getMediaAudio() == null ? null : dlna.getMediaAudio().getLang();
        }

        private String getMediaSubtitleLanguage(DLNAResource dlna) {
            return dlna.getMediaSubtitle() == null ? null : dlna.getMediaSubtitle().getLang();
        }

        private int compareLanguage(String lang1, String lang2) {
            if (lang1 == null && lang2 == null) {
                return 0;
            }
            if (lang1 != null && lang2 != null) {
                return lang1.compareToIgnoreCase(lang2);
            }
            if (lang1 == null) {
                return -1;
            }
            return 1;
        }

        @Override
        public int compare(DLNAResource dlna1, DLNAResource dlna2) {
            Integer playerIndex2;
            Integer playerIndex1 = this.players.indexOf(dlna1.getPlayer());
            if (!playerIndex1.equals(playerIndex2 = Integer.valueOf(this.players.indexOf(dlna2.getPlayer())))) {
                return playerIndex1.compareTo(playerIndex2);
            }
            int cmpAudioLang = this.compareLanguage(this.getMediaAudioLanguage(dlna1), this.getMediaAudioLanguage(dlna2));
            if (cmpAudioLang != 0) {
                return cmpAudioLang;
            }
            int cmpSubtitleLang = this.compareLanguage(this.getMediaSubtitleLanguage(dlna1), this.getMediaSubtitleLanguage(dlna2));
            return cmpSubtitleLang;
        }
    }
}

