/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import net.pms.configuration.ConfigurationReader;
import net.pms.configuration.ProgramPaths;
import org.apache.commons.configuration.Configuration;

class ConfigurationProgramPaths
implements ProgramPaths {
    private static final String KEY_VLC_PATH = "vlc_path";
    private static final String KEY_EAC3TO_PATH = "eac3to_path";
    private static final String KEY_MENCODER_PATH = "mencoder_path";
    private static final String KEY_FFMPEG_PATH = "ffmpeg_path";
    private static final String KEY_MPLAYER_PATH = "mplayer_path";
    private static final String KEY_TSMUXER_PATH = "tsmuxer_path";
    private static final String KEY_FLAC_PATH = "flac_path";
    private static final String KEY_DCRAW = "dcraw_path";
    private static final String KEY_IMCONVERT_PATH = "imconvert_path";
    private final Configuration configuration;
    private final ConfigurationReader configurationReader;
    private final ProgramPaths defaults;

    public ConfigurationProgramPaths(Configuration configuration, ProgramPaths defaults) {
        this.configuration = configuration;
        this.configurationReader = new ConfigurationReader(configuration, true);
        this.defaults = defaults;
    }

    @Override
    public String getFfmpegPath() {
        return this.getString(KEY_FFMPEG_PATH, this.defaults.getFfmpegPath());
    }

    @Override
    public String getFlacPath() {
        return this.getString(KEY_FLAC_PATH, this.defaults.getFlacPath());
    }

    @Override
    public String getMencoderPath() {
        return this.getString(KEY_MENCODER_PATH, this.defaults.getMencoderPath());
    }

    @Override
    public String getMplayerPath() {
        return this.getString(KEY_MPLAYER_PATH, this.defaults.getMplayerPath());
    }

    @Override
    public String getTsmuxerPath() {
        return this.getString(KEY_TSMUXER_PATH, this.defaults.getTsmuxerPath());
    }

    @Override
    public String getVlcPath() {
        return this.getString(KEY_VLC_PATH, this.defaults.getVlcPath());
    }

    private String getString(String key, String def) {
        return this.configurationReader.getNonBlankConfigurationString(key, def);
    }

    @Override
    public String getDCRaw() {
        return this.getString(KEY_DCRAW, this.defaults.getDCRaw());
    }
}

