/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.Entry;
import mediautil.image.jpeg.IFD;
import mediautil.image.jpeg.LLJTran;
import mediautil.image.jpeg.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exif
extends AbstractImageInfo<LLJTran> {
    public static final String FORMAT = "Exif";
    public static final byte[] EXIF_MARK = new byte[]{69, 120, 105, 102, 0, 0};
    static final int FIRST_IFD_OFF = 6;
    static final int MIN_JPEG_SIZE = 100;
    public static final int NEWSUBFILETYPE = 254;
    public static final int IMAGEWIDTH = 256;
    public static final int IMAGELENGTH = 257;
    public static final int BITSPERSAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRICINTERPRETATION = 262;
    public static final int FILLORDER = 266;
    public static final int DOCUMENTNAME = 269;
    public static final int IMAGEDESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIPOFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLESPERPIXEL = 277;
    public static final int ROWSPERSTRIP = 278;
    public static final int STRIPBYTECOUNTS = 279;
    public static final int XRESOLUTION = 282;
    public static final int YRESOLUTION = 283;
    public static final int PLANARCONFIGURATION = 284;
    public static final int RESOLUTIONUNIT = 296;
    public static final int TRANSFERFUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATETIME = 306;
    public static final int ARTIST = 315;
    public static final int WHITEPOINT = 318;
    public static final int PRIMARYCHROMATICITIES = 319;
    public static final int SUBIFDS = 330;
    public static final int JPEGTABLES = 347;
    public static final int TRANSFERRANGE = 342;
    public static final int JPEGPROC = 512;
    public static final int JPEGINTERCHANGEFORMAT = 513;
    public static final int JPEGINTERCHANGEFORMATLENGTH = 514;
    public static final int YCBCRCOEFFICIENTS = 529;
    public static final int YCBCRSUBSAMPLING = 530;
    public static final int YCBCRPOSITIONING = 531;
    public static final int REFERENCEBLACKWHITE = 532;
    public static final int CFAREPEATPATTERNDIM = 33421;
    public static final int CFAPATTERN = 33422;
    public static final int BATTERYLEVEL = 33423;
    public static final int COPYRIGHT = 33432;
    public static final int EXPOSURETIME = 33434;
    public static final int FNUMBER = 33437;
    public static final int IPTC_NAA = 33723;
    public static final int EXIFOFFSET = 34665;
    public static final int INTERCOLORPROFILE = 34675;
    public static final int EXPOSUREPROGRAM = 34850;
    public static final int SPECTRALSENSITIVITY = 34852;
    public static final int GPSINFO = 34853;
    public static final int ISOSPEEDRATINGS = 34855;
    public static final int OECF = 34856;
    public static final int EXIFVERSION = 36864;
    public static final int DATETIMEORIGINAL = 36867;
    public static final int DATETIMEDIGITIZED = 36868;
    public static final int COMPONENTSCONFIGURATION = 37121;
    public static final int COMPRESSEDBITSPERPIXEL = 37122;
    public static final int SHUTTERSPEEDVALUE = 37377;
    public static final int APERTUREVALUE = 37378;
    public static final int BRIGHTNESSVALUE = 37379;
    public static final int EXPOSUREBIASVALUE = 37380;
    public static final int MAXAPERTUREVALUE = 37381;
    public static final int SUBJECTDISTANCE = 37382;
    public static final int METERINGMODE = 37383;
    public static final int LIGHTSOURCE = 37384;
    public static final int FLASH = 37385;
    public static final int FOCALLENGTH = 37386;
    public static final int MAKERNOTE = 37500;
    public static final int USERCOMMENT = 37510;
    public static final int SUBSECTIME = 37520;
    public static final int SUBSECTIMEORIGINAL = 37521;
    public static final int SUBSECTIMEDIGITIZED = 37522;
    public static final int FLASHPIXVERSION = 40960;
    public static final int COLORSPACE = 40961;
    public static final int EXIFIMAGEWIDTH = 40962;
    public static final int EXIFIMAGELENGTH = 40963;
    public static final int INTEROPERABILITYOFFSET = 40965;
    public static final int FLASHENERGY = 41483;
    public static final int SPATIALFREQUENCYRESPONSE = 41484;
    public static final int FOCALPLANEXRESOLUTION = 41486;
    public static final int FOCALPLANEYRESOLUTION = 41487;
    public static final int FOCALPLANERESOLUTIONUNIT = 41488;
    public static final int SUBJECTLOCATION = 41492;
    public static final int EXPOSUREINDEX = 41493;
    public static final int SENSINGMETHOD = 41495;
    public static final int FILESOURCE = 41728;
    public static final int SCENETYPE = 41729;
    public static final int FOCALLENGTHIN35MMFILM = 41989;
    public static final int SHARPNESS = 41994;
    public static final int CUSTOMRENDERED = 41985;
    public static final int EXPOSUREMODE = 41986;
    public static final int WHITEBALANCE = 41987;
    public static final int DIGITALZOOMRATIO = 41988;
    public static final int SATURATION = 41993;
    public static final int SCENECAPTURETYPE = 41990;
    public static final int GAINCONTROL = 41991;
    public static final int CONTRAST = 41992;
    public static final int PRINTMODE = 50341;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int ORIENTATION_TOPLEFT = 1;
    public static final int ORIENTATION_TOPRIGHT = 2;
    public static final int ORIENTATION_BOTRIGHT = 3;
    public static final int ORIENTATION_BOTLEFT = 4;
    public static final int ORIENTATION_LEFTTOP = 5;
    public static final int ORIENTATION_RIGHTTOP = 6;
    public static final int ORIENTATION_RIGHTBOT = 7;
    public static final int ORIENTATION_LEFTBOT = 8;
    public static final String[] EXPOSURE_PROGRAMS = new String[]{"P0", "P1", "Normal", "P3", "P5"};
    public static final String[] METERING_MODES = new String[]{"P0", "P1", "Normal", "P3", "PATTERN"};
    static final int DIR_ENTRY_SIZE = 12;
    public static final int[] TYPELENGTH = new int[]{1, 1, 2, 4, 8, 1, 1, 2, 4, 8};
    private static final int[] posForOrientationTags = new int[]{-1, 27, 78, 177, 228, 57, 108, 147, 198};
    public static final int[] opToCorrectOrientation = new int[]{-1, 0, 1, 6, 2, 3, 5, 4, 7};
    protected int currentimage;
    protected int version;
    protected IFD[] ifds;

    public Exif(InputStream inputStream, byte[] byArray, int n, String string, String string2, LLJTran lLJTran) throws FileFormatException {
        super(inputStream, byArray, n, string, string2, lLJTran);
    }

    public Exif() {
        this.ifds = new IFD[2];
        this.intel = true;
        this.version = 2;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    public static byte[] getMarkerData() {
        return new byte[]{-1, -31, 0, 40, 69, 120, 105, 102, 0, 0, 73, 73, 42, 0, 8, 0, 0, 0, 1, 0, 15, 1, 2, 0, 5, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 70, 65, 75, 69, 0, 0};
    }

    public Entry getTagValue(int n, boolean bl) {
        return this.getTagValue(new Integer(n), -1, bl);
    }

    public Entry getTagValue(Integer n, int n2, boolean bl) {
        return this.ifds[bl ? 0 : 1] != null ? this.ifds[bl ? 0 : 1].getEntry(n, n2) : null;
    }

    public void setTagValue(int n, int n2, Entry entry, boolean bl) {
        if (this.ifds[bl ? 0 : 1] != null) {
            this.ifds[bl ? 0 : 1].setEntry(new Integer(n), n2, entry);
        }
    }

    @Override
    public int getThumbnailLength() {
        int n = 0;
        Entry entry = this.getTagValue(514, false);
        if (entry == null) {
            entry = this.getTagValue(279, false);
        }
        if (entry != null) {
            n = (Integer)entry.getValue(0);
        }
        return n;
    }

    @Override
    public int getThumbnailOffset() {
        int n = 0;
        Entry entry = this.getTagValue(513, false);
        if (entry == null) {
            entry = this.getTagValue(273, false);
        }
        if (entry != null) {
            n = (Integer)entry.getValue(0) + 6;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveThumbnailImage(OutputStream outputStream) throws IOException {
        int n;
        if (outputStream == null || this.format == null) {
            return false;
        }
        boolean bl = false;
        String string = this.getThumbnailExtension();
        int n2 = this.getThumbnailOffset();
        int n3 = this.getThumbnailLength();
        int n4 = n = "jpeg".equals(string) ? 100 : 0;
        if (n2 > 0 && n3 > n) {
            InputStream inputStream = null;
            try {
                if ("jpeg".equals(string)) {
                    int n5;
                    inputStream = new FileInputStream(this.getImageFile());
                    byte[] byArray = new byte[n3];
                    Exif.skip(inputStream, this.offset + n2);
                    Exif.read(inputStream, byArray);
                    for (n5 = 0; (byArray[n5] != -1 || byArray[n5 + 1] != -40) && n5 < byArray.length - 1; ++n5) {
                    }
                    if (byArray.length - n5 > 100) {
                        outputStream.write(byArray, n5, byArray.length - n5);
                        bl = true;
                    }
                } else if ("bmp".equals(string)) {
                    inputStream = new FileInputStream(this.getImageFile());
                    Exif.skip(inputStream, this.offset + n2);
                    Entry entry = this.getTagValue(279, false);
                    if (entry != null) {
                        n3 = (Integer)entry.getValue(0);
                        int n6 = 0;
                        int n7 = 0;
                        entry = this.getTagValue(256, false);
                        if (entry != null) {
                            n6 = (Integer)entry.getValue(0);
                        }
                        if ((entry = this.getTagValue(257, false)) != null) {
                            n7 = (Integer)entry.getValue(0);
                        }
                        int n8 = 8;
                        entry = this.getTagValue(258, false);
                        if (entry != null) {
                            n8 = (Integer)entry.getValue(0);
                        }
                        int n9 = 3;
                        entry = this.getTagValue(277, false);
                        if (entry != null) {
                            n9 = (Integer)entry.getValue(0);
                        }
                        this.data = new byte[54];
                        System.arraycopy(BMP_SIG, 0, this.data, 0, BMP_SIG.length);
                        n2 = 2;
                        int n10 = n6 * n9 + 3 & 0xFFFFFFFC;
                        n2 = this.i2bsI(n2, 54 + n10 * n7, 4);
                        n2 = this.i2bsI(n2, 0, 4);
                        n2 = this.i2bsI(n2, 54, 4);
                        n2 = this.i2bsI(n2, 40, 4);
                        n2 = this.i2bsI(n2, n6, 4);
                        n2 = this.i2bsI(n2, n7, 4);
                        n2 = this.i2bsI(n2, 1, 2);
                        n2 = this.i2bsI(n2, n9 * n8, 2);
                        n2 = this.i2bsI(n2, 0, 4);
                        n2 = this.i2bsI(n2, n10 * n7, 4);
                        n2 = this.i2bsI(n2, 2834, 4);
                        n2 = this.i2bsI(n2, 2834, 4);
                        n2 = this.i2bsI(n2, 0, 4);
                        n2 = this.i2bsI(n2, 0, 4);
                        outputStream.write(this.data);
                        this.data = new byte[n3];
                        Exif.read(inputStream, this.data);
                        int n11 = n10 - n6 * n9;
                        n10 = n6 * n9;
                        byte[] byArray = null;
                        if (n11 != 0) {
                            byArray = new byte[n11];
                        }
                        for (n2 = n3 - n10; n2 >= 0; n2 -= n10) {
                            for (int i = 0; i < n10; i += 3) {
                                outputStream.write(this.data[n2 + i + 2]);
                                outputStream.write(this.data[n2 + i + 1]);
                                outputStream.write(this.data[n2 + i]);
                            }
                            if (n11 == 0) continue;
                            outputStream.write(byArray);
                        }
                    }
                    bl = true;
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        if (!bl) {
            return super.saveThumbnailImage(outputStream);
        }
        return true;
    }

    @Override
    public String getThumbnailExtension() {
        return this.getTagValue(513, false) != null ? "jpeg" : (this.getTagValue(273, false) != null ? "bmp" : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Icon getThumbnailIcon(Dimension dimension) {
        block35: {
            block34: {
                int n;
                String string = this.getThumbnailExtension();
                int n2 = this.getThumbnailOffset();
                int n3 = this.getThumbnailLength();
                int n4 = n = "jpeg".equals(string) ? 100 : 0;
                if (n2 > 0 && n3 > n) {
                    InputStream inputStream = null;
                    try {
                        if ("jpeg".equals(string)) {
                            int n5;
                            try {
                                inputStream = new FileInputStream(this.getImageFile());
                                byte[] byArray = new byte[n3];
                                Exif.skip(inputStream, this.offset + n2);
                                inputStream.read(byArray);
                                for (n5 = 0; (byArray[n5] != -1 || byArray[n5 + 1] != -40) && n5 < byArray.length - 1; ++n5) {
                                }
                                if (n5 < byArray.length - 100) {
                                    ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(byArray, n5, byArray.length - n5));
                                    return imageIcon;
                                }
                                break block34;
                            }
                            catch (IOException iOException) {
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                if (Log.debugLevel >= 1) {
                                    System.err.println("Bad index " + n5 + " for " + this.getName());
                                }
                                break block34;
                            }
                        }
                        if (!"bmp".equals(string)) break block34;
                        try {
                            inputStream = new FileInputStream(this.getImageFile());
                            Exif.skip(inputStream, this.offset + n2);
                            Entry entry = this.getTagValue(279, false);
                            if (entry != null) {
                                n3 = (Integer)entry.getValue(0);
                                this.data = new byte[n3];
                                Exif.read(inputStream, this.data);
                                int n6 = 0;
                                int n7 = 0;
                                entry = this.getTagValue(256, false);
                                if (entry != null) {
                                    n6 = (Integer)entry.getValue(0);
                                }
                                if ((entry = this.getTagValue(257, false)) != null) {
                                    n7 = (Integer)entry.getValue(0);
                                }
                                int n8 = 8;
                                entry = this.getTagValue(258, false);
                                if (entry != null) {
                                    n8 = (Integer)entry.getValue(0);
                                }
                                int n9 = 3;
                                entry = this.getTagValue(277, false);
                                if (entry != null) {
                                    n9 = (Integer)entry.getValue(0);
                                }
                                int[] nArray = new int[n6 * n7];
                                int n10 = 0;
                                while (true) {
                                    if (n10 >= nArray.length) {
                                        MemoryImageSource memoryImageSource = new MemoryImageSource(n6, n7, nArray, 0, n6);
                                        Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
                                        nArray = null;
                                        ImageIcon imageIcon = new ImageIcon(image);
                                        return imageIcon;
                                    }
                                    nArray[n10] = ((this.data[n10 * 3] & 0xFF) << 16) + ((this.data[n10 * 3 + 1] & 0xFF) << 8) + (this.data[n10 * 3 + 2] & 0xFF) + -16777216;
                                    ++n10;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            if (Log.debugLevel >= 1) {
                                iOException.printStackTrace(System.err);
                            }
                        }
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (this.getAdvancedImage() != null) {
                try {
                    return this.getAdvancedImage().createThumbnailIcon(this.getImageFile().getPath(), null);
                }
                catch (Throwable throwable) {
                    if (Log.debugLevel < 1) break block35;
                    System.err.println("AdvImage:" + throwable);
                }
            }
        }
        if (Log.debugLevel < 3) return null;
        System.out.println("Embedded thumbnail not found for " + this.getImageFile());
        return null;
    }

    @Override
    public int getResolutionX() {
        Entry entry = this.getTagValue(40962, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return -1;
    }

    public void setResolutionX(int n) {
        Entry entry = this.getTagValue(40962, true);
        if (entry == null) {
            entry = new Entry(4);
            this.setTagValue(40962, 0, entry, true);
        }
        entry.setValue(0, new Integer(n));
    }

    @Override
    public int getResolutionY() {
        Entry entry = this.getTagValue(40963, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return -1;
    }

    public void setResolutionY(int n) {
        Entry entry = this.getTagValue(40963, true);
        if (entry == null) {
            entry = new Entry(4);
            this.setTagValue(40963, 0, entry, true);
        }
        entry.setValue(0, new Integer(n));
    }

    @Override
    public int getMetering() {
        Entry entry = this.getTagValue(37383, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return 0;
    }

    public String getMeteringAsString() {
        int n = this.getMetering();
        if (n >= 0 && n < METERING_MODES.length) {
            return METERING_MODES[n];
        }
        return "" + n;
    }

    @Override
    public int getExpoProgram() {
        Entry entry = this.getTagValue(34850, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return 0;
    }

    public String getExpoProgramAsString() {
        int n = this.getExpoProgram();
        if (n >= 0 && n < EXPOSURE_PROGRAMS.length) {
            return EXPOSURE_PROGRAMS[n];
        }
        return "" + n;
    }

    @Override
    public String getMake() {
        Entry entry = this.getTagValue(271, true);
        if (entry != null) {
            return entry.toString();
        }
        return "n/a";
    }

    @Override
    public String getModel() {
        Entry entry = this.getTagValue(272, true);
        if (entry != null) {
            return entry.toString();
        }
        return "n/a";
    }

    @Override
    public String getDataTimeOriginalString() {
        String string;
        Entry entry = this.getTagValue(36867, true);
        if (entry != null && (string = entry.toString()).indexOf("0000:00:00") < 0) {
            return string;
        }
        return dateformat.format(new Date());
    }

    @Override
    public float getFNumber() {
        Entry entry = this.getTagValue(33437, true);
        if (entry != null) {
            return ((Rational)entry.getValue(0)).floatValue();
        }
        entry = this.getTagValue(37378, true);
        if (entry != null) {
            return this.apertureToFnumber(((Rational)entry.getValue(0)).floatValue());
        }
        return -1.0f;
    }

    @Override
    public Rational getShutter() {
        Entry entry = this.getTagValue(33434, true);
        if (entry != null) {
            return (Rational)entry.getValue(0);
        }
        entry = this.getTagValue(37377, true);
        try {
            return TV_TO_SEC[(int)((Rational)entry.getValue(0)).floatValue()];
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    @Override
    public boolean isFlash() {
        Entry entry = this.getTagValue(37385, true);
        if (entry != null) {
            return (Integer)entry.getValue(0) == 1;
        }
        return false;
    }

    @Override
    public float getFocalLength() {
        Entry entry = this.getTagValue(37386, true);
        if (entry != null) {
            return Math.round((float)((double)(38.0f * ((Rational)entry.getValue(0)).floatValue()) / 5.8));
        }
        return 0.0f;
    }

    @Override
    public String getQuality() {
        Entry entry = this.getTagValue(37122, true);
        if (entry == null) {
            return "Unknown";
        }
        switch (((Rational)entry.getValue(0)).intValue()) {
            case 1: {
                return "BASIC";
            }
            case 2: {
                return "NORMAL";
            }
            case 4: {
                return "FINE";
            }
        }
        return this.getTagValue(37122, true).toString();
    }

    public String getOrientation() {
        Entry entry = this.getTagValue(274, true);
        int n = (Integer)entry.getValue(0);
        if (n > 0 && n <= Naming.OrientationNames.length) {
            return Naming.OrientationNames[n - 1];
        }
        return "Unknown";
    }

    @Override
    public String getReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Entry entry = this.getTagValue(33434, true);
        stringBuffer.append("Shutter: ");
        if (entry != null) {
            stringBuffer.append(entry.toString());
        } else {
            entry = this.getTagValue(37377, true);
            if (entry != null) {
                stringBuffer.append(entry.toString());
            } else {
                stringBuffer.append("n/a");
            }
        }
        stringBuffer.append(", Aperture: ");
        entry = this.getTagValue(33437, true);
        if (entry == null) {
            entry = this.getTagValue(37378, true);
            if (entry != null) {
                stringBuffer.append(fnumberformat.format((double)((Rational)entry.getValue(0)).floatValue() * 0.4 + 1.0));
            } else {
                stringBuffer.append("n/a");
            }
        } else {
            stringBuffer.append(fnumberformat.format(((Rational)entry.getValue(0)).floatValue()));
        }
        stringBuffer.append(", Flash: ");
        entry = this.getTagValue(37385, true);
        if (entry != null) {
            stringBuffer.append((Integer)entry.getValue(0) == 1 ? "yes" : "no");
        } else {
            stringBuffer.append("n/a");
        }
        return stringBuffer.toString();
    }

    @Override
    public void readInfo() {
        this.ifds = new IFD[2];
        this.offset -= this.data.length;
        this.intel = this.data[6] == 73;
        boolean bl = this.motorola = this.data[6] == 77;
        if (!this.intel && !this.motorola) {
            return;
        }
        this.version = this.s2n(8, 2);
        this.processAllIFDs();
        this.data = null;
    }

    public static int transformOrientationTag(int n, int n2) {
        int n3 = 0;
        if (n >= 1 && n <= 8) {
            int n4;
            int n5 = n4 = posForOrientationTags[n];
            switch (n2) {
                case 3: {
                    n5 = n4 & 0xCC | (n4 & 3) << 4 | n4 >> 4 & 3;
                    break;
                }
                case 4: {
                    n5 = n4 & 0x33 | (n4 & 0xC) << 4 | (n4 & 0xC0) >> 4;
                    break;
                }
                case 5: {
                    n5 = n4 >> 2 | (n4 & 3) << 6;
                    break;
                }
                case 7: {
                    n5 = (n4 << 2 | n4 >> 6) & 0xFF;
                    break;
                }
                case 6: {
                    n5 = (n4 & 0xF) << 4 | n4 >> 4;
                    break;
                }
                case 1: {
                    n5 = (n4 & 0x30) << 2 | (n4 & 0xC0) >> 2 | (n4 & 3) << 2 | (n4 & 0xC) >> 2;
                    break;
                }
                case 2: {
                    n5 = (n4 & 3) << 6 | (n4 & 0xC) << 2 | (n4 & 0x30) >> 2 | n4 >> 6;
                    break;
                }
            }
            n3 = 0;
            while (posForOrientationTags[++n3] != n5) {
            }
        }
        return n3;
    }

    private void printIfds(IFD iFD, int n, PrintStream printStream) {
        if (iFD != null) {
            printStream.println("print Lvl = " + n);
            Map map = iFD.getEntries();
            for (Integer n2 : map.keySet()) {
                int n3 = n2;
                Entry entry = (Entry)map.get(n2);
                printStream.print("Key = 0x" + Integer.toHexString(n3) + " Type = " + entry.getType());
                Object[] objectArray = entry.getValues();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        printStream.print(" Val" + i + " = " + objectArray[i]);
                    }
                } else {
                    printStream.print("'" + entry.toString() + "'");
                }
                printStream.println();
            }
            IFD[] iFDArray = iFD.getIFDs();
            if (iFDArray != null) {
                for (int i = 0; i < iFDArray.length; ++i) {
                    this.printIfds(iFDArray[i], n + 1, printStream);
                }
            }
        }
    }

    @Override
    public void writeInfo(byte[] byArray, OutputStream outputStream, int n, int n2, boolean bl, int n3, int n4, String string) throws IOException {
        int n5;
        Object object;
        Serializable serializable;
        int n6;
        Object object2;
        int n7;
        if (this.ifds == null) {
            throw new IllegalStateException("EXIF data not filled.");
        }
        Entry[] entryArray = null;
        Object[] objectArray = null;
        int n8 = 0;
        Entry entry = null;
        Object object3 = null;
        if ((n2 & 0x10) != 0 && (entry = this.getTagValue(274, true)) != null && (n7 = ((Integer)(object2 = entry.getValue(0))).intValue()) != (n6 = Exif.transformOrientationTag(n7, n))) {
            object3 = object2;
            entry.setValue(0, new Integer(n6));
        }
        boolean bl2 = false;
        Entry entry2 = null;
        Object object4 = null;
        Object object5 = null;
        Entry entry3 = this.getTagValue(40963, true);
        if (entry3 != null) {
            object5 = entry3.getValue(0);
            entry2 = this.getTagValue(40962, true);
            if (entry2 != null) {
                object4 = entry2.getValue(0);
                if (n3 > 0 && n4 > 0) {
                    serializable = new Integer(n3);
                    object = new Integer(n4);
                    bl2 = true;
                    entry3.setValue(0, object);
                    entry2.setValue(0, serializable);
                    if (bl) {
                        object4 = serializable;
                        object5 = object;
                    }
                }
            }
        }
        if (!bl) {
            entryArray = new Entry[16];
            objectArray = new Object[entryArray.length];
        }
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                if (!bl2 && entry2 != null && entry3 != null) {
                    bl2 = true;
                    entry3.setValue(0, object4);
                    entry2.setValue(0, object5);
                }
                for (int i = 0; i < 2; ++i) {
                    serializable = this.getTagValue(282, i == 0);
                    object = this.getTagValue(283, i == 0);
                    if (serializable == null || object == null) continue;
                    Object object6 = ((Entry)serializable).getValue(0);
                    Object object7 = ((Entry)object).getValue(0);
                    if (!bl) {
                        entryArray[n8] = serializable;
                        objectArray[n8] = object6;
                        entryArray[++n8] = object;
                        objectArray[n8] = object7;
                        ++n8;
                    }
                    ((Entry)object).setValue(0, object6);
                    ((Entry)serializable).setValue(0, object7);
                }
                break;
            }
        }
        if (!bl) {
            if (object3 != null) {
                entryArray[n8] = entry;
                objectArray[n8] = object3;
                ++n8;
            }
            if ((serializable = this.getTagValue(513, false)) != null) {
                object = ((Entry)serializable).getValue(0);
                entryArray[n8] = serializable;
                objectArray[n8] = object;
                ++n8;
            }
            if ((serializable = this.getTagValue(514, false)) != null) {
                object = ((Entry)serializable).getValue(0);
                entryArray[n8] = serializable;
                objectArray[n8] = object;
                ++n8;
            }
            if (bl2) {
                entryArray[n8] = entry2;
                objectArray[n8] = object4;
                entryArray[++n8] = entry3;
                objectArray[n8] = object5;
                ++n8;
            }
        }
        outputStream.write(EXIF_MARK);
        if (this.intel) {
            outputStream.write(73);
            outputStream.write(73);
        } else {
            outputStream.write(77);
            outputStream.write(77);
        }
        outputStream.write(this.n2s(this.version, 2));
        int n9 = EXIF_MARK.length + 2;
        outputStream.write(this.n2s(n9, 4));
        for (n5 = 0; n5 < 2; ++n5) {
            boolean bl3 = false;
            if (n5 == 1 || this.ifds[n5 + 1] == null) {
                bl3 = true;
            }
            n9 = this.writeIfd(byArray, outputStream, n9, this.ifds[n5], n, n2, bl3, string);
        }
        for (n5 = 0; n5 < n8; ++n5) {
            Entry entry4 = entryArray[n5];
            if (entry4 == null) continue;
            entry4.setValue(0, objectArray[n5]);
        }
    }

    @Override
    public void setThumbnail(byte[] byArray, int n, int n2, String string, OutputStream outputStream) throws IOException {
        Entry entry;
        if (this.ifds[1] == null) {
            this.ifds[1] = new IFD(1);
            entry = new Entry(3);
            entry.setValue(0, new Integer(2));
            this.ifds[1].addEntry(296, entry);
            entry = new Entry(5);
            entry.setValue(0, new Rational(180, 1));
            this.ifds[1].addEntry(282, entry);
            entry = new Entry(5);
            entry.setValue(0, new Rational(180, 1));
            this.ifds[1].addEntry(283, entry);
        }
        String string2 = string.toLowerCase();
        entry = this.getTagValue(259, false);
        if (entry == null) {
            entry = new Entry(3);
            this.setTagValue(259, 0, entry, false);
        }
        entry.setValue(0, new Integer(6));
        if ("jpeg".equals(string2) || "jpg".equals(string2)) {
            this.ifds[1].removeEntry(273);
            this.ifds[1].removeEntry(279);
            this.ifds[1].removeEntry(262);
            entry = this.getTagValue(513, false);
            if (entry == null) {
                entry = new Entry(4);
                this.setTagValue(513, 0, entry, false);
            }
            entry.setValue(0, new Integer(n - 4 - 6));
            entry = this.getTagValue(514, false);
            if (entry == null) {
                entry = new Entry(4);
                this.setTagValue(514, 0, entry, false);
            }
            entry.setValue(0, new Integer(n2));
        } else {
            entry.setValue(0, new Integer(1));
            this.ifds[1].removeEntry(513);
            this.ifds[1].removeEntry(514);
            entry = this.getTagValue(273, false);
            if (entry == null) {
                entry = new Entry(4);
                this.setTagValue(273, 0, entry, false);
            }
            entry.setValue(0, new Integer(n - 4 - 6));
            entry = this.getTagValue(279, false);
            if (entry == null) {
                entry = new Entry(4);
                this.setTagValue(279, 0, entry, false);
            }
            entry.setValue(0, new Integer(n2));
        }
        this.writeInfo(byArray, outputStream, 0, 0, true);
    }

    @Override
    public boolean removeThumbnailTags() {
        IFD iFD = this.ifds[1];
        if (iFD != null) {
            this.ifds[1].removeEntry(513);
            this.ifds[1].removeEntry(514);
            this.ifds[1].removeEntry(273);
            this.ifds[1].removeEntry(279);
            this.ifds[1].removeEntry(262);
        }
        return true;
    }

    protected int writeIfd(byte[] byArray, OutputStream outputStream, int n, IFD iFD, int n2, int n3, boolean bl, String string) throws IOException {
        int n4;
        ByteArrayOutputStream byteArrayOutputStream;
        block31: {
            Object object;
            if (iFD == null) {
                if (Log.debugLevel >= 2) {
                    System.err.println("Warning: Requested to write NULL IFD, nothing written.");
                }
                return n;
            }
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            int n5 = (iFD.getEntries() == null ? 0 : iFD.getEntries().size()) + (iFD.getIFDs() == null ? 0 : iFD.getIFDs().length);
            outputStream.write(this.n2s(n5, 2));
            n += n5 * 12 + 2 + 4;
            Iterator iterator = iFD.getEntries().entrySet().iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator.hasNext()) {
                int n6;
                int n7;
                Entry entry;
                Map.Entry entry2 = iterator.next();
                n4 = (Integer)entry2.getKey();
                if (n4 == 513) {
                    bl2 = true;
                    continue;
                }
                if (n4 == 514) continue;
                if (n4 == 273) {
                    bl3 = true;
                    continue;
                }
                if (n4 == 279 || (entry = (Entry)entry2.getValue()) == null) continue;
                outputStream.write(this.n2s(n4, 2));
                int n8 = entry.getType();
                outputStream.write(this.n2s(n8, 2));
                if (n8 == 2) {
                    object = entry.toString().getBytes(string);
                    outputStream.write(this.n2s(((Object[])object).length + 1, 4));
                    if (((Object[])object).length + 1 > 4) {
                        outputStream.write(this.n2s(n, 4));
                        byteArrayOutputStream.write((byte[])object);
                        byteArrayOutputStream.write(0);
                        n += ((Object)object).length + 1;
                        continue;
                    }
                    outputStream.write((byte[])object);
                    if (((Object)object).length >= 4) continue;
                    for (n7 = 0; n7 < 4 - ((Object)object).length; ++n7) {
                        outputStream.write(0);
                    }
                    continue;
                }
                object = entry.getValues();
                outputStream.write(this.n2s(((Object[])object).length, 4));
                n7 = TYPELENGTH[n8 - 1];
                if (((Object[])object).length * n7 > 4) {
                    outputStream.write(this.n2s(n, 4));
                    n6 = 1;
                    boolean bl4 = n8 % 5 == 0;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (bl4) {
                            byteArrayOutputStream.write(this.n2s(((Rational)object[i]).getNum(), 4));
                            byteArrayOutputStream.write(this.n2s(((Rational)object[i]).getDen(), 4));
                            n += 8;
                            continue;
                        }
                        byteArrayOutputStream.write(this.n2s((Integer)object[i], n7));
                        n += n7;
                    }
                    continue;
                }
                for (n6 = 0; n6 < ((Object)object).length; ++n6) {
                    outputStream.write(this.n2s((Integer)object[n6], n7));
                }
                if (((Object)object).length * n7 >= 4) continue;
                for (n6 = 0; n6 < 4 - ((Object)object).length * n7; ++n6) {
                    outputStream.write(0);
                }
            }
            if (bl2) {
                int n9 = this.getThumbnailLength();
                if (byArray != null && n9 > 100 && n4 >= 0 && n4 + n9 <= byArray.length) {
                    try {
                        for (n4 = this.getThumbnailOffset() + 4; (byArray[n4] != -1 || byArray[n4 + 1] != -40) && n4 < byArray.length - 1; ++n4) {
                            --n9;
                        }
                        if (n9 > 100) {
                            int n10 = byteArrayOutputStream.size();
                            if ((n3 & 2) != 0 && n2 != 0 && n2 != 8) {
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n4, n9);
                                object = new LLJTran(byteArrayInputStream);
                                ((LLJTran)object).read(3, false);
                                ((LLJTran)object).transform(n2, 0);
                                ((LLJTran)object).save(byteArrayOutputStream, 0);
                                byteArrayInputStream = null;
                            } else {
                                byteArrayOutputStream.write(byArray, n4, n9);
                            }
                            n10 = byteArrayOutputStream.size() - n10;
                            Entry entry = this.getTagValue(514, false);
                            if (entry != null) {
                                entry.setValue(0, new Integer(n10));
                            }
                            outputStream.write(this.n2s(514, 2));
                            outputStream.write(this.n2s(4, 2));
                            outputStream.write(this.n2s(1, 4));
                            outputStream.write(this.n2s(n10, 4));
                            entry = this.getTagValue(513, false);
                            entry.setValue(0, new Integer(n));
                            outputStream.write(this.n2s(513, 2));
                            outputStream.write(this.n2s(entry.getType(), 2));
                            outputStream.write(this.n2s(1, 4));
                            outputStream.write(this.n2s(n, 4));
                            n += n10;
                        }
                    }
                    catch (Throwable throwable) {
                        if (Log.debugLevel >= 1) {
                            throwable.printStackTrace(System.err);
                        }
                    }
                }
            } else if (bl3) {
                int n11 = this.getThumbnailLength();
                n4 = this.getThumbnailOffset() + 4;
                if (byArray != null && n11 > 0 && n4 >= 0 && n4 + n11 <= byArray.length) {
                    try {
                        if (n4 < n11 - 100) {
                            int n12 = byteArrayOutputStream.size();
                            byteArrayOutputStream.write(byArray, n4, n11);
                            n12 = byteArrayOutputStream.size() - n12;
                            Entry entry = this.getTagValue(279, false);
                            if (entry != null) {
                                entry.setValue(0, new Integer(n12));
                            }
                            outputStream.write(this.n2s(279, 2));
                            outputStream.write(this.n2s(4, 2));
                            outputStream.write(this.n2s(1, 4));
                            outputStream.write(this.n2s(n12, 4));
                            entry = this.getTagValue(273, false);
                            entry.setValue(0, new Integer(n));
                            outputStream.write(this.n2s(273, 2));
                            outputStream.write(this.n2s(entry.getType(), 2));
                            outputStream.write(this.n2s(1, 4));
                            outputStream.write(this.n2s(n, 4));
                            n += n12;
                        }
                    }
                    catch (Throwable throwable) {
                        if (Log.debugLevel < 1) break block31;
                        throwable.printStackTrace(System.err);
                    }
                }
            }
        }
        IFD[] iFDArray = iFD.getIFDs();
        for (n4 = 0; iFDArray != null && n4 < iFDArray.length; ++n4) {
            IFD iFD2 = iFDArray[n4];
            outputStream.write(this.n2s(iFD2.getTag(), 2));
            outputStream.write(this.n2s(iFD2.getType(), 2));
            outputStream.write(this.n2s(1, 4));
            outputStream.write(this.n2s(n, 4));
            n = this.writeIfd(byArray, byteArrayOutputStream, n, iFD2, n2, n3, false, string);
        }
        outputStream.write(this.n2s(bl ? 0 : n, 4));
        byteArrayOutputStream.writeTo(outputStream);
        return n;
    }

    protected int firstIFD() {
        return this.s2n(10, 4) + 6;
    }

    protected int nextIFD(int n) {
        int n2 = this.s2n(n, 2);
        return this.s2n(n + 2 + 12 * n2, 4) + 6;
    }

    protected void processAllIFDs() {
        int n = this.firstIFD();
        for (int i = 0; n > 6 && i < 2; ++i) {
            this.ifds[i] = new IFD(i);
            this.storeIFD(n, this.ifds[i]);
            n = this.nextIFD(n);
        }
    }

    protected void storeIFD(int n, IFD iFD) {
        int n2 = this.s2n(n, 2);
        for (int i = 0; i < n2; ++i) {
            int n3 = n + 2 + 12 * i;
            int n4 = this.s2n(n3, 2);
            int n5 = this.s2n(n3 + 2, 2);
            if (n5 < 1 || n5 > 10) continue;
            int n6 = TYPELENGTH[n5 - 1];
            int n7 = this.s2n(n3 + 4, 4);
            int n8 = n3 + 8;
            if (n7 * n6 > 4) {
                n8 = this.s2n(n8, 4) + 6;
            }
            if (n5 == 2) {
                try {
                    iFD.addEntry(n4, new Entry(n5, new String(this.data, n8, n7 - 1, "Default")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (Log.debugLevel < 1) continue;
                    System.err.println("storeIFD: getString() " + unsupportedEncodingException);
                }
                continue;
            }
            Object[] objectArray = new Object[n7];
            boolean bl = true;
            for (int j = 0; j < n7; ++j) {
                objectArray[j] = n5 % 5 != 0 ? new Integer(this.s2n(n8, n6, bl)) : new Rational(this.s2n(n8, 4, bl), this.s2n(n8 + 4, 4, bl));
                n8 += n6;
                if ((n4 == 34665 || n4 == 40965) && j == 0 && (Integer)objectArray[0] > 0) {
                    IFD iFD2 = new IFD(n4, n5);
                    this.storeIFD((Integer)objectArray[0] + 6, iFD2);
                    iFD.addIFD(iFD2);
                    continue;
                }
                iFD.addEntry(n4, new Entry(n5, objectArray));
            }
        }
    }

    public IFD[] getIFDs() {
        return this.ifds;
    }
}

