/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mediautil.gen.Log;
import mediautil.gen.MediaFormat;
import mediautil.gen.MediaInfo;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.AdvancedImage;
import mediautil.image.jpeg.Entry;
import mediautil.image.jpeg.Exif;
import mediautil.image.jpeg.LLJTran;
import mediautil.image.jpeg.LLJTranException;

public class BasicJpeg
extends LLJTran
implements MediaFormat {
    protected AdvancedImage advancedImage;
    public static final String PROGRAMNAME = "LLJTran";
    protected Rectangle rect;
    private Map tables;
    private byte[] markers;
    private byte[] rawDct;
    private String in_comment;

    public BasicJpeg(File file) {
        super(file);
        this.read();
    }

    public BasicJpeg(InputStream inputStream) {
        super(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(boolean bl, boolean bl2) {
        int n = this.getReadUpto();
        if (!(n >= 3 || bl && n >= 1)) {
            int n2 = 3;
            if (bl) {
                n2 = 1;
            }
            if (n > 0 && this.getFile() != null) {
                this.resetInput((InputStream)null);
            }
            try {
                this.read(n2, bl);
            }
            catch (LLJTranException lLJTranException) {
                if (Log.debugLevel >= 1) {
                    System.err.println("Error Reading Jpeg: " + lLJTranException.getMessage());
                }
                if (this.inStream != null) {
                    try {
                        this.inStream.close();
                        this.inStream = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.closeInternalInputStream();
            }
        }
    }

    protected void read() {
        this.read(true, false);
    }

    public boolean isValid() {
        return this.valid;
    }

    public InputStream getAsStream() {
        return this.createInputStream();
    }

    public String getParentPath() {
        return this.file == null ? null : this.file.getParent();
    }

    public long getFileSize() {
        return this.length();
    }

    public long length() {
        return this.file == null ? -1L : this.file.length();
    }

    public URL getUrl() {
        if (this.file == null) {
            return null;
        }
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Date getDateTimeOriginal() {
        return this.file == null ? new Date() : new Date(this.file.lastModified());
    }

    public boolean renameTo(File file) {
        if (this.file == null) {
            return false;
        }
        if (this.file.renameTo(file)) {
            this.file = file;
            try {
                this.imageinfo.setName(this.file.getName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public MediaInfo getMediaInfo() {
        return this.getImageInfo();
    }

    public String getType() {
        return "JPEG";
    }

    public String getThumbnailType() {
        return ((AbstractImageInfo)this.getMediaInfo()).getThumbnailExtension();
    }

    public byte[] getThumbnailData(Dimension dimension) {
        throw new RuntimeException("Method getThumbnailData is not implemented yet");
    }

    public Image getImage() {
        if (this.valid) {
            return Toolkit.getDefaultToolkit().getImage(this.getLocationName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getBufferedImage() throws IOException {
        Iterator<ImageReader> iterator;
        if (this.valid && (iterator = ImageIO.getImageReadersByFormatName("JPEG")).hasNext()) {
            ImageReader imageReader = iterator.next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.getFile());
            try {
                imageReader.setInput(imageInputStream, true);
                BufferedImage bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
                return bufferedImage;
            }
            finally {
                imageInputStream.close();
            }
        }
        return null;
    }

    public Icon getThumbnail(Dimension dimension) {
        return ((AbstractImageInfo)this.getMediaInfo()).getThumbnailIcon(dimension);
    }

    public void setAdvancedImage(AdvancedImage advancedImage) {
        this.advancedImage = advancedImage;
    }

    public AdvancedImage getAdvancedImage() {
        return this.advancedImage;
    }

    public Icon getIcon() {
        block4: {
            try {
                if (this.valid) {
                    if (this.getAdvancedImage() != null) {
                        return this.getAdvancedImage().createIcon(this.getLocationName());
                    }
                    return new ImageIcon(this.getLocationName());
                }
            }
            catch (Throwable throwable) {
                if (Log.debugLevel < 1) break block4;
                throwable.printStackTrace(System.err);
            }
        }
        return null;
    }

    public void setComment(String string) {
        this.in_comment = string;
        if (this.imageinfo != null) {
            this.imageinfo.setAttribute("Comments", this.in_comment);
        }
    }

    protected void transformAppHeader(int n, boolean bl) throws IOException {
        if (!(this.imageinfo instanceof Exif)) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        Exif exif = (Exif)this.imageinfo;
        if (this.artist != null) {
            Entry entry = exif.getTagValue(315, true);
            if (entry == null) {
                entry = new Entry("Camera owner, " + this.artist);
                exif.setTagValue(315, 34665, entry, true);
            } else {
                entry.setValue(0, "Camera owner, " + this.artist);
            }
        }
        int n2 = 777;
        if (bl) {
            n2 |= 2;
        }
        super.transformAppHeader(n, n2, true);
    }

    protected void addMarker(int n, byte by) {
        byte[] byArray;
        if (this.tables == null) {
            this.tables = new Hashtable();
        }
        if (this.markers == null) {
            this.markers = new byte[1];
        } else {
            byArray = new byte[this.markers.length + 1];
            System.arraycopy(this.markers, 0, byArray, 0, this.markers.length);
            this.markers = byArray;
        }
        this.markers[this.markers.length - 1] = by;
        byArray = new byte[n + 4];
        byArray[0] = -1;
        byArray[1] = by;
        System.arraycopy(this.markerid, 0, byArray, 2, 2);
        System.arraycopy(this.data, 0, byArray, 4, n);
        this.tables.put("" + by, byArray);
    }

    void writeUnprocessedMarkers(OutputStream outputStream) throws IOException {
        if (this.tables != null && this.markers != null) {
            for (int i = 0; i < this.markers.length; ++i) {
                byte[] byArray = (byte[])this.tables.get("" + this.markers[i]);
                if (byArray == null) continue;
                outputStream.write(byArray);
            }
        }
    }

    void writeRawDCT(OutputStream outputStream) throws IOException {
        if (this.rawDct != null) {
            outputStream.write(this.rawDct);
        }
    }

    void readRawDCT(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            this.readcounter += n;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.rawDct = byteArrayOutputStream.toByteArray();
    }

    public boolean transform(String string, int n) {
        return this.transform(string, n, false);
    }

    public boolean transform(String string, int n, boolean bl) {
        return this.transform(string, n, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(String string, int n, boolean bl, Class clazz) {
        if (new File(string).exists()) {
            if (Log.debugLevel >= 1) {
                System.err.println("File " + string + " already exists.");
            }
        } else {
            OutputStream outputStream = null;
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(string), 4096);
                boolean bl2 = this.transform(outputStream, n, bl, clazz);
                return bl2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Log.debugLevel >= 1) {
                    System.err.println(fileNotFoundException + " in saving of " + this.getName());
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(OutputStream outputStream, int n, boolean bl, Class clazz) {
        int n2 = 512;
        boolean bl2 = false;
        if (bl) {
            n2 = 770;
            bl2 = true;
        }
        this.read(false, bl);
        try {
            this.transform(outputStream, n, n2, this.rect, this.restart_interval, clazz);
        }
        catch (IOException iOException) {
            if (Log.debugLevel >= 1) {
                System.err.println(iOException + " in saving of " + this.getName());
            }
            if (Log.debugLevel >= 1) {
                iOException.printStackTrace(System.err);
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.freeMemory();
        }
        return true;
    }

    void save(OutputStream outputStream, int n, Class clazz) throws IOException {
        String string = n == 9 ? this.in_comment : "Put your copyright here" + (this.out_comment.length() == 0 ? "" : "\n") + this.out_comment;
        if ("".equals(string)) {
            string = null;
        }
        this.writeJpeg(outputStream, n, string, this.appxs_read, clazz);
    }

    protected void writeJpeg(OutputStream outputStream, int n, String string, boolean bl, Class clazz) throws IOException {
        if (n == 8) {
            n = 0;
        }
        int n2 = 777;
        if (!bl) {
            n2 &= 0xFFFFFEFF;
        }
        super.writeJpeg(outputStream, n, string, n2, null, clazz, this.restart_interval, false);
        if (!this.canBeProcessed) {
            this.writeUnprocessedMarkers(outputStream);
            this.writeRawDCT(outputStream);
        }
        outputStream.flush();
        outputStream.close();
        outputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMarkers(OutputStream outputStream) throws IOException {
        try {
            this.read(true, true);
            if (outputStream != null) {
                this.writeMarkerAppXs(outputStream);
                outputStream.close();
            }
        }
        finally {
            this.appxs = null;
        }
    }

    public void freeMemory() {
        super.freeMemory();
        this.tables = null;
        this.markers = null;
        this.rawDct = null;
    }

    public void setArtist(String string) {
        this.artist = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(Image image, final boolean bl) {
        Dimension dimension;
        Dimension dimension2 = dimension = new Dimension();
        synchronized (dimension2) {
            dimension.width = image.getWidth(new ImageObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    if (bl && (n & 3) == 3 || (n & 0x10) == 32 || (n & 0x80) == 128 || (n & 0x40) == 64) {
                        Dimension dimension2 = dimension;
                        synchronized (dimension2) {
                            dimension.width = n4;
                            dimension.height = n5;
                            dimension.notify();
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (dimension.width < 0) {
                try {
                    dimension.wait(60000L);
                }
                catch (Exception exception) {}
            } else {
                dimension.height = image.getHeight(null);
            }
        }
        return dimension;
    }

    public static Image getScaled(Image image, Dimension dimension, int n, double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            dArray = new double[1];
        }
        Dimension dimension2 = BasicJpeg.getScaledSize(image, dimension, dArray);
        if (dArray[0] == 0.0) {
            return image;
        }
        return image.getScaledInstance(dimension2.width, dimension2.height, n);
    }

    public static Dimension getScaledSize(Image image, Dimension dimension, double[] dArray) {
        Dimension dimension2 = BasicJpeg.getImageSize(image, true);
        if (dimension2.width <= 0 || dimension2.height <= 0) {
            return dimension;
        }
        if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
            return dimension2;
        }
        double d = (double)dimension.height / (double)dimension2.height;
        double d2 = (double)dimension.width / (double)dimension2.width;
        if (d < d2) {
            d2 = d;
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = d2;
        }
        return new Dimension((int)((double)dimension2.width * d2), (int)((double)dimension2.height * d2));
    }

    public static void main(String[] stringArray) {
        try {
            System.setErr(new PrintStream(new FileOutputStream("LLJTran.log"), true));
        }
        catch (IOException iOException) {
            System.err.println("LLJTran: Can't redirect error stream.");
        }
        new BasicJpeg(new File(stringArray[0])).transform(stringArray[1], Integer.parseInt(stringArray[2]), true);
    }

    public void setCropRect(Rectangle rectangle) {
        this.rect = rectangle;
    }

    public Rectangle getCropRect() {
        if (this.rect == null) {
            return null;
        }
        return (Rectangle)this.rect.clone();
    }
}

