/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.Options;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

final class WindowsFieldCaret
extends DefaultCaret
implements UIResource {
    private static final LayeredHighlighter.LayerPainter WindowsPainter = new WindowsHighlightPainter(null);
    private boolean isKeyboardFocusEvent = true;

    WindowsFieldCaret() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        JTextComponent c = this.getComponent();
        if (c == null) {
            return;
        }
        if (c.isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if (!(c.isEnabled() && this.isKeyboardFocusEvent && Options.isSelectOnFocusGainActive(c))) {
            return;
        }
        if (c instanceof JFormattedTextField) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowsFieldCaret.this.selectAll();
                }
            });
        } else {
            this.selectAll();
        }
    }

    private void selectAll() {
        JTextComponent c = this.getComponent();
        if (c == null) {
            return;
        }
        boolean backward = Boolean.TRUE.equals(c.getClientProperty("JGoodies.invertSelection"));
        if (backward) {
            this.setDot(c.getDocument().getLength());
            this.moveDot(0);
        } else {
            this.setDot(0);
            this.moveDot(c.getDocument().getLength());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!e.isTemporary()) {
            this.isKeyboardFocusEvent = true;
            if (this.getComponent() != null && Boolean.TRUE.equals(this.getComponent().getClientProperty("JGoodies.setCaretToStartOnFocusLost"))) {
                this.setDot(0);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) || e.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }

    @Override
    protected void adjustVisibility(Rectangle r) {
        SwingUtilities.invokeLater(new SafeScroller(r));
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return WindowsPainter;
    }

    private static final class WindowsHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        WindowsHighlightPainter(Color c) {
            super(c);
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            Rectangle alloc = bounds.getBounds();
            try {
                TextUI mapper = c.getUI();
                Rectangle p0 = mapper.modelToView(c, offs0);
                Rectangle p1 = mapper.modelToView(c, offs1);
                Color color = this.getColor();
                if (color == null) {
                    g.setColor(c.getSelectionColor());
                } else {
                    g.setColor(color);
                }
                boolean firstIsDot = false;
                boolean secondIsDot = false;
                if (c.isEditable()) {
                    int dot = c.getCaretPosition();
                    firstIsDot = offs0 == dot;
                    boolean bl = secondIsDot = offs1 == dot;
                }
                if (p0.y == p1.y) {
                    Rectangle r = p0.union(p1);
                    if (r.width > 0) {
                        if (firstIsDot) {
                            ++r.x;
                            --r.width;
                        } else if (secondIsDot) {
                            --r.width;
                        }
                    }
                    g.fillRect(r.x, r.y, r.width, r.height);
                } else {
                    int p0ToMarginWidth = alloc.x + alloc.width - p0.x;
                    if (firstIsDot && p0ToMarginWidth > 0) {
                        ++p0.x;
                        --p0ToMarginWidth;
                    }
                    g.fillRect(p0.x, p0.y, p0ToMarginWidth, p0.height);
                    if (p0.y + p0.height != p1.y) {
                        g.fillRect(alloc.x, p0.y + p0.height, alloc.width, p1.y - (p0.y + p0.height));
                    }
                    if (secondIsDot && p1.x > alloc.x) {
                        --p1.x;
                    }
                    g.fillRect(alloc.x, p1.y, p1.x - alloc.x, p1.height);
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Color color = this.getColor();
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            boolean firstIsDot = false;
            boolean secondIsDot = false;
            if (c.isEditable()) {
                int dot = c.getCaretPosition();
                firstIsDot = offs0 == dot;
                boolean bl = secondIsDot = offs1 == dot;
            }
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                if (firstIsDot && alloc.width > 0) {
                    g.fillRect(alloc.x + 1, alloc.y, alloc.width - 1, alloc.height);
                } else if (secondIsDot && alloc.width > 0) {
                    g.fillRect(alloc.x, alloc.y, alloc.width - 1, alloc.height);
                } else {
                    g.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
                }
                return alloc;
            }
            try {
                Rectangle r;
                Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                Rectangle rectangle = r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                if (firstIsDot && r.width > 0) {
                    g.fillRect(r.x + 1, r.y, r.width - 1, r.height);
                } else if (secondIsDot && r.width > 0) {
                    g.fillRect(r.x, r.y, r.width - 1, r.height);
                } else {
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
                return r;
            }
            catch (BadLocationException e) {
                return null;
            }
        }
    }

    private final class SafeScroller
    implements Runnable {
        private final Rectangle r;

        SafeScroller(Rectangle r) {
            this.r = r;
        }

        @Override
        public void run() {
            JTextField field = (JTextField)WindowsFieldCaret.this.getComponent();
            if (field == null) {
                return;
            }
            TextUI ui = field.getUI();
            int dot = WindowsFieldCaret.this.getDot();
            Position.Bias bias = Position.Bias.Forward;
            Rectangle startRect = null;
            try {
                startRect = ui.modelToView(field, dot, bias);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            Insets i = field.getInsets();
            BoundedRangeModel vis = field.getHorizontalVisibility();
            int x = this.r.x + vis.getValue() - i.left;
            int quarterSpan = vis.getExtent() / 4;
            if (this.r.x < i.left) {
                vis.setValue(x - quarterSpan);
            } else if (this.r.x + this.r.width > i.left + vis.getExtent() + 1) {
                vis.setValue(x - 3 * quarterSpan);
            }
            if (startRect == null) {
                return;
            }
            try {
                Rectangle endRect = ui.modelToView(field, dot, bias);
                if (endRect != null && !endRect.equals(startRect)) {
                    WindowsFieldCaret.this.damage(endRect);
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
    }
}

