#!/usr/bin/perl
# tester3.cgi - This will test the HTMLObject Normal object.

use HTMLObject::Normal;
use HTMLObject::ReadCookie;
use HTMLObject::CGILib;
use strict;
#use cgi_lib;

use vars '%input';

%input = ();
#cgi_lib::ReadParse(*input);
HTMLObject::CGILib::ReadParse(*input);

my $name = $input{'name'};

my $doc = HTMLObject::Normal->new();
my $cookieObj = HTMLObject::ReadCookie->new;

$doc->setCookie(name=>'testing', value=>'This rocks!');
$doc->setCookie(name=>'testing2', value=>'Hello World!');

my @cookies = ();
my @tempArray;
$tempArray[0] = "one";
$tempArray[1] = "two";
$cookies[0] = [ @tempArray ]; 

$tempArray[0] = "three";
$tempArray[1] = "four";
$cookies[1] = [ @tempArray ]; 

$doc->setTitle("Tester3.cgi");

$doc->setCompressedCookie(name => 'testing3', cookies => \@cookies, expires => 'Sun, 01-Dec-2002 00:00:00 GMT');

$doc->setBodyFgcolor("black");
$doc->setBodyBgcolor("lightgrey");

# test the JavaScript output stuff.
$doc->setFocus("javascript");
$doc->print("var test = 100;\n");

$doc->setFocus("head");

$doc->setJavascriptVersion('1.2');
$doc->printJavascriptRequired(version => '1.1');

# make each javascript error popup in a unique window for each frame.
$doc->setJavascriptErrorHandlerWindow(name => "$name");
$doc->enableJavascriptErrorHandler(email => "htmlobject\@xperienceinc.com", prgName => "tester3.cgi", prgVersion => "2.18");

$doc->setLinkDecorations();

$doc->setFocus("javascript");
#$doc->print("self = null;\n"); # force a javascript error to test our error handler.
$doc->print("this = null;\n"); # force a javascript error to test our error handler.

$doc->setFocus("body");
$doc->print("This is tester3.cgi..." . $doc->br . "\n");
$doc->print("This is a test!<TESTTAG>\n" . $doc->br);

$doc->printTag(tag => "<TESTTAG>", value => "\n" . $doc->br . "This was inserted via " . $doc->b(content => "printTag") . ".");
$doc->printTag(tag => "<TESTTAG>", value => "&nbsp;I just added some more text to this tag!");

my $testTagValue = $doc->readTag(tag => "<TESTTAG>");
$doc->deleteTag(tag => "<TESTTAG>");

$doc->printTag(tag => "<TESTTAG>", value => "The following content was printed, read and then deleted and then re-printed ($testTagValue)", mode => "single");

# check for our cookie and if it is set, display a message saying so.
my %cresult = $cookieObj->getCookies;
if (scalar keys %cresult > 0)
{
  $doc->print("Gathered all cookies successfully!<br><br>");
}
foreach my $cookie (keys %cresult)
{
  $doc->print("Cookie = '$cookie' had value = '" . $cookieObj->cookies->{$cookie} . "'" . $doc->br . "\n");
}
# get all compressed cookies.
%cresult = $cookieObj->getCompressedCookies(cname => "testing3");
if (scalar keys %cresult > 0)
{
  $doc->print("Gathered all compressed cookies successfully!" . $doc->br . $doc->br);
}
else
{
  $doc->print("Error gathering compressed cookies!" . $doc->br . $doc->br);
}
foreach my $cookie (keys %cresult)
{
  $doc->print("Compressed Cookie = '$cookie' had value = '" . $cookieObj->cookies->{$cookie} . "'" . $doc->br . "\n");
}

if (exists $cookieObj->cookies->{'testing'})
{
  $doc->print("The cookie 'testing' was successfully set!");
  $doc->print($doc->br . "\n'testing' had value = '" . $cookieObj->cookies->{'testing'} . "'.");
}
if (exists $cookieObj->cookies->{'testing2'})
{
  $doc->print($doc->br . $doc->br . "The cookie 'testing2' was successfully set!");
  $doc->print($doc->br . "\n'testing2' had value = '" . $cookieObj->cookies->{'testing2'} . "'.");
}
if (exists $cookieObj->cookies->{'testing3'})
{
  $doc->print($doc->br . $doc->br . "The cookie 'testing3' was successfully set!");
  $doc->print($doc->br . "\n'testing3' had value = '" . $cookieObj->cookies->{'testing3'} . "'.");
}
if (exists $cookieObj->cookies->{'one'})
{
  $doc->print($doc->br . $doc->br . "The cookie 'one' was successfully set!");
  $doc->print($doc->br . "\n'one' had value = '" . $cookieObj->cookies->{'one'} . "'.");
}
if (exists $cookieObj->cookies->{'three'})
{
  $doc->print($doc->br . $doc->br . "The cookie 'three' was successfully set!");
  $doc->print($doc->br . "\n'three' had value = '" . $cookieObj->cookies->{'three'} . "'.");
}

$doc->display();
