# $Id: Makefile.PL,v 1.1.1.1 2005/03/05 16:45:05 kissg Exp $

require 5.6.0;
use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

sub MY::install {
	package MY;
	my $inherited = shift->SUPER::install(@_);
	$inherited =~  s{\$\(PERL_ARCHLIB\)(/auto/\$\(FULLEXT\)/\.packlist)}
			{\$\(INSTALLARCHLIB\)\1}sg;
	$inherited =~  s{(\ninstall((_\w+)?) ::.*?) doc\2_install}
			{\1}g;
	$inherited =~  s{(\@\$\(UNINSTALL\) \$\(INSTALLARCHLIB\)/auto/\$\(FULLEXT\)/\.packlist)}
			{\1\n\t\@find \$\(INSTALLARCHLIB\) -depth -type d | xargs rmdir};
	$inherited;
}

sub MY::tools_other {
	package MY;
	my $inherited = shift->SUPER::tools_other(@_);
	$inherited .= q{
# Overwrite original $(UNINSTALL):
UNINSTALL = $(PERL) -MExtUtils::Install -e 'uninstall($$ARGV[0],1,0);'
};
	$inherited;
}

sub MY::top_targets {
	package MY;
	my $inherited = shift->SUPER::top_targets(@_);
	$inherited .= q{
# Make an extra symlink
config::
	[ -s lib/pista ] || ln -sf . lib/pista
};
	$inherited;
}

WriteMakefile(
	NAME		=> 'Pista',
	DISTNAME	=> 'pista',
	VERSION_FROM	=> 'script/pista',
	AUTHOR		=> 'Gabor Kiss <kissg@cdata.hu>',
	ABSTRACT	=> 'PIC programmer utility',
	INSTALLDIRS	=> 'perl',
	PREFIX		=> '/usr/local',
	INSTALLBIN	=> '$(PREFIX)/bin',
	INSTALLPRIVLIB	=> '$(PREFIX)/lib/pista',
	INSTALLARCHLIB	=> '$(PREFIX)/lib/pista',
	EXE_FILES	=> [ qw( script/pista ) ],
	PREREQ_PM	=> {
				'Term::ReadLine'	=> 0,
				'Text::ParseWords'	=> 0,
				'Getopt::Long'		=> 0,
				'FileHandle'		=> 0,
			   },
	clean		=> { FILES      => "pista-*.tar.gz" },
	dist		=> {
		COMPRESS	=> "gzip -f",
		SUFFIX		=> 'gz',
		CI		=> 'cvs commit',
		RCS_LABEL	=> 'cvs tag RELEASE_$(VERSION_SYM)',
	},
);
