export interface MatchingInterval {
    from: number;
    to: number;
}
export interface MatchingResult {
    path: string[];
    value: string | number;
    intervals: MatchingInterval[];
}
export interface KVSearchResult<T> {
    original: T;
    rendered: T;
    score: number;
    index: number;
    matched?: MatchingResult[];
}
export interface Query {
    keyPath: (string | RegExp)[];
    match: 'exact' | 'fuzzy' | 'negative' | 'greater' | 'greaterEqual' | 'less' | 'lessEqual';
    pattern: string | number;
}
export interface QueryNode {
    operator: 'or' | 'and';
    left: QueryNode | Query;
    right: QueryNode | Query;
}
export declare function isQueryNode(q: Query | QueryNode | 'or' | 'and'): q is QueryNode;
export declare function isQuery(q: Query | QueryNode | 'or' | 'and'): q is Query;
export interface KVSearchConfiguration {
    caseSensitive?: boolean;
    excludedChars?: string[];
    includeMatches?: boolean;
    shouldSort?: boolean;
    shouldRender?: boolean;
    escapeHTML?: boolean;
    findAllMatches?: boolean;
    pre?: string;
    post?: string;
    indexedKeys?: (string | RegExp | (string | RegExp)[])[];
}
export declare function union<T>(a: Record<number, KVSearchResult<T>>, b: Record<number, KVSearchResult<T>>): void;
export declare function intersect<T>(a: Record<number, KVSearchResult<T>>, b: Record<number, KVSearchResult<T>>): Record<number, KVSearchResult<T>>;
export declare class KVSearch<T> {
    private readonly conf;
    constructor(conf?: KVSearchConfiguration);
    filter(pattern: string, list: T[], conf?: KVSearchConfiguration): KVSearchResult<T>[];
    filterWithQuery(query: Query | QueryNode, list: T[], conf?: KVSearchConfiguration): KVSearchResult<T>[];
    match(query: Query, obj: T, conf?: KVSearchConfiguration): KVSearchResult<T> | null;
    render(obj: T, matchingResults?: MatchingResult[], conf?: KVSearchConfiguration): T;
    private renderingWalk;
    private executeQuery;
    private internalMatch;
    private processWalkingPath;
    private recursiveMatch;
    private matchSingleStringOrNumber;
}
