import { DecodedValueMap, QueryParamConfig, QueryParamConfigMap, StringParam } from 'serialize-query-params';
import { QueryParamOptions } from './options';
import { QueryParamConfigMapWithInherit, SetQuery } from './types';
declare type UseQueryParamsResult<QPCMap extends QueryParamConfigMap> = [
    DecodedValueMap<QPCMap>,
    SetQuery<QPCMap>
];
declare type ExpandInherits<QPCMap extends QueryParamConfigMapWithInherit> = {
    [ParamName in keyof QPCMap]: QPCMap[ParamName] extends string ? typeof StringParam : QPCMap[ParamName] extends QueryParamConfig<any> ? QPCMap[ParamName] : never;
};
/**
 * Given a query parameter configuration (mapping query param name to { encode, decode }),
 * return an object with the decoded values and a setter for updating them.
 */
export declare function useQueryParams<QPCMap extends QueryParamConfigMap = QueryParamConfigMap>(): UseQueryParamsResult<QPCMap>;
export declare function useQueryParams<QPCMap extends QueryParamConfigMapWithInherit>(names: string[], options?: QueryParamOptions): UseQueryParamsResult<ExpandInherits<QPCMap>>;
export declare function useQueryParams<QPCMap extends QueryParamConfigMapWithInherit, OutputQPCMap extends QueryParamConfigMap = ExpandInherits<QPCMap>>(paramConfigMap: QPCMap, options?: QueryParamOptions): UseQueryParamsResult<OutputQPCMap>;
export default useQueryParams;
