package Liblktlang.Prelude is
   Content : constant String :=
      "# In this file, the RootNode__ type designates the root node type from the" & Character'Val (10)
       & "# Langkit spec importing this prelude. See the ``Decl`` environment spec for" & Character'Val (10)
       & "# more details." & Character'Val (10)
       & Character'Val (10)
       & "|"" Trait implicitly implemented by all types" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "trait BasicTrait {" & Character'Val (10)
       & "    |"" Return whether this value is null." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun is_null(): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a 1-sized array whose only item is the expression." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun singleton(): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    generic[U]" & Character'Val (10)
       & "    fun do(do_fn: (T)->U, default_val: U = null[U]): U" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Wrap the node inside a ``Entity``, using the current entity" & Character'Val (10)
       & "    |"" informations." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun as_entity(): Entity[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Wrap the node inside a ``Entity``, using empty entity informations." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun as_bare_entity(): Entity[T]" & Character'Val (10)
       & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun to_builder(): NodeBuilder[T]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct Int {" & Character'Val (10)
       & "    |"" Convert a regular integer into a big integer." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun as_big_int(): BigInt" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct BigInt {" & Character'Val (10)
       & "    |"" Convert a big integer into a regular integer. This raises a" & Character'Val (10)
       & "    |"" PropertyError if the big integer is out of range." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun as_int(): Int" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct Symbol {" & Character'Val (10)
       & "    |"" Return this symbol as a string." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun image(): String" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct Regexp {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "@open" & Character'Val (10)
       & "enum Bool {" & Character'Val (10)
       & "    case false, true" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "trait Sized {" & Character'Val (10)
       & "    |"" Return the number of element in the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun length(): Int" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "trait Indexable {" & Character'Val (10)
       & "    |"" Do not use this function directly. This acts like the `[]` operator on" & Character'Val (10)
       & "    |"" indexable types." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun __call__(index: Int): T" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like the `[]` operator, but return null if `index` is out-of-bounds." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun at(index: Int): T" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "trait Iterable {" & Character'Val (10)
       & "    |"" Return an array of the results of evaluating `map_fn` to the items of" & Character'Val (10)
       & "    |"" `collection`." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" For instance, to return an array that contains all parents of an array of" & Character'Val (10)
       & "    |"" AST nodes:" & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" .. code:: lkt" & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |""     node_array.map((n) => n.parent)" & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    generic[U]" & Character'Val (10)
       & "    fun map(map_fn: (T)->U): Array[U]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``map``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    generic[U]" & Character'Val (10)
       & "    fun imap(map_fn: (T, Int)->U): Array[U]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``map``, except that `map_fn` is expected to return arrays:" & Character'Val (10)
       & "    |"" this returns an array that is the concatenation of all the returned" & Character'Val (10)
       & "    |"" arrays." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" .. code:: lkt" & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |""     [0, 2, 4].mapcat((n) => [n, n + 1]) == [0, 1, 2, 3, 4, 5]" & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    generic[U]" & Character'Val (10)
       & "    fun mapcat(map_fn: (T)->Array[U]): Array[U]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``mapcat``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    generic[U]" & Character'Val (10)
       & "    fun imapcat(map_fn: (T, Int)->Array[U]): Array[U]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Filter elements in the collection." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" This return an array that only contains items from the collection for" & Character'Val (10)
       & "    |"" which the ``filter_fn`` predicate returned true. For instance, to filter" & Character'Val (10)
       & "    |"" all null AST nodes in an array:" & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" .. code:: python" & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |""     node_array.filter(lambda n: Not(n.is_null))" & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun filter(filter_fn: (T)->Bool): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``filter``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun ifilter(filter_fn: (T, Int)->Bool): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Shortcut to perform ``filter`` and ``map`` in a single shot." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    generic[U]" & Character'Val (10)
       & "    fun filtermap(map_fn: (T)->U, filter_fn: (T)->Bool): Array[U]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``filtermap``, but the provided lambdas each have a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    generic[U]" & Character'Val (10)
       & "    fun ifiltermap(map_fn: (T, Int)->U, filter_fn: (T, Int)->Bool): Array[U]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the first element of the collection for which the ``filter_fn``" & Character'Val (10)
       & "    |"" predicate returned true." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun find(filter_fn: (T)->Bool): T" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return an array that contains all items in the collection until the" & Character'Val (10)
       & "    |"" first one for which the ``pred_fn`` predicate returns false." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" For instance, this returns an array that contains the first parents of" & Character'Val (10)
       & "    |"" ``node`` whose type is a subtype of some `Scope` AST node type:" & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" .. code:: python" & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |""     node.parents.take_while(lambda n: n.is_a(Scope))" & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun take_while(pred_fn: (T)->Bool): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``take_while``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun itake_while(pred_fn: (T, Int)->Bool): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return whether the collection is empty." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun empty(): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return whether the collection contains ``elt``." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun contains(elt: T): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return whether `pred_fn` returns true for all the items of the" & Character'Val (10)
       & "    |"" collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun all(logic_fn: (T)->Bool): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``all``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun iall(logic_fn: (T, Int)->Bool): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``all``, but return true as soon as the predicate returns true for" & Character'Val (10)
       & "    |"" one collection item." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun any(logic_fn: (T)->Bool): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``any``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun iany(logic_fn: (T, Int)->Bool): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``map``, except that `logic_fn` is expected to return equations:" & Character'Val (10)
       & "    |"" this returns a conjunction of all the returned equations." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun logic_all(logic_fn: (T)->Equation): Equation" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``logic_all``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun ilogic_all(logic_fn: (T, Int)->Equation): Equation" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``map``, except that `logic_fn` is expected to return equations:" & Character'Val (10)
       & "    |"" this returns a disjunction of all the returned equations." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun logic_any(logic_fn: (T)->Equation): Equation" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``logic_all``, but the provided lambda has a second argument" & Character'Val (10)
       & "    |"" corresponding to the index of the element inside the collection." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun ilogic_any(logic_fn: (T, Int)->Equation): Equation" & Character'Val (10)
       & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun to_set(): Set[T]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Base class for array types." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "struct Array implements Sized, Indexable[T], Iterable[T] {" & Character'Val (10)
       & "    |"" Turn the array into an iterator." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun to_iterator(): Iterator[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a copy of ``array`` with duplicated elements removed." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun unique(): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a new lexical environment that logically groups together multiple" & Character'Val (10)
       & "    |"" environments. `env_array` must be an array that contains the" & Character'Val (10)
       & "    |"" environments to be grouped. If it is empty, the empty environment is" & Character'Val (10)
       & "    |"" returned." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" If provided, `with_md` must be a metadata structure: it will be made the" & Character'Val (10)
       & "    |"" default metadata for this lexical environment." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun env_group(with_md: Metadata = null[Metadata]): LexicalEnv" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "struct Set implements Sized, Iterable[T] {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Base class for iterator types." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "struct Iterator {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "trait Node {" & Character'Val (10)
       & "    |"" Return the syntactic parent for this node. Return null for the root" & Character'Val (10)
       & "    |"" node." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun parent(): T" & Character'Val (10)
       & Character'Val (10)
       & "    |"" For nodes that introduce a new environment, return the parent lexical" & Character'Val (10)
       & "    |"" environment. Return the ""inherited"" environment otherwise." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun node_env(): LexicalEnv" & Character'Val (10)
       & Character'Val (10)
       & "    |"" For nodes that introduce a new environment, return it. Return the" & Character'Val (10)
       & "    |"" ""inherited"" environment otherwise." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun children_env(): LexicalEnv" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the analysis unit owning this node." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun unit(): AnalysisUnit" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return an array that contains the lexical parents, this node included" & Character'Val (10)
       & "    |"" iff ``with_self`` is True. Nearer parents are first in the list." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun parents(with_self: Bool = true): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return an array that contains the direct lexical" & Character'Val (10)
       & "    |"" children." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" .. warning:: This constructs a whole array every-time you call" & Character'Val (10)
       & "    |""     it, and as such is less efficient than calling the" & Character'Val (10)
       & "    |""     ``Child`` built-in." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun children(): Array[T]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the text corresponding to this node. Private property" & Character'Val (10)
       & "    |"" (for internal DSL use)." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun text(): String" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the PLE root that owns this node, or the unit root node if this" & Character'Val (10)
       & "    |"" unit has no PLE root." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun ple_root(): RootNode__" & Character'Val (10)
       & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun can_reach(from_node: RootNode__): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the first token used to parse this node." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun token_start(): Token" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the last token used to parse this node." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun token_end(): Token" & Character'Val (10)
       & Character'Val (10)
       & "    |""Return the 0-based index for Node in its parent's children." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun child_index(): Int" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the node's previous sibling, or null if there is no such sibling." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun previous_sibling(): Entity[RootNode__]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the node's next sibling, or null if there is no such sibling." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun next_sibling(): Entity[RootNode__]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return whether the node is a ghost." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" Unlike regular nodes, ghost nodes cover no token in the input source:" & Character'Val (10)
       & "    |"" they are logically located instead between two tokens. Both the" & Character'Val (10)
       & "    |"" ``token_start`` and the ``token_end`` of all ghost nodes is the token" & Character'Val (10)
       & "    |"" right after this logical position." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun is_ghost(): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a string containing the filename + the sloc in GNU conformant" & Character'Val (10)
       & "    |"" format. Useful to create diagnostics from a node." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun full_sloc_image(): String" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[class T]" & Character'Val (10)
       & "class ASTList: RootNode__ implements Sized, Indexable[T], Iterable[T] {" & Character'Val (10)
       & "    |"" Convert the list of nodes to an array." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun as_array(): Array[T]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[class T]" & Character'Val (10)
       & "class NodeBuilder {" & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun build(parent: RootNode__ = null[RootNode__]): T" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct Char {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct String implements Sized, Indexable[Char], Iterable[Char] {" & Character'Val (10)
       & "    |"" Turn a string into the corresponding symbol." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun to_symbol(): Symbol" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a string that is the concatenation of all elements in ``string``," & Character'Val (10)
       & "    |"" with the ``self`` string in-between each array element." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun join(strings: Array[String]): String" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & Character'Val (10)
       & "|"" This type represents a logical variable. A logical variable is a reference," & Character'Val (10)
       & "|"" that can take a specific value when it is bound to a specific Equation, and" & Character'Val (10)
       & "|"" that equation is solved for a certain problem set." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" It is a special type in Langkit at this point, in that its value is" & Character'Val (10)
       & "|"" initially undefined, and is mutated after the solve of an equation to a" & Character'Val (10)
       & "|"" specific value. It is thus the only type in Langkit for the moment for" & Character'Val (10)
       & "|"" which variables of the type can be mutated after creation." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" TODO: For the moment a logic variable is necessarily a holder around an" & Character'Val (10)
       & "|"" ASTNodeType. At some point we might want to make it generic, like list and" & Character'Val (10)
       & "|"" array types." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct LogicVar {" & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun get_value(): Entity[RootNode__]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Describes an interpretation of a reference. Can be attached to logic atoms" & Character'Val (10)
       & "|"" (e.g. Binds) to indicate under which interpretation this particular atom was" & Character'Val (10)
       & "|"" produced, which can in turn be used to produce informative diagnostics for" & Character'Val (10)
       & "|"" resolution failures." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct LogicContext {" & Character'Val (10)
       & "    ref_node: Entity[RootNode__]" & Character'Val (10)
       & "    decl_node: Entity[RootNode__]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "dynvar logic_context: LogicContext" & Character'Val (10)
       & Character'Val (10)
       & Character'Val (10)
       & "|"" An Equation instance is an equation where logic variables (of type LogicVar)" & Character'Val (10)
       & "|"" are involved in logical expressions." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" An equation can be solved, and the variables instances will then be bound to" & Character'Val (10)
       & "|"" specific values." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" Equations instance will typically be produced by expressions involving logic" & Character'Val (10)
       & "|"" variables." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct Equation {" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Solve the equation and return whether any solution was found or not. The" & Character'Val (10)
       & "    |"" solutions are not returned, instead, logic variables are bound to their" & Character'Val (10)
       & "    |"" values in the current solution." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun solve(): Bool" & Character'Val (10)
       & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``solve`` but return a ``SolverResult`` struct instead, which" & Character'Val (10)
       & "    |"" ``success`` field indicates whether resolution was successful or not." & Character'Val (10)
       & "    |"" If not, its ``diagnostics`` field contains an array of" & Character'Val (10)
       & "    |"" ``SolverDiagnostic``." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun solve_with_diagnostics(): SolverResult" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct PropertyError {" & Character'Val (10)
       & "    exception_message: String = ""PropertyError exception""" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct PreconditionFailure {" & Character'Val (10)
       & "    exception_message: String = ""PreconditionFailure exception""" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "@ignore_constructor_arg" & Character'Val (10)
       & "struct RefCategories {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "enum LookupKind {" & Character'Val (10)
       & "    case recursive, flat, minimal" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct LexicalEnv {" & Character'Val (10)
       & "    |"" Perform a lexical environment lookup. Look for nodes that are associated" & Character'Val (10)
       & "    |"" to the given ``symbol`` in the lexical environment." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" If ``lookup`` is null (the default), it will take the default" & Character'Val (10)
       & "    |"" value ``LookupKind.recursive`` which will do a recursive lookup in" & Character'Val (10)
       & "    |"" parent environments and referenced ones." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" If ``lookup`` evaluates to ``LookupKind.flat``, only lookup own" & Character'Val (10)
       & "    |"" env and transitive referenced/parent envs." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" If ``lookup`` evaluates to ``LookupKind.minimal``, only lookup" & Character'Val (10)
       & "    |"" own env." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" If ``origin`` is not None, do a sequential lookup: discard AST nodes" & Character'Val (10)
       & "    |"" that belong to the same unit as ``from_node`` node and that appear" & Character'Val (10)
       & "    |"" before it." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun get(" & Character'Val (10)
       & "        symbol: Symbol," & Character'Val (10)
       & "        origin: RootNode__ = null[RootNode__]," & Character'Val (10)
       & "        lookup: LookupKind = LookupKind.recursive," & Character'Val (10)
       & "        categories: RefCategories = null[RefCategories]" & Character'Val (10)
       & "    ): Array[Entity[RootNode__]]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Like ``get``, but only return the first entity found, or a null entity" & Character'Val (10)
       & "    |"" if no entity is found." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun get_first(" & Character'Val (10)
       & "        symbol: Symbol," & Character'Val (10)
       & "        origin: RootNode__ = null[RootNode__]," & Character'Val (10)
       & "        lookup: LookupKind = LookupKind.recursive," & Character'Val (10)
       & "        categories: RefCategories = null[RefCategories]" & Character'Val (10)
       & "    ): Entity[RootNode__]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the node associated to the `env` environment." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun env_node(): RootNode__" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a copy of the lexical environment which has no parent." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun env_orphan(): LexicalEnv" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the parent of the lexical environment." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun env_parent(): LexicalEnv" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a new ``EntityInfo`` struct in which rebindings are shedded" & Character'Val (10)
       & "    |"" according to the location of the given lexical environment. This simply" & Character'Val (10)
       & "    |"" forwards the call to langkit support's ``Shed_Entity_Info`` subprogram." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun shed_rebindings(info: EntityInfo): EntityInfo" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a new environment based on `env` to include the given" & Character'Val (10)
       & "    |"" `rebindings`." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun rebind_env(r: EnvRebindings): LexicalEnv" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "enum DesignatedEnvKind {" & Character'Val (10)
       & "    case none, current_env, named_env, direct_env" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Designate an environment for an env spec action." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" The designated environment can be either, depending on the ``kind``" & Character'Val (10)
       & "|"" field:" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * If ``kind`` is ``none``, no environment is designated." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * If ``kind`` is ``current_env``, designate the current environment" & Character'Val (10)
       & "|""   at this point during PLE." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * If ``kind`` is ``named_env``, designate the environment which" & Character'Val (10)
       & "|""   has precedence for the ``env_name`` environment name. If" & Character'Val (10)
       & "|""   ``env_name`` is null, this designates to environment." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * If ``kind`` is ``direct_env``, the direct value for the" & Character'Val (10)
       & "|""   designated environment. That environment must be a primary one" & Character'Val (10)
       & "|""   and cannot be foreign to the node currently processed by PLE. If" & Character'Val (10)
       & "|""   it is the empty environment, do nothing." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct DesignatedEnv {" & Character'Val (10)
       & "    kind: DesignatedEnvKind" & Character'Val (10)
       & "    env_name: Symbol" & Character'Val (10)
       & "    direct_env: LexicalEnv" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Specify a kind of analysis unit. Specification units provide an interface to" & Character'Val (10)
       & "|"" the outer world while body units provide an implementation for the" & Character'Val (10)
       & "|"" corresponding interface." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "enum AnalysisUnitKind {" & Character'Val (10)
       & "    case unit_specification, unit_body" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Represent the analysis of a single file." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "trait AnalysisUnit {" & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun root(): RootNode__" & Character'Val (10)
       & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun is_referenced_from(unit: AnalysisUnit): Bool" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct EnvRebindings {" & Character'Val (10)
       & "    |"" Lexical environment that is remapped by ``rebindings``." & Character'Val (10)
       & "    old_env: LexicalEnv" & Character'Val (10)
       & "    |"" Lexical environment that ``rebindings`` remaps to." & Character'Val (10)
       & "    new_env: LexicalEnv" & Character'Val (10)
       & "    |"" Parent rebindings for ``rebindings``." & Character'Val (10)
       & "    get_parent: EnvRebindings" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Functionally append a rebinding from `old_env` to `new_env` (two lexical" & Character'Val (10)
       & "    |"" environments) on top of `rebindings` (a chain of rebindings)." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun append_rebinding(" & Character'Val (10)
       & "        old_env: LexicalEnv," & Character'Val (10)
       & "        new_env: LexicalEnv" & Character'Val (10)
       & "    ): EnvRebindings" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Combine rebindings `rhs` with the current environment rebindings." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    fun concat_rebindings(rhs: EnvRebindings): EnvRebindings" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" EnvAssoc type, used to add associations of keys and values to the lexical" & Character'Val (10)
       & "|"" environments, via the add_to_env primitive." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct EnvAssoc {" & Character'Val (10)
       & "    key: Symbol" & Character'Val (10)
       & "    value: RootNode__" & Character'Val (10)
       & "    dest_env: DesignatedEnv" & Character'Val (10)
       & "    metadata: Metadata" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" This built-in type is involved in the dynamic primary env mechanism." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct InnerEnvAssoc {" & Character'Val (10)
       & "    key: Symbol" & Character'Val (10)
       & "    value: RootNode__" & Character'Val (10)
       & "    rebindings: EnvRebindings = null[EnvRebindings]" & Character'Val (10)
       & "    metadata: Metadata = null[Metadata]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Represents the kind of a referenced env. Here are the different kinds:" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * transitive: The reference is transitive, e.g. it will be explored in" & Character'Val (10)
       & "|""   every case (whether the lookup is recursive or not). It will be explored" & Character'Val (10)
       & "|""   *before* parent environments." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * prioritary: The reference is non transitive, e.g. it will be explored" & Character'Val (10)
       & "|""   only if the lookup on the env is recursive. It will be explored *before*" & Character'Val (10)
       & "|""   parent environments." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * normal: The reference is non transitive, e.g. it will be explored only" & Character'Val (10)
       & "|""   if the lookup on the env is recursive. It will be explored *after*" & Character'Val (10)
       & "|""   parent environments." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "@open" & Character'Val (10)
       & "enum RefKind {" & Character'Val (10)
       & "    case transitive, prioritary, normal" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Action to do in an environment specification." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct EnvAction {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Action that sets the initial env in which the rest of the environment" & Character'Val (10)
       & "|"" actions are evaluated. Except for Do() hooks, this action must be first in" & Character'Val (10)
       & "|"" the list of actions." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" ``env``: Environment that must become the initial one." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun set_initial_env(env: DesignatedEnv): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Create a new lexical environment." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" This action creates an environment related to this node. Using this action" & Character'Val (10)
       & "|"" has restrictions:" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" * there can be only one such action per env spec;" & Character'Val (10)
       & "|"" * it must be a pre action." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" ``no_parent``: If passed, the new env will be created with no parent env." & Character'Val (10)
       & "|"" ``transitive_parent``: TODO." & Character'Val (10)
       & "|"" ``names``: Optional array of names (symbols) for the created" & Character'Val (10)
       & "|""     environment. If not passed or if this is an empty array, the created" & Character'Val (10)
       & "|""     environment is not named." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun add_env(" & Character'Val (10)
       & "    no_parent: Bool = false," & Character'Val (10)
       & "    transitive_parent: Bool = false," & Character'Val (10)
       & "    names: Array[Symbol] = null" & Character'Val (10)
       & "): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Specify a single to add to the lexical environment." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun add_single_to_env(mapping: EnvAssoc): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Specify elements to add to the lexical environment." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun add_all_to_env(mappings: Array[EnvAssoc]): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Specify a single element to add to the lexical environment. See ``EnvAssoc``" & Character'Val (10)
       & "|"" for more precision about the first four arguments." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun add_to_env_kv(" & Character'Val (10)
       & "    key: Symbol," & Character'Val (10)
       & "    value: RootNode__," & Character'Val (10)
       & "    dest_env: DesignatedEnv = null," & Character'Val (10)
       & "    metadata: Metadata = null" & Character'Val (10)
       & "): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Evaluate given expression for its side effects, discarding its result." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[T]" & Character'Val (10)
       & "fun do(expr: T): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Handle the node's children lexical environments." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun handle_children(): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Reference a group of lexical environments, that will be lazily yielded by" & Character'Val (10)
       & "|"" calling the `through` property on the array of nodes `nodes`." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" ``nodes``: An expression that yields a list of nodes." & Character'Val (10)
       & "|"" ``through``: A property reference." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" ``kind``: Kind of reference." & Character'Val (10)
       & "|"" ``dest_env``: If passed, the destination environment for this reference." & Character'Val (10)
       & "|"" ``cond``: If passed, an expression evaluating to a boolean condition. If" & Character'Val (10)
       & "|""     False, reference won't be made and the others expressions won't be" & Character'Val (10)
       & "|""     evaluated." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" ``category``: If passed, must be a string representing a category name." & Character'Val (10)
       & "|""     String must represent a valid Ada name. A category in set of possible" & Character'Val (10)
       & "|""     referenced envs categories will be implicitly created for each unique" & Character'Val (10)
       & "|""     string passed to a call to reference, in a given compilation context." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" ``shed_corresponding_rebindings``: If true, when shedding rebindings" & Character'Val (10)
       & "|""     during an env lookup, this referenced env will be followed to check," & Character'Val (10)
       & "|""     and eventually shed rebindings associated to the referenced env." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun reference(" & Character'Val (10)
       & "    nodes: Array[RootNode__]," & Character'Val (10)
       & "    through: ()->LexicalEnv," & Character'Val (10)
       & "    kind: RefKind = normal," & Character'Val (10)
       & "    dest_env: LexicalEnv = null," & Character'Val (10)
       & "    cond: Bool = true," & Character'Val (10)
       & "    category: String = null," & Character'Val (10)
       & "    shed_corresponding_rebindings: Bool = false" & Character'Val (10)
       & "): EnvAction" & Character'Val (10)
       & Character'Val (10)
       & "|"" Record that contains semantic information which, when added to an AST node," & Character'Val (10)
       & "|"" makes an ``Entity``." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct EntityInfo {" & Character'Val (10)
       & "    |"" The metadata associated to the AST node" & Character'Val (10)
       & "    md: Metadata" & Character'Val (10)
       & Character'Val (10)
       & "    |"" The environment rebindings." & Character'Val (10)
       & "    rebindings: EnvRebindings" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Whether the entity was obtained from rebindings, or a lexical" & Character'Val (10)
       & "    |"" environment." & Character'Val (10)
       & "    from_rebound: Bool" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Node type with assorted semantic information." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "generic[N]" & Character'Val (10)
       & "struct Entity {" & Character'Val (10)
       & "    |"" The stored AST node." & Character'Val (10)
       & "    node: N" & Character'Val (10)
       & "    |"" Entity info for this node." & Character'Val (10)
       & "    info: EntityInfo" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Nodes that implement this trait can only be parsed as a single token." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "trait TokenNode {" & Character'Val (10)
       & "    |"" Return the symbol that this node was parsed from." & Character'Val (10)
       & "    @builtin" & Character'Val (10)
       & "    @property" & Character'Val (10)
       & "    fun symbol(): Symbol" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & Character'Val (10)
       & "|"" A raw diagnostic produced by a solver resolution failure. This contains as" & Character'Val (10)
       & "|"" much information as possible to allow formatters down the chain to" & Character'Val (10)
       & "|"" filter/choose which diagnostics to show among a set of diagnostics produced" & Character'Val (10)
       & "|"" for a single equation." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct SolverDiagnostic {" & Character'Val (10)
       & "    |"" String explaining the error, which may contain holes represented by the" & Character'Val (10)
       & "    |"" ``{}`` characters." & Character'Val (10)
       & "    message_template: String" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Array of nodes, which are to be plugged in the" & Character'Val (10)
       & "    |"" holes of the template in the same order (i.e. the first argument" & Character'Val (10)
       & "    |"" goes into the first hole of the template, etc.)." & Character'Val (10)
       & "    args: Array[Entity[RootNode__]]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Node which indicates the location of the error." & Character'Val (10)
       & "    location: RootNode__" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Array of contexts that were deemed relevant for this error." & Character'Val (10)
       & "    contexts: Array[LogicContext]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Solver round during which this diagnostic was emitted." & Character'Val (10)
       & "    round: Int" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & Character'Val (10)
       & "|"" A pair returned by the ``solve_with_diagnostic`` primitive." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct SolverResult {" & Character'Val (10)
       & "    |"" Field indicating whether resolution was successful or not." & Character'Val (10)
       & "    success: Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Array of diagnostics which may be non-empty if ``success`` is ``false``." & Character'Val (10)
       & "    diagnostics: Array[SolverDiagnostic] = null[Array[SolverDiagnostic]]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Reference to a token in an analysis unit." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct Token {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Location in a source fie. Line and column numbers are one-based." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct SourceLocation {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "struct __internal {" & Character'Val (10)
       & "    |"" Placeholder type when the Langkit specification does not have a type" & Character'Val (10)
       & "    |"" annotated with ``@metadata``." & Character'Val (10)
       & "    |""" & Character'Val (10)
       & "    |"" This is hidden in its own scope and later has a reference in the" & Character'Val (10)
       & "    |"" global lexical environemnt so that if no type is designated as metadata," & Character'Val (10)
       & "    |"" this types serves as fallback." & Character'Val (10)
       & "    @metadata" & Character'Val (10)
       & "    struct __EmptyMetadata {" & Character'Val (10)
       & "    }" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Nodes that implement this trait are considered error nodes for when parsing" & Character'Val (10)
       & "|"" errors occur." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "trait ErrorNode {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "struct Address {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Build a dynamic lexical environment." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" Lookup through such environments uses the given property to determine the" & Character'Val (10)
       & "|"" list of (symbol, node) associations to be analyzed. This property must take" & Character'Val (10)
       & "|"" no argument and return an array of ``InnerEnvAssoc`` structs." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" This is opposed to the environments created during PLE which, at the end of" & Character'Val (10)
       & "|"" the PLE stage, contain a static mapping of such assocations.  Note that" & Character'Val (10)
       & "|"" building such environments is only possible in lazy field initializers." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun dynamic_lexical_env(" & Character'Val (10)
       & "    assocs_getter: ()->Array[InnerEnvAssoc]," & Character'Val (10)
       & "    assoc_resolver: ()->Entity[RootNode__] = null," & Character'Val (10)
       & "    transitive_parent: Bool = true" & Character'Val (10)
       & "): LexicalEnv" & Character'Val (10)
       & Character'Val (10)
       & "|"" Define the domain of a logical variable. Several important properties about" & Character'Val (10)
       & "|"" this expression:" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" This is the entry point into the logic DSL. A ``LogicVar`` variable *must*" & Character'Val (10)
       & "|"" have a domain defined in the context of an equation. If it doesn't, its" & Character'Val (10)
       & "|"" solution set is empty, and thus the only possible value for it is undefined." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" If an equation is defined in which the only constraint on variables is their" & Character'Val (10)
       & "|"" domains, then, for a set A, B, .., N of logical variables, with domains DA," & Character'Val (10)
       & "|"" DB, .., DN, the set of solutions will be of the product of the set of every" & Character'Val (10)
       & "|"" domains." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" So for example, in the equation::" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|""     domain(A, [1, 2]) and domain(B, [1, 2])" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" The set of solutions is::" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|""     [(1, 1), (1, 2), (2, 1), (2, 2)]" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" The ``or`` operator acts like concatenation on domains of logic variable," & Character'Val (10)
       & "|"" so for example::" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|""     domain(A, [1, 2]) or Domain(A, [3, 4])" & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" is equivalent to (but slower than) ``domain(A, [1, 2, 3, 4])``." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" You can define an equation that is invalid, in that not every equation has" & Character'Val (10)
       & "|"" a domain, and, due to runtime dispatch, we cannot statically predict if" & Character'Val (10)
       & "|"" that's going to happen. Thus, trying to solve such an equation will result" & Character'Val (10)
       & "|"" in an error." & Character'Val (10)
       & "|""" & Character'Val (10)
       & "|"" Please note that for the moment equations can exist only on AST nodes, so" & Character'Val (10)
       & "|"" the above examples are invalid, and just meant to illustrate the semantics." & Character'Val (10)
       & "@builtin" & Character'Val (10)
       & "fun domain(var: LogicVar, values: Array[Entity[RootNode__]]): Equation" & Character'Val (10)
       & Character'Val (10)
       & "|"" Node that serves as the location of a diagnostic when a solver predicate" & Character'Val (10)
       & "|"" fails" & Character'Val (10)
       & "dynvar error_location: RootNode__" & Character'Val (10)
       & Character'Val (10)
       & "#" & Character'Val (10)
       & "# Generic interfaces" & Character'Val (10)
       & "#" & Character'Val (10)
       & Character'Val (10)
       & "# TODO: Enforce that no user defined type can implement interfaces reserved" & Character'Val (10)
       & "# for builtin types." & Character'Val (10)
       & Character'Val (10)
       & "# Reserved for builtin types." & Character'Val (10)
       & "#" & Character'Val (10)
       & "# Defines the interface for Logic_Context. The type is not manually defined in" & Character'Val (10)
       & "# the generated libraries, so we need to define this interface in order to have" & Character'Val (10)
       & "# the corresponding generated class implement the interface from the support" & Character'Val (10)
       & "# library." & Character'Val (10)
       & "|"" Describes an interpretation of a reference. Can be attached to logic atoms" & Character'Val (10)
       & "|"" (e.g. Binds) to indicate under which interpretation this particular atom was" & Character'Val (10)
       & "|"" produced, which can in turn be used to produce informative diagnostics for" & Character'Val (10)
       & "|"" resolution failures." & Character'Val (10)
       & "@generic_interface()" & Character'Val (10)
       & "trait LogicContextInterface {" & Character'Val (10)
       & "    fun ref_node(): NodeInterface" & Character'Val (10)
       & "    fun decl_node(): NodeInterface" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "# Reserved for builtin types." & Character'Val (10)
       & "#" & Character'Val (10)
       & "# Defines the interface for Solver_Diagnostic. The type is not manually defined" & Character'Val (10)
       & "# in the generated libraries, so we need to define this interface in order to" & Character'Val (10)
       & "# have the corresponding generated class implement the interface from the" & Character'Val (10)
       & "# support library." & Character'Val (10)
       & "|"" A raw diagnostic produced by a solver resolution failure. This contains as" & Character'Val (10)
       & "|"" much information as possible to allow formatters down the chain to" & Character'Val (10)
       & "|"" filter/choose which diagnostics to show among a set of diagnostics produced" & Character'Val (10)
       & "|"" for a single equation." & Character'Val (10)
       & "@generic_interface()" & Character'Val (10)
       & "trait SolverDiagnosticInterface {" & Character'Val (10)
       & "    |"" Return the string explaining the error, which may contain holes" & Character'Val (10)
       & "    |"" represented by the ``{}`` characters." & Character'Val (10)
       & "    fun message_template(): String" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return an array of nodes, which are to be plugged in the holes of the" & Character'Val (10)
       & "    |"" template in the same order (i.e. the first argument goes into the first" & Character'Val (10)
       & "    |"" hole of the template, etc.)." & Character'Val (10)
       & "    fun args(): Array[NodeInterface]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the node which indicates the location of the error." & Character'Val (10)
       & "    fun location(): NodeInterface" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the array of contexts that were deemed relevant for this error." & Character'Val (10)
       & "    fun contexts(): Array[LogicContextInterface]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "# This interface is automatically implemented by the root node. It musts" & Character'Val (10)
       & "# not be implemented in the language spec. Unlike ``LspNodeInterface``" & Character'Val (10)
       & "# below, this interface does have any method. It is only used as a type so" & Character'Val (10)
       & "# that other interface may refer to the root node type without forcing the" & Character'Val (10)
       & "# user to implement the methods of ``LspNodeInterface``." & Character'Val (10)
       & "|"" Interface representing the root node." & Character'Val (10)
       & "@generic_interface(node_only=true)" & Character'Val (10)
       & "trait NodeInterface {" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface to be implemented by all nodes that will support common LSP" & Character'Val (10)
       & "|"" requests: run name resolution or code completion." & Character'Val (10)
       & "@generic_interface(node_only=true)" & Character'Val (10)
       & "trait LspNodeInterface {" & Character'Val (10)
       & "    |"" Return True if this node is an entry point for name resolution." & Character'Val (10)
       & "    fun xref_entry_point(): Bool" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a list of completion item." & Character'Val (10)
       & "    fun complete_items(): Array[CompletionItemInterface]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Run name resolution on this node if it is an entry point and return all" & Character'Val (10)
       & "    |"" raised diagnostics, if any." & Character'Val (10)
       & "    fun nameres_diagnostics(): Array[SolverDiagnosticInterface]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface representing identifiers that define an entity in the analyzed" & Character'Val (10)
       & "|"" source code." & Character'Val (10)
       & "@generic_interface(node_only=true)" & Character'Val (10)
       & "trait DefiningNameInterface {" & Character'Val (10)
       & "    |"" Return the full name defined by this DefiningName." & Character'Val (10)
       & "    fun full_name(): String" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return a string containing the detail of this defining name to display" & Character'Val (10)
       & "    |"" when hovering or in completion items (generally the type or prototype)." & Character'Val (10)
       & "    fun decl_detail(): String" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return an integer correspoding to the LSP's CompletionItemKind type." & Character'Val (10)
       & "    fun completion_item_kind(): Int" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the documentation associated to this defining name." & Character'Val (10)
       & "    fun documentation(): String" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the type associated to this defining name." & Character'Val (10)
       & "    fun get_type(): TypeInterface" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return an array of RefResults containing all references in the given" & Character'Val (10)
       & "    |"" AnalysisUnits." & Character'Val (10)
       & "    fun find_all_references(" & Character'Val (10)
       & "        units: Array[AnalysisUnit]" & Character'Val (10)
       & "    ): Array[RefResultInterface]" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return an array of DefiningName containing all implementations of the" & Character'Val (10)
       & "    |"" DefiningName in the given units." & Character'Val (10)
       & "    fun find_implementations(" & Character'Val (10)
       & "        units: Array[AnalysisUnit]" & Character'Val (10)
       & "    ): Array[DefiningNameInterface]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface representing types in the analyzed source code." & Character'Val (10)
       & "@generic_interface(node_only=true)" & Character'Val (10)
       & "trait TypeInterface {" & Character'Val (10)
       & "    |"" Return the full name of the type." & Character'Val (10)
       & "    fun full_name(): String" & Character'Val (10)
       & Character'Val (10)
       & "    |"" Return the DefiningName of the type associated to this type." & Character'Val (10)
       & "    fun defining_name(): DefiningNameInterface" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface representing nodes that can have a type in the analyzed source" & Character'Val (10)
       & "|"" code." & Character'Val (10)
       & "@generic_interface(node_only=true)" & Character'Val (10)
       & "trait TypableNodeInterface {" & Character'Val (10)
       & "    |"" Return the type of the associated to this node." & Character'Val (10)
       & "    fun expr_type(): TypeInterface" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface representing nodes that reference a definition." & Character'Val (10)
       & "@generic_interface(node_only=true)" & Character'Val (10)
       & "trait ReferenceInterface {" & Character'Val (10)
       & "    |"" Return the DefiningName referenced by this object." & Character'Val (10)
       & "    fun referenced_defining_name(): DefiningNameInterface" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface representing a declaration containing at least one defined name." & Character'Val (10)
       & "@generic_interface(node_only=true)" & Character'Val (10)
       & "trait DeclarationInterface {" & Character'Val (10)
       & "    |"" Return the list of names defined by this definition." & Character'Val (10)
       & "    fun defining_names(): Array[DefiningNameInterface]" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface representing a struct that contains completion information." & Character'Val (10)
       & "@generic_interface()" & Character'Val (10)
       & "trait CompletionItemInterface {" & Character'Val (10)
       & "    |"" Return the declaration for this completion item." & Character'Val (10)
       & "    fun decl(): DeclarationInterface" & Character'Val (10)
       & "}" & Character'Val (10)
       & Character'Val (10)
       & "|"" Interface representing a struct that contains the result of resolving an" & Character'Val (10)
       & "|"" entity reference." & Character'Val (10)
       & "@generic_interface()" & Character'Val (10)
       & "trait RefResultInterface {" & Character'Val (10)
       & "    |"" Return the reference of this RefResult." & Character'Val (10)
       & "    fun ref(): ReferenceInterface" & Character'Val (10)
       & "}" & Character'Val (10)

   ;
end Liblktlang.Prelude;