import * as React from 'react'
import * as Container from '../../util/container'
import * as Types from '../../constants/types/fs'
import * as Constants from '../../constants/fs'
import * as Kb from '../../common-adapters'
import * as Styles from '../../styles'

// The behavior is to only show spinner when user first time lands on a screen
// and when don't have the data that drives it yet. Since RPCs happen
// automatically, we are just relying on whether data is available from the
// redux store.

type OwnProps = {
  path: Types.Path
}

const mapStateToProps = (state, {path}: OwnProps) => ({
  _pathItem: Constants.getPathItem(state.fs.pathItems, path),
  _tlfsLoaded: !!state.fs.tlfs.private.size,
})

const mergeProps = (stateProps, _, {path}: OwnProps) => {
  const parsedPath = Constants.parsePath(path)
  switch (parsedPath.kind) {
    case Types.PathKind.Root:
      return {show: false}
    case Types.PathKind.TlfList:
      return {show: !stateProps._tlfsLoaded}
    case Types.PathKind.TeamTlf:
    case Types.PathKind.GroupTlf:
    case Types.PathKind.InTeamTlf:
    case Types.PathKind.InGroupTlf:
      // Only show the loading spinner when we are first-time loading a pathItem.
      // If we already have content to show, just don't show spinner anymore even
      // if we are loading.
      if (stateProps._pathItem.type === Types.PathType.Unknown) {
        return {show: true}
      }
      if (
        stateProps._pathItem.type === Types.PathType.Folder &&
        stateProps._pathItem.progress === Types.ProgressType.Pending
      ) {
        return {show: true}
      }
      return {show: false}
    default:
      return {show: false}
  }
}

const Loading = props => props.show && <Kb.ProgressIndicator style={styles.progressIndicator} />

const styles = Styles.styleSheetCreate(
  () =>
    ({
      progressIndicator: {
        height: 18,
        width: 18,
      },
    } as const)
)

export default Container.connect(mapStateToProps, () => ({}), mergeProps)(Loading)
