// Auto-generated by avdl-compiler v1.3.29 (https://github.com/keybase/node-avdl-compiler)
//   Input file: prot.avdl

package flip

import (
	"errors"
	chat1 "github.com/keybase/client/go/protocol/chat1"
	gregor1 "github.com/keybase/client/go/protocol/gregor1"
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
)

type Time int64

func (o Time) DeepCopy() Time {
	return o
}

type Start struct {
	StartTime                    Time           `codec:"startTime" json:"startTime"`
	CommitmentWindowMsec         int64          `codec:"commitmentWindowMsec" json:"commitmentWindowMsec"`
	RevealWindowMsec             int64          `codec:"revealWindowMsec" json:"revealWindowMsec"`
	SlackMsec                    int64          `codec:"slackMsec" json:"slackMsec"`
	CommitmentCompleteWindowMsec int64          `codec:"commitmentCompleteWindowMsec" json:"commitmentCompleteWindowMsec"`
	Params                       FlipParameters `codec:"params" json:"params"`
}

func (o Start) DeepCopy() Start {
	return Start{
		StartTime:                    o.StartTime.DeepCopy(),
		CommitmentWindowMsec:         o.CommitmentWindowMsec,
		RevealWindowMsec:             o.RevealWindowMsec,
		SlackMsec:                    o.SlackMsec,
		CommitmentCompleteWindowMsec: o.CommitmentCompleteWindowMsec,
		Params:                       o.Params.DeepCopy(),
	}
}

type UserDevice struct {
	D gregor1.DeviceID `codec:"d" json:"d"`
	U gregor1.UID      `codec:"u" json:"u"`
}

func (o UserDevice) DeepCopy() UserDevice {
	return UserDevice{
		D: o.D.DeepCopy(),
		U: o.U.DeepCopy(),
	}
}

type GameMetadata struct {
	Initiator      UserDevice           `codec:"initiator" json:"initiator"`
	ConversationID chat1.ConversationID `codec:"conversationID" json:"conversationID"`
	GameID         chat1.FlipGameID     `codec:"gameID" json:"gameID"`
}

func (o GameMetadata) DeepCopy() GameMetadata {
	return GameMetadata{
		Initiator:      o.Initiator.DeepCopy(),
		ConversationID: o.ConversationID.DeepCopy(),
		GameID:         o.GameID.DeepCopy(),
	}
}

type CommitmentComplete struct {
	Players []UserDeviceCommitment `codec:"players" json:"players"`
}

func (o CommitmentComplete) DeepCopy() CommitmentComplete {
	return CommitmentComplete{
		Players: (func(x []UserDeviceCommitment) []UserDeviceCommitment {
			if x == nil {
				return nil
			}
			ret := make([]UserDeviceCommitment, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Players),
	}
}

type FlipType int

const (
	FlipType_BOOL    FlipType = 1
	FlipType_INT     FlipType = 2
	FlipType_BIG     FlipType = 3
	FlipType_SHUFFLE FlipType = 4
)

func (o FlipType) DeepCopy() FlipType { return o }

var FlipTypeMap = map[string]FlipType{
	"BOOL":    1,
	"INT":     2,
	"BIG":     3,
	"SHUFFLE": 4,
}

var FlipTypeRevMap = map[FlipType]string{
	1: "BOOL",
	2: "INT",
	3: "BIG",
	4: "SHUFFLE",
}

func (e FlipType) String() string {
	if v, ok := FlipTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type FlipParameters struct {
	T__       FlipType `codec:"t" json:"t"`
	Int__     *int64   `codec:"int,omitempty" json:"int,omitempty"`
	Big__     *[]byte  `codec:"big,omitempty" json:"big,omitempty"`
	Shuffle__ *int64   `codec:"shuffle,omitempty" json:"shuffle,omitempty"`
}

func (o *FlipParameters) T() (ret FlipType, err error) {
	switch o.T__ {
	case FlipType_INT:
		if o.Int__ == nil {
			err = errors.New("unexpected nil value for Int__")
			return ret, err
		}
	case FlipType_BIG:
		if o.Big__ == nil {
			err = errors.New("unexpected nil value for Big__")
			return ret, err
		}
	case FlipType_SHUFFLE:
		if o.Shuffle__ == nil {
			err = errors.New("unexpected nil value for Shuffle__")
			return ret, err
		}
	}
	return o.T__, nil
}

func (o FlipParameters) Int() (res int64) {
	if o.T__ != FlipType_INT {
		panic("wrong case accessed")
	}
	if o.Int__ == nil {
		return
	}
	return *o.Int__
}

func (o FlipParameters) Big() (res []byte) {
	if o.T__ != FlipType_BIG {
		panic("wrong case accessed")
	}
	if o.Big__ == nil {
		return
	}
	return *o.Big__
}

func (o FlipParameters) Shuffle() (res int64) {
	if o.T__ != FlipType_SHUFFLE {
		panic("wrong case accessed")
	}
	if o.Shuffle__ == nil {
		return
	}
	return *o.Shuffle__
}

func NewFlipParametersWithBool() FlipParameters {
	return FlipParameters{
		T__: FlipType_BOOL,
	}
}

func NewFlipParametersWithInt(v int64) FlipParameters {
	return FlipParameters{
		T__:   FlipType_INT,
		Int__: &v,
	}
}

func NewFlipParametersWithBig(v []byte) FlipParameters {
	return FlipParameters{
		T__:   FlipType_BIG,
		Big__: &v,
	}
}

func NewFlipParametersWithShuffle(v int64) FlipParameters {
	return FlipParameters{
		T__:       FlipType_SHUFFLE,
		Shuffle__: &v,
	}
}

func (o FlipParameters) DeepCopy() FlipParameters {
	return FlipParameters{
		T__: o.T__.DeepCopy(),
		Int__: (func(x *int64) *int64 {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Int__),
		Big__: (func(x *[]byte) *[]byte {
			if x == nil {
				return nil
			}
			tmp := (func(x []byte) []byte {
				if x == nil {
					return nil
				}
				return append([]byte{}, x...)
			})((*x))
			return &tmp
		})(o.Big__),
		Shuffle__: (func(x *int64) *int64 {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Shuffle__),
	}
}

type MessageType int

const (
	MessageType_START               MessageType = 1
	MessageType_COMMITMENT          MessageType = 2
	MessageType_COMMITMENT_COMPLETE MessageType = 3
	MessageType_REVEAL              MessageType = 4
	MessageType_END                 MessageType = 5
)

func (o MessageType) DeepCopy() MessageType { return o }

var MessageTypeMap = map[string]MessageType{
	"START":               1,
	"COMMITMENT":          2,
	"COMMITMENT_COMPLETE": 3,
	"REVEAL":              4,
	"END":                 5,
}

var MessageTypeRevMap = map[MessageType]string{
	1: "START",
	2: "COMMITMENT",
	3: "COMMITMENT_COMPLETE",
	4: "REVEAL",
	5: "END",
}

func (e MessageType) String() string {
	if v, ok := MessageTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type Stage int

const (
	Stage_ROUND1 Stage = 1
	Stage_ROUND2 Stage = 2
)

func (o Stage) DeepCopy() Stage { return o }

var StageMap = map[string]Stage{
	"ROUND1": 1,
	"ROUND2": 2,
}

var StageRevMap = map[Stage]string{
	1: "ROUND1",
	2: "ROUND2",
}

func (e Stage) String() string {
	if v, ok := StageRevMap[e]; ok {
		return v
	}
	return ""
}

type Secret [32]byte

func (o Secret) DeepCopy() Secret {
	var ret Secret
	copy(ret[:], o[:])
	return ret
}

type Commitment [32]byte

func (o Commitment) DeepCopy() Commitment {
	var ret Commitment
	copy(ret[:], o[:])
	return ret
}

type UserDeviceCommitment struct {
	Ud UserDevice `codec:"ud" json:"ud"`
	C  Commitment `codec:"c" json:"c"`
}

func (o UserDeviceCommitment) DeepCopy() UserDeviceCommitment {
	return UserDeviceCommitment{
		Ud: o.Ud.DeepCopy(),
		C:  o.C.DeepCopy(),
	}
}

type Hash [32]byte

func (o Hash) DeepCopy() Hash {
	var ret Hash
	copy(ret[:], o[:])
	return ret
}

type Reveal struct {
	Secret Secret `codec:"secret" json:"secret"`
	Cch    Hash   `codec:"cch" json:"cch"`
}

func (o Reveal) DeepCopy() Reveal {
	return Reveal{
		Secret: o.Secret.DeepCopy(),
		Cch:    o.Cch.DeepCopy(),
	}
}

type GameMessageBody struct {
	T__                  MessageType         `codec:"t" json:"t"`
	Start__              *Start              `codec:"start,omitempty" json:"start,omitempty"`
	Commitment__         *Commitment         `codec:"commitment,omitempty" json:"commitment,omitempty"`
	CommitmentComplete__ *CommitmentComplete `codec:"commitmentComplete,omitempty" json:"commitmentComplete,omitempty"`
	Reveal__             *Reveal             `codec:"reveal,omitempty" json:"reveal,omitempty"`
}

func (o *GameMessageBody) T() (ret MessageType, err error) {
	switch o.T__ {
	case MessageType_START:
		if o.Start__ == nil {
			err = errors.New("unexpected nil value for Start__")
			return ret, err
		}
	case MessageType_COMMITMENT:
		if o.Commitment__ == nil {
			err = errors.New("unexpected nil value for Commitment__")
			return ret, err
		}
	case MessageType_COMMITMENT_COMPLETE:
		if o.CommitmentComplete__ == nil {
			err = errors.New("unexpected nil value for CommitmentComplete__")
			return ret, err
		}
	case MessageType_REVEAL:
		if o.Reveal__ == nil {
			err = errors.New("unexpected nil value for Reveal__")
			return ret, err
		}
	}
	return o.T__, nil
}

func (o GameMessageBody) Start() (res Start) {
	if o.T__ != MessageType_START {
		panic("wrong case accessed")
	}
	if o.Start__ == nil {
		return
	}
	return *o.Start__
}

func (o GameMessageBody) Commitment() (res Commitment) {
	if o.T__ != MessageType_COMMITMENT {
		panic("wrong case accessed")
	}
	if o.Commitment__ == nil {
		return
	}
	return *o.Commitment__
}

func (o GameMessageBody) CommitmentComplete() (res CommitmentComplete) {
	if o.T__ != MessageType_COMMITMENT_COMPLETE {
		panic("wrong case accessed")
	}
	if o.CommitmentComplete__ == nil {
		return
	}
	return *o.CommitmentComplete__
}

func (o GameMessageBody) Reveal() (res Reveal) {
	if o.T__ != MessageType_REVEAL {
		panic("wrong case accessed")
	}
	if o.Reveal__ == nil {
		return
	}
	return *o.Reveal__
}

func NewGameMessageBodyWithStart(v Start) GameMessageBody {
	return GameMessageBody{
		T__:     MessageType_START,
		Start__: &v,
	}
}

func NewGameMessageBodyWithCommitment(v Commitment) GameMessageBody {
	return GameMessageBody{
		T__:          MessageType_COMMITMENT,
		Commitment__: &v,
	}
}

func NewGameMessageBodyWithCommitmentComplete(v CommitmentComplete) GameMessageBody {
	return GameMessageBody{
		T__:                  MessageType_COMMITMENT_COMPLETE,
		CommitmentComplete__: &v,
	}
}

func NewGameMessageBodyWithReveal(v Reveal) GameMessageBody {
	return GameMessageBody{
		T__:      MessageType_REVEAL,
		Reveal__: &v,
	}
}

func NewGameMessageBodyWithEnd() GameMessageBody {
	return GameMessageBody{
		T__: MessageType_END,
	}
}

func (o GameMessageBody) DeepCopy() GameMessageBody {
	return GameMessageBody{
		T__: o.T__.DeepCopy(),
		Start__: (func(x *Start) *Start {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Start__),
		Commitment__: (func(x *Commitment) *Commitment {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Commitment__),
		CommitmentComplete__: (func(x *CommitmentComplete) *CommitmentComplete {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.CommitmentComplete__),
		Reveal__: (func(x *Reveal) *Reveal {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Reveal__),
	}
}

type Version int

const (
	Version_V1 Version = 1
)

func (o Version) DeepCopy() Version { return o }

var VersionMap = map[string]Version{
	"V1": 1,
}

var VersionRevMap = map[Version]string{
	1: "V1",
}

func (e Version) String() string {
	if v, ok := VersionRevMap[e]; ok {
		return v
	}
	return ""
}

type GameMessage struct {
	V__  Version        `codec:"v" json:"v"`
	V1__ *GameMessageV1 `codec:"v1,omitempty" json:"v1,omitempty"`
}

func (o *GameMessage) V() (ret Version, err error) {
	switch o.V__ {
	case Version_V1:
		if o.V1__ == nil {
			err = errors.New("unexpected nil value for V1__")
			return ret, err
		}
	}
	return o.V__, nil
}

func (o GameMessage) V1() (res GameMessageV1) {
	if o.V__ != Version_V1 {
		panic("wrong case accessed")
	}
	if o.V1__ == nil {
		return
	}
	return *o.V1__
}

func NewGameMessageWithV1(v GameMessageV1) GameMessage {
	return GameMessage{
		V__:  Version_V1,
		V1__: &v,
	}
}

func NewGameMessageDefault(v Version) GameMessage {
	return GameMessage{
		V__: v,
	}
}

func (o GameMessage) DeepCopy() GameMessage {
	return GameMessage{
		V__: o.V__.DeepCopy(),
		V1__: (func(x *GameMessageV1) *GameMessageV1 {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V1__),
	}
}

type GameMessageV1 struct {
	Md   GameMetadata    `codec:"md" json:"md"`
	Body GameMessageBody `codec:"body" json:"body"`
}

func (o GameMessageV1) DeepCopy() GameMessageV1 {
	return GameMessageV1{
		Md:   o.Md.DeepCopy(),
		Body: o.Body.DeepCopy(),
	}
}

type FlipInterface interface {
}

func FlipProtocol(i FlipInterface) rpc.Protocol {
	return rpc.Protocol{
		Name:    "flip.flip",
		Methods: map[string]rpc.ServeHandlerDescription{},
	}
}

type FlipClient struct {
	Cli rpc.GenericClient
}
