/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.encryption_signing.BcPGPHashContextContentSignerBuilder;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;

public class BcHashContextSigner {
    public static PGPSignature signHashContext(@Nonnull MessageDigest hashContext, @Nonnull SignatureType signatureType, @Nonnull PGPSecretKeyRing secretKeys, @Nonnull SecretKeyRingProtector protector) throws PGPException {
        PGPPublicKey signingKeyCandidate;
        KeyRingInfo info = PGPainless.inspectKeyRing(secretKeys);
        List<PGPPublicKey> signingSubkeyCandidates = info.getSigningSubkeys();
        PGPSecretKey signingKey = null;
        Iterator<PGPPublicKey> iterator = signingSubkeyCandidates.iterator();
        while (iterator.hasNext() && (signingKey = secretKeys.getSecretKey((signingKeyCandidate = iterator.next()).getKeyID())) == null) {
        }
        if (signingKey == null) {
            throw new PGPException("Key does not contain suitable signing subkey.");
        }
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(signingKey, protector);
        return BcHashContextSigner.signHashContext(hashContext, signatureType, privateKey);
    }

    static PGPSignature signHashContext(MessageDigest hashContext, SignatureType signatureType, PGPPrivateKey privateKey) throws PGPException {
        PGPSignatureGenerator sigGen = new PGPSignatureGenerator(new BcPGPHashContextContentSignerBuilder(hashContext));
        sigGen.init(signatureType.getCode(), privateKey);
        return sigGen.generate();
    }
}

