<?
###########################################################################
#
# index.php -  NagTrap start page
#
# Copyright (c) 2006 - 2007 Michael Luebben (nagtrap@nagtrap.org)
# Last Modified: 13.10.2007
#
# License:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
###########################################################################
//?><PRE><?
//var_dump($_POST);
//var_dump($_GET);
//?></PRE><?
// Disable error-message
error_reporting(E_ALL ^ E_NOTICE);

require("./include/defines/global.php");

require("./include/functions/functions.debug.php");

require("./include/classes/class.main.php");
require("./include/classes/class.frontend.php");
require("./include/classes/class.common.php");
require("./include/classes/class.mysqlDB.php");


$MAIN = new main();

// Read config.ini.php
$configINI = $MAIN->readConfig(CONST_MAINCFG);

// Set variables in configuration
$configINI['database']['tableSnmpttArchive'] = "snmptt_archive";

// Read error.xml for error-messages
$errorXML = $MAIN->readXML("./include/xml/language/".$configINI['global']['language']."/error.xml");

// Read language 
$languageXML = $MAIN->readXML("./include/xml/language/".$configINI['global']['language']."/main.xml");

// Set table
$table = $MAIN->setTable($tableName,$_REQUEST['severity'],$_REQUEST['trapSelect']);

$FRONTEND = new frontend($configINI);

$FRONTEND->openSite();

$FRONTEND->constructorHeader();

if ($MAIN->checkUser() == "0") {
   $FRONTEND->printError("AUTHENTIFICATION",NULL);
} else {
   $DATABASE = new database($configINI);
   $DATABASE->connect();

   // If set action, then mark, delete or archive a trap in the database
   if($_GET['action'] == "mark" or $_GET['action'] == "delete" or $_GET['action'] == "archive") {
      $DATABASE->handleTrap($_GET['action'],$_GET['trapID'],$table['name']); 
   }

   // Mark more as one trap 
   if($_POST["markTraps"] AND $_POST["trapIDs"]){
      foreach($_POST["trapIDs"] as $trapID){
         $DATABASE->handleTrap("mark",$trapID,$table['name']); 
      }
   }

   // Delete more as one trap 
   if($_POST["deleteTraps"] AND $_POST["trapIDs"]){
      foreach($_POST["trapIDs"] as $trapID){
         $DATABASE->handleTrap("delete",$trapID,$table['name']);
      }
   }

   // Delete more as one trap 
   if($_POST["archiveTraps"] AND $_POST["trapIDs"]){
      foreach($_POST["trapIDs"] as $trapID){
         $DATABASE->handleTrap("archive",$trapID,$table['name']);
      }
   }

   $FRONTEND->constructorMain();
   $FRONTEND->constructorFooter();
}
$FRONTEND->closeSite();
$FRONTEND->printSite();
?>
