/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.AttributeSelectionUtils;
import org.gradle.internal.component.model.DefaultAttributeMatcher;
import org.gradle.internal.component.model.DefaultCompatibilityCheckResult;
import org.gradle.internal.component.model.DefaultMultipleCandidateResult;
import org.gradle.internal.component.resolution.failure.ResolutionFailureDescriberRegistry;
import org.gradle.internal.component.resolution.failure.describer.ResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.interfaces.ResolutionFailure;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;

public class DefaultAttributesSchema
implements AttributesSchemaInternal {
    private final InstantiatorFactory instantiatorFactory;
    private final IsolatableFactory isolatableFactory;
    private final ResolutionFailureDescriberRegistry failureDescriberRegistry;
    private final Map<Attribute<?>, AttributeMatchingStrategy<?>> strategies = new HashMap();
    private final Map<String, Attribute<?>> attributesByName = new HashMap();
    private final List<AttributeDescriber> consumerAttributeDescribers = new ArrayList<AttributeDescriber>();
    private final Set<Attribute<?>> precedence = new LinkedHashSet();
    private final Map<AttributesSchemaInternal, AttributeMatcher> matcherCache = new ConcurrentHashMap<AttributesSchemaInternal, AttributeMatcher>();

    public DefaultAttributesSchema(InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory) {
        this(instantiatorFactory, instantiatorFactory.inject(), isolatableFactory);
    }

    public DefaultAttributesSchema(InstantiatorFactory instantiatorFactory, InstanceGenerator instanceGenerator, IsolatableFactory isolatableFactory) {
        this.instantiatorFactory = instantiatorFactory;
        this.isolatableFactory = isolatableFactory;
        this.failureDescriberRegistry = ResolutionFailureDescriberRegistry.emptyRegistry(instanceGenerator);
    }

    public <T> AttributeMatchingStrategy<T> getMatchingStrategy(Attribute<T> attribute) {
        AttributeMatchingStrategy<?> strategy = this.strategies.get(attribute);
        if (strategy == null) {
            throw new IllegalArgumentException("Unable to find matching strategy for " + attribute);
        }
        return (AttributeMatchingStrategy)Cast.uncheckedCast(strategy);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute) {
        return this.attribute(attribute, null);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute, @Nullable Action<? super AttributeMatchingStrategy<T>> configureAction) {
        AttributeMatchingStrategy strategy = (AttributeMatchingStrategy)Cast.uncheckedCast(this.strategies.get(attribute));
        if (strategy == null) {
            strategy = (AttributeMatchingStrategy)Cast.uncheckedCast((Object)this.instantiatorFactory.decorateLenient().newInstance(DefaultAttributeMatchingStrategy.class, new Object[]{this.instantiatorFactory, this.isolatableFactory}));
            this.strategies.put(attribute, strategy);
            this.attributesByName.put(attribute.getName(), attribute);
        }
        if (configureAction != null) {
            configureAction.execute((Object)strategy);
        }
        return strategy;
    }

    public Set<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    public boolean hasAttribute(Attribute<?> key) {
        return this.strategies.containsKey(key);
    }

    @Override
    public AttributeMatcher withProducer(AttributesSchemaInternal producerSchema) {
        return this.matcherCache.computeIfAbsent(producerSchema, key -> new DefaultAttributeMatcher(new DefaultAttributeSelectionSchema(this, producerSchema)));
    }

    @Override
    public AttributeMatcher matcher() {
        return this.withProducer(EmptySchema.INSTANCE);
    }

    @Override
    public CompatibilityRule<Object> compatibilityRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (CompatibilityRule)Cast.uncheckedCast((Object)matchingStrategy.getCompatibilityRules());
        }
        return EmptySchema.INSTANCE.compatibilityRules(attribute);
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (DisambiguationRule)Cast.uncheckedCast((Object)matchingStrategy.getDisambiguationRules());
        }
        return EmptySchema.INSTANCE.disambiguationRules(attribute);
    }

    public List<AttributeDescriber> getConsumerDescribers() {
        return this.consumerAttributeDescribers;
    }

    public void addConsumerDescriber(AttributeDescriber describer) {
        this.consumerAttributeDescribers.add(describer);
    }

    public void attributeDisambiguationPrecedence(Attribute<?> ... attributes) {
        for (Attribute<?> attribute : attributes) {
            if (this.precedence.add(attribute)) continue;
            throw new IllegalArgumentException(String.format("Attribute '%s' precedence has already been set.", attribute.getName()));
        }
    }

    public void setAttributeDisambiguationPrecedence(List<Attribute<?>> attributes) {
        this.precedence.clear();
        this.attributeDisambiguationPrecedence(attributes.toArray(new Attribute[0]));
    }

    public List<Attribute<?>> getAttributeDisambiguationPrecedence() {
        return Collections.unmodifiableList(new ArrayList(this.precedence));
    }

    @Override
    @Nullable
    public Attribute<?> getAttributeByName(String name) {
        return this.attributesByName.get(name);
    }

    @Override
    public <FAILURE extends ResolutionFailure> void addFailureDescriber(Class<FAILURE> failureType, Class<? extends ResolutionFailureDescriber<FAILURE>> describerType) {
        this.failureDescriberRegistry.registerDescriber(failureType, describerType);
    }

    @Override
    public <FAILURE extends ResolutionFailure> List<ResolutionFailureDescriber<FAILURE>> getFailureDescribers(Class<FAILURE> failureType) {
        return this.failureDescriberRegistry.getDescribers(failureType);
    }

    private static class ExtraAttributesEntry {
        private final ImmutableAttributes[] candidateAttributeSets;
        private final ImmutableAttributes requestedAttributes;
        private final int hashCode;

        private ExtraAttributesEntry(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requestedAttributes) {
            this.candidateAttributeSets = candidateAttributeSets;
            this.requestedAttributes = requestedAttributes;
            int hash = Arrays.hashCode(candidateAttributeSets);
            this.hashCode = hash = 31 * hash + requestedAttributes.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraAttributesEntry that = (ExtraAttributesEntry)o;
            if (this.requestedAttributes != that.requestedAttributes) {
                return false;
            }
            if (this.candidateAttributeSets.length != that.candidateAttributeSets.length) {
                return false;
            }
            for (int i = 0; i < this.candidateAttributeSets.length; ++i) {
                if (this.candidateAttributeSets[i] == that.candidateAttributeSets[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class DefaultAttributeSelectionSchema
    implements AttributeSelectionSchema {
        private final AttributesSchemaInternal consumerSchema;
        private final AttributesSchemaInternal producerSchema;
        private final Map<ExtraAttributesEntry, Attribute<?>[]> extraAttributesCache;

        public DefaultAttributeSelectionSchema(AttributesSchemaInternal consumerSchema, AttributesSchemaInternal producerSchema) {
            this.consumerSchema = consumerSchema;
            this.producerSchema = producerSchema;
            this.extraAttributesCache = new ConcurrentHashMap<ExtraAttributesEntry, Attribute<?>[]>();
        }

        @Override
        public boolean hasAttribute(Attribute<?> attribute) {
            return this.consumerSchema.getAttributes().contains(attribute) || this.producerSchema.getAttributes().contains(attribute);
        }

        @Override
        public Set<Object> disambiguate(Attribute<?> attribute, @Nullable Object requested, Set<Object> candidates) {
            DefaultMultipleCandidateResult<Object> result = null;
            DisambiguationRule<Object> rules = this.consumerSchema.disambiguationRules(attribute);
            if (rules.doesSomething()) {
                result = new DefaultMultipleCandidateResult<Object>(requested, candidates);
                rules.execute(result);
                if (result.hasResult()) {
                    return result.getMatches();
                }
            }
            if ((rules = this.producerSchema.disambiguationRules(attribute)).doesSomething()) {
                if (result == null) {
                    result = new DefaultMultipleCandidateResult<Object>(requested, candidates);
                }
                rules.execute(result);
                if (result.hasResult()) {
                    return result.getMatches();
                }
            }
            if (requested != null && candidates.contains(requested)) {
                return Collections.singleton(requested);
            }
            return null;
        }

        @Override
        public boolean matchValue(Attribute<?> attribute, Object requested, Object candidate) {
            if (requested.equals(candidate)) {
                return true;
            }
            DefaultCompatibilityCheckResult<Object> result = null;
            CompatibilityRule<Object> rules = this.consumerSchema.compatibilityRules(attribute);
            if (rules.doesSomething()) {
                result = new DefaultCompatibilityCheckResult<Object>(requested, candidate);
                rules.execute(result);
                if (result.hasResult()) {
                    return result.isCompatible();
                }
            }
            if ((rules = this.producerSchema.compatibilityRules(attribute)).doesSomething()) {
                if (result == null) {
                    result = new DefaultCompatibilityCheckResult<Object>(requested, candidate);
                }
                rules.execute(result);
                if (result.hasResult()) {
                    return result.isCompatible();
                }
            }
            return false;
        }

        @Override
        public Attribute<?> getAttribute(String name) {
            Attribute<?> attribute = this.consumerSchema.getAttributeByName(name);
            if (attribute != null) {
                return attribute;
            }
            return this.producerSchema.getAttributeByName(name);
        }

        @Override
        public Attribute<?>[] collectExtraAttributes(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requested) {
            ExtraAttributesEntry entry = new ExtraAttributesEntry(candidateAttributeSets, requested);
            return this.extraAttributesCache.computeIfAbsent(entry, key -> AttributeSelectionUtils.collectExtraAttributes(this, candidateAttributeSets, requested));
        }

        @Override
        public AttributeSelectionSchema.PrecedenceResult orderByPrecedence(Collection<Attribute<?>> requested) {
            if (this.consumerSchema.getAttributeDisambiguationPrecedence().isEmpty() && this.producerSchema.getAttributeDisambiguationPrecedence().isEmpty()) {
                return new AttributeSelectionSchema.PrecedenceResult(IntStream.range(0, requested.size()).boxed().collect(Collectors.toList()));
            }
            LinkedHashMap<String, Integer> remaining = new LinkedHashMap<String, Integer>();
            int position = 0;
            for (Attribute<?> requestedAttribute : requested) {
                remaining.put(requestedAttribute.getName(), position++);
            }
            ArrayList<Integer> sorted = new ArrayList<Integer>(remaining.size());
            for (Attribute preferredAttribute : this.consumerSchema.getAttributeDisambiguationPrecedence()) {
                if (!requested.contains(preferredAttribute)) continue;
                sorted.add((Integer)remaining.remove(preferredAttribute.getName()));
            }
            for (Attribute preferredAttribute : this.producerSchema.getAttributeDisambiguationPrecedence()) {
                if (!remaining.containsKey(preferredAttribute.getName()) || !requested.contains(preferredAttribute)) continue;
                sorted.add((Integer)remaining.remove(preferredAttribute.getName()));
            }
            if (sorted.isEmpty()) {
                return new AttributeSelectionSchema.PrecedenceResult(remaining.values());
            }
            return new AttributeSelectionSchema.PrecedenceResult(sorted, remaining.values());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultAttributeSelectionSchema that = (DefaultAttributeSelectionSchema)o;
            return this.consumerSchema.equals(that.consumerSchema) && this.producerSchema.equals(that.producerSchema);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.consumerSchema, this.producerSchema});
        }
    }
}

