// generated by diplomat-tool
import { DataError } from "./DataError.mjs"
import { DataProvider } from "./DataProvider.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `DecomposingNormalizer`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizer.html) for more information.
 */
const DecomposingNormalizer_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_DecomposingNormalizer_destroy_mv1(ptr);
});

export class DecomposingNormalizer {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("DecomposingNormalizer is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            DecomposingNormalizer_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Construct a new DecomposingNormalizer instance for NFD using compiled data.
     *
     * See the [Rust documentation for `new_nfd`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizer.html#method.new_nfd) for more information.
     */
    static createNfd() {

        const result = wasm.icu4x_DecomposingNormalizer_create_nfd_mv1();

        try {
            return new DecomposingNormalizer(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Construct a new DecomposingNormalizer instance for NFD using a particular data source.
     *
     * See the [Rust documentation for `new_nfd`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizer.html#method.new_nfd) for more information.
     */
    static createNfdWithProvider(provider) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_DecomposingNormalizer_create_nfd_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new DecomposingNormalizer(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Construct a new DecomposingNormalizer instance for NFKD using compiled data.
     *
     * See the [Rust documentation for `new_nfkd`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizer.html#method.new_nfkd) for more information.
     */
    static createNfkd() {

        const result = wasm.icu4x_DecomposingNormalizer_create_nfkd_mv1();

        try {
            return new DecomposingNormalizer(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Construct a new DecomposingNormalizer instance for NFKD using a particular data source.
     *
     * See the [Rust documentation for `new_nfkd`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizer.html#method.new_nfkd) for more information.
     */
    static createNfkdWithProvider(provider) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_DecomposingNormalizer_create_nfkd_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new DecomposingNormalizer(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Normalize a string
     *
     * Ill-formed input is treated as if errors had been replaced with REPLACEMENT CHARACTERs according
     * to the WHATWG Encoding Standard.
     *
     * See the [Rust documentation for `normalize_utf8`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizerBorrowed.html#method.normalize_utf8) for more information.
     */
    normalize(s) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const sSlice = diplomatRuntime.DiplomatBuf.str8(wasm, s);
        const write = new diplomatRuntime.DiplomatWriteBuf(wasm);

    wasm.icu4x_DecomposingNormalizer_normalize_mv1(this.ffiValue, ...sSlice.splat(), write.buffer);

        try {
            return write.readString8();
        }

        finally {
            functionCleanupArena.free();

            write.free();
        }
    }

    /**
     * Check if a string is normalized
     *
     * Ill-formed input is treated as if errors had been replaced with REPLACEMENT CHARACTERs according
     * to the WHATWG Encoding Standard.
     *
     * See the [Rust documentation for `is_normalized_utf8`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizerBorrowed.html#method.is_normalized_utf8) for more information.
     */
    isNormalized(s) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const sSlice = diplomatRuntime.DiplomatBuf.str8(wasm, s);

        const result = wasm.icu4x_DecomposingNormalizer_is_normalized_mv1(this.ffiValue, ...sSlice.splat());

        try {
            return result;
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * Check if a string is normalized
     *
     * Ill-formed input is treated as if errors had been replaced with REPLACEMENT CHARACTERs according
     * to the WHATWG Encoding Standard.
     *
     * See the [Rust documentation for `is_normalized_utf16`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizerBorrowed.html#method.is_normalized_utf16) for more information.
     */
    isNormalizedUtf16(s) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const sSlice = diplomatRuntime.DiplomatBuf.str16(wasm, s);

        const result = wasm.icu4x_DecomposingNormalizer_is_normalized_utf16_mv1(this.ffiValue, ...sSlice.splat());

        try {
            return result;
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * Return the index a slice of potentially-invalid UTF-8 is normalized up to
     *
     * See the [Rust documentation for `split_normalized_utf8`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizerBorrowed.html#method.split_normalized_utf8) for more information.
     *
     * See the [Rust documentation for `split_normalized`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizerBorrowed.html#method.split_normalized) for more information.
     */
    isNormalizedUpTo(s) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const sSlice = diplomatRuntime.DiplomatBuf.str8(wasm, s);

        const result = wasm.icu4x_DecomposingNormalizer_is_normalized_up_to_mv1(this.ffiValue, ...sSlice.splat());

        try {
            return result;
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * Return the index a slice of potentially-invalid UTF-16 is normalized up to
     *
     * See the [Rust documentation for `split_normalized_utf16`](https://docs.rs/icu/latest/icu/normalizer/struct.DecomposingNormalizerBorrowed.html#method.split_normalized_utf16) for more information.
     */
    isNormalizedUtf16UpTo(s) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const sSlice = diplomatRuntime.DiplomatBuf.str16(wasm, s);

        const result = wasm.icu4x_DecomposingNormalizer_is_normalized_utf16_up_to_mv1(this.ffiValue, ...sSlice.splat());

        try {
            return result;
        }

        finally {
            functionCleanupArena.free();

        }
    }

    constructor(symbol, ptr, selfEdge) {
        return this.#internalConstructor(...arguments)
    }
}