/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.pim;

import java.util.Date;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.PIMListImpl;
import org.kobjects.pim.PimField;
import org.kobjects.pim.PimItem;

abstract class PIMItemImpl
implements PIMItem {
    PimItem item;
    PIMListImpl list;
    boolean modified;

    PIMItemImpl(PIMListImpl list, PimItem item) {
        this.list = list;
        this.item = item;
    }

    String fieldToName(int id) {
        return this.list.fieldToName(id);
    }

    String attrToName(int id) {
        return this.list.attrToName(id);
    }

    abstract void copyItem();

    void addObject(int fieldId, int attr, Object data) {
        if (!this.modified) {
            this.copyItem();
            this.modified = true;
        }
        String name = this.fieldToName(fieldId);
        PimField field = new PimField(name);
        this.item.addField(field);
        this.setObject(fieldId, this.item.getFieldCount(name) - 1, attr, data);
    }

    Object getObject(int fieldId, int index) {
        return this.item.getField(this.fieldToName(fieldId), index).getValue();
    }

    public void addBinary(int field, int attributes, byte[] value, int offset, int length) {
        throw new RuntimeException("NYI");
    }

    public void addBoolean(int field, int attributes, boolean value) {
        this.addObject(field, attributes, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addDate(int field, int attributes, long value) {
        this.addObject(field, attributes, new Long(value));
    }

    public void addInt(int field, int attributes, int value) {
        this.addObject(field, attributes, new Integer(value));
    }

    public void addString(int field, int attributes, String value) {
        this.addObject(field, attributes, value);
    }

    public void addStringArray(int field, int attributes, String[] value) {
        this.addObject(field, attributes, value);
    }

    public void addToCategory(String category) {
        throw new RuntimeException("NYI");
    }

    public int countValues(int field) {
        return this.item.getFieldCount(this.fieldToName(field));
    }

    public int maxCategories() {
        return 0;
    }

    public int getAttributes(int id, int index) {
        PimField field = this.item.getField(this.fieldToName(id), index);
        int[] attrs = this.list.getSupportedAttributes(id);
        int set = 0;
        for (int i = 0; i < attrs.length; ++i) {
            if (!field.getAttribute(this.attrToName(attrs[i]))) continue;
            set |= attrs[i];
        }
        return set;
    }

    public byte[] getBinary(int field, int index) {
        return (byte[])this.getObject(field, index);
    }

    public boolean getBoolean(int field, int index) {
        return (Boolean)this.getObject(field, index);
    }

    public String[] getCategories() {
        throw new RuntimeException("NYI");
    }

    public long getDate(int field, int index) {
        throw new RuntimeException("NYI");
    }

    public int[] getFields() {
        throw new RuntimeException("NYI");
    }

    public int getInt(int field, int index) {
        return (Integer)this.getObject(field, index);
    }

    public PIMList getPIMList() {
        return this.list;
    }

    public String getString(int field, int index) {
        return (String)this.getObject(field, index);
    }

    public String[] getStringArray(int field, int index) {
        return (String[])this.getObject(field, index);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void removeFromCategory(String category) {
        throw new RuntimeException("NYI");
    }

    public void removeValue(int field, int index) {
        if (!this.modified) {
            this.copyItem();
            this.modified = true;
        }
        this.item.removeField(this.fieldToName(field), index);
    }

    public void setBinary(int field, int index, int attributes, byte[] value, int offset, int length) {
        throw new RuntimeException("NYI");
    }

    public void setBoolean(int field, int index, int attributes, boolean value) {
        this.setObject(field, index, attributes, new Boolean(value));
    }

    public void setDate(int field, int index, int attributes, long value) {
        this.setObject(field, index, attributes, new Date(value));
    }

    public void setInt(int field, int index, int attributes, int value) {
        this.setObject(field, index, attributes, new Integer(value));
    }

    void setObject(int fieldID, int index, int attributes, Object value) {
        if (!this.modified) {
            this.copyItem();
            this.modified = true;
        }
        PimField field = this.item.getField(this.fieldToName(fieldID), index);
        field.setValue(value);
        int[] supp = this.list.getSupportedAttributes(fieldID);
        for (int i = 0; i < supp.length; ++i) {
            field.setAttribute(this.attrToName(supp[i]), (attributes & supp[i]) != 0);
        }
    }

    public void setString(int field, int index, int attributes, String value) {
        this.setObject(field, index, attributes, value);
    }

    public void setStringArray(int field, int index, int attributes, String[] value) {
        this.setObject(field, index, attributes, value);
    }
}

