/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CmdInfo;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.ScmDeviceLabel;
import javax.microedition.lcdui.ScmSoftButton;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.scm.ScmComponent;
import org.me4se.scm.ScmContainer;
import org.me4se.scm.ScmScrollBar;
import org.me4se.scm.ScmScrollPane;

class ScmDisplayable
extends ScmContainer {
    static String[] TYPES = new String[]{"null", "SCREEN", "BACK", "CANCEL", "OK", "HELP", "STOP", "EXIT", "ITEM"};
    static final Command OPTIONS_COMMAND = new Command(ApplicationManager.getProperty("options.command.label", "Menu"), 1, 0);
    static final Command ITEM_SELECT_COMMAND = new Command("Select", 4, 0);
    Displayable displayable;
    ScmSoftButton[] softButtons;
    Hashtable buttons = new Hashtable();
    ApplicationManager manager = ApplicationManager.getInstance();
    ScmDeviceLabel title;
    ScmDeviceLabel ticker;
    ScmComponent main;
    int best;
    boolean shutdownTrigger;

    ScmDisplayable(Displayable displayable) {
        this.displayable = displayable;
        this.setWidth(this.manager.screenWidth);
        this.setHeight(this.manager.screenHeight);
        this.init();
    }

    public void init() {
        int cnt;
        this.fullScreen = this.displayable instanceof Canvas && ((Canvas)this.displayable)._fullScreenMode;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
        if (!this.fullScreen) {
            this.title = this.displayable.titleComponent;
            this.ticker = this.displayable.tickerComponent;
            this.add(this.title);
            if (this.title.location == null) {
                this.title.setHeight(this.title.getMinimumSize().height);
                this.title.setWidth(this.getWidth());
            }
            if (this.ticker.location != null) {
                this.add(this.ticker);
            }
            if (this.displayable instanceof Screen) {
                Screen scr = (Screen)this.displayable;
                if (scr.iconUp != null) {
                    this.add(scr.iconUp);
                }
                if (scr.iconDown != null) {
                    this.add(scr.iconDown);
                }
            }
        }
        if (ApplicationManager.getProperty("skin") == null) {
            cnt = 2;
        } else {
            cnt = 0;
            while (ApplicationManager.getProperty("softbutton." + cnt) != null) {
                ++cnt;
            }
        }
        this.softButtons = new ScmSoftButton[cnt];
        for (int i = 0; i < this.softButtons.length; ++i) {
            this.softButtons[i] = new ScmSoftButton(this, i);
            if (this.fullScreen) continue;
            this.add(this.softButtons[i]);
        }
    }

    public void paint(Graphics g) {
        Vector toRun = null;
        if (this.displayable.display != null && this.displayable.display.callSerially.size() > 0) {
            toRun = this.displayable.display.callSerially;
            this.displayable.display.callSerially = new Vector();
        }
        super.paint(g);
        if (this.manager.timeoutImage != null) {
            g.drawImage(this.manager.timeoutImage, (this.getWidth() - this.manager.timeoutImage.getWidth(null)) / 2, (this.getHeight() - this.manager.timeoutImage.getHeight(null)) / 2, null);
        }
        if (toRun != null) {
            for (int i = 0; i < toRun.size(); ++i) {
                ((Runnable)toRun.elementAt(i)).run();
            }
        }
    }

    public boolean keyRepeated(String key) {
        if (this.shutdownTrigger) {
            ApplicationManager.getInstance().active.notifyDestroyed();
            return true;
        }
        return super.keyRepeated(key);
    }

    public boolean keyPressed(String key) {
        ScmSoftButton bi;
        int nr;
        this.shutdownTrigger = "POWER".equals(key);
        String timeout = ApplicationManager.getProperty("me4se.timeout");
        if (timeout != null && !timeout.equals("")) {
            if (this.manager.firstKeyPress == 0L) {
                this.manager.firstKeyPress = System.currentTimeMillis();
            } else if (this.manager.firstKeyPress + 1000L * (long)Integer.parseInt(timeout) < System.currentTimeMillis()) {
                if (this.manager.timeoutImage == null) {
                    try {
                        this.manager.timeoutImage = this.manager.getImage(ApplicationManager.getProperty("me4se.timeout-image", "/timeout.png"));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }
        }
        if (key.startsWith("SOFT") && key.length() == 5 && (nr = key.charAt(4) - 49) < this.softButtons.length && (bi = this.softButtons[nr]).getParent() != null) {
            bi.action();
            return true;
        }
        return super.keyPressed(key);
    }

    void setMain(ScmComponent main, boolean scrollable) {
        if (scrollable) {
            ScmScrollPane scrollPane = new ScmScrollPane();
            scrollPane.add(main);
            if (ApplicationManager.getFlag("scrollbar")) {
                ScmScrollBar sb = new ScmScrollBar();
                sb.setBackground(ApplicationManager.getInstance().bgColor);
                scrollPane.setVerticalBar(sb);
            }
            main = scrollPane;
        }
        if (this.main != null) {
            this.remove(this.main);
        }
        this.main = main;
        this.add(main);
        this.doLayout();
    }

    protected void updateButtons() {
        Vector commands = this.displayable.getCommandInfoList();
        this.buttons = new Hashtable();
        for (int i = 0; i < commands.size(); ++i) {
            String dj;
            CmdInfo ci = (CmdInfo)commands.elementAt(i);
            Command cmd = ci.command;
            int j = 0;
            String[] desired = ApplicationManager.split(ApplicationManager.getProperty("command.keys." + cmd.getTypeName()));
            if (j >= desired.length || this.buttons.get(dj = desired[j].toUpperCase()) != null || dj.startsWith("SOFT")) continue;
            this.buttons.put(dj, ci);
            if (cmd.getLabel() != null && !cmd.getLabel().equals("") || cmd.getLongLabel() != null && !cmd.getLongLabel().equals("")) continue;
            commands.removeElementAt(i);
            --i;
        }
        Vector remaining = null;
        for (int pass = 0; pass < 2; ++pass) {
            int i;
            for (int i2 = 0; i2 < this.softButtons.length; ++i2) {
                this.softButtons[i2].setCommand(null, null);
            }
            CmdInfo reinserted = null;
            remaining = new Vector();
            for (i = 0; i < commands.size(); ++i) {
                remaining.addElement(commands.elementAt(i));
            }
            if (pass == 1) {
                remaining.insertElementAt(new CmdInfo(OPTIONS_COMMAND, null), 0);
            }
            for (i = 0; i < remaining.size(); ++i) {
                String dj;
                int j;
                CmdInfo ci = (CmdInfo)remaining.elementAt(i);
                Command cmd = ci.command;
                String[] desired = ApplicationManager.split(ApplicationManager.getProperty(cmd == OPTIONS_COMMAND ? "command.menu.activate" : "command.keys." + cmd.getTypeName()));
                if (cmd == OPTIONS_COMMAND && desired.length == 0) {
                    desired = new String[]{"SOFT" + this.softButtons.length};
                }
                if ((j = 0) >= desired.length || !(dj = desired[j].toUpperCase()).startsWith("SOFT")) continue;
                this.buttons.put(dj, ci);
                int idx = Integer.parseInt(dj.substring(4)) - 1;
                if (this.softButtons[idx].command != null) continue;
                this.softButtons[idx].setCommand(cmd, ci.item);
                remaining.removeElementAt(i);
                --i;
                if (this.softButtons[idx].getWidth() >= 50 || ci.command.type == 0) continue;
                remaining.addElement(ci);
                reinserted = ci;
            }
            for (i = 0; i < this.softButtons.length && remaining.size() > 0; ++i) {
                if (this.softButtons[i].command != null) continue;
                CmdInfo ci = (CmdInfo)remaining.elementAt(0);
                if (this.softButtons[i].getWidth() >= 50) {
                    remaining.removeElementAt(0);
                }
                this.softButtons[i].setCommand(ci.command, ci.item);
            }
            if (remaining.size() == 0 || remaining.size() == 1 && remaining.elementAt(0) == reinserted) break;
        }
        this.displayable.commandMenuEntries = remaining;
    }

    public void doLayout() {
        int x = 0;
        int y = 0;
        int w = this.manager.screenWidth;
        int h = this.manager.screenHeight;
        x = ApplicationManager.getIntProperty("screenPaintableRegion.x", x);
        y = ApplicationManager.getIntProperty("screenPaintableRegion.y", y);
        w = ApplicationManager.getIntProperty("screenPaintableRegion.width", w);
        h = ApplicationManager.getIntProperty("screenPaintableRegion.height", h);
        if (this.fullScreen) {
            x = ApplicationManager.getIntProperty("canvasPaintableRegion.x", x);
            y = ApplicationManager.getIntProperty("canvasPaintableRegion.y", y);
            w = ApplicationManager.getIntProperty("canvasPaintableRegion.width", w);
            h = ApplicationManager.getIntProperty("canvasPaintableRegion.height", h);
        }
        if (ApplicationManager.getProperty("skin") == null && h == this.manager.screenHeight && this.softButtons != null && this.softButtons.length > 0 && this.softButtons[0] != null) {
            h -= this.softButtons[0].getHeight();
        }
        if (this.title != null && this.title.location == null) {
            this.title.setBounds(x, y, w, this.title.getHeight());
            h -= (y += this.title.getHeight() + 1);
        }
        if (this.main != null) {
            x = 0;
            y = 0;
            w = this.getWidth();
            h = this.getHeight();
            boolean change = w != this.main.getWidth() || h != this.main.getHeight();
            this.main.setBounds(x, y, w, h);
            this.main.doLayout();
            if (change && this.displayable != null) {
                try {
                    this.displayable.sizeChanged(w, h);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.doLayout();
    }
}

