/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.yura.domination.engine.ai.logic.AIDomination;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AICapital
extends AIDomination {
    public AICapital(int type) {
        super(type);
    }

    @Override
    protected List<Country> getBorder(AIDomination.GameState gs) {
        List<Country> border = super.getBorder(gs);
        if (gs.commonThreat == null) {
            return border;
        }
        int attack = (int)gs.commonThreat.attackValue / (gs.orderedPlayers.size() + 1);
        int minNeeded = Integer.MAX_VALUE;
        Country priority = null;
        for (Country c : gs.capitals) {
            if (c.getOwner() != this.player) continue;
            int additional = Math.max(attack - c.getArmies(), this.additionalTroopsNeeded(c, gs));
            if (additional <= 0) {
                return border;
            }
            if (additional >= minNeeded) continue;
            minNeeded = additional;
            priority = c;
        }
        if (priority != null) {
            border.add(0, priority);
        }
        return border;
    }

    @Override
    protected String planObjective(boolean attack, List<Country> attackable, AIDomination.GameState gameState, Map<Country, AIDomination.AttackTarget> targets, Set<Country> allCountriesTaken, boolean pressAttack, boolean shouldEndAttack, boolean highProbability) {
        block13: {
            if (this.game.getSetupDone()) {
                String result;
                HashMap<Player, Integer> owned = new HashMap<Player, Integer>();
                for (Country c : gameState.capitals) {
                    Integer count = (Integer)owned.get(c.getOwner());
                    count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                    owned.put(c.getOwner(), count);
                }
                double num = gameState.capitals.size();
                Integer myowned = (Integer)owned.get(this.player);
                if (myowned == null) {
                    myowned = 0;
                }
                double percentOwned = (double)myowned.intValue() / num;
                double ratio = gameState.me.playerValue / gameState.orderedPlayers.get((int)0).playerValue;
                if ((highProbability || this.isIncreasingSet() && ratio / 3.0 > percentOwned || percentOwned >= 0.5 && (this.isIncreasingSet() || ratio > 1.0)) && (result = this.planCapitalMove(attack, attackable, gameState, targets, null, highProbability, allCountriesTaken, !highProbability, shouldEndAttack)) != null) {
                    return result;
                }
                for (Map.Entry e : owned.entrySet()) {
                    Integer numOwned = (Integer)e.getValue();
                    Player other = (Player)e.getKey();
                    if (other == this.player || (double)numOwned.intValue() / num < 0.5) continue;
                    int primaryDefense = 0;
                    for (Country c : gameState.capitals) {
                        if (c.getOwner() == other) continue;
                        primaryDefense += c.getArmies();
                    }
                    for (int j = 0; j < gameState.orderedPlayers.size(); ++j) {
                        String result2;
                        AIDomination.PlayerState ps = gameState.orderedPlayers.get(j);
                        if (ps.p != other) continue;
                        if (gameState.commonThreat == null && gameState.orderedPlayers.size() > 1) {
                            double d = ps.attackValue;
                            int n = ps.strategic ? 3 : 4;
                            if (d > (double)(n * primaryDefense)) {
                                gameState.commonThreat = ps;
                                if (!gameState.targetPlayers.contains(ps.p)) {
                                    gameState.targetPlayers.add(ps.p);
                                }
                            }
                        }
                        if (ps.attackValue > (double)(2 * primaryDefense) && myowned < 2 && (result2 = this.planCapitalMove(attack, attackable, gameState, targets, (Player)e.getKey(), false, allCountriesTaken, !highProbability, shouldEndAttack)) != null) {
                            return result2;
                        }
                        break block13;
                    }
                    break;
                }
            } else if (this.r.nextInt(this.game.getPlayers().size()) == 0) {
                Country c = this.findCapital();
                return this.getPlaceCommand(c, 1);
            }
        }
        return null;
    }

    private String planCapitalMove(boolean attack, List<Country> attackable, AIDomination.GameState gameState, Map<Country, AIDomination.AttackTarget> targets, Player target, boolean allOrNone, Set<Country> allCountriesTaken, boolean lowProbability, boolean shouldEndAttack) {
        int remaining = this.player.getExtraArmies();
        ArrayList<AIDomination.AttackTarget> toAttack = new ArrayList<AIDomination.AttackTarget>();
        for (Country c : gameState.capitals) {
            if (c.getOwner() == this.player || target != null && target != c.getOwner()) continue;
            AIDomination.AttackTarget at = targets.get(c);
            if (at == null) {
                if (!allOrNone) continue;
                return null;
            }
            if (at.remaining < 1) {
                if ((remaining += at.remaining) < 1 && allOrNone) {
                    return null;
                }
                if (attack || allOrNone) continue;
                toAttack.add(at);
                continue;
            }
            if (attack) {
                toAttack.add(at);
                continue;
            }
            return null;
        }
        if (!toAttack.isEmpty()) {
            if (allOrNone) {
                AIDomination.EliminationTarget et = new AIDomination.EliminationTarget();
                et.allOrNone = allOrNone;
                et.attackTargets = toAttack;
                et.ps = gameState.orderedPlayers.get(0);
                return this.eliminate(attackable, targets, gameState, attack, remaining, allCountriesTaken, et, shouldEndAttack, lowProbability);
            }
            Collections.sort(toAttack, Collections.reverseOrder());
            AIDomination.AttackTarget at = (AIDomination.AttackTarget)toAttack.get(0);
            int route = this.findBestRoute(attackable, gameState, attack, null, at, gameState.targetPlayers.get(0), targets);
            Country start = attackable.get(route);
            if (attack) {
                return this.getAttack(targets, at, route, start);
            }
            return this.getPlaceCommand(start, -at.remaining + 1);
        }
        return null;
    }

    @Override
    protected String getBattleWon(AIDomination.GameState gameState) {
        if (gameState.commonThreat == null) {
            return super.getBattleWon(gameState);
        }
        if (gameState.capitals.contains(this.game.getAttacker())) {
            int needed = this.additionalTroopsNeeded(this.game.getAttacker(), gameState);
            if (needed > 0) {
                return "move " + this.game.getMustMove();
            }
            return "move " + Math.max(this.game.getMustMove(), -needed / 2 - this.getMinPlacement());
        }
        if (gameState.capitals.contains(this.game.getDefender()) && (this.ownsNeighbours(this.player, this.game.getAttacker()) || !this.ownsNeighbours(this.player, this.game.getDefender()))) {
            return "move all";
        }
        return super.getBattleWon(gameState);
    }

    @Override
    public String getCapital() {
        return "capital " + this.findCapital().getColor();
    }

    protected Country findCapital() {
        int score = Integer.MAX_VALUE;
        Country result = null;
        Vector v = this.player.getTerritoriesOwned();
        for (int i = 0; i < v.size(); ++i) {
            Country c = (Country)v.get(i);
            int val = this.scoreCountry(c);
            if ((val -= c.getArmies() / this.game.getPlayers().size()) >= score && (val != score || !this.r.nextBoolean())) continue;
            score = val;
            result = c;
        }
        return result;
    }

    @Override
    protected double getContinentValue(Continent co) {
        double value = super.getContinentValue(co);
        if (!this.game.getSetupDone()) {
            return Math.sqrt(value);
        }
        return super.getContinentValue(co);
    }
}

