/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#include "SDL.h"
#include <cstdio>

#ifdef _MSC_VER
/* Some 'real' C++ headers required, as we're not getting C++ 
   namespaces with <c*> (i.e. <cstdio>) headers in MSVC */
#include <new>
/* And a 'fix' for MSVC6 variable scoping */
#define for if ( 0 ) ; else for
#endif

#define TILE_HEIGHT 10
#define TILE_WIDTH 10 

#define SCR_WIDTH 640
#define SCR_HEIGHT 460

#define XTILES SCR_WIDTH / TILE_WIDTH
#define YTILES SCR_HEIGHT / TILE_HEIGHT

// length of modes in ms
#define PLACE_CANNON_LENGTH 15000 // 15s
#define SHOOTING_LENGTH 15000 // 15s
#define REPAIR_LENGTH 20000 // 20s
#define ENDROUND_LENGTH 6000 // 6s
#define ENDGAME_LENGTH 20000 // 20s
#define CASTLE_SELECT_LENGTH 15000 // 15s

#define MSG_MAXLEN (1024-1)
#define NAME_MAXLEN MSG_MAXLEN

#define MAX_PLAYERS 4
#ifndef OWNER_NOONE
#define OWNER_NOONE MAX_PLAYERS
#endif

#define DEFAULT_NUM_PLAYERS 2

#define AMMO_DAMAGE 10
#define BIG_AMMO_DAMAGE 80
#define CANNON_HP 80
#define BIG_CANNON_HP 160

// costs for different things
#define CANNON_COST 25
#define BIG_CANNON_COST 50
#define BLOCK_COST 1

// income for different things
#define CASTLE_INCOME 20

#define NORMAL 1
#define BIG 2

#define DEFAULT_NUM_CASTLES 7
#define DEFAULT_NUM_WINS 1

#define ERRTEXT_DUR 6000 // 6s
#define TALKTEXT_DUR 10000 // 10s
#define TALKTEXT_GAME_DUR 5000 // in game only for 5s

#define VERSION "v0.7"

#define COPYRIGHT "Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo, and Marko Mattila"

#endif
