//////////////////////////////////////////////////////////////////////////////
//Copyright 2008
//  Andrew Gacek, Steven Holte, Gopalan Nadathur, Xiaochu Qi, Zach Snow
//////////////////////////////////////////////////////////////////////////////
// This file is part of Teyjus.                                             //
//                                                                          //
// Teyjus is free software: you can redistribute it and/or modify           //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation, either version 3 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// Teyjus is distributed in the hope that it will be useful,                //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with Teyjus.  If not, see <http://www.gnu.org/licenses/>.          //
//////////////////////////////////////////////////////////////////////////////
#include "byteswap.h"

u_int16_t bswap_16(u_int16_t x)
{
  return ((x >> 8) | (x << 8));
}

u_int32_t bswap_32(u_int32_t x)
{
  return (bswap_16(x & 0xffff) << 16) | bswap_16(x >> 16);
}

u_int64_t bswap_64(u_int64_t x)
{
  return (((u_int64_t)bswap_32(x & 0xffffffff)) << 32) | bswap_32(x >> 32);
}
