/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;

public class DefaultBuildToolingModelController
implements BuildToolingModelController {
    private final BuildLifecycleController buildController;
    private final BuildState buildState;
    private final ToolingModelBuilderLookup buildScopeLookup;

    public DefaultBuildToolingModelController(BuildState buildState, BuildLifecycleController buildController, ToolingModelBuilderLookup buildScopeLookup) {
        this.buildState = buildState;
        this.buildController = buildController;
        this.buildScopeLookup = buildScopeLookup;
    }

    @Override
    public GradleInternal getConfiguredModel() {
        return this.buildController.getConfiguredBuild();
    }

    @Override
    public ToolingModelScope locateBuilderForTarget(String modelName, boolean param) {
        ToolingModelBuilderLookup.Builder builder = this.buildScopeLookup.maybeLocateForBuildScope(modelName, param, this.buildState);
        if (builder != null) {
            return new BuildToolingScope(builder);
        }
        ProjectState targetProject = this.buildController.withProjectsConfigured(gradle -> gradle.getDefaultProject().getOwner());
        return this.doLocate(targetProject, modelName, param);
    }

    @Override
    public ToolingModelScope locateBuilderForTarget(ProjectState target, String modelName, boolean param) {
        if (target.getOwner() != this.buildState) {
            throw new IllegalArgumentException("Project has unexpected owner.");
        }
        this.buildController.configureProjects();
        return this.doLocate(target, modelName, param);
    }

    private ToolingModelScope doLocate(ProjectState target, String modelName, boolean param) {
        return new ProjectToolingScope(target, modelName, param);
    }

    private static class ProjectToolingScope
    extends AbstractToolingScope {
        private final ProjectState target;
        private final String modelName;
        private final boolean parameter;

        public ProjectToolingScope(ProjectState target, String modelName, boolean parameter) {
            this.target = target;
            this.modelName = modelName;
            this.parameter = parameter;
        }

        @Override
        @Nullable
        public ProjectState getTarget() {
            return this.target;
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            this.target.ensureConfigured();
            ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)this.target.getMutableModel().getServices().get(ToolingModelBuilderLookup.class);
            return lookup.locateForClientOperation(this.modelName, this.parameter, this.target);
        }
    }

    private static class BuildToolingScope
    extends AbstractToolingScope {
        private final ToolingModelBuilderLookup.Builder builder;

        public BuildToolingScope(ToolingModelBuilderLookup.Builder builder) {
            this.builder = builder;
        }

        @Override
        @Nullable
        public ProjectState getTarget() {
            return null;
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            return this.builder;
        }
    }

    private static abstract class AbstractToolingScope
    implements ToolingModelScope {
        private AbstractToolingScope() {
        }

        abstract ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException;

        @Override
        public Object getModel(String modelName, @Nullable Function<Class<?>, Object> parameterFactory) {
            ToolingModelBuilderLookup.Builder builder = this.locateBuilder();
            if (parameterFactory == null) {
                return builder.build(null);
            }
            Object parameter = parameterFactory.apply(builder.getParameterType());
            return builder.build(parameter);
        }
    }
}

