/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2005 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "config.h"
#include "ui_pixbuf_save.h"

/*
 *-----------------------------------------------------------------------------
 * png save
 *-----------------------------------------------------------------------------
 */

gboolean pixbuf_to_file_as_png (GdkPixbuf *pixbuf, const char *filename)
{
	GError *error = NULL;
	gint ret;

	if (!pixbuf || !filename) return FALSE;

	ret = gdk_pixbuf_save(pixbuf, filename, "png", &error,
			      "tEXt::Software", PACKAGE" "VERSION, NULL);

	if (error)
		{
		printf("Error saving png file: %s\n", error->message);
		g_error_free(error);
		}

	return ret;
}


