/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyConflict;
import org.apache.ivy.ant.IvyDependency;
import org.apache.ivy.ant.IvyExclude;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.AbstractIncludeExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.apache.ivy.util.filter.FilterHelper;
import org.apache.tools.ant.BuildException;

public class IvyResolve
extends IvyTask {
    private File file = null;
    private String conf = null;
    private String organisation = null;
    private String module = null;
    private String branch = null;
    private String revision = null;
    private String pubdate = null;
    private boolean inline = false;
    private boolean haltOnFailure = true;
    private boolean showProgress = true;
    private boolean useCacheOnly = false;
    private String type = null;
    private boolean transitive = true;
    private boolean refresh = false;
    private boolean changing = false;
    private Boolean keep = null;
    private String failureProperty = null;
    private boolean useOrigin = false;
    private String resolveMode = null;
    private String resolveId = null;
    private String log = "default";
    private boolean checkIfChanged = true;
    private List dependencies = new ArrayList();
    private List excludes = new ArrayList();
    private List conflicts = new ArrayList();

    public boolean isUseOrigin() {
        return this.useOrigin;
    }

    public void setUseOrigin(boolean bl) {
        this.useOrigin = bl;
    }

    public String getDate() {
        return this.pubdate;
    }

    public void setDate(String string) {
        this.pubdate = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public void setCache(File file) {
        this.cacheAttributeNotSupported();
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isHaltonfailure() {
        return this.haltOnFailure;
    }

    public void setHaltonfailure(boolean bl) {
        this.haltOnFailure = bl;
    }

    public void setShowprogress(boolean bl) {
        this.showProgress = bl;
    }

    public boolean isUseCacheOnly() {
        return this.useCacheOnly;
    }

    public void setUseCacheOnly(boolean bl) {
        this.useCacheOnly = bl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String string) {
        this.log = string;
    }

    public void setFailurePropery(String string) {
        this.log("The 'failurepropery' attribute is deprecated. Please use the 'failureproperty' attribute instead", 1);
        this.setFailureProperty(string);
    }

    public void setFailureProperty(String string) {
        this.failureProperty = string;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public IvyDependency createDependency() {
        IvyDependency ivyDependency = new IvyDependency();
        this.dependencies.add(ivyDependency);
        return ivyDependency;
    }

    public IvyExclude createExclude() {
        IvyExclude ivyExclude = new IvyExclude();
        this.excludes.add(ivyExclude);
        return ivyExclude;
    }

    public IvyConflict createConflict() {
        IvyConflict ivyConflict = new IvyConflict();
        this.conflicts.add(ivyConflict);
        return ivyConflict;
    }

    @Override
    protected void prepareTask() {
        super.prepareTask();
        Message.setShowProgress(this.showProgress);
    }

    @Override
    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        try {
            ResolveReport resolveReport;
            Object object4;
            Object object2;
            ExtendableItem extendableItem;
            boolean bl;
            this.conf = this.getProperty(this.conf, ivySettings, "ivy.configurations");
            this.type = this.getProperty(this.type, ivySettings, "ivy.resolve.default.type.filter");
            String[] stringArray = this.splitConfs(this.conf);
            boolean bl2 = bl = !this.dependencies.isEmpty() || !this.excludes.isEmpty() || !this.conflicts.isEmpty();
            if (bl) {
                if (this.isInline()) {
                    throw new BuildException("the inline mode is incompatible with child elements");
                }
                if (this.organisation != null) {
                    throw new BuildException("'organisation' is not allowed with child elements");
                }
                if (this.module != null) {
                    throw new BuildException("'module' is not allowed with child elements");
                }
                if (this.file != null) {
                    throw new BuildException("'file' not allowed with child elements");
                }
                if (!this.getAllowedLogOptions().contains(this.log)) {
                    throw new BuildException("invalid option for 'log': " + this.log + ". Available options are " + this.getAllowedLogOptions());
                }
                extendableItem = ModuleRevisionId.newInstance("", "", Ivy.getWorkingRevision());
                object2 = DefaultModuleDescriptor.newBasicInstance((ModuleRevisionId)extendableItem, null);
                for (Object object3 : this.dependencies) {
                    object4 = ((IvyDependency)object3).asDependencyDescriptor((ModuleDescriptor)object2, "default", ivySettings);
                    ((DefaultModuleDescriptor)object2).addDependency((DependencyDescriptor)object4);
                }
                for (Object object4 : this.excludes) {
                    Object object5 = ((IvyExclude)object4).asRule(ivySettings);
                    ((AbstractIncludeExcludeRule)object5).addConfiguration("default");
                    ((DefaultModuleDescriptor)object2).addExcludeRule((ExcludeRule)object5);
                }
                for (Object object5 : this.conflicts) {
                    ((IvyConflict)object5).addConflict((DefaultModuleDescriptor)object2, ivySettings);
                }
                resolveReport = ivy.resolve((ModuleDescriptor)object2, this.getResolveOptions(ivy, new String[]{"default"}, ivySettings));
            } else if (this.isInline()) {
                if (this.organisation == null) {
                    throw new BuildException("'organisation' is required when using inline mode");
                }
                if (this.module == null) {
                    throw new BuildException("'module' is required when using inline mode");
                }
                if (this.file != null) {
                    throw new BuildException("'file' not allowed when using inline mode");
                }
                if (!this.getAllowedLogOptions().contains(this.log)) {
                    throw new BuildException("invalid option for 'log': " + this.log + ". Available options are " + this.getAllowedLogOptions());
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!"*".equals(stringArray[i])) continue;
                    stringArray[i] = "*(public)";
                }
                if (this.revision == null) {
                    this.revision = "latest.integration";
                }
                resolveReport = ivy.resolve(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision), this.getResolveOptions(ivy, stringArray, ivySettings), this.changing);
            } else {
                if (this.organisation != null) {
                    throw new BuildException("'organisation' not allowed when not using 'org' attribute");
                }
                if (this.module != null) {
                    throw new BuildException("'module' not allowed when not using 'org' attribute");
                }
                if (this.file == null) {
                    this.file = this.getProject().resolveFile(this.getProperty(ivySettings, "ivy.dep.file"));
                }
                resolveReport = ivy.resolve(this.file.toURI().toURL(), this.getResolveOptions(ivy, stringArray, ivySettings));
            }
            if (resolveReport.hasError()) {
                if (this.failureProperty != null) {
                    this.getProject().setProperty(this.failureProperty, "true");
                }
                if (this.isHaltonfailure()) {
                    throw new BuildException("resolve failed - see output for details");
                }
            }
            this.setResolved(resolveReport, this.resolveId, this.isKeep());
            stringArray = resolveReport.getConfigurations();
            if (this.isKeep()) {
                Object object3;
                extendableItem = resolveReport.getModuleDescriptor();
                object2 = extendableItem.getModuleRevisionId().getOrganisation();
                String string = extendableItem.getModuleRevisionId().getName();
                object3 = extendableItem.getResolvedModuleRevisionId().getRevision();
                this.getProject().setProperty("ivy.organisation", (String)object2);
                ivySettings.setVariable("ivy.organisation", (String)object2);
                this.getProject().setProperty("ivy.module", string);
                ivySettings.setVariable("ivy.module", string);
                this.getProject().setProperty("ivy.revision", (String)object3);
                ivySettings.setVariable("ivy.revision", (String)object3);
                object4 = null;
                if (this.getCheckIfChanged()) {
                    object4 = resolveReport.hasChanged();
                    this.getProject().setProperty("ivy.deps.changed", ((Boolean)object4).toString());
                    ivySettings.setVariable("ivy.deps.changed", ((Boolean)object4).toString());
                }
                this.getProject().setProperty("ivy.resolved.configurations", this.mergeConfs(stringArray));
                ivySettings.setVariable("ivy.resolved.configurations", this.mergeConfs(stringArray));
                if (this.file != null) {
                    this.getProject().setProperty("ivy.resolved.file", this.file.getAbsolutePath());
                    ivySettings.setVariable("ivy.resolved.file", this.file.getAbsolutePath());
                }
                if (this.resolveId != null) {
                    this.getProject().setProperty("ivy.organisation." + this.resolveId, (String)object2);
                    ivySettings.setVariable("ivy.organisation." + this.resolveId, (String)object2);
                    this.getProject().setProperty("ivy.module." + this.resolveId, string);
                    ivySettings.setVariable("ivy.module." + this.resolveId, string);
                    this.getProject().setProperty("ivy.revision." + this.resolveId, (String)object3);
                    ivySettings.setVariable("ivy.revision." + this.resolveId, (String)object3);
                    if (this.getCheckIfChanged()) {
                        this.getProject().setProperty("ivy.deps.changed." + this.resolveId, ((Boolean)object4).toString());
                        ivySettings.setVariable("ivy.deps.changed." + this.resolveId, ((Boolean)object4).toString());
                    }
                    this.getProject().setProperty("ivy.resolved.configurations." + this.resolveId, this.mergeConfs(stringArray));
                    ivySettings.setVariable("ivy.resolved.configurations." + this.resolveId, this.mergeConfs(stringArray));
                    if (this.file != null) {
                        this.getProject().setProperty("ivy.resolved.file." + this.resolveId, this.file.getAbsolutePath());
                        ivySettings.setVariable("ivy.resolved.file." + this.resolveId, this.file.getAbsolutePath());
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("unable to convert given ivy file to url: " + this.file + ": " + malformedURLException, (Throwable)malformedURLException);
        }
        catch (ParseException parseException) {
            this.log(parseException.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + parseException, (Throwable)parseException);
        }
        catch (ResolveProcessException resolveProcessException) {
            throw new BuildException("impossible to resolve dependencies:\n\t" + resolveProcessException.getMessage(), (Throwable)resolveProcessException);
        }
        catch (Exception exception) {
            throw new BuildException("impossible to resolve dependencies:\n\t" + exception, (Throwable)exception);
        }
    }

    protected Collection getAllowedLogOptions() {
        return Arrays.asList("default", "download-only", "quiet");
    }

    private ResolveOptions getResolveOptions(Ivy ivy, String[] stringArray, IvySettings ivySettings) {
        if (this.useOrigin) {
            ivySettings.useDeprecatedUseOrigin();
        }
        return ((ResolveOptions)new ResolveOptions().setLog(this.log)).setConfs(stringArray).setValidate(this.doValidate(ivySettings)).setArtifactFilter(FilterHelper.getArtifactTypeFilter(this.type)).setRevision(this.revision).setDate(IvyResolve.getPubDate(this.pubdate, null)).setUseCacheOnly(this.useCacheOnly).setRefresh(this.refresh).setTransitive(this.transitive).setResolveMode(this.resolveMode).setResolveId(this.resolveId).setCheckIfChanged(this.checkIfChanged);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean bl) {
        this.transitive = bl;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public void setChanging(boolean bl) {
        this.changing = bl;
    }

    public boolean isKeep() {
        return this.keep == null ? this.organisation == null : this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean bl) {
        this.inline = bl;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public void setResolveId(String string) {
        this.resolveId = string;
    }

    public String getResolveMode() {
        return this.resolveMode;
    }

    public void setResolveMode(String string) {
        this.resolveMode = string;
    }

    public boolean getCheckIfChanged() {
        return this.checkIfChanged;
    }

    public void setCheckIfChanged(boolean bl) {
        this.checkIfChanged = bl;
    }
}

