/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.impl.ClassImplementationSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.LambdaImplementationSnapshot;
import org.gradle.internal.snapshot.impl.UnknownImplementationSnapshot;

public class ImplementationSnapshotSerializer
implements Serializer<ImplementationSnapshot> {
    public ImplementationSnapshot read(Decoder decoder) throws Exception {
        Impl serializer = Impl.values()[decoder.readSmallInt()];
        return serializer.read(decoder);
    }

    public void write(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
        Impl serializer = ImplementationSnapshotSerializer.determineSerializer(implementationSnapshot);
        encoder.writeSmallInt(serializer.ordinal());
        serializer.write(encoder, implementationSnapshot);
    }

    private static Impl determineSerializer(ImplementationSnapshot implementationSnapshot) {
        if (implementationSnapshot instanceof ClassImplementationSnapshot) {
            return Impl.CLASS;
        }
        if (implementationSnapshot instanceof LambdaImplementationSnapshot) {
            return Impl.LAMBDA;
        }
        if (implementationSnapshot instanceof UnknownImplementationSnapshot) {
            return Impl.UNKNOWN;
        }
        throw new IllegalArgumentException("Unexpected implementation snapshot type: " + implementationSnapshot.getClass().getName());
    }

    private static enum Impl implements Serializer<ImplementationSnapshot>
    {
        CLASS{

            @Override
            protected ImplementationSnapshot readAdditionalData(String classIdentifier, Decoder decoder) throws Exception {
                HashCode classLoaderHash = (HashCode)this.hashCodeSerializer.read(decoder);
                return new ClassImplementationSnapshot(classIdentifier, classLoaderHash);
            }

            @Override
            public void writeAdditionalData(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
                this.hashCodeSerializer.write(encoder, (Object)implementationSnapshot.getClassLoaderHash());
            }
        }
        ,
        LAMBDA{

            @Override
            protected ImplementationSnapshot readAdditionalData(String classIdentifier, Decoder decoder) throws Exception {
                HashCode classLoaderHash = (HashCode)this.hashCodeSerializer.read(decoder);
                String functionalInterfaceClass = decoder.readString();
                String implClass = decoder.readString();
                String implMethodName = decoder.readString();
                String implMethodSignature = decoder.readString();
                int implMethodKind = decoder.readSmallInt();
                return new LambdaImplementationSnapshot(classIdentifier, classLoaderHash, functionalInterfaceClass, implClass, implMethodName, implMethodSignature, implMethodKind);
            }

            @Override
            protected void writeAdditionalData(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
                LambdaImplementationSnapshot serLambda = (LambdaImplementationSnapshot)implementationSnapshot;
                this.hashCodeSerializer.write(encoder, (Object)serLambda.getClassLoaderHash());
                encoder.writeString((CharSequence)serLambda.getFunctionalInterfaceClass());
                encoder.writeString((CharSequence)serLambda.getImplClass());
                encoder.writeString((CharSequence)serLambda.getImplMethodName());
                encoder.writeString((CharSequence)serLambda.getImplMethodSignature());
                encoder.writeSmallInt(serLambda.getImplMethodKind());
            }
        }
        ,
        UNKNOWN{

            @Override
            protected ImplementationSnapshot readAdditionalData(String classIdentifier, Decoder decoder) throws Exception {
                UnknownImplementationSnapshot.UnknownReason unknownReason = UnknownImplementationSnapshot.UnknownReason.values()[decoder.readSmallInt()];
                return new UnknownImplementationSnapshot(classIdentifier, unknownReason);
            }

            @Override
            protected void writeAdditionalData(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
                UnknownImplementationSnapshot unknownImplSnapshot = (UnknownImplementationSnapshot)implementationSnapshot;
                encoder.writeSmallInt(unknownImplSnapshot.getUnknownReason().ordinal());
            }
        };

        protected final Serializer<HashCode> hashCodeSerializer = new HashCodeSerializer();

        public void write(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
            encoder.writeString((CharSequence)implementationSnapshot.getClassIdentifier());
            this.writeAdditionalData(encoder, implementationSnapshot);
        }

        public ImplementationSnapshot read(Decoder decoder) throws Exception {
            String classIdentifier = decoder.readString();
            return this.readAdditionalData(classIdentifier, decoder);
        }

        protected abstract ImplementationSnapshot readAdditionalData(String var1, Decoder var2) throws Exception;

        protected abstract void writeAdditionalData(Encoder var1, ImplementationSnapshot var2) throws Exception;
    }
}

