/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

public class KotlinFunctionIntrinsic
extends FunctionIntrinsicWithReceiverComputed {
    @NotNull
    private final String functionName;
    private final JsExpression[] additionalArguments;

    public KotlinFunctionIntrinsic(@NotNull String functionName, JsExpression ... additionalArguments) {
        if (functionName == null) {
            KotlinFunctionIntrinsic.$$$reportNull$$$0(0);
        }
        this.functionName = functionName;
        this.additionalArguments = additionalArguments;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
        if (arguments2 == null) {
            KotlinFunctionIntrinsic.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            KotlinFunctionIntrinsic.$$$reportNull$$$0(2);
        }
        JsNameRef function2 = JsAstUtils.pureFqn(this.functionName, (JsExpression)Namer.kotlinObject());
        if (this.additionalArguments.length > 0) {
            ArrayList<? extends JsExpression> newArguments2 = new ArrayList<JsExpression>(arguments2);
            for (JsExpression e : this.additionalArguments) {
                newArguments2.add(e.deepCopy());
            }
            arguments2 = newArguments2;
        }
        return new JsInvocation((JsExpression)function2, receiver == null ? arguments2 : TranslationUtils.generateInvocationArguments(receiver, arguments2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

