#ifndef _YYDECODE_H
#define _YYDECODE_H 1

#define lenof(str) (sizeof(str) - sizeof(char))

#define UUMARKER_BEGIN	"begin "
#define UUMARKER_END	"end\n"
#define B64MARKER_BEGIN	"begin-base64 "
#define B64MARKER_END	"===="

#define YMARKER_BEGIN	"=ybegin "
#define YMARKER_PART	"=ypart "
#define YMARKER_END	"=yend "

#define YTAG_PART	" part="
#define YTAG_TOTAL	" total="
#define YTAG_LINE	" line="
#define YTAG_SIZE	" size="
#define YTAG_NAME	" name="
#define YTAG_BEGIN	" begin="
#define YTAG_END	" end="
#define YTAG_PCRC32	" pcrc32="
#define YTAG_CRC32	" crc32="

#define YYDEC_BROKEN_SUFFIX	".broken"

/* 8MB for each part */
#define PART_SIZE_SOFT_LIMIT	(1 << 23)

/* EXIT_SUCCESS = 0, EXIT_FAILURE = 1 */
#define EXIT_WARNING	2
#define EXIT_EOF	3

enum part_status
{
	part_missing = 0,
	part_intact,
	part_duplicated,
	part_broken
};

struct decoded_file
{
	struct decoded_file *next;

	/* used only as a key for decoded_filename lookup ... */
	char *	filename;
	/* ... anything else shall use the following, to avoid user confusion */
	char *	outname;
	int	mode;
	/* if set, ignore this file (can't write to the file for some reason) */
	int	previously_existed;

	/* zero on the first run */
	int	is_seekable;

	FILE *	handle;
	off_t	bytes_written;

	off_t	total_size;
	int	total_parts;
	enum part_status *status;

	/* Follow an optimistic strategy, and assume that most of the time,
	 * we'll receive the parts in order, so we do not need to make another
	 * pass over the output file to calculate the file CRC. If we get parts
	 * out of order, then set crc32_prev_part = -1; we'll have to make a
	 * pass over the entire file later on. */

	int	crc32_prev_part;
	struct crc32_ctx crc32_context;
	u_int32_t crc32;
};

struct decode_context
{
	const char *inname;
	char *out;
	size_t out_size;

	int part;
	int total_parts;
	enum part_status status;
};

typedef int (*read_enc)(struct decode_context *c, struct decoded_file *f, char *buf);

#endif /* _YYDECODE_H */

