/*
    Scan Tailor - Interactive post-processing tool for scanned pages.
    Copyright (C) 2007-2009  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ZoneInteractionContext.h"
#include <boost/bind.hpp>
#include "ZoneContextMenuInteraction.h"
#include "ZoneCreationInteraction.h"
#include "ZoneDefaultInteraction.h"
#include "ZoneDragInteraction.h"
#include "ZoneVertexDragInteraction.h"

ZoneInteractionContext::ZoneInteractionContext(ImageViewBase& image_view, EditableZoneSet& zones)
    : m_imageView(image_view),
      m_zones(zones),
      m_defaultInteractionCreator(boost::bind(&ZoneInteractionContext::createStdDefaultInteraction, this)),
      m_zoneCreationInteractionCreator(
          boost::bind(&ZoneInteractionContext::createStdZoneCreationInteraction, this, _1)),
      m_vertexDragInteractionCreator(
          boost::bind(&ZoneInteractionContext::createStdVertexDragInteraction, this, _1, _2, _3)),
      m_zoneDragInteractionCreator(boost::bind(&ZoneInteractionContext::createStdZoneDragInteraction, this, _1, _2)),
      m_contextMenuInteractionCreator(boost::bind(&ZoneInteractionContext::createStdContextMenuInteraction, this, _1)),
      m_showPropertiesCommand(&ZoneInteractionContext::showPropertiesStub) {}

ZoneInteractionContext::~ZoneInteractionContext() = default;

InteractionHandler* ZoneInteractionContext::createStdDefaultInteraction() {
  return new ZoneDefaultInteraction(*this);
}

InteractionHandler* ZoneInteractionContext::createStdZoneCreationInteraction(InteractionState& interaction) {
  return new ZoneCreationInteraction(*this, interaction);
}

InteractionHandler* ZoneInteractionContext::createStdVertexDragInteraction(InteractionState& interaction,
                                                                           const EditableSpline::Ptr& spline,
                                                                           const SplineVertex::Ptr& vertex) {
  return new ZoneVertexDragInteraction(*this, interaction, spline, vertex);
}

InteractionHandler* ZoneInteractionContext::createStdZoneDragInteraction(InteractionState& interaction,
                                                                         const EditableSpline::Ptr& spline) {
  return new ZoneDragInteraction(*this, interaction, spline);
}

InteractionHandler* ZoneInteractionContext::createStdContextMenuInteraction(InteractionState& interaction) {
  return ZoneContextMenuInteraction::create(*this, interaction);
}
