# Usage:
# lib_to_dll(output_list_of_dlls ${list_of_dot_lib_files})
macro (lib_to_dll out_list_)
  set(${out_list_} "")
  foreach (lib_file_ ${ARGN})
    #string(REGEX REPLACE "\\.lib$" ".dll" dll_file_ "${lib_file_}")
    #if (NOT "${dll_file_}" STREQUAL "${lib_file_}")
    #    list(APPEND ${out_list_} "${dll_file_}")
    #endif()
    get_filename_component(lib_file_name_ "${lib_file_}" NAME)
    get_filename_component(dir_ "${lib_file_}" PATH)

    string(REGEX REPLACE "^lib(.*)\\.a$" "\\1.dll" dll_file_name_ "${lib_file_name_}")
    if ("${dll_file_name_}" STREQUAL "${lib_file_name_}")
      string(REGEX REPLACE "^(.*)\\.lib$" "\\1.dll" dll_file_name_ "${lib_file_name_}")
    endif()

    if (NOT "${dll_file_name_}" STREQUAL "${lib_file_name_}")
      list(APPEND ${out_list_} "${dir_}/${dll_file_name_}")
    endif()
  endforeach()
endmacro()